/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Service
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.Service";
    protected final Logger logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    private Core core = null;
    protected Device device = null;
    private Entity entity = null;

    public int init(Core core, Device device, Entity entity) {
        this.core = core;
        if (this.core == null || (this.device = device) == null || (this.entity = entity) == null) {
            return -21601;
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Starting shutdown of " + (Object)((Object)this) + " ...");
        }
        if (this.core.isShutdown()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Deregistering of " + (Object)((Object)this) + " will be ignored, 'cause the RE is shutting down!");
            }
        } else {
            try {
                int errorCode = this.core.deregisterEntity(this.entity.getEntityID());
                if (errorCode != 0) {
                    this.logger.warn("Deregistering " + (Object)((Object)this) + " failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Deregistering " + (Object)((Object)this) + " failed with " + ex.getMessage() + " :-(");
            }
        }
        this.core.clearEntityStatus(this.entity.getEntityID());
        return 0;
    }

    public Core getCore() {
        return this.core;
    }

    public Device getDevice() {
        return this.device;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getServiceName() {
        return this.entity.getEntityName();
    }

    public long getServiceID() {
        return this.entity.getEntityID();
    }

    public long getServiceType() {
        return this.entity.getEntityType();
    }

    public abstract int checkService();

    public final void publishServiceStatus(int status) {
        this.getCore().setEntityStatus(this.getEntity().getEntityID(), status);
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.Service@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.entity + "]";
    }
}

