/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.proxy.ent.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiveDevice
implements Runnable {
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.LiveDevice";
    private Entity[] srvEnities = null;
    private Device device = null;
    private Thread myThread = null;
    private Class<? extends VideoSrv> srvToStart = null;

    public int init(Device device, Entity[] srvEnities, Class<? extends VideoSrv> srvToStart) {
        this.device = device;
        if (this.device == null) {
            return -20002;
        }
        this.srvEnities = srvEnities;
        if (srvEnities == null) {
            return -20002;
        }
        this.srvToStart = srvToStart;
        if (this.srvToStart == null) {
            return -20002;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public void run() {
        try {
            int lifeDeviceError = 0;
            block8: while (!this.device.isShutdown()) {
                for (Entity entity : this.srvEnities) {
                    try {
                        if (!entity.isEnabled().booleanValue() || (lifeDeviceError = this.device.initializeDevice(entity.getEntityType())) == 0) continue;
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)ex, (Throwable)ex);
                        this.logger.error("Creating " + this + " failed :-(");
                        lifeDeviceError = -1;
                    }
                    break;
                }
                if (this.device != null && !this.device.isShutdown()) {
                    this.device.getCore().setEntityStatus(this.device.getDeviceID(), lifeDeviceError);
                    if (lifeDeviceError == -21656) {
                        this.device.getCore().sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.device.getDeviceID(), lifeDeviceError, "Network connectivity problems for [" + this.device.getDeviceEntity().getEntityName() + "]", "Network connectivity problems for [" + this.device.getDeviceEntity().getEntityName() + "]");
                        this.device.getCore().sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.device.getDeviceID());
                    }
                    if (lifeDeviceError != 0) {
                        for (Service service : this.device.services) {
                            if (service == null) continue;
                            ((VideoSrv)service).sendStatusService(lifeDeviceError);
                        }
                        try {
                            long l = System.currentTimeMillis() + 10000L;
                            while (System.currentTimeMillis() < l) {
                                Thread.sleep(10L);
                                if (!this.device.isShutdown(CLASS_NAME)) continue;
                                continue block8;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            this.logger.error("Error while sleep: " + exception.getMessage() + " for " + this.device);
                        }
                    } else {
                        for (Service service : this.device.services) {
                            try {
                                if (service == null || !((Object)((Object)service)).getClass().equals(this.srvToStart)) continue;
                                ((VideoSrv)service).initLive();
                            }
                            catch (Exception e) {
                                this.logger.error("Error while starting LiveService " + (Object)((Object)service) + " for " + this.device);
                                this.logger.error((Object)e, (Throwable)e);
                            }
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            this.logger.error("Exception in LiveService for " + this);
            this.logger.error((Object)e, e);
        }
    }
}

