/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.TimeUnit;

public final class JitterCalculator {
    private static final long RESET_VALUE = TimeUnit.SECONDS.toMillis(20L);
    private long timeStampLastVideoPaket = Long.MIN_VALUE;
    private long lastMaxJitterValueTimestamp = System.currentTimeMillis();
    private long maxJitterValue = 0L;

    public final void calculateJitter(long now, long timestampOfLastStatisticFrame, long receivedVideoFrames) throws SeeTecException {
        if (now < 0L || timestampOfLastStatisticFrame < 0L || now <= timestampOfLastStatisticFrame || receivedVideoFrames <= 0L) {
            if (now == timestampOfLastStatisticFrame || receivedVideoFrames == 0L) {
                this.timeStampLastVideoPaket = now;
                return;
            }
            throw new SeeTecException(-20002, "Parameter are not valid [1:" + now + "|2:" + timestampOfLastStatisticFrame + "|3:" + receivedVideoFrames + "]");
        }
        if (this.timeStampLastVideoPaket != Long.MIN_VALUE) {
            if (this.lastMaxJitterValueTimestamp + RESET_VALUE < now) {
                this.maxJitterValue = 0L;
            }
            if (now - this.timeStampLastVideoPaket > this.maxJitterValue) {
                long packetDistance = now - this.timeStampLastVideoPaket;
                double fpsVideoPerSecond = this.calculateFps(now, timestampOfLastStatisticFrame, receivedVideoFrames);
                this.maxJitterValue = fpsVideoPerSecond != 0.0 ? (long)((double)packetDistance - 1000.0 / fpsVideoPerSecond) : 0L;
                this.lastMaxJitterValueTimestamp = now;
            }
        }
        this.timeStampLastVideoPaket = now;
    }

    private double calculateFps(long now, long timestampOfLastStatisticFrame, long receivedVideoFrames) {
        long realDistance = now - timestampOfLastStatisticFrame;
        float factor = (float)((double)realDistance / 1000.0);
        double fpsVideoPerSecond = (float)receivedVideoFrames / factor;
        return fpsVideoPerSecond;
    }

    public final long getMaxVideoJitter() {
        return Math.abs(this.maxJitterValue);
    }
}

