/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.shared.util.SeeTecException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ImageStreamPaket {
    public static final byte[] IMAGE_STREAM_HEADER_MAGIC = new byte[]{94, -25, -20, 17};
    public static final int IMAGE_STREAM_HEADER_LENGTH = 26;
    private final long sessionID;
    private final short transactionID;
    private final int frameNr;
    private final int offset;
    private final byte[] payload;

    public ImageStreamPaket(long sessionID, short transactionID, int frameNr, int offset, byte[] payload) {
        this.sessionID = sessionID;
        this.transactionID = transactionID;
        this.frameNr = frameNr;
        this.offset = offset;
        this.payload = payload;
    }

    public byte[] serialize() throws SeeTecException {
        int payloadLength = this.payload == null ? 0 : this.payload.length;
        ByteBuffer serializedImageStreamPaketAsBuffer = ByteBuffer.allocate(26 + payloadLength);
        serializedImageStreamPaketAsBuffer.put(IMAGE_STREAM_HEADER_MAGIC);
        serializedImageStreamPaketAsBuffer.putLong(this.sessionID);
        serializedImageStreamPaketAsBuffer.putShort(this.transactionID);
        serializedImageStreamPaketAsBuffer.putInt(this.frameNr);
        serializedImageStreamPaketAsBuffer.putInt(this.payload == null ? 0 : this.payload.length);
        serializedImageStreamPaketAsBuffer.putInt(this.offset);
        if (this.payload != null) {
            serializedImageStreamPaketAsBuffer.put(this.payload);
        }
        return serializedImageStreamPaketAsBuffer.array();
    }

    public static ImageStreamPaket deserialize(byte[] data) throws SeeTecException {
        byte[] payload;
        if (data == null || data.length < 26) {
            throw new SeeTecException(-20002, "Invalid ImageStreamHeader.");
        }
        if (data[0] != IMAGE_STREAM_HEADER_MAGIC[0] || data[1] != IMAGE_STREAM_HEADER_MAGIC[1] || data[2] != IMAGE_STREAM_HEADER_MAGIC[2] || data[3] != IMAGE_STREAM_HEADER_MAGIC[3]) {
            throw new SeeTecException(-20002, "Invalid ImageStreamHeader magic.");
        }
        ByteBuffer dataAsBuffer = ByteBuffer.wrap(data, IMAGE_STREAM_HEADER_MAGIC.length, data.length - IMAGE_STREAM_HEADER_MAGIC.length);
        long sessionID = dataAsBuffer.getLong();
        short transactionID = dataAsBuffer.getShort();
        int frameNr = dataAsBuffer.getInt();
        int frameSizeAfterHeader = dataAsBuffer.getInt();
        int offset = dataAsBuffer.getInt();
        byte[] byArray = payload = data.length == 26 ? null : Arrays.copyOfRange(data, 26, data.length);
        if (frameSizeAfterHeader != 0) {
            if (payload == null) {
                throw new SeeTecException(-20002, "Framesize field not 0 but payload null.");
            }
            if (frameSizeAfterHeader != payload.length) {
                throw new SeeTecException(-20002, "Framesize field and payload length are differing.");
            }
        } else if (payload != null) {
            throw new SeeTecException(-20002, "Framesize field 0 but payload not null.");
        }
        return new ImageStreamPaket(sessionID, transactionID, frameNr, offset, payload);
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public short getTransactionID() {
        return this.transactionID;
    }

    public int getFrameNr() {
        return this.frameNr;
    }

    public int getFrameSizeAfterHeader() {
        return this.payload == null ? 0 : this.payload.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

