/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandlerIntf;
import de.seetec.v5.re.cm.device.shared.EdgeStorageImportTask;
import de.seetec.v5.re.cm.device.shared.EdgeStorageImportWatchdog;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EdgeStorageHandler
implements Runnable,
EdgeStorageHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.EdgeStorageHandler";
    private final Logger logger;
    private Thread thread;
    private boolean isRunning;
    private Core core;
    private EdgeStorageImportWatchdog watchdog;
    private ExecutorService executorService;
    private Set<Long> videoSourcesInProgress;
    private final LinkedList<PlaybackVideoSourceClient> queue = new LinkedList();
    private int limitForGapSearching;

    public EdgeStorageHandler() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(Core core) {
        this.core = core;
        try {
            int errorCode;
            if (this.core.getDmCnfMgr().getEdgeStorageSpeed() < 0.0) {
                this.core.getDmCnfMgr().setEdgeStorageSpeed(1.0);
                errorCode = this.core.getDmCnfMgr().writeCnfFile();
                if (errorCode != 0) {
                    this.logger.warn("EdgeStorageSpeed could net be written to conf.file");
                }
            }
            if (this.core.getDmCnfMgr().getEdgeStorageParallelImports() == 0) {
                this.core.getDmCnfMgr().setEdgeStorageParallelImports(1);
                errorCode = this.core.getDmCnfMgr().writeCnfFile();
                if (errorCode != 0) {
                    this.logger.warn("Number of parallel Edge Storage imports could not be written to conf.file");
                }
            }
            this.limitForGapSearching = this.core.getDmCnfMgr().getEdgeStorageCheckTimerange();
            int numberOfParallelThreads = this.core.getDmCnfMgr().getEdgeStorageParallelImports();
            PriorityBlockingQueue<Runnable> priorityBlockingQueue = new PriorityBlockingQueue<Runnable>(1, (o1, o2) -> ((EdgeStorageImportTask)o2).getPriority() - ((EdgeStorageImportTask)o1).getPriority());
            this.executorService = new ThreadPoolExecutor(numberOfParallelThreads, numberOfParallelThreads, 1L, TimeUnit.MILLISECONDS, priorityBlockingQueue);
            this.videoSourcesInProgress = new HashSet<Long>();
            this.isRunning = true;
            this.thread = new Thread((Runnable)this, CLASS_NAME);
            this.thread.start();
            this.watchdog = new EdgeStorageImportWatchdog(this, core);
            this.watchdog.start();
            return 0;
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("EdgeStorage parameters could not be set: " + configurationException.getMessage());
            return -20030;
        }
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.logger.debug("EdgeStorageHandling: Checking for EdgeStorage devices (Size of queue: " + this.queue.size() + ")");
            while (this.queue.size() > 0) {
                PlaybackVideoSourceClient playbackVideoSourceClient = this.queue.removeFirst();
                if (playbackVideoSourceClient == null) {
                    this.logger.warn("EdgeStorageHandling: Empty PlaybackVideoSourceClient in queue");
                    continue;
                }
                Long videoSourceId = playbackVideoSourceClient.getVideoSrv().getEntityID();
                if (videoSourceId == null) {
                    this.logger.warn("EdgeStorageHandling: Video Source ID from " + playbackVideoSourceClient + " is null ");
                    continue;
                }
                this.logger.info("EdgeStorageHandling: Start checking " + playbackVideoSourceClient + " for gaps.");
                if (this.videoSourcesInProgress.contains(videoSourceId)) {
                    this.logger.warn("Video source " + videoSourceId + " is already in progress");
                    continue;
                }
                try {
                    EdgeStorageImportTask edgeStorageImportTask = new EdgeStorageImportTask(playbackVideoSourceClient, videoSourceId, this.core, this.watchdog, this);
                    edgeStorageImportTask.setPriority(0);
                    this.videoSourcesInProgress.add(edgeStorageImportTask.getVideoSourceId());
                    this.logger.info("Adding new EdgeStorageImportTask to executor service for " + playbackVideoSourceClient.getVideoSrv().getEntityName());
                    this.addTask(edgeStorageImportTask);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while creating new EdgeStorageImportTask! " + (Object)((Object)ex));
                }
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException interruptedException) {
                this.logger.warn("EdgeStorageHandling: Error while sleeping in " + this, (Throwable)interruptedException);
            }
        }
    }

    public static long[] getMinMaxTimestampFromList(List<TimeRange> gapList) {
        long startTimestamp = Long.MAX_VALUE;
        long endTimestamp = 0L;
        for (TimeRange timeRange : gapList) {
            if (timeRange.getStartTimestamp() < startTimestamp) {
                startTimestamp = timeRange.getStartTimestamp();
            }
            if (timeRange.getEndTimestamp() <= endTimestamp) continue;
            endTimestamp = timeRange.getEndTimestamp();
        }
        if (startTimestamp == Long.MAX_VALUE) {
            startTimestamp = 0L;
        }
        if (endTimestamp == 0L) {
            endTimestamp = Long.MAX_VALUE;
        }
        return new long[]{startTimestamp, endTimestamp};
    }

    public final boolean addPlaybackVideoSourceClient(PlaybackVideoSourceClient playbackVideoSourceClient) {
        if (playbackVideoSourceClient == null) {
            this.logger.warn("EdgeStorageHandling: playbackVideoSourceClient is NULL for " + this);
            return false;
        }
        if (this.queue.contains(playbackVideoSourceClient)) {
            this.logger.warn("EdgeStorageHandling: Queue already contains playbackVideoSourceClient for " + playbackVideoSourceClient.getVideoSrv());
            return false;
        }
        this.logger.info("Add PlaybackVideoSourceClient to queue: " + playbackVideoSourceClient);
        if (playbackVideoSourceClient.isManualTrigger()) {
            this.queue.addFirst(playbackVideoSourceClient);
            this.logger.info("Add PlaybackVideoSourceClient as first element to queue: " + playbackVideoSourceClient);
        } else {
            this.queue.addLast(playbackVideoSourceClient);
            this.logger.info("Add PlaybackVideoSourceClient as last element to queue: " + playbackVideoSourceClient);
        }
        this.logger.info("EdgeStorageHandling: Queue contains: " + this.queue.size() + " elements now");
        return true;
    }

    public final void removePlaybackVideoSourceClient(PlaybackVideoSourceClient playbackVideoSourceClient) {
        this.logger.info("Remove PlaybackVideoSourceClient to queue: " + playbackVideoSourceClient);
        if (playbackVideoSourceClient != null && this.queue.contains(playbackVideoSourceClient)) {
            this.queue.remove(playbackVideoSourceClient);
        }
        this.logger.info("EdgeStorageHandling: Queue contains: " + this.queue.size() + " elements now");
    }

    public static List<TimeRange> getOverlappingTimeRanges(List<TimeRange> deviceRecordings, List<TimeRange> gaps) {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        for (TimeRange timeRangeGap : gaps) {
            for (TimeRange timeRangeDevice : deviceRecordings) {
                if (!timeRangeGap.isPartOf(timeRangeDevice) && !timeRangeDevice.isPartOf(timeRangeGap)) continue;
                TimeRange gapToFill = new TimeRange(Math.max(timeRangeGap.getStartTimestamp(), timeRangeDevice.getStartTimestamp()), Math.min(timeRangeGap.getEndTimestamp(), timeRangeDevice.getEndTimestamp()), timeRangeDevice.getNameOfTimerange());
                result.add(gapToFill);
            }
        }
        return result;
    }

    public static List<TimeRange> removeOverlappingTimeRanges(List<TimeRange> overlappingTimeRanges, List<TimeRange> gapList) {
        ArrayList<TimeRange> resultList = new ArrayList<TimeRange>();
        overlappingTimeRanges.forEach(timeRange -> resultList.addAll(EdgeStorageHandler.removeOverlappingTimeRangeFromList(timeRange, gapList)));
        return resultList;
    }

    public static List<TimeRange> removeOverlappingTimeRangeFromList(TimeRange timeRange, List<TimeRange> gapList) {
        ArrayList<TimeRange> resultList = new ArrayList<TimeRange>();
        for (TimeRange tr : gapList) {
            resultList.addAll(EdgeStorageHandler.removeTimeRange(timeRange, tr));
        }
        return resultList;
    }

    public static List<TimeRange> removeTimeRange(TimeRange timeRangeToRemove, TimeRange containing) {
        ArrayList<TimeRange> resultList = new ArrayList<TimeRange>();
        if (timeRangeToRemove == null && containing != null) {
            resultList.add(containing);
            return resultList;
        }
        if (containing == null || timeRangeToRemove.equals(containing) || timeRangeToRemove.getStartTimestamp() < containing.getStartTimestamp() && timeRangeToRemove.getEndTimestamp() > containing.getEndTimestamp()) {
            return resultList;
        }
        if (timeRangeToRemove.getEndTimestamp() <= containing.getStartTimestamp() || timeRangeToRemove.getStartTimestamp() >= containing.getEndTimestamp()) {
            resultList.add(containing);
            return resultList;
        }
        if (containing.getStartTimestamp() < timeRangeToRemove.getStartTimestamp()) {
            resultList.add(new TimeRange(containing.getStartTimestamp(), timeRangeToRemove.getStartTimestamp()));
        }
        if (containing.getEndTimestamp() > timeRangeToRemove.getEndTimestamp()) {
            resultList.add(new TimeRange(timeRangeToRemove.getEndTimestamp(), containing.getEndTimestamp()));
        }
        return resultList;
    }

    @Override
    public synchronized void importFinished(Long videoSourceId) {
        this.videoSourcesInProgress.remove(videoSourceId);
    }

    synchronized void addTask(EdgeStorageImportTask edgeStorageImportTask) {
        this.executorService.execute(edgeStorageImportTask);
    }

    public final int shutdown() {
        this.isRunning = false;
        this.queue.clear();
        this.executorService.shutdownNow();
        this.watchdog.shutdown();
        return 0;
    }

    public final String toString() {
        return super.toString();
    }

    static List<TimeRange> removeShortGaps(List<TimeRange> recordingGaps) {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        for (TimeRange timeRange : recordingGaps) {
            if (timeRange.getLength() <= TimeUnit.SECONDS.toMillis(1L)) continue;
            result.add(timeRange);
        }
        return result;
    }

    @Override
    public long getLimitForGapSearching() {
        return this.limitForGapSearching;
    }
}

