/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.PtzCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourcesDefinitionType;
import de.seetec.v5.re.cm.device.DefinitionType;
import de.seetec.v5.re.cm.device.shared.DeviceClientRequestHandler;
import de.seetec.v5.re.cm.device.shared.LiveDevice;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.shared.ActionHandlerIntf;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.OpenProblemWrapper;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.tree.TreeNode;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public abstract class Device
extends Basic
implements SRPCDispatcherListener,
ActionHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.Device";
    protected static final String VIDEO_CAMERA_DEFINITION_NAME = "VideoCameraDefinition";
    public static final String VERSION_PREFIX = "RE_APP_VERSION::";
    protected Logger logger = null;
    protected Core core = null;
    private final Object CRH_SEMAPHORE = new Object();
    private List<DeviceClientRequestHandler> deviceClientRequestHandlerList = null;
    protected Tree<Entity> entityTree = null;
    private Entity deviceEntity = null;
    protected Service[] services = null;
    private Map<Long, Long> htSubEntities = null;
    private DeviceCnf deviceCnf = null;
    private IOHandler ioHandler = null;
    private final long tsStartup = System.currentTimeMillis();
    private LiveDevice liveDevice = null;
    protected DeviceDefinition deviceDefinitionFromConfiguration;
    protected VideoCameraDefinition videoCameraDefinitionFromConfiguration;

    public Device() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int initLiveDevice(Class<? extends VideoSrv> srvToStart) {
        if (srvToStart != null) {
            this.liveDevice = new LiveDevice();
            return this.liveDevice.init(this, this.getSrvEntities(), srvToStart);
        }
        this.logger.info("Don't start LiveDevice for " + this);
        return 0;
    }

    protected int init(Core core, long entityID) {
        int errorCode;
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.deviceClientRequestHandlerList = new ArrayList<DeviceClientRequestHandler>();
        try {
            errorCode = this.init(entityID);
            if (errorCode != 0) {
                return errorCode;
            }
            if (!this.deviceEntity.isEnabled().booleanValue()) {
                this.logger.warn(this + " is deactivated and will now be discarded!");
                return -21658;
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        DeviceCnf deviceCnf = new DeviceCnf(core.getLTESupportConfiguration());
        errorCode = deviceCnf.init(this.getDeviceEntity().getConfiguration());
        if (errorCode != 0) {
            this.logger.error("Initializing " + deviceCnf + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        String serverHostAddress = this.getServerHostAddressFromDMConf();
        NetworkParameter.setLocalServerAddress((String)serverHostAddress);
        this.deviceCnf = deviceCnf;
        if (this.isSupportingIO()) {
            try {
                this.ioHandler = this.createIOHandler();
                errorCode = this.ioHandler.init(this.core, this, this.getSrvEntities());
                if (errorCode != 0) {
                    this.ioHandler.shutdown();
                    this.logger.error("Initializing " + this.ioHandler + " failed with error [" + errorCode + "]");
                    return errorCode;
                }
            }
            catch (Exception ex) {
                this.logger.error("Creating [IOHandler] for " + this + " failed with [" + ex.getMessage() + "]", (Throwable)ex);
                return -21600;
            }
        }
        this.core.registerToSRPCDispatcher(this, this.getDeviceID());
        errorCode = this.core.registerEntity(this.getDeviceID(), this.getDeviceType());
        if (errorCode != 0) {
            this.logger.error("Registering " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.getCore().actionHandler.put(this.getDeviceID(), this);
        return errorCode;
    }

    private int init(long entityID) {
        this.htSubEntities = new Hashtable<Long, Long>();
        this.registerSubEntity(entityID);
        try {
            this.entityTree = this.core.getEntMgrProxy().getEntitiesAsTree(Long.valueOf(entityID), new ArrayList(), Boolean.valueOf(true), Integer.valueOf(TreeTypes.PHYSICALTREE.getType()), TimeUnit.SECONDS.toMillis(30L));
        }
        catch (SeeTecException ex) {
            this.logger.error("While getting Entities as Tree: ", (Throwable)ex);
        }
        if (this.entityTree == null) {
            this.logger.error("Cannot determine entity tree for id [" + entityID + "]");
            return -21602;
        }
        this.deviceEntity = (Entity)this.entityTree.getRoot().getData();
        if (this.deviceEntity == null) {
            this.logger.error("Cannot determine device entity");
            return -21602;
        }
        return 0;
    }

    public boolean hasNewVersionRelevantChanges(Long id) {
        TreeNode treeNode;
        Entity currentVersion = null;
        Entity newVersion = null;
        if (this.entityTree != null && (treeNode = (TreeNode)this.entityTree.getNodes().get("" + id)) != null) {
            currentVersion = (Entity)treeNode.getData();
        }
        try {
            newVersion = this.core.getEntMgrProxy().getEntityByID(id, Boolean.valueOf(true), 30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hasNewVersionRelevantChangesDecider(currentVersion, newVersion);
    }

    protected boolean hasNewVersionRelevantChangesDecider(Entity currentVersion, Entity newVersion) {
        boolean result = false;
        ArrayList<String> changedValues = new ArrayList<String>();
        String changedTemplate = "%s changed from %s to %s.";
        if (currentVersion != null && currentVersion.getEntityType() != null && (currentVersion.getEntityType() == 9814L || currentVersion.getEntityType() == 270700L)) {
            return false;
        }
        if (newVersion != null && newVersion.getEntityType() != null && (newVersion.getEntityType() == 9814L || newVersion.getEntityType() == 270700L)) {
            return false;
        }
        if (currentVersion == null || newVersion == null) {
            return true;
        }
        if (currentVersion.getEntityName() == null && newVersion.getEntityName() != null || currentVersion.getEntityName() != null && newVersion.getEntityName() == null || !currentVersion.getEntityName().equals(newVersion.getEntityName())) {
            changedValues.add(String.format(changedTemplate, "Name", currentVersion.getEntityName(), newVersion.getEntityName()));
            result = true;
        }
        if (currentVersion.getEntityType() == null && newVersion.getEntityType() != null || currentVersion.getEntityType() != null && newVersion.getEntityType() == null || !currentVersion.getEntityType().equals(newVersion.getEntityType())) {
            changedValues.add(String.format(changedTemplate, "Type", currentVersion.getEntityType(), newVersion.getEntityType()));
            result = true;
        }
        if (currentVersion.isEnabled() == null && newVersion.isEnabled() != null || currentVersion.isEnabled() != null && newVersion.isEnabled() == null || !currentVersion.isEnabled().equals(newVersion.isEnabled())) {
            changedValues.add(String.format(changedTemplate, "Active", currentVersion.isEnabled(), newVersion.isEnabled()));
            result = true;
        }
        if (currentVersion.getConfiguration() == null && newVersion.getConfiguration() != null || currentVersion.getConfiguration() != null && newVersion.getConfiguration() == null || !Arrays.equals(currentVersion.getConfiguration(), newVersion.getConfiguration())) {
            changedValues.add("Configuration changed.");
            result = true;
        }
        if (result) {
            StringBuilder changeInformation = new StringBuilder("Relevant changes to entity ");
            changeInformation.append(currentVersion.getEntityID());
            for (String line : changedValues) {
                changeInformation.append("\r\n");
                changeInformation.append("   ");
                changeInformation.append(line);
            }
            this.logger.info((CharSequence)changeInformation);
        }
        return result;
    }

    public boolean hasMutableEntityTree() {
        Long deviceType = this.getDeviceType();
        boolean result = deviceType == 230L || deviceType == 231L || deviceType == 232L || deviceType == 234L || deviceType == 235L;
        return result;
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        int errorCode = this.core.getDeviceLifeCycleInformation().setDeviceStopped(this);
        if (errorCode != 0) {
            this.logger.warn("Removing " + this + " failed with error [" + errorCode + "]");
        }
        long ts = System.currentTimeMillis();
        try {
            errorCode = this.core.deregisterEntity(this.getDeviceID());
            if (errorCode != 0) {
                this.logger.warn("Deregistering " + this + " failed with error [" + errorCode + "] after [" + Basic.longToFormattedString((long)(System.currentTimeMillis() - ts)) + "ms]");
            } else if (this.logger.isDebugEnabled()) {
                this.logger.info("Deregistering " + this + " within [" + Basic.longToFormattedString((long)(System.currentTimeMillis() - ts)) + " ms] successful");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Deregistering " + this + " failed with " + ex.getMessage() + " after [" + Basic.longToFormattedString((long)(System.currentTimeMillis() - ts)) + "ms]");
        }
        this.shutdownAllDeviceClientRequestHandlerAndSetListToNull();
        if (this.ioHandler != null) {
            this.ioHandler.shutdown();
            this.ioHandler = null;
        }
        this.deviceCnf = null;
        this.core.clearEntityStatus(this.deviceEntity.getEntityID());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAllDeviceClientRequestHandlerAndSetListToNull() {
        Object object = this.CRH_SEMAPHORE;
        synchronized (object) {
            if (this.deviceClientRequestHandlerList != null) {
                int numberOfNotDeregisterDeviceCRH = 0;
                for (int i = this.deviceClientRequestHandlerList.size() - 1; i >= 0; --i) {
                    DeviceClientRequestHandler deviceClientRequestHandler = this.deviceClientRequestHandlerList.get(i);
                    int shutdownError = deviceClientRequestHandler.shutdown();
                    if (shutdownError != 0) {
                        this.logger.warn("Shutting down [" + (Object)((Object)deviceClientRequestHandler) + "] failed with error [" + shutdownError + "] ");
                    }
                    if (i == this.deviceClientRequestHandlerList.size() - numberOfNotDeregisterDeviceCRH) continue;
                    this.logger.warn(" [" + (Object)((Object)deviceClientRequestHandler) + "] won't deregister from Device [ " + this.toString() + " ] ");
                    ++numberOfNotDeregisterDeviceCRH;
                }
                this.deviceClientRequestHandlerList.clear();
                this.deviceClientRequestHandlerList = null;
            }
        }
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() != 0) {
            this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported :-(");
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -21005;
        }
        return this.handleRequest(socket);
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn("... Client refused. Core is already shutting down");
            return -21609;
        }
        int activeThreads = Thread.activeCount();
        this.logger.info("New client from " + socket + ". There are already [" + Basic.longToFormattedString((long)activeThreads) + "] threads active!");
        if (activeThreads >= RECore.getThreadLimit()) {
            try {
                this.logger.error("There are already [" + Basic.longToFormattedString((long)activeThreads) + "] threads active. So, the client connection " + socket + " will be refused!");
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21680;
        }
        DeviceClientRequestHandler devCRH = new DeviceClientRequestHandler();
        int errorCode = devCRH.init(this, socket);
        if (errorCode != 0) {
            this.logger.error("Initializing " + (Object)((Object)devCRH) + " failed with error [" + errorCode + "]");
            errorCode = devCRH.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + (Object)((Object)devCRH) + " failed with error [" + errorCode + "]");
            }
            return errorCode;
        }
        return 0;
    }

    public Core getCore() {
        return this.core;
    }

    public Entity[] getSrvEntities() {
        List vChildren = this.entityTree.getRoot().getChildren();
        Entity[] srvEntities = new Entity[vChildren.size()];
        for (int i = 0; i < vChildren.size(); ++i) {
            srvEntities[i] = (Entity)((TreeNode)vChildren.get(i)).getData();
        }
        return srvEntities;
    }

    public int getNumberOfVideoSources() {
        Entity[] srvEntities;
        int numberOfVideoSources = 0;
        for (Entity srvEntitie : srvEntities = this.getSrvEntities()) {
            if (srvEntitie.getEntityType() < 210000L || srvEntitie.getEntityType() >= 220000L) continue;
            ++numberOfVideoSources;
        }
        return numberOfVideoSources;
    }

    public Entity[] getEnabledEntities(long[] path, long[] typeList) {
        return this.getEntities(path, typeList, true);
    }

    public Entity[] getAllEntities(long[] path, long[] typeList) {
        return this.getEntities(path, typeList, false);
    }

    private Entity[] getEntities(long[] path, long[] typeList, boolean enabled) {
        TreeNode actualNode = this.entityTree.getRoot();
        block0: for (int i = 0; i < path.length; ++i) {
            if (actualNode == null) {
                this.logger.warn("Cannot find path :-(");
                return new Entity[0];
            }
            List children = actualNode.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                TreeNode nextNode = (TreeNode)children.get(j);
                Entity entity = (Entity)nextNode.getData();
                if (entity.getEntityID() != path[i]) continue;
                if (!enabled || entity.isEnabled().booleanValue()) {
                    actualNode = nextNode;
                    continue block0;
                }
                this.logger.warn(nextNode + " not enabled");
                return new Entity[0];
            }
        }
        List vChildren = actualNode.getChildren();
        Vector<Entity> vEntities = new Vector<Entity>();
        block2: for (int i = 0; i < vChildren.size(); ++i) {
            Entity entity = (Entity)((TreeNode)vChildren.get(i)).getData();
            if (enabled && !entity.isEnabled().booleanValue()) continue;
            if (typeList != null) {
                for (int j = 0; j < typeList.length; ++j) {
                    if (entity.getEntityType() != typeList[j]) continue;
                    vEntities.add(entity);
                    continue block2;
                }
                continue;
            }
            vEntities.add(entity);
        }
        Entity[] entities = new Entity[vEntities.size()];
        for (int i = 0; i < vEntities.size(); ++i) {
            entities[i] = (Entity)vEntities.get(i);
        }
        return entities;
    }

    public DeviceCnf getDeviceCnf() {
        return this.deviceCnf;
    }

    public Entity getDeviceEntity() {
        return this.deviceEntity;
    }

    public void setDeviceEntity(Entity deviceEntity) {
        this.deviceEntity = deviceEntity;
    }

    public Long getDeviceID() {
        return this.deviceEntity.getEntityID();
    }

    public Long getDeviceType() {
        return this.deviceEntity.getEntityType();
    }

    public long getStartup() {
        return this.tsStartup;
    }

    public void registerSubEntity(Long entityID) {
        this.htSubEntities.put(entityID, entityID);
    }

    public boolean isSubEntity(Long entityID) {
        boolean found;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Looking for [" + entityID + "] within subentities " + this.entityTree.getNodes());
        }
        found = !(found = this.entityTree.getNodes().containsKey("" + entityID)) ? this.htSubEntities.containsKey(entityID) : found;
        return found;
    }

    public int checkDevice() {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        for (int i = 0; this.services != null && i < this.services.length; ++i) {
            if (this.services[i] == null) continue;
            long tsStart = System.currentTimeMillis();
            this.services[i].checkService();
            long duration = System.currentTimeMillis() - tsStart;
            if (duration <= 60000L) continue;
            this.logger.info("Checking " + (Object)((Object)this.services[i]) + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerClientRequestHandler(DeviceClientRequestHandler deviceClientRequestHandler) throws NullPointerException {
        Object object = this.CRH_SEMAPHORE;
        synchronized (object) {
            this.deviceClientRequestHandlerList.add(deviceClientRequestHandler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deregisterClientRequestHandler(DeviceClientRequestHandler deviceClientRequestHandler) {
        Object object = this.CRH_SEMAPHORE;
        synchronized (object) {
            for (int i = 0; this.deviceClientRequestHandlerList != null && i < this.deviceClientRequestHandlerList.size(); ++i) {
                if (this.deviceClientRequestHandlerList.get(i) != deviceClientRequestHandler) continue;
                this.deviceClientRequestHandlerList.remove(i);
                return 0;
            }
        }
        return -21640;
    }

    protected abstract int handleAction(Long var1, Long var2, Long var3, Long var4, byte[] var5);

    @Override
    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData, long ptzPriority, long ptzTimeout) {
        if (actionID == null) {
            actionID = -1L;
        }
        if (alarmScriptID == null) {
            alarmScriptID = -1L;
        }
        if (alarmInstanceID == null) {
            alarmInstanceID = -1L;
        }
        if (alarmDuration == null) {
            alarmDuration = -1L;
        }
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        return this.handleAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData);
    }

    public abstract int stopDevice();

    public String getFirmwareVersion() {
        return "<unknown>";
    }

    protected abstract IOHandler createIOHandler();

    protected abstract boolean isSupportingIO();

    public IOHandler getIOHandler() {
        return this.ioHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(long id) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (Service service : this.services) {
                if (service == null || service.getServiceID() != id) continue;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return service;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return null;
        }
    }

    public abstract int initializeDevice(long var1);

    public static <T> T unmarshalDefinition(Element currentDefinitionElement, Class<T> definitionClass) throws SeeTecException {
        try {
            if (currentDefinitionElement == null) {
                throw new SeeTecException(-20002, "Argument was null.");
            }
            String definitionString = new XMLOutputter().outputString(currentDefinitionElement);
            return (T)Basic.unmarshalXML(definitionClass, (Object)definitionString);
        }
        catch (JAXBException | SAXException excpetion) {
            throw new SeeTecException(-20002, "Not possible to unmarshal definition: " + excpetion.getMessage());
        }
    }

    protected final int getDefintions(GenericDeviceType genericDeviceType) {
        block23: {
            Element currentDeviceDefinitionsElement;
            Document deviceConf;
            Element currentVideoSourceDefinitionsElement = null;
            try {
                String xmlString = new String(this.getDeviceEntity().getConfiguration());
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                deviceConf = new SAXBuilder().build((InputStream)bais);
                Element root = deviceConf.getRootElement();
                currentDeviceDefinitionsElement = root.getChild(DefinitionType.DEVICE.getName());
                if (genericDeviceType.equals((Object)GenericDeviceType.VIDEO)) {
                    currentVideoSourceDefinitionsElement = root.getChild(DefinitionType.VIDEO_CAMERA.getName());
                }
            }
            catch (JDOMException exception) {
                this.logger.error("No configuration available", (Throwable)exception);
                return -21601;
            }
            String signature = null;
            String manufacturer = null;
            String name = null;
            String comments = null;
            if (currentDeviceDefinitionsElement != null) {
                try {
                    Element signatureElement = currentDeviceDefinitionsElement.getChild("Signature");
                    signature = signatureElement.getText();
                    Element manufacturerElement = currentDeviceDefinitionsElement.getChild("Manufacturer");
                    manufacturer = manufacturerElement.getText();
                    Element nameElement = currentDeviceDefinitionsElement.getChild("Name");
                    name = nameElement.getText();
                    Element commentsElement = currentDeviceDefinitionsElement.getChild("Comments");
                    for (Object child : commentsElement.getChildren()) {
                        Element childElement = (Element)child;
                        if (!childElement.getText().startsWith(VERSION_PREFIX)) continue;
                        comments = childElement.getText();
                        break;
                    }
                    try {
                        this.deviceDefinitionFromConfiguration = Device.unmarshalDefinition(currentDeviceDefinitionsElement, DeviceDefinition.class);
                        if (currentVideoSourceDefinitionsElement != null) {
                            this.videoCameraDefinitionFromConfiguration = Device.unmarshalDefinition(currentVideoSourceDefinitionsElement, VideoCameraDefinition.class);
                        }
                    }
                    catch (SeeTecException seeTecException) {
                        return seeTecException.getErrorCode();
                    }
                }
                catch (Exception exception) {
                    this.logger.error("Exception while reading device configuration for " + currentDeviceDefinitionsElement, (Throwable)exception);
                }
            }
            try {
                DeviceDefinition deviceDefinitionFromDevice = this.getDeviceDefinitionFromDevice(signature, manufacturer, name, comments);
                if (deviceDefinitionFromDevice != null) {
                    try {
                        VideoSourcesDefinitionType videoSourcesDefinition = this.getVideoSourcesDefinitionFromDevice(deviceDefinitionFromDevice.getNoOfCams());
                        deviceDefinitionFromDevice.setVideoSourcesDefinition(videoSourcesDefinition);
                        String deviceDefinitionXml = Basic.marshalXML((Object)deviceDefinitionFromDevice);
                        ByteArrayInputStream bais = new ByteArrayInputStream(deviceDefinitionXml.getBytes());
                        Document deviceDefinitionDocument = new SAXBuilder().build((InputStream)bais);
                        Element root = deviceConf.getRootElement();
                        if (currentDeviceDefinitionsElement != null) {
                            root.removeChild(DefinitionType.DEVICE.getName());
                        }
                        root.addContent(deviceDefinitionDocument.getRootElement());
                        VideoCameraDefinition videoCameraDefinitionFromDevice = null;
                        if (genericDeviceType.equals((Object)GenericDeviceType.VIDEO)) {
                            videoCameraDefinitionFromDevice = this.getVideoCameraDefinitionFromDevice();
                            String videoCameraDefinitionXml = Basic.marshalXML((Object)videoCameraDefinitionFromDevice);
                            bais = new ByteArrayInputStream(videoCameraDefinitionXml.getBytes());
                            Document videoCameraDefinitionDocument = new SAXBuilder().build((InputStream)bais);
                            if (currentVideoSourceDefinitionsElement != null) {
                                root.removeChild(DefinitionType.VIDEO_CAMERA.getName());
                            }
                            root.addContent(videoCameraDefinitionDocument.getRootElement());
                        }
                        XMLOutputter outputter = new XMLOutputter();
                        String xmlString = outputter.outputString(deviceConf);
                        this.core.getEntMgrProxy().setEntity(this.getDeviceEntity().getEntityID(), this.getDeviceEntity().getEntityName(), this.getDeviceEntity().getEntityType(), this.getDeviceEntity().getMID(), this.getDeviceEntity().isEnabled(), xmlString.getBytes(), null, null, null, null, null, this.core.getCayugaToken(), 30000L);
                        this.deviceDefinitionFromConfiguration = deviceDefinitionFromDevice;
                        if (genericDeviceType.equals((Object)GenericDeviceType.VIDEO)) {
                            this.videoCameraDefinitionFromConfiguration = videoCameraDefinitionFromDevice;
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        this.logger.error("Exception while writing device configuration for " + this, (Throwable)exception);
                    }
                    break block23;
                }
                Element root = deviceConf.getRootElement();
                try {
                    this.deviceDefinitionFromConfiguration = Device.unmarshalDefinition(root.getChild(DefinitionType.DEVICE.getName()), DeviceDefinition.class);
                    if (currentVideoSourceDefinitionsElement != null) {
                        this.videoCameraDefinitionFromConfiguration = Device.unmarshalDefinition(root.getChild(DefinitionType.VIDEO_CAMERA.getName()), VideoCameraDefinition.class);
                    }
                }
                catch (SeeTecException seeTecException) {
                    return seeTecException.getErrorCode();
                }
            }
            catch (SeeTecException exception) {
                this.logger.error((Object)exception);
                return exception.getErrorCode();
            }
        }
        return 0;
    }

    protected abstract DeviceDefinition getDeviceDefinitionFromDevice(String var1, String var2, String var3, String var4) throws SeeTecException;

    protected abstract VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException;

    protected VideoSourcesDefinitionType getVideoSourcesDefinitionFromDevice(int sourcesNumber) throws SeeTecException {
        return new VideoSourcesDefinitionType();
    }

    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int videoSourceNr) {
        return new ArrayList<TimeRange>();
    }

    protected abstract SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException;

    public final DeviceDefinition getDeviceDefinitionFromConfiguration() {
        return this.deviceDefinitionFromConfiguration;
    }

    public final VideoCameraDefinition getVideoCameraDefinitionFromConfiguration() {
        return this.videoCameraDefinitionFromConfiguration;
    }

    public final void updateGenericEventTriggerDefintion() throws Exception {
        XMLOutputter outputter = new XMLOutputter();
        String deviceConfigurationXml = new String(this.getDeviceEntity().getConfiguration());
        Document deviceDocument = new SAXBuilder().build((InputStream)new ByteArrayInputStream(deviceConfigurationXml.getBytes()));
        Element currentDeviceDefinitionsElement = deviceDocument.getRootElement().getChild(DefinitionType.DEVICE.getName());
        String deviceDefinitionString = outputter.outputString(currentDeviceDefinitionsElement);
        DeviceDefinition deviceDefinition = (DeviceDefinition)Basic.unmarshalXML(DeviceDefinition.class, (Object)deviceDefinitionString);
        if (deviceDefinition != null) {
            deviceDefinition.getSupportedGenericEvents().getGenericEventDefinition().clear();
            deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
            String deviceDefinitionXml = Basic.marshalXML((Object)deviceDefinition);
            Document deviceDefinitionDocument = new SAXBuilder().build((InputStream)new ByteArrayInputStream(deviceDefinitionXml.getBytes()));
            Element deviceDefintionRoot = deviceDocument.getRootElement();
            deviceDefintionRoot.removeChild(DefinitionType.DEVICE.getName());
            deviceDefintionRoot.addContent(deviceDefinitionDocument.getRootElement());
            String newConfiguration = outputter.outputString(deviceDocument);
            this.core.getEntMgrProxy().setEntity(this.getDeviceEntity().getEntityID(), this.getDeviceEntity().getEntityName(), this.getDeviceEntity().getEntityType(), this.getDeviceEntity().getMID(), this.getDeviceEntity().isEnabled(), newConfiguration.getBytes(), null, null, null, null, null, this.core.getCayugaToken(), 30000L);
        } else {
            this.logger.warn("DeviceDefinition is null for " + this);
        }
    }

    public final void sendCannotEstablishConnectionLoggingEvent(int statusCode) throws ConfigurationException {
        String serverAddressDM;
        try {
            serverAddressDM = this.getCore().getDmCnfMgr().getServerAddress();
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException("Could not read DM ServerAddress from configuration");
        }
        this.getCore().sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getDeviceID());
        this.getCore().sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getDeviceID(), statusCode, "Cannot establish connection to [" + this.getDeviceEntity().getEntityName() + "]", "Cannot establish connection to [Name: " + this.getDeviceEntity().getEntityName() + "] from DM [" + serverAddressDM + "] because of error [" + statusCode + "].");
    }

    public final void sendResolvedConnectionEvent(long id) {
        String entityName = "Unknown";
        String localHostAddress = "Unknown";
        try {
            localHostAddress = this.getCore().getDmCnfMgr().getServerAddress();
            entityName = this.getDeviceEntity().getEntityName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            OpenProblemWrapper openProblemWrapper = this.getCore().getSqlDatabaseHandler().getOpenProblem(id, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM);
            if (openProblemWrapper != null) {
                this.getCore().sendConnectivityProblemResolvedEvent(openProblemWrapper.getSourceId(), openProblemWrapper.getTimestamp(), "Connection established for [" + entityName + "]", "Connection established for [" + entityName + "] from [" + localHostAddress + "].");
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error retrieving open problem for: " + id);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.Device@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.deviceEntity + "]";
    }

    private String getServerHostAddressFromDMConf() {
        String localServerAddress;
        try {
            localServerAddress = this.core.getDmCnfMgr().getServerAddress();
        }
        catch (ConfigurationException ce) {
            localServerAddress = null;
        }
        if (localServerAddress == null) {
            try {
                localServerAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                this.logger.error("Retrieving IP/hostname failed with error " + this.toString());
                localServerAddress = null;
            }
        }
        return localServerAddress;
    }

    protected PtzCapabilitiesType convertFeatureTypeToPtzCapabilitiesType(FeaturesType featuresType) {
        PtzCapabilitiesType ptzCapabilitiesType = null;
        if (featuresType != null) {
            ptzCapabilitiesType = new PtzCapabilitiesType();
            ptzCapabilitiesType.setCanAbsolutePan(featuresType.isCanAbsolutePan());
            ptzCapabilitiesType.setCanAbsoluteTilt(featuresType.isCanAbsoluteTilt());
            ptzCapabilitiesType.setCanAbsoluteZoom(featuresType.isCanAbsoluteZoom());
            ptzCapabilitiesType.setCanAutoFocus(featuresType.isCanAutoFocus());
            ptzCapabilitiesType.setCanAutoIris(featuresType.isCanAutoIris());
            ptzCapabilitiesType.setCanAutoNullLux(featuresType.isCanAutoNullLux());
            ptzCapabilitiesType.setCanCenterPT(featuresType.isCanCenterPT());
            ptzCapabilitiesType.setCanContinuousPan(featuresType.isCanContinuousPan());
            ptzCapabilitiesType.setCanContinuousTilt(featuresType.isCanContinuousTilt());
            ptzCapabilitiesType.setCanContinuousZoom(featuresType.isCanContinuousZoom());
            ptzCapabilitiesType.setCanFocus(featuresType.isCanFocus());
            ptzCapabilitiesType.setCanIris(featuresType.isCanIris());
            ptzCapabilitiesType.setCanNullLux(featuresType.isCanNullLux());
            ptzCapabilitiesType.setCanPreset(featuresType.isCanPreset());
            ptzCapabilitiesType.setCanRelativePan(featuresType.isCanRelativePan());
            ptzCapabilitiesType.setCanRelativeTilt(featuresType.isCanRelativeTilt());
            ptzCapabilitiesType.setCanRelativeZoom(featuresType.isCanRelativeZoom());
            ptzCapabilitiesType.setMaxAbsoluteZoom(featuresType.getMaxAbsoluteZoom());
            ptzCapabilitiesType.setMaxPan(featuresType.getMaxPan());
            ptzCapabilitiesType.setMaxSpeed(featuresType.getMaxSpeed());
            ptzCapabilitiesType.setMaxTilt(featuresType.getMaxTilt());
            ptzCapabilitiesType.setMaxZoom(featuresType.getMaxZoom());
            ptzCapabilitiesType.setMinAbsoluteZoom(featuresType.getMinAbsoluteZoom());
            ptzCapabilitiesType.setMinPan(featuresType.getMinPan());
            ptzCapabilitiesType.setMinSpeed(featuresType.getMinSpeed());
            ptzCapabilitiesType.setMinTilt(featuresType.getMinTilt());
            ptzCapabilitiesType.setMinZoom(featuresType.getMinZoom());
            ptzCapabilitiesType.setPTZContinuousSpeedFactor(featuresType.getPTZContinuousSpeedFactor());
            ptzCapabilitiesType.setPTZMaxContinuousLevel(featuresType.getPTZMaxContinuousLevel());
            ptzCapabilitiesType.setPTZMinContinuousLevel(featuresType.getPTZMinContinuousLevel());
        }
        return ptzCapabilitiesType;
    }

    protected static enum GenericDeviceType {
        VIDEO,
        ACCESS;

    }
}

