/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream {
    private InputStream in;
    private int buffer;
    private int nextBit = 8;

    public BitInputStream(byte[] buf) {
        this.in = new ByteArrayInputStream(buf);
    }

    public synchronized void skipBits(int biteToSkip) throws IOException {
        for (int i = 0; i < biteToSkip; ++i) {
            this.readBit();
        }
    }

    public synchronized int readBit() throws IOException {
        if (this.in == null) {
            throw new IOException("Already closed");
        }
        if (this.nextBit == 8) {
            this.buffer = this.in.read();
            if (this.buffer == -1) {
                throw new EOFException();
            }
            this.nextBit = 0;
        }
        int bit = this.buffer & 128 >> this.nextBit;
        ++this.nextBit;
        return bit == 0 ? 0 : 1;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }
}

