/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.sip;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.sip.AudioSrvCRH;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.shared.Action;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.Trigger;
import de.seetec.v5.re.cm.shared.communication.ContentStream;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.re.cm.shared.communication.RecordingHandler;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.shared.AudioSrvCnf;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.TimerangeCnf;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.RspGetRecordingInfos;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class AudioSrv
extends Service
implements SRPCDispatcherListener,
MDBAccessorIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.sip.AudioSrv";
    private final Object CRH_SEMAPHORE = new Object();
    private final Object MDB_SEMAPHORE = new Object();
    private List<AudioSrvCRH> clientRequestHandlerList = null;
    private RecordingHandler recordingHandler = null;
    private Action[] actions = null;
    private AudioSrvCnf audioSrvCnf = null;
    private TimerangeCnf stdRecTimerange = null;
    private Trigger triggerAudioCallRequest = null;
    private Trigger triggerAudioCallStop = null;
    private long tsLastTryToGetRecordingHandler = -1L;

    public final int init(Core core, Device device, Entity entity, Trigger[] trigger) {
        try {
            int errorCode = super.init(core, device, entity);
            if (errorCode != 0) {
                return errorCode;
            }
            errorCode = this.init(trigger);
            try {
                super.getCore().setEntityStatus(super.getEntity().getEntityID(), errorCode);
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            super.getCore().registerToSRPCDispatcher(this, entity.getEntityID());
            this.logger.info("Registering " + this + " ... ");
            errorCode = this.getCore().registerEntity(entity.getEntityID(), entity.getEntityType());
            if (errorCode != 0) {
                this.logger.error("Registering " + this + " failed with error [" + errorCode + "] ");
                return errorCode;
            }
            return errorCode;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -21600;
        }
    }

    private int init(Trigger[] trigger) throws Exception {
        this.clientRequestHandlerList = new Vector<AudioSrvCRH>();
        for (Trigger trigger1 : trigger) {
            if (trigger1.getTriggerType() == 9811L) {
                this.triggerAudioCallRequest = trigger1;
                continue;
            }
            if (trigger1.getTriggerType() == 9812L) {
                this.triggerAudioCallStop = trigger1;
                continue;
            }
            this.logger.warn("Ignoring " + trigger1 + "!");
        }
        this.audioSrvCnf = new AudioSrvCnf();
        int errorCode = this.audioSrvCnf.init(super.getEntity());
        if (errorCode != 0) {
            this.logger.error("Creating [AudioSrvCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        long[] typeList = new long[]{9901L, 9902L, 9903L, 9904L};
        Entity[] entities = super.getDevice().getEnabledEntities(new long[]{super.getEntity().getEntityID()}, typeList);
        this.actions = new Action[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            this.actions[i] = new Action();
            if (this.actions[i].init(entities[i]) == 0) continue;
            this.logger.error("Cannot initialize action [" + entities[i] + "] ");
            return -21671;
        }
        boolean recordingEnabled = this.audioSrvCnf.isRecordingEnabled("Standard");
        long timerangeEntityID = this.audioSrvCnf.getTimeRangeID("Standard");
        this.stdRecTimerange = new TimerangeCnf(super.getCore().getWorkCenterCalendarRepository());
        if (!recordingEnabled) {
            this.stdRecTimerange.init(false);
            errorCode = 0;
        } else if (timerangeEntityID < 0L) {
            this.stdRecTimerange.init(true);
            errorCode = 0;
        } else {
            try {
                Entity timerangeEntity = super.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(timerangeEntityID), Boolean.TRUE, 30000L);
                errorCode = this.stdRecTimerange.init(timerangeEntity.getConfiguration());
                if (errorCode != 0) {
                    this.logger.error("Creating [TimerangeCnf] failed with error [" + errorCode + "] ");
                    return errorCode;
                }
            }
            catch (SeeTecException srpcex) {
                this.logger.warn((Object)srpcex, (Throwable)srpcex);
                if (srpcex.getErrorCode() != -20110) {
                    throw new RuntimeException(srpcex.getMessage());
                }
                this.logger.info("Timerange with id [" + Basic.longToFormattedString((long)timerangeEntityID) + "] is no longer available. Mode [always] will be used!");
                this.stdRecTimerange.init(true);
            }
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Shutting down " + this + " ...");
        try {
            if (this.clientRequestHandlerList != null) {
                AudioSrvCRH[] clientRequestHandler = this.clientRequestHandlerList.toArray(new AudioSrvCRH[this.clientRequestHandlerList.size()]);
                for (int i = clientRequestHandler.length; i > 0; --i) {
                    clientRequestHandler[i - 1].shutdown();
                }
            }
            this.clientRequestHandlerList = null;
        }
        catch (Throwable ex) {
            this.logger.warn("Exception while shutting down CRH of " + this + ": " + ex, ex);
        }
        if (this.recordingHandler != null) {
            int errorCode = this.recordingHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.recordingHandler + " failed with error [" + errorCode + "] ");
            }
            this.recordingHandler = null;
        }
        return super.shutdown();
    }

    public Long getEntityID() {
        return super.getEntity().getEntityID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordingHandler getRecordingHandler() {
        Object object = this.MDB_SEMAPHORE;
        synchronized (object) {
            while (true) {
                if (this.recordingHandler != null && !this.recordingHandler.isShutdown()) {
                    return this.recordingHandler;
                }
                if (this.getCore() != null && this.getCore().isShutdown()) {
                    this.logger.warn((Object)((Object)this.getCore()) + " is already shutting down!");
                    return null;
                }
                if (this.isShutdown(CLASS_NAME)) {
                    this.logger.warn(this + " is already shutting down!");
                    return null;
                }
                if (this.tsLastTryToGetRecordingHandler + 60000L < System.currentTimeMillis()) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.tsLastTryToGetRecordingHandler = System.currentTimeMillis();
            RecordingHandler recHandler = new RecordingHandler();
            int errorCode = recHandler.init(super.getCore(), this);
            if (errorCode != 0) {
                recHandler.shutdown();
                this.logger.error("Connecting MultimediaDatabase failed with error [" + errorCode + "] ");
                throw new RuntimeException("Initializing [RecordingHandler] failed with error [" + errorCode + "] ");
            }
            this.recordingHandler = recHandler;
        }
        return this.recordingHandler;
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() == 0) {
            return this.handleRequest(socket);
        }
        if (networkDispatcherHeader.getProtocol() == 1) {
            NetworkClientProxy networkClientProxy = new NetworkClientProxy(this.getCore().getConfigurationProvider());
            int errorCode = networkClientProxy.init(socket, networkDispatcherHeader.getClientID());
            if (errorCode != 0) {
                this.logger.error("Creating [NetworkClientProxy] with " + socket + "/" + networkDispatcherHeader + " failed with error [" + errorCode + "] ");
                try {
                    socket.close();
                }
                catch (IOException | NullPointerException exception) {
                    // empty catch block
                }
                return errorCode;
            }
            this.logger.info(socket + " used now as ContentStream for client [" + networkDispatcherHeader.getClientID() + "]");
            return super.getCore().registerNetworkClientProxy(networkClientProxy);
        }
        this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported. " + socket);
        try {
            socket.close();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        return -21005;
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            try {
                this.logger.error("... Client refused. " + this + " is already shutting down ");
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21609;
        }
        int activeThreads = Thread.activeCount();
        if (activeThreads >= RECore.getThreadLimit()) {
            try {
                this.logger.error("There are already [" + activeThreads + "] threads active. So, the client connection " + socket + " will be refused!");
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21680;
        }
        try {
            AudioSrvCRH audioSrvCRH = new AudioSrvCRH();
            int errorCode = audioSrvCRH.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing [AudioSrvCRH] failed with error [" + errorCode + "] ");
                errorCode = audioSrvCRH.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down " + audioSrvCRH + " failed with error [" + errorCode + "] ");
                }
                return errorCode;
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            try {
                socket.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int registerAudioSrvCRH(AudioSrvCRH audioSrvClientRequestHandler) {
        this.clientRequestHandlerList.add(audioSrvClientRequestHandler);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deregisterAudioSrvCRH(AudioSrvCRH audioSrvClientRequestHandler) {
        Object object = this.CRH_SEMAPHORE;
        synchronized (object) {
            for (int i = 0; this.clientRequestHandlerList != null && i < this.clientRequestHandlerList.size(); ++i) {
                if (this.clientRequestHandlerList.get(i) != audioSrvClientRequestHandler) continue;
                this.clientRequestHandlerList.remove(i);
                return 0;
            }
        }
        return -21640;
    }

    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        String sAlarmScriptID = "_undefined_";
        String sAlarmDuration = "_undefined_";
        if (alarmDuration != null && alarmDuration >= 0L) {
            sAlarmDuration = Basic.longToFormattedString((long)(alarmDuration / 1000L)) + "," + alarmDuration % 1000L + " s";
        }
        if (alarmScriptID != null && alarmScriptID >= 0L) {
            sAlarmScriptID = Basic.longToFormattedString((Long)alarmScriptID);
        }
        this.logger.info("Action [" + actionID + "] of scenario [" + sAlarmScriptID + "] with duration [" + sAlarmDuration + "] is triggered for " + this + " ...");
        if (this.isShutdown(CLASS_NAME) || this.getCore().isShutdown()) {
            this.logger.warn("Cannot trigger action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] because of shutdown of " + this + " ");
            return -21609;
        }
        for (Action action : this.actions) {
            long foundActionID = action.getActionID();
            long foundActionType = action.getActionType();
            if (foundActionID != actionID) continue;
            if (foundActionType == 9901L) {
                return this.getRecordingHandler().startStandardRecording(actionID, alarmScriptID, alarmInstanceID, System.currentTimeMillis() + alarmDuration, genericData);
            }
            if (foundActionType == 9902L) {
                return this.getRecordingHandler().stopStandardRecording(actionID, alarmScriptID, alarmInstanceID, genericData);
            }
            if (foundActionType == 9903L) {
                try {
                    long tsMaxRecording = System.currentTimeMillis() + this.audioSrvCnf.getPostEventTime();
                    if (alarmDuration >= 0L) {
                        tsMaxRecording = System.currentTimeMillis() + alarmDuration;
                    }
                    return this.getRecordingHandler().startAlarmRecording(actionID, alarmScriptID, alarmInstanceID, tsMaxRecording, genericData);
                }
                catch (Exception ce) {
                    this.logger.error("Starting alarm recording for " + this + " failed ", (Throwable)ce);
                    return -21677;
                }
            }
            if (foundActionType == 9904L) {
                this.logger.info("Stop alarm recording of " + this + "!");
                return this.getRecordingHandler().stopAlarmRecording(actionID, alarmScriptID, alarmInstanceID, genericData);
            }
            this.logger.error("Action type [" + foundActionType + "] is unknown to " + this + " ");
            return -21672;
        }
        this.logger.error("Action [" + actionID + "] is unknown to " + this + " ");
        return -21670;
    }

    public int publishTrigger(boolean alarmRecording, long eventType, String caller, String callee, long tsStart, long tsEnd, byte[] recording) {
        this.logger.info("EventType=[" + Basic.longToFormattedString((long)eventType) + "], Caller=[" + caller + "], Callee=[" + callee + "], AlarmRecording=[" + alarmRecording + "] for " + this);
        if (eventType == 551L) {
            return super.getCore().sendApplicationEvent(this.triggerAudioCallRequest.getTriggerID());
        }
        if (eventType == 553L) {
            return super.getCore().sendApplicationEvent(this.triggerAudioCallStop.getTriggerID());
        }
        if (eventType == 554L) {
            int mediatype = 16;
            int attributes = 0;
            ContentFrame contentFrame = new ContentFrame(mediatype, attributes, tsStart, tsEnd, recording);
            RecordingHandler recHandler = this.getRecordingHandler();
            DatabaseWriter databaseWriter = this.getRecordingHandler().getDatabaseWriter();
            if (alarmRecording) {
                recHandler.startAlarmRecording();
                int errorCode = databaseWriter.deliverFrameToArchiveImmediately(contentFrame);
                if (errorCode != 0) {
                    this.logger.error("Exception while delivering Audio frame for Alarm Recording");
                    return errorCode;
                }
                recHandler.stopAlarmRecording();
                this.logger.info("Audio recording " + contentFrame + " stored to alarm track");
            } else {
                recHandler.startStandardRecording();
                int errorCode = databaseWriter.deliverFrameToArchiveImmediately(contentFrame);
                if (errorCode != 0) {
                    this.logger.error("Exception while delivering Audio frame for Standard Recording");
                    return errorCode;
                }
                recHandler.stopStandardRecording();
                this.logger.info("Audio recording " + contentFrame + " stored to standard track");
            }
            return 0;
        }
        this.logger.info("Ignoring trigger [" + eventType + "] for " + this);
        return 0;
    }

    @Override
    public long getContentID() {
        return super.getServiceID();
    }

    @Override
    public String getContentName() {
        return super.getServiceName();
    }

    @Override
    public MDBCnfIntf getMDBCnf() {
        return this.audioSrvCnf;
    }

    @Override
    public long getRecordingDuration() {
        try {
            return this.stdRecTimerange.getExpirationTime(System.currentTimeMillis());
        }
        catch (Exception ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            throw new RuntimeException("Cannot determine recording duration ");
        }
    }

    @Override
    public int checkService() {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        if (this.getRecordingHandler() == null) {
            return -21600;
        }
        return 0;
    }

    public int getRecordingInfosFromMdb(ReqGetRecordingInfos request, List<RspGetRecordingInfos> vResult) {
        long mdbId;
        int errorCode = 0;
        try {
            mdbId = this.getCore().getMultimediaDatabaseLifeCycle().getMultimediaDatabaseRuntime();
        }
        catch (Throwable throwable) {
            this.logger.error("Cannot locate MDB ");
            return -21631;
        }
        ArrayList<Long> mdbIds = new ArrayList<Long>();
        mdbIds.add(mdbId);
        try {
            long failoverMdbId = this.getDevice().getCore().getFailoverMdbID();
            if (failoverMdbId != -1L) {
                mdbIds.add(failoverMdbId);
            }
        }
        catch (Throwable throwable) {
            this.logger.info("Failover MDB cannot be found. ");
        }
        for (Long id : mdbIds) {
            DatabaseProxy mdsProxy = null;
            long mdbDeviceId = id + 1L;
            try {
                mdsProxy = this.getCore().createDatabaseProxy(null, mdbDeviceId);
                errorCode = mdsProxy.getRecordingInformation(request, vResult);
                if (errorCode != 0) {
                    this.logger.warn("[MDSProxy::getRecordingInfos] at [" + mdbDeviceId + "] failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
            }
            if (mdsProxy == null) continue;
            try {
                mdsProxy.shutdown();
            }
            catch (Throwable throwable) {}
        }
        return errorCode;
    }

    @Override
    public void setVideoMode(String videoMode) {
    }

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
    }

    public ContentStreamIntf createContentStream(int openingMode) {
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down ");
        }
        if (openingMode == 0) {
            return new ContentStream();
        }
        throw new RuntimeException("Opening mode [" + openingMode + " for " + this + " not supported for " + this + " ");
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "]";
    }

    @Override
    public TimeRangeInfoContainer getRecordingInfos(ReqGetRecordingInfos request, boolean retrieveFromMDB, boolean useCleanAndMerge) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

