/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.sip;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.other.sip.AudioSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.shared.Trigger;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;

public class AudioDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.sip.AudioDevice";
    private AudioSrv audioSrv = null;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        Entity[] srvEnities = super.getSrvEntities();
        this.services = new Service[srvEnities.length];
        for (int i = 0; i < srvEnities.length; ++i) {
            Entity entity = srvEnities[i];
            boolean enabled = entity.isEnabled();
            long srvID = entity.getEntityID();
            long srvType = entity.getEntityType();
            String srvName = srvEnities[i].getEntityName();
            Service lastService = null;
            try {
                if (!enabled) {
                    this.logger.info("Service [" + srvID + "]/[" + srvName + "] with type [" + srvType + "] disabled");
                    continue;
                }
                this.logger.info("Service [" + srvID + "]/[" + srvName + "] with type [" + srvType + "] will be activated ...");
                if (srvType == 2500L) {
                    long[] typeList = new long[]{9811L, 9812L};
                    Entity[] entities = super.getEnabledEntities(new long[]{srvID}, typeList);
                    Trigger[] trigger = new Trigger[entities.length];
                    for (int j = 0; j < entities.length; ++j) {
                        trigger[j] = new Trigger();
                        trigger[j].init(entities[j]);
                    }
                    AudioSrv audioSrv = new AudioSrv();
                    lastService = audioSrv;
                    errorCode = audioSrv.init(core, this, srvEnities[i], trigger);
                    if (errorCode != 0) {
                        audioSrv.shutdown();
                        this.logger.error("Creating " + (Object)((Object)lastService) + " failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                    this.audioSrv = audioSrv;
                    this.services[i] = this.audioSrv;
                } else {
                    this.logger.warn("Service [" + Basic.longToFormattedString((long)srvType) + "] not supported for " + this);
                }
                if (!this.isShutdown(CLASS_NAME)) continue;
                this.logger.warn(this + " is already shutting down!");
                if (lastService == null) break;
                lastService.shutdown();
                break;
            }
            catch (Exception ex) {
                if (lastService != null) {
                    lastService.shutdown();
                }
                this.logger.error((Object)ex, (Throwable)ex);
                this.logger.error("Creating " + this + " failed");
                return -1;
            }
        }
        this.logger.info(this + " initialized");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Starting shutdown of " + this + " ...");
        if (this.services != null) {
            this.logger.info("Shutting down [" + this.services.length + "] services ...");
            for (Service service : this.services) {
                int errorCode;
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
            }
        }
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        this.logger.error("NOT YET IMPLEMENTED for " + this + " :-(");
        return -21600;
    }

    @Override
    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            try {
                this.logger.error("... Client refused. " + this + " is already shutting down");
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21609;
        }
        return this.audioSrv.handleRequest(socket);
    }

    public int processEvent(boolean alarmRecording, long eventType, String caller, String callee, long tsStart, long tsEnd, byte[] recording) {
        if (eventType == 554L || this.getSIPAddress().equals(caller)) {
            return this.audioSrv.publishTrigger(alarmRecording, eventType, caller, callee, tsStart, tsEnd, recording);
        }
        this.logger.info("Event [" + Basic.longToFormattedString((long)eventType) + "] for call [" + caller + "]/[" + caller + "] not interesting for " + this);
        return 0;
    }

    public String getSIPAddress() {
        try {
            return super.getDeviceCnf().getGenericParameter("SIPAddress");
        }
        catch (Throwable cex) {
            return "<unknown>";
        }
    }

    @Override
    public int initializeDevice(long srvType) {
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ", SIPAddress=[" + this.getSIPAddress() + "], " + this.audioSrv + "]";
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

