/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCDataUnit;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCSecUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchneiderITCMessage {
    private static final Logger ICX_LOG = LogManager.getLogger((String)"ICX");
    private static final byte RESERVE = 0;
    private static final byte START_MIN = -16;
    private static final byte START_MAX = -10;
    private byte indicator = 0;
    private byte[] icx = null;
    private SchneiderITCDataUnit payload = null;

    private static SchneiderITCMessage create(byte type) {
        SchneiderITCMessage message = new SchneiderITCMessage();
        message.indicator = type;
        ICX_LOG.debug("ICX Created message type [" + Integer.toHexString(type & 0xFF) + "]");
        return message;
    }

    public static SchneiderITCMessage createResponseMessage(byte[] nonce, byte[] passwordHash) {
        SchneiderITCMessage message = SchneiderITCMessage.create((byte)-11);
        byte[] resp = SchneiderITCSecUtils.calcChallangeResponse(nonce, passwordHash);
        message.icx = resp;
        return message;
    }

    public static SchneiderITCMessage createWatchDogResponse(SchneiderITCDataUnit payLoad) {
        SchneiderITCMessage message = new SchneiderITCMessage();
        message.indicator = (byte)-14;
        message.payload = SchneiderITCDataUnit.createWatchDogResponse(payLoad);
        return message;
    }

    public static SchneiderITCMessage createIdleMessage() {
        return SchneiderITCMessage.create((byte)-15);
    }

    public static SchneiderITCMessage deserialize(byte[] foundMessage) {
        SchneiderITCMessage message = SchneiderITCMessage.create(foundMessage[0]);
        message.icx = new byte[foundMessage.length - 3];
        System.arraycopy(foundMessage, 2, message.icx, 0, message.icx.length);
        return message;
    }

    public static int findMessageStart(byte[] inBuffer) {
        int index = -1;
        for (int i = 0; i < inBuffer.length; ++i) {
            byte b = inBuffer[i];
            if (b <= -16 || b >= -10) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int findMessageEnd(byte[] inBuffer, int startAt) {
        int index = -1;
        if (startAt >= inBuffer.length) {
            return -1;
        }
        if (startAt < 0) {
            return -1;
        }
        for (int i = startAt; i < inBuffer.length; ++i) {
            if (inBuffer[i] != -1) continue;
            index = i;
            break;
        }
        return index;
    }

    public byte[] serialize() throws IOException {
        byte[] finalMessage;
        if (null == this.icx) {
            finalMessage = new byte[]{this.indicator, 0, -1};
        } else {
            ByteArrayOutputStream builder = new ByteArrayOutputStream();
            builder.write(this.indicator);
            builder.write(0);
            builder.write(this.icx);
            builder.write(-1);
            finalMessage = builder.toByteArray();
        }
        return finalMessage;
    }

    public byte getIndicator() {
        return this.indicator;
    }

    public SchneiderITCDataUnit getPayload() {
        if (null == this.icx) {
            return null;
        }
        if (null == this.payload) {
            try {
                this.payload = SchneiderITCDataUnit.create(this.icx);
            }
            catch (Exception ex) {
                ICX_LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return this.payload;
    }

    public byte[] getICX() {
        return this.icx;
    }
}

