/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.configuration.device.other.schneideritc.device.SchneiderITCDevice;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCSecUtils;
import de.seetec.v5.shared.Basic;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class SchneiderITCDeviceCnf {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private SchneiderITCDevice schneiderDevice = null;

    public int init(byte[] configuration) {
        if (configuration == null) {
            return -20002;
        }
        try {
            this.schneiderDevice = (SchneiderITCDevice)Basic.unmarshalXML(SchneiderITCDevice.class, (Object)configuration);
            return 0;
        }
        catch (JAXBException | SAXException jaxbException) {
            this.logger.warn("Can't deserialize doorset for " + this);
            return -20002;
        }
    }

    public String getHost() {
        return this.schneiderDevice.getRemoteHost();
    }

    public int getPort() {
        return this.schneiderDevice.getRemotePort();
    }

    public boolean isUseAuthentication() {
        return this.schneiderDevice.isUseAuthentication();
    }

    public byte[] getPasswordHash() {
        if (!this.isUseAuthentication()) {
            return null;
        }
        String configChild = this.schneiderDevice.getPassword();
        byte[] pwHash = null;
        if (null != configChild) {
            pwHash = configChild.getBytes();
        } else {
            configChild = this.schneiderDevice.getPassword();
            if (null != configChild) {
                pwHash = SchneiderITCSecUtils.calculatePasswordHash(configChild);
            }
        }
        return pwHash;
    }
}

