/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.networkio;

import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkDevice;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkSrv;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkProtocolHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private GenericNetworkDevice device = null;
    private Thread myThread = null;
    private long nextSocketCheckTime;
    private String connectTo = null;
    private int listenerPort = -1;
    private String protocolType = null;
    private Vector<GenericNetworkSrv> services = null;
    private boolean keepAlive = false;
    private Socket socket = null;
    private ServerSocket serverSocket = null;
    private MessageDelivery messageDelivery = null;
    private String controlCharacter = null;

    public int init(GenericNetworkDevice device, String protocolType, String connectTo, int listenerPort, boolean keepAlive, String controlCharacter) {
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.protocolType = protocolType;
        if (this.protocolType == null) {
            return -21601;
        }
        this.connectTo = connectTo;
        this.listenerPort = listenerPort;
        if (this.listenerPort <= 0) {
            return -21601;
        }
        this.keepAlive = keepAlive;
        this.controlCharacter = controlCharacter;
        this.services = new Vector();
        this.messageDelivery = new MessageDelivery();
        this.messageDelivery.init();
        if (this.keepAlive || this.connectTo.length() <= 0) {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        this.logger.info("Initializing successful for " + this);
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.messageDelivery != null) {
            this.messageDelivery.shutdown();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
            this.socket = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
            this.serverSocket = null;
        }
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myThread = null;
        }
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            if (this.connectTo.length() > 0) {
                this.activeConnect();
            } else if (this.protocolType.equals("TCP (permanently)")) {
                this.permanentListenerModus();
            } else {
                this.listenerModus();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void activeConnect() {
        boolean writeLogOutput = true;
        while (!this.isShutdown(CLASS_NAME) && !this.device.getCore().isShutdown()) {
            block9: {
                try {
                    this.socket = new Socket(this.connectTo, this.listenerPort);
                    this.socket.setSoTimeout(1000);
                    InputStream inputStream = this.socket.getInputStream();
                    byte[] buffer = new byte[4096];
                    writeLogOutput = true;
                    while (!this.isShutdown(CLASS_NAME)) {
                        int len;
                        try {
                            len = inputStream.read(buffer);
                        }
                        catch (SocketTimeoutException ste) {
                            this.checkIfSocketIsConnected();
                            continue;
                        }
                        if (len > 0) {
                            byte[] result = new byte[len];
                            System.arraycopy(buffer, 0, result, 0, len);
                            for (int i = 0; i < this.services.size(); ++i) {
                                GenericNetworkSrv service = this.services.elementAt(i);
                                service.checkIncomingMessage(result);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioex) {
                    if (this.isShutdown(CLASS_NAME)) {
                        this.logger.info(this + " is shutting down ...");
                    }
                    if (!writeLogOutput) break block9;
                    this.logger.warn("Problems with tcp connection [" + this.connectTo + ":" + this.listenerPort + "]");
                    this.logger.info("Try new tcp connection to [" + this.connectTo + ":" + this.listenerPort + "]");
                    writeLogOutput = false;
                }
            }
            this.closeUnusedSocket();
        }
    }

    private void checkIfSocketIsConnected() throws IOException {
        if (this.nextSocketCheckTime < System.currentTimeMillis()) {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(10);
            this.nextSocketCheckTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        }
    }

    private void closeUnusedSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ex);
            }
        }
    }

    public void listenerModus() {
        try {
            this.serverSocket = new ServerSocket(this.listenerPort);
        }
        catch (IOException ioex) {
            this.logger.error("Trouble with server socket [" + this.listenerPort + "] for " + this, (Throwable)ioex);
            return;
        }
        while (!this.isShutdown(CLASS_NAME) && !this.device.getCore().isShutdown()) {
            try {
                try {
                    this.socket = this.serverSocket.accept();
                    this.logger.info("Incoming Network I/O message from " + this.socket);
                }
                catch (SocketException sex) {
                    if (this.isShutdown(CLASS_NAME)) {
                        this.logger.info(this + " is shutting down ...");
                        break;
                    }
                    this.logger.warn("Problems with tcp connection [" + this.connectTo + ":" + this.listenerPort + "]", (Throwable)sex);
                    continue;
                }
                if (!this.device.isAllowed(this.socket.getInetAddress(), this.readGivenAllowedAddress())) {
                    this.logger.warn(this.socket + " not allowed to send Network I/O message!");
                    this.socket.close();
                    this.socket = null;
                    continue;
                }
                this.socket.setSoTimeout(100);
                try (InputStream is = this.socket.getInputStream();
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    len = is.read(buffer);
                    if (len > 0) {
                        baos.write(buffer, 0, len);
                    }
                    this.deliverMessage(baos.toByteArray());
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.deliverMessage(new byte[0]);
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
            try {
                if (this.socket == null) continue;
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
        }
    }

    private String readGivenAllowedAddress() {
        String givenAllowedAddress = "";
        try {
            givenAllowedAddress = this.device.getDeviceCnf().getGenericParameter("AllowedIPAddresses");
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Unable to read 'AllowedIPAddresses' for " + this);
        }
        return givenAllowedAddress;
    }

    public void permanentListenerModus() {
        byte[] delimiter = new byte[]{13, 10, 13, 10};
        if (this.controlCharacter == null || this.controlCharacter.trim().length() <= 0) {
            this.logger.info("Using default delimiter for " + this);
        } else if (this.controlCharacter.trim().equalsIgnoreCase("CR")) {
            this.logger.info("Using [" + this.controlCharacter + "] as delimiter for " + this);
            delimiter = new byte[]{13};
        } else if (this.controlCharacter.trim().equalsIgnoreCase("LF")) {
            this.logger.info("Using [" + this.controlCharacter + "] as delimiter for " + this);
            delimiter = new byte[]{10};
        } else if (this.controlCharacter.trim().equalsIgnoreCase("CRLF")) {
            this.logger.info("Using [" + this.controlCharacter + "] as delimiter for " + this);
            delimiter = new byte[]{13, 10};
        }
        try {
            this.serverSocket = new ServerSocket(this.listenerPort);
        }
        catch (IOException ioex) {
            this.logger.error("Trouble with server socket [" + this.listenerPort + "] for " + this, (Throwable)ioex);
            return;
        }
        while (!this.isShutdown(CLASS_NAME) && !this.device.getCore().isShutdown()) {
            try {
                try {
                    this.socket = this.serverSocket.accept();
                    this.logger.info("Incoming Network I/O message from " + this.socket);
                }
                catch (SocketException socketEx) {
                    if (this.isShutdown(CLASS_NAME)) {
                        this.logger.info(this + " is shutting down ...");
                        break;
                    }
                    this.logger.warn("Problems with tcp connection [" + this.connectTo + ":" + this.listenerPort + "] :-(", (Throwable)socketEx);
                    continue;
                }
                if (!this.device.isAllowed(this.socket.getInetAddress(), this.readGivenAllowedAddress())) {
                    this.logger.warn(this.socket + " not allowed to send Network I/O message!");
                    this.socket.close();
                    this.socket = null;
                    continue;
                }
                this.socket.setSoTimeout(100);
                InputStream is = this.socket.getInputStream();
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.logger.info("Reading from " + this.socket);
                long tsLastMessage = System.currentTimeMillis();
                while (!this.isShutdown(CLASS_NAME)) {
                    byte[] nextMsg;
                    if (Math.abs(tsLastMessage - System.currentTimeMillis()) > 120000L) {
                        this.logger.warn("Disacrding connection because of idle time : " + this.socket);
                        break;
                    }
                    int len = -1;
                    try {
                        len = is.read(buffer);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                    if (len <= 0) continue;
                    baos.write(buffer, 0, len);
                    tsLastMessage = System.currentTimeMillis();
                    if (baos.size() > 65536) {
                        this.logger.error("Buffered message to big, discarding socket --> " + this);
                    }
                    while ((nextMsg = this.parseForMessage(baos, delimiter)) != null) {
                        this.messageDelivery.addMessage(nextMsg);
                    }
                }
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
            try {
                if (this.socket == null) continue;
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ioex) {
                this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            }
        }
        this.logger.info("Stop reading from " + this.socket);
        this.shutdown();
    }

    private void deliverMessage(byte[] message) {
        if (message != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Deliver message [" + new String(message) + "] to all services ...");
            }
            boolean bNoMatchingService = true;
            for (int i = 0; i < this.services.size(); ++i) {
                GenericNetworkSrv service = this.services.elementAt(i);
                if (!service.checkIncomingMessage(message)) continue;
                bNoMatchingService = false;
            }
            if (bNoMatchingService) {
                this.logger.warn("No match of message [" + new String(message) + "] to one of [" + this.services.size() + "] services!");
            }
        }
    }

    public int addService(GenericNetworkSrv service) {
        this.services.addElement(service);
        return 0;
    }

    public byte[] parseForMessage(ByteArrayOutputStream baos, byte[] boundary) {
        byte[] parsedMessage;
        byte[] array = baos.toByteArray();
        int lengthOfFirstMessage = Basic.indexOfByteArray((byte[])array, (byte[])boundary, (int)0, (int)array.length, (boolean)true);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("array=[" + new String(array) + "], boundary=[" + new String(boundary) + "], lengthOfFirstMessage=[" + lengthOfFirstMessage + "]");
        }
        if (lengthOfFirstMessage < 0) {
            return null;
        }
        if (lengthOfFirstMessage == 0) {
            parsedMessage = new byte[]{};
        } else {
            parsedMessage = new byte[lengthOfFirstMessage];
            System.arraycopy(array, 0, parsedMessage, 0, parsedMessage.length);
        }
        int startOfNextMessage = lengthOfFirstMessage + boundary.length;
        baos.reset();
        if (startOfNextMessage < array.length) {
            baos.write(array, startOfNextMessage, array.length - startOfNextMessage);
        }
        return parsedMessage;
    }

    public byte[] sendMsg(byte[] msg, boolean isHttps) throws Exception {
        byte[] result = new byte[]{};
        try {
            if (this.socket == null) {
                this.socket = isHttps ? NetworkHelper.createNetworkConnection((String)this.connectTo, (int)this.listenerPort, (boolean)true, (int)1000) : NetworkHelper.createNetworkConnection((String)this.connectTo, (int)this.listenerPort, (boolean)false, (int)1000);
                this.socket.setSoTimeout(1000);
            }
            OutputStream os = this.socket.getOutputStream();
            os.write(msg);
            os.flush();
            try {
                InputStream is = this.socket.getInputStream();
                byte[] buffer = new byte[4096];
                try {
                    int len = is.read(buffer);
                    if (len > 0) {
                        this.logger.info("RSP=[" + new String(buffer, 0, len) + "]");
                        result = new byte[len];
                        System.arraycopy(buffer, 0, result, 0, len);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
            if (!this.keepAlive) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.error("Host: [" + this.connectTo + ":" + this.listenerPort, (Throwable)ioex);
            throw new SeeTecException(-21656, "Network error");
        }
        return result;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ConnectTo=[" + this.connectTo + "], ListenerPort=[" + this.listenerPort + "], ProtocolType=[" + this.protocolType + "], KeepAlive=[" + this.keepAlive + "]]";
    }

    private class MessageDelivery
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler.MessageDelivery";
        private Thread myThread = null;
        private final LinkedList<byte[]> msgQueue = new LinkedList();

        private MessageDelivery() {
        }

        public void init() {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }

        public final boolean isShutdown() {
            return this.isShutdown(CLASS_NAME);
        }

        public int shutdown() {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            NetworkProtocolHandler.this.shutdown();
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!NetworkProtocolHandler.this.isShutdown() && !this.isShutdown()) {
                    if (this.msgQueue.isEmpty()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        byte[] nextMessage = this.msgQueue.removeFirst();
                        if (nextMessage == null) continue;
                        NetworkProtocolHandler.this.deliverMessage(nextMessage);
                    }
                    catch (NoSuchElementException nse) {
                        NetworkProtocolHandler.this.logger.warn("ignoring " + nse + " for " + this);
                    }
                }
            }
            catch (Throwable ex) {
                NetworkProtocolHandler.this.logger.error((Object)ex, ex);
            }
            super.setRunFinished(CLASS_NAME, true);
            this.shutdown();
        }

        public void addMessage(byte[] message) {
            this.msgQueue.add(message);
        }

        public String toString() {
            String sThis = "de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler.MessageDelivery@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + NetworkProtocolHandler.this.toString() + "]";
        }
    }
}

