/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.networkio;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkHandler;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class GenericNetworkDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.networkio.GenericNetworkDevice";
    private GenericNetworkHandler genericNetworkHandler = null;

    @Override
    public int init(Core core, long entityID) {
        int i;
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        Entity[] srvEnities = super.getSrvEntities();
        ArrayList<GenericNetworkSrv> inputServices = new ArrayList<GenericNetworkSrv>();
        ArrayList<GenericNetworkSrv> outputServices = new ArrayList<GenericNetworkSrv>();
        for (int i2 = 0; i2 < srvEnities.length; ++i2) {
            Entity entity = srvEnities[i2];
            long srvType = entity.getEntityType();
            boolean entityEnabled = entity.isEnabled();
            if (!entityEnabled) continue;
            GenericNetworkSrv service = new GenericNetworkSrv();
            errorCode = service.init(this.core, this, entity);
            if (errorCode != 0) {
                this.logger.error("Creating " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            if (srvType == 9806L) {
                inputServices.add(service);
                continue;
            }
            if (srvType == 9951L) {
                outputServices.add(service);
                continue;
            }
            this.logger.error("Type of " + (Object)((Object)service) + " not supported for " + this);
            return -21611;
        }
        int counter = -1;
        this.services = new GenericNetworkSrv[inputServices.size() + outputServices.size()];
        for (i = 0; i < inputServices.size(); ++i) {
            this.services[++counter] = (Service)((Object)inputServices.get(i));
        }
        for (i = 0; i < outputServices.size(); ++i) {
            this.services[++counter] = (Service)((Object)outputServices.get(i));
        }
        this.genericNetworkHandler = new GenericNetworkHandler();
        errorCode = this.genericNetworkHandler.init(this.core, this, (GenericNetworkSrv[])this.services);
        if (errorCode != 0) {
            this.logger.error("Initializing [GenericNetworkHandler] failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.logger.info(this + " initialized.");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Starting shutdown of " + this + " ...");
        if (this.services != null) {
            this.logger.info("Shutting down [" + this.services.length + "] services ...");
            for (Service service : this.services) {
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
            }
        }
        if (this.genericNetworkHandler != null && (errorCode = this.genericNetworkHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + (Object)((Object)this.genericNetworkHandler) + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    protected GenericNetworkHandler getGenericNetworkHandler() {
        return this.genericNetworkHandler;
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        if (this.getGenericNetworkHandler() != null) {
            return this.getGenericNetworkHandler().triggerAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData);
        }
        this.logger.error("Cannot get [GenericNetworkHandler] for " + this);
        return -21600;
    }

    public boolean isAllowed(InetAddress inetAddress, String givenAllowedIPAdresses) {
        try {
            List<String> allowedAdresses = this.generateListOfAllowedIPAddresses(givenAllowedIPAdresses);
            if (allowedAdresses.isEmpty()) {
                return true;
            }
            String hostAdress = "";
            if (inetAddress.getHostAddress() != null) {
                hostAdress = inetAddress.getHostAddress().toUpperCase();
            }
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            long startForReverseDNSLookup = System.currentTimeMillis();
            String hostName = inetAddress.getHostName().toUpperCase();
            long timeForReverseDNSLookup = System.currentTimeMillis() - startForReverseDNSLookup;
            if (timeForReverseDNSLookup > TimeUnit.SECONDS.toMillis(3L)) {
                this.logger.warn(Basic.generateIndentedMultiLineLog((String)("Reverse DNS lookup for '" + inetAddress + "' took " + timeForReverseDNSLookup + "ms. Please correct your network settings!")));
            }
            int[] hostTupel = new int[4];
            int counter = -1;
            StringTokenizer stringToken = new StringTokenizer(hostAdress, ".");
            while (stringToken.hasMoreElements()) {
                hostTupel[++counter] = Integer.parseInt((String)stringToken.nextElement());
            }
            for (String allowedAdress : allowedAdresses) {
                if (hostName.equals(allowedAdress)) {
                    return true;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.info("[" + hostName + "] doesn't match with [" + allowedAdress + "] :-(");
            }
            boolean allowed = true;
            for (String allowedAdress : allowedAdresses) {
                allowed = true;
                if (hostAdress.equals("127.0.0.1")) break;
                ArrayList<String> tupels = new ArrayList<String>();
                stringToken = new StringTokenizer(allowedAdress, ".");
                while (stringToken.hasMoreElements()) {
                    String tupel = ((String)stringToken.nextElement()).trim().toUpperCase();
                    tupels.add(tupel);
                }
                allowed = true;
                for (int j = 0; j < tupels.size(); ++j) {
                    String tupel = (String)tupels.get(j);
                    if (tupel.startsWith("*") || tupel.equals("" + hostTupel[j])) continue;
                    if (tupel.contains("-")) {
                        stringToken = new StringTokenizer(tupel, "-");
                        int rangeStart = Integer.parseInt((String)stringToken.nextElement());
                        int rangeEnd = Integer.parseInt((String)stringToken.nextElement());
                        if (rangeStart <= hostTupel[j] && rangeEnd >= hostTupel[j]) continue;
                        allowed = false;
                        break;
                    }
                    allowed = false;
                }
                if (!allowed) continue;
                break;
            }
            return allowed;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return false;
        }
    }

    private List<String> generateListOfAllowedIPAddresses(String givenAllowedIPAdresses) {
        String allowedIPAdresses = "";
        if (givenAllowedIPAdresses != null) {
            allowedIPAdresses = givenAllowedIPAdresses.trim();
        }
        ArrayList<String> allowedAdresses = new ArrayList<String>();
        StringTokenizer stringToken = new StringTokenizer(allowedIPAdresses, ",");
        while (stringToken.hasMoreElements()) {
            String adress = ((String)stringToken.nextElement()).trim().toUpperCase();
            allowedAdresses.add(adress);
        }
        return allowedAdresses;
    }

    @Override
    public int initializeDevice(long srvType) {
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

