/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.networkio;

import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkHandler;
import de.seetec.v5.re.cm.shared.IOSRPCConnector;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.srpc.SRPCHandler;
import de.seetec.v5.shared.net.srpc.general.ReqTriggerAction;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.net.Socket;

public class GenericNetworkCRH
extends SRPCHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.networkio.GenericNetworkCRH";
    private GenericNetworkHandler genericNetworkHandler = null;
    private IOSRPCConnector srpcConnector = null;
    private final long tsStartup = System.currentTimeMillis();
    private String clientHost = null;
    private Integer clientPort = null;

    public int init(GenericNetworkHandler genericNetworkHandler, Socket socket) {
        int errorCode;
        this.genericNetworkHandler = genericNetworkHandler;
        if (this.genericNetworkHandler == null) {
            return -21601;
        }
        this.clientHost = socket.getInetAddress().getHostAddress();
        this.clientPort = socket.getPort();
        try {
            this.srpcConnector = new IOSRPCConnector();
            errorCode = this.srpcConnector.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing new connector with socket [" + socket + "] failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Creating new connector with socket [" + socket + "] failed :-(", (Throwable)ex);
            return -21604;
        }
        errorCode = this.genericNetworkHandler.registerCRH(this);
        if (errorCode != 0) {
            this.logger.error("Registering client failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Shutting down " + (Object)((Object)this) + " ...");
        int errorCode = this.genericNetworkHandler.deregisterCRH(this);
        if (errorCode != 0) {
            this.logger.warn("Deregistering client failed with error [" + errorCode + "] :-(");
        }
        if (this.thread != null) {
            this.logger.info("Terminating " + this.thread + " ...");
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + (Object)((Object)this) + " didn't finished in time :-(");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    this.logger.warn("Exception while waiting: " + ex.getMessage() + " for " + (Object)((Object)this));
                }
            }
            this.thread = null;
        }
        if (this.srpcConnector != null) {
            errorCode = this.srpcConnector.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + (Object)((Object)this.srpcConnector) + "] failed with error [" + errorCode + "] :-(");
            }
            this.srpcConnector = null;
        }
        errorCode = super.shutdown();
        this.logger.info("... " + (Object)((Object)this) + " is down :-)");
        return errorCode;
    }

    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down " + (Object)((Object)this) + " ... :-(");
        this.shutdown();
    }

    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
        try {
            this.logger.info("Thread " + (Object)((Object)this) + " started ...");
            while (true) {
                SrpcMessage nextRequest;
                if (tsNextStillAliveMsg < System.currentTimeMillis()) {
                    tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
                    this.logger.info("Thread " + (Object)((Object)this) + " has an uptime of [" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "] :-)");
                }
                if ((nextRequest = this.getNextReqOrNull()) != null) {
                    if (this.isShutdown(CLASS_NAME)) {
                        super.stopHandler();
                    }
                    switch (Methods.valueOf((int)nextRequest.getHash())) {
                        case ENT_FUNCTION_TRIGGER_ACTION: {
                            ReqTriggerAction reqTriggerAction = ReqTriggerAction.parseGObject((GObject)nextRequest.getPayload());
                            this.execTriggerAction(reqTriggerAction);
                            break;
                        }
                    }
                }
                this.doDelayBreakedByShutdown(CLASS_NAME, 25L);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.info("Terminating Thread " + (Object)((Object)this));
            super.setRunFinished(CLASS_NAME, true);
            int errorCode = this.shutdown();
            if (errorCode != 0) {
                this.logger.error("[shutdown] failed with error [" + errorCode + "] :-(");
            }
            return;
        }
    }

    private void execTriggerAction(ReqTriggerAction request) {
        int errorCode = this.genericNetworkHandler.triggerAction(request.getActionID(), request.getAlarmScriptID(), request.getAlarmInstanceID(), request.getAlarmTimerange(), request.getGenericData());
        if (errorCode != 0) {
            this.logger.warn("Triggering action failed with error [" + errorCode + "]");
        }
    }

    private long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.other.networkio.GenericNetworkCRH@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.clientHost + ":" + this.clientPort + "]]";
    }
}

