/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.alarmsystems.spc.EDPCommands;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcAreaSrv;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcCommandWrapper;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDeviceCnf;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcIoHandler;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcOutputSrv;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSocketHandler;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.shared.srpc.ReqSetState;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SpcDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDevice";
    private SpcSocketHandler spcSocketHandler = null;
    private SpcIoHandler spcIoHandler = null;
    private SpcDeviceCnf deviceCnf = null;
    private long lastCannotCreateDeviceEventSent = Long.MIN_VALUE;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.deviceCnf = new SpcDeviceCnf();
        errorCode = this.deviceCnf.init(this.getDeviceEntity());
        if (errorCode != 0) {
            this.logger.error("Creating [SpcDeviceCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        Entity[] srvEntities = super.getSrvEntities();
        this.services = new SpcSrv[srvEntities.length];
        for (int i = 0; i < srvEntities.length; ++i) {
            Entity entity = srvEntities[i];
            boolean enabled = entity.isEnabled();
            if (!enabled) continue;
            SpcSrv service = new SpcSrv();
            errorCode = service.init(this.core, this, entity);
            if (errorCode != 0) {
                this.logger.error("Creating " + service + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            this.services[i] = service;
        }
        this.spcIoHandler = new SpcIoHandler();
        errorCode = this.spcIoHandler.init(this.core, this, srvEntities, true);
        if (errorCode != 0) {
            this.logger.error("Initializing [SpcIoHandler] failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.spcSocketHandler = new SpcSocketHandler();
        errorCode = this.spcSocketHandler.init(this, (SpcSrv[])this.services, this.spcIoHandler, this.deviceCnf);
        if (errorCode != 0) {
            this.logger.error("Initializing [SpcSocketHandler] failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.logger.info(this + " initialized.");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.spcIoHandler != null && (errorCode = this.spcIoHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + this.spcIoHandler + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        if (this.spcSocketHandler != null && (errorCode = this.spcSocketHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + this.spcSocketHandler + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        if (this.services != null) {
            for (Service service : this.services) {
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
            }
        }
        this.deviceCnf = null;
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        Entity entityByID = this.getCore().getEntityByID(actionID);
        if (entityByID.getEntityType() == 9982L) {
            this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ALERTS_RESTORE, -1));
        } else {
            for (SpcOutputSrv output : this.spcIoHandler.getOutputs()) {
                if (output.getServiceID() != actionID.longValue()) continue;
                if (output.getServiceType() == 9911L) {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.OUTPUT_SET, output.getOutputNumber()));
                } else if (output.getServiceType() == 9912L) {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.OUTPUT_RESET, output.getOutputNumber()));
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        return 0;
    }

    @Override
    protected final IOHandler createIOHandler() {
        return this.spcIoHandler;
    }

    @Override
    protected final boolean isSupportingIO() {
        return false;
    }

    public void sendNotReachableEvent() {
        try {
            if (System.currentTimeMillis() > this.lastCannotCreateDeviceEventSent + 5000L) {
                this.lastCannotCreateDeviceEventSent = System.currentTimeMillis();
                this.sendCannotEstablishConnectionLoggingEvent(-21656);
                this.logger.error("Cannot establish connection SPC. SystemNotification send");
            }
        }
        catch (ConfigurationException e) {
            this.logger.warn("Failed to send SPC not reachable events. Message: " + e.getMessage());
        }
    }

    public void setState(ReqSetState reqSetState) {
        long entityID = reqSetState.getEntityID();
        int state = reqSetState.getState();
        this.setState(entityID, state);
    }

    public void setState(long entityID, int state) {
        for (SpcAreaSrv area : this.spcIoHandler.getAreas()) {
            if (area.getServiceID() != entityID) continue;
            switch (state) {
                case 1: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.AREA_SET, area.getAreaNumber()));
                    break;
                }
                case 2: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.AREA_UNSET, area.getAreaNumber()));
                    break;
                }
                case 3: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.AREA_FORCE_SET, area.getAreaNumber()));
                    break;
                }
            }
            return;
        }
        for (Service service : this.services) {
            SpcSrv spcSrv = (SpcSrv)service;
            if (spcSrv == null || spcSrv.getActionID() != entityID) continue;
            switch (state) {
                case 10: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ZONE_ISOLATE, spcSrv.getDetectorGroup()));
                    break;
                }
                case 11: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ZONE_DEISOLATE, spcSrv.getDetectorGroup()));
                    break;
                }
                case 12: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ZONE_INHIBIT, spcSrv.getDetectorGroup()));
                    break;
                }
                case 13: {
                    this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ZONE_DEINHIBIT, spcSrv.getDetectorGroup()));
                    break;
                }
            }
            return;
        }
    }

    public void restoreAllAlarms() {
        this.spcSocketHandler.queuedCommands.add(new SpcCommandWrapper(EDPCommands.ALERTS_RESTORE, -1));
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

