/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcAreaSrvCnf;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;

public class SpcAreaSrv
extends SpcSrv {
    private SpcAreaSrvCnf srvCnf = null;
    private int lastStatus = -1;
    private long lastStatusChange = -1L;
    private int areaNumber = -1;
    private IOHandler ioHandler = null;

    public int init(Core core, Device device, IOHandler ioHandler, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class of " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.ioHandler = ioHandler;
        this.srvCnf = new SpcAreaSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [SrvCnf] for " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            this.areaNumber = this.srvCnf.getAreaNumber();
        }
        catch (ConfigurationException cex) {
            this.logger.error("Configuration of " + this + " is invalid");
            return -21602;
        }
        return 0;
    }

    private int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        this.logger.info("Event of source [" + sourceID + "] from " + this);
        return super.getCore().sendApplicationEvent(sourceID);
    }

    public void checkInput(int actualValue) {
        if (this.lastStatusChange < 0L) {
            try {
                this.lastStatusChange = System.currentTimeMillis();
                this.lastStatus = actualValue;
                super.publishServiceStatus(this.lastStatus);
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return;
        }
        try {
            if (this.lastStatus != actualValue) {
                this.logger.info("Status changed from [" + this.lastStatus + "] to [" + actualValue + "] for digital input [" + Basic.longToFormattedString((Long)super.getEntity().getEntityID()) + "] of " + this.ioHandler);
                super.publishServiceStatus(actualValue);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        if (this.lastStatusChange < System.currentTimeMillis()) {
            if ((this.getServiceType() == 9801L || this.getServiceType() == 9804L || this.getServiceType() == 9815L) && this.lastStatus == 0 && actualValue != 0) {
                this.logger.info("Input [" + this.getAreaNumber() + "] was switching to ON for " + this);
                this.lastStatusChange = System.currentTimeMillis();
                this.sendEvent();
            }
            if ((this.getServiceType() == 9802L || this.getServiceType() == 9805L || this.getServiceType() == 9816L) && this.lastStatus != 0 && actualValue == 0) {
                this.logger.info("Input [" + this.getAreaNumber() + "] was switching to OFF for " + this);
                this.lastStatusChange = System.currentTimeMillis();
                this.sendEvent();
            }
        }
        this.lastStatus = actualValue;
    }

    public int getAreaNumber() {
        return this.areaNumber;
    }
}

