/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.device.alarmsystems.spc.SIACodeType;

public enum SIACode {
    NONE(SIACodeType.NONE, -1L),
    BA(SIACodeType.EVENT, 1L),
    BR(SIACodeType.EVENT, 11L),
    HA(SIACodeType.EVENT, 3L),
    HR(SIACodeType.EVENT, 13L),
    FA(SIACodeType.EVENT, 5L),
    FR(SIACodeType.EVENT, 15L),
    PA(SIACodeType.EVENT, 2L),
    PR(SIACodeType.EVENT, 12L),
    MA(SIACodeType.EVENT, 4L),
    MR(SIACodeType.EVENT, 14L),
    BT(SIACodeType.EVENT, 101L),
    BJ(SIACodeType.EVENT, 111L),
    TA(SIACodeType.EVENT, 102L),
    TR(SIACodeType.EVENT, 112L),
    UA(SIACodeType.EVENT, 103L),
    UR(SIACodeType.EVENT, 113L),
    HT(SIACodeType.EVENT, 203L),
    HJ(SIACodeType.EVENT, 213L),
    PT(SIACodeType.EVENT, 202L),
    PJ(SIACodeType.EVENT, 212L),
    MT(SIACodeType.EVENT, 204L),
    MJ(SIACodeType.EVENT, 214L),
    UT(SIACodeType.EVENT, 301L),
    UJ(SIACodeType.EVENT, 311L),
    NR(SIACodeType.EVENT, 401L),
    NT(SIACodeType.EVENT, 411L),
    OA(SIACodeType.INACTIVE, -1L),
    CG(SIACodeType.ACTIVE, -1L),
    OG(SIACodeType.INACTIVE, -1L),
    CP(SIACodeType.ACTIVE, -1L),
    OP(SIACodeType.INACTIVE, -1L),
    CQ(SIACodeType.ACTIVE, -1L),
    OQ(SIACodeType.INACTIVE, -1L),
    CS(SIACodeType.ACTIVE, -1L),
    OS(SIACodeType.INACTIVE, -1L);

    private final SIACodeType codeType;
    private final long eventCode;

    private SIACode(SIACodeType codeType, long eventCode) {
        this.codeType = codeType;
        this.eventCode = eventCode;
    }

    public final String getName() {
        return this.name();
    }

    public final SIACodeType getCodeType() {
        return this.codeType;
    }

    public final long getEventCode() {
        return this.eventCode;
    }

    public static final SIACode getSIACode(String name) {
        for (SIACode siaCode : SIACode.values()) {
            if (!siaCode.getName().equals(name)) continue;
            return siaCode;
        }
        return NONE;
    }
}

