/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

public enum ReplyCode {
    OK(-16, "SPC Command Reply: OK", false),
    OK_NOT_COMPLETE(-15, "SPC Command Reply: OK, but not all requested data was returned", false),
    FAIL_BAD_PARAMETER(-14, "SPC Command Reply: # is invalid", true),
    FAIL_ENGINEER_MODE(-4, "SPC Command Reply:Panel is in full engineer mode", true),
    FAIL_NOT_READY(-3, "SPC Command Reply: Not ready", true),
    FAIL_NOT_PERMITTED(-2, "SPC Command Reply: SPC Commands are not enabled at the panel", true),
    FAIL_NOT_IMPLEMENTED(-1, "SPC Command Reply: Command is not implemented", true);

    private final byte code;
    private final String description;
    private final boolean warn;

    private ReplyCode(byte code, String description, boolean isWarn) {
        this.code = code;
        this.description = description;
        this.warn = isWarn;
    }

    public static ReplyCode getReplyCode(byte value) {
        for (ReplyCode replyCode : ReplyCode.values()) {
            if (replyCode.code != value) continue;
            return replyCode;
        }
        return FAIL_NOT_IMPLEMENTED;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isWarn() {
        return this.warn;
    }
}

