/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.accesscontrol.tdsi;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIDataWrapper;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIDevice;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSISrvCnf;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import java.util.Vector;

public class TDSISrv
extends Service {
    private long myEventGroupID = Long.MIN_VALUE;
    private String myRuleName = null;
    private TDSISrvCnf srvCnf = null;

    @Override
    public int init(Core core, Device device, Entity entity) {
        int errorCode = 0;
        errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.srvCnf = new TDSISrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [TDSIDeviceCnf] failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        try {
            this.myEventGroupID = this.srvCnf.getEventGroupID();
            this.myRuleName = entity.getEntityName();
        }
        catch (Exception e) {
            this.logger.error("Error while reading configuration of " + (Object)((Object)this));
            return -21602;
        }
        errorCode = core.registerEntity(this.getServiceID(), this.getServiceType());
        if (errorCode != 0) {
            this.logger.error("Registering service " + (Object)((Object)this) + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        try {
            this.getCore().setEntityStatus(entity.getEntityID(), 0);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    private int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        return super.getCore().sendApplicationEvent(sourceID);
    }

    @Override
    public int checkService() {
        return 0;
    }

    public long getActionID() {
        if ((this.isShutdown() || super.isShutdown() || this.getEntity() == null) && this.getDevice() != null) {
            this.getDevice().shutdown();
        }
        return this.getEntity().getEntityID();
    }

    public void checkIncomingMessage(TDSIDataWrapper data) {
        block11: {
            int numberOfMatches = 0;
            try {
                if (data != null) {
                    Vector<Long> groupList = ((TDSIDevice)this.device).getTDSIDeviceCnf().getEventGroupList(data.getEventType());
                    for (int i = 0; i < groupList.size(); ++i) {
                        if (groupList.elementAt(i) != this.myEventGroupID) continue;
                        this.logger.info("Incoming event (" + data.getEventType() + ") for: " + this.myRuleName + ". Event is: " + data.toString());
                        if (this.srvCnf.getSource() != null) {
                            if (data.getSource() != null) {
                                numberOfMatches = data.getSource().equalsIgnoreCase(this.srvCnf.getSource()) ? ++numberOfMatches : numberOfMatches;
                            }
                        } else {
                            ++numberOfMatches;
                        }
                        ++numberOfMatches;
                        ++numberOfMatches;
                        if (this.srvCnf.getDetail3() != null) {
                            if (data.getDetail3() != null) {
                                numberOfMatches = data.getDetail3().equalsIgnoreCase(this.srvCnf.getDetail3()) ? ++numberOfMatches : numberOfMatches;
                            }
                        } else {
                            ++numberOfMatches;
                        }
                        if (numberOfMatches == 4) {
                            this.sendEvent();
                        }
                        break block11;
                    }
                    break block11;
                }
                this.logger.error("Given data null in " + (Object)((Object)this));
            }
            catch (Throwable ex) {
                this.logger.error("Trouble handling message for " + (Object)((Object)this) + " :-(", ex);
            }
        }
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ", ActionID=[" + Basic.longToFormattedString((long)this.getActionID()) + "]]";
    }
}

