/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.RecordingStatistic;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.CameraRecordingStatistic;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.ContentStatistic;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.TrackStatistic;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StatisticDaemon {
    private static final String NL = System.lineSeparator();
    private static final int CAMERA_RECORDING_STATUS_NO_ERROR = 0;
    private static final String ALARM_FPS_DELTA_TAG = "AlarmRecordingMilliFpsDelta";
    private static final String ALARM_MAX_FRAMES_DROPPED_TAG = "AlarmRecordingMaximumFramesDropped";
    private static final String STANDARD_FPS_DELTA_TAG = "StandardRecordingMilliFpsDelta";
    private static final String STANDARD_MAX_FRAMES_DROPPED_TAG = "StandardRecordingMaximumFramesDropped";
    private static final String THRESHOLDS_ENABLED_TAG = "Enabled";
    private static final String NOTIFICATIONS_TIMERANGE_TAG = "MDBStatisticsNotificationsTimeRange";
    private static final String MAX_PACKET_LOSS_TAG = "MaximumPacketLossMilliPercentage";
    private static final String STANDARD_TRACK_MSG_HEADER = "Standard track" + NL;
    private static final String ALARM_TRACK_MSG_HEADER = "Alarm track" + NL;
    private static final String GENERAL_TRACK_MSG_HEADER = "General" + NL;
    private static final String HEIGHT_NOT_VALID_MSG = "\tHeight is invalid. Expected height was '%s', but actual height was '%s'." + NL;
    private static final String WIDTH_NOT_VALID_MSG = "\tWidth is invalid. Expected width was '%s', but actual width was '%s'." + NL;
    private static final String CODEC_NOT_VALID_MSG = "\tCodec is invalid. Expected codec was '%s', but actual codec was '%s'." + NL;
    private static final String FPS_NOT_VALID_MSG = "\tFPS values are out of bounds. Expected fps value was '%s', but actual value was '%s'." + NL;
    private static final String DROPPED_FRAMES_NOT_VALID_MSG = "\tToo many dropped frames. Maximum amount of dropped frames was '%s', but actual amount was '%s'." + NL;
    private static final String PACKET_LOSS_NOT_VALID_MSG = "\tPacket loss threshold exceeded. Maximum amount of packet loss was '%s' percent, but actual amount was '%s' percent." + NL;
    private static final String CAMERA_UNAVAILABLE_ERR_MSG = "\tCamera is unavailable!" + NL;
    private Core core;
    private RecordingStatistic recordingStatistic;
    private final Logger logger;
    private Long latestNotificationTimeRange = Long.MIN_VALUE;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> futureTask;
    private Runnable scheduledTask;

    public StatisticDaemon() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(Core core, RecordingStatistic recordingStatistic) {
        if (core == null || recordingStatistic == null) {
            return -20002;
        }
        this.core = core;
        this.recordingStatistic = recordingStatistic;
        this.scheduledTask = new Runnable(){

            @Override
            public void run() {
                StatisticDaemon.this.checkStatistics();
            }
        };
        this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("StatisticDaemon"));
        this.notificationSettingsChanged();
        return 0;
    }

    public int notificationSettingsChanged() {
        try {
            Document dmConfiguration = this.getDMConfiguration();
            String thresholdsEnabled = dmConfiguration.getElementsByTagName(THRESHOLDS_ENABLED_TAG).item(0).getTextContent();
            Long notificationTimeRange = Long.parseLong(dmConfiguration.getElementsByTagName(NOTIFICATIONS_TIMERANGE_TAG).item(0).getTextContent());
            if ("true".equals(thresholdsEnabled) && notificationTimeRange > 0L && !this.latestNotificationTimeRange.equals(notificationTimeRange)) {
                this.enableAutomaticStatisticsChecking(notificationTimeRange);
            } else if ("false".equals(thresholdsEnabled) || notificationTimeRange < 0L) {
                this.disableAutomaticStatisticsChecking(notificationTimeRange);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Failed to initialize MDB statistics daemon.");
            return -20030;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Failed to load DM entity id from core for MDB statistics daemon.");
            return -20003;
        }
        catch (NullPointerException ex) {
            this.logger.warn("Failed to load full CameraManagement configuration from DM. Probably fresh installation.");
        }
        return 0;
    }

    protected void checkStatistics() {
        try {
            RspGetCameraRecordingStatistics response = new RspGetCameraRecordingStatistics(Integer.valueOf(0), "".getBytes(StandardCharsets.UTF_8));
            response = this.recordingStatistic.getCameraRecordingStatistics(response, this.latestNotificationTimeRange);
            CameraRecordingStatistic cameraRecordingStatistic = (CameraRecordingStatistic)Basic.unmarshalXML(CameraRecordingStatistic.class, (Object)response.getCameraRecordingStatistics());
            this.checkThresholds(this.getDMConfiguration(), cameraRecordingStatistic);
        }
        catch (Exception ex) {
            this.logger.error("Failed to check MDB statistice due to an error. Reason: " + ex.getMessage());
        }
    }

    private Document getDMConfiguration() throws SeeTecException, ConfigurationException {
        long dmId = this.core.getDmCnfMgr().getEntityID();
        Entity entity = this.core.getEntMgrProxy().getEntityByID(Long.valueOf(dmId), Boolean.valueOf(true), 30000L);
        return this.xmlToDocument(entity.getConfiguration());
    }

    private void checkThresholds(Document cameraManagementConf, CameraRecordingStatistic statistics) {
        List content = statistics.getContents().getContent();
        for (ContentStatistic contentStatistic : content) {
            try {
                this.checkStatisticsOfSingleCamera(contentStatistic, cameraManagementConf);
            }
            catch (NullPointerException ex) {
                this.logger.error("Failed to check statistics of camera " + contentStatistic.getCameraName() + ".");
            }
        }
    }

    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="All values in the formatted string comes from trusted source in core not directly from user.")
    private void checkStatisticsOfSingleCamera(ContentStatistic cameraStatistic, Document cameraManagementConf) {
        Integer recordingStatus = cameraStatistic.getStatusOfRecording();
        if (this.isCameraDeactivated(recordingStatus)) {
            return;
        }
        boolean isCameraRecording = recordingStatus.equals(0);
        if (!isCameraRecording) {
            this.sendError(this.core, cameraStatistic.getCameraSourceID(), cameraStatistic.getCameraName(), CAMERA_UNAVAILABLE_ERR_MSG);
            return;
        }
        Integer maxPacketLoss = Integer.parseInt(cameraManagementConf.getElementsByTagName(MAX_PACKET_LOSS_TAG).item(0).getTextContent());
        boolean packetLossValid = cameraStatistic.getPacketLossRatio() <= (long)maxPacketLoss.intValue();
        String packetLossMsg = "";
        if (!packetLossValid) {
            packetLossMsg = String.format(PACKET_LOSS_NOT_VALID_MSG, this.miliToSingleDecimal(maxPacketLoss.intValue()), this.miliToSingleDecimal(cameraStatistic.getPacketLossRatio()));
        }
        String alarmTrackMsg = this.checkStatisticsOfSingleTrack(cameraStatistic.getAlarmTrack(), cameraManagementConf, ALARM_FPS_DELTA_TAG, ALARM_MAX_FRAMES_DROPPED_TAG);
        String standartTrackMsg = this.checkStatisticsOfSingleTrack(cameraStatistic.getStandardTrack(), cameraManagementConf, STANDARD_FPS_DELTA_TAG, STANDARD_MAX_FRAMES_DROPPED_TAG);
        if (!(alarmTrackMsg.isEmpty() && standartTrackMsg.isEmpty() && packetLossValid)) {
            this.sendWarning(this.core, cameraStatistic.getCameraSourceID(), cameraStatistic.getCameraName(), this.getWarningMsg(packetLossMsg, standartTrackMsg, alarmTrackMsg));
        }
    }

    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="All values in the formatted string comes from trusted source in core not directly from user.")
    private String checkStatisticsOfSingleTrack(TrackStatistic track, Document cameraManagementConf, String fpsDeltaTag, String maxFramesDroppedTag) {
        String msg = "";
        try {
            boolean widthValid = track.getExpectedWidth().equals(track.getWidth());
            msg = this.concenateStringIf(!widthValid, msg, String.format(WIDTH_NOT_VALID_MSG, track.getExpectedWidth(), track.getWidth()));
            boolean heightValid = track.getExpectedHeight().equals(track.getHeight());
            msg = this.concenateStringIf(!heightValid, msg, String.format(HEIGHT_NOT_VALID_MSG, track.getExpectedHeight(), track.getHeight()));
            boolean codecValid = track.getExpectedCodec().equals(track.getCodec());
            String expectedCodecName = track.getExpectedCodec() != null && Codec.isExisting((int)track.getExpectedCodec()) ? Codec.valueOf((int)track.getExpectedCodec()).name() : "Unknown";
            String actualCodecName = track.getCodec() != null && Codec.isExisting((int)track.getCodec()) ? Codec.valueOf((int)track.getCodec()).name() : "Unknown";
            msg = this.concenateStringIf(!codecValid, msg, String.format(CODEC_NOT_VALID_MSG, expectedCodecName, actualCodecName));
            Integer aRecFpsDelta = Integer.parseInt(cameraManagementConf.getElementsByTagName(fpsDeltaTag).item(0).getTextContent());
            boolean fpsDeltaValid = Math.abs(track.getExpectedVideoFramerate() - track.getVideoFramerate()) <= (long)aRecFpsDelta.intValue();
            msg = this.concenateStringIf(!fpsDeltaValid, msg, String.format(FPS_NOT_VALID_MSG, this.miliToSingleDecimal(track.getExpectedVideoFramerate()), this.miliToSingleDecimal(track.getVideoFramerate())));
            Integer aRecMaxFramesDrop = Integer.parseInt(cameraManagementConf.getElementsByTagName(maxFramesDroppedTag).item(0).getTextContent());
            boolean droppedFramesValid = track.getAmountOfDroppedFrames() <= (long)aRecMaxFramesDrop.intValue();
            msg = this.concenateStringIf(!droppedFramesValid, msg, String.format(DROPPED_FRAMES_NOT_VALID_MSG, aRecMaxFramesDrop, track.getAmountOfDroppedFrames()));
        }
        catch (NullPointerException ex) {
            this.logger.error("Error when reading DM or camera statistics!" + ex);
        }
        return msg;
    }

    private String getWarningMsg(String packetLossMsg, String standartTrackMsg, String alarmTrackMsg) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createWarningMsg(GENERAL_TRACK_MSG_HEADER, packetLossMsg));
        sb.append(this.createWarningMsg(STANDARD_TRACK_MSG_HEADER, standartTrackMsg));
        sb.append(this.createWarningMsg(ALARM_TRACK_MSG_HEADER, alarmTrackMsg));
        return sb.toString();
    }

    private String createWarningMsg(String header, String results) {
        if (results.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(NL);
        sb.append(header);
        sb.append(NL);
        sb.append(results);
        return sb.toString();
    }

    protected void enableAutomaticStatisticsChecking(long notificationTimeRange) {
        this.latestNotificationTimeRange = notificationTimeRange;
        if (this.futureTask != null) {
            this.futureTask.cancel(true);
        }
        this.futureTask = this.scheduler.scheduleAtFixedRate(this.scheduledTask, notificationTimeRange, notificationTimeRange, TimeUnit.MILLISECONDS);
        this.logger.info("MDB Statistics automatic checks scheduled at rate of " + TimeUnit.MINUTES.convert(notificationTimeRange, TimeUnit.MILLISECONDS) + " minutes.");
    }

    protected void disableAutomaticStatisticsChecking(long notificationTimeRange) {
        this.latestNotificationTimeRange = notificationTimeRange;
        if (this.futureTask != null) {
            this.futureTask.cancel(true);
            this.futureTask = null;
            this.logger.info("MDB Statistics automatic checks disabled.");
        }
    }

    private boolean isCameraDeactivated(Integer recordingStatus) {
        return recordingStatus == -1;
    }

    private Document xmlToDocument(byte[] xml) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new ByteArrayInputStream(xml));
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error("Wrong encoding xml configuration from dm.");
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            this.logger.error("Error when converting mdb xml byte array to document object.", (Throwable)ex);
        }
        return document;
    }

    private String concenateStringIf(boolean condition, String msg, String add) {
        if (condition) {
            msg = msg + add;
        }
        return msg;
    }

    protected void sendError(Core core, Long cameraId, String emailSubject, String emailBody) {
        this.sendEvent(core, cameraId, EventType.MDB_EVENTTYPE_STATISTICS_ERROR_STATUS, emailSubject, emailBody);
    }

    protected void sendWarning(Core core, Long cameraId, String emailSubject, String emailBody) {
        this.sendEvent(core, cameraId, EventType.MDB_EVENTTYPE_STATISTICS_LIMITED_STATUS, emailSubject, emailBody);
    }

    private void sendEvent(Core core, Long cameraId, EventType event, String emailSubject, String emailBody) {
        try {
            core.sendEvent(event, core.getDmCnfMgr().getEntityID(), cameraId, null);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Failed to send message to core. " + (Object)((Object)ex));
        }
        core.sendLoggingEvent(event, cameraId, -20037, emailSubject, emailBody);
    }

    public void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    protected double miliToSingleDecimal(long miliValue) {
        double rounded = Math.rint((double)miliValue / 100.0);
        return rounded / 10.0;
    }
}

