/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.DeviceLifeCycleInformation;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeviceLifeCycleInformationImpl
implements DeviceLifeCycleInformation {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final SystemTimeProvider systemTimeProvider;
    private final Map<Long, Long> initializingDevices;
    private final List<Device> devices;
    private final ReentrantReadWriteLock lock;

    public DeviceLifeCycleInformationImpl(SystemTimeProvider systemTimeProvider) {
        this.systemTimeProvider = systemTimeProvider == null ? new DefaultSystemTimeProvider() : systemTimeProvider;
        this.devices = new ArrayList<Device>();
        this.lock = new ReentrantReadWriteLock();
        this.initializingDevices = new HashMap<Long, Long>();
    }

    @Override
    public List<Long> getDevicesInLifeCycle() {
        ArrayList<Long> list = new ArrayList<Long>();
        this.lock.readLock().lock();
        try {
            this.devices.forEach(device -> list.add(device.getDeviceID()));
            this.initializingDevices.keySet().forEach(key -> list.add((Long)key));
        }
        finally {
            this.lock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getService(long entityID) {
        this.lock.readLock().lock();
        try {
            for (Device device : this.devices) {
                Service service = device.getService(entityID);
                if (service == null) continue;
                Service service2 = service;
                return service2;
            }
            Iterator<Device> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Device[] getDeviceList() {
        this.lock.readLock().lock();
        try {
            Device[] deviceArray = this.devices.toArray(new Device[this.devices.size()]);
            return deviceArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Device getDevice(long entityID) {
        this.lock.readLock().lock();
        try {
            for (Device device : this.devices) {
                if (device.getDeviceID() != entityID) continue;
                Device device2 = device;
                return device2;
            }
            Iterator<Device> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setStartInitializingDevice(long id) {
        this.lock.writeLock().lock();
        try {
            this.initializingDevices.put(id, this.systemTimeProvider.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getStartUpTimeOfInitializingDevice(long id) {
        this.lock.readLock().lock();
        try {
            Long l = this.initializingDevices.get(id);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setStopInitializingDevice(long id) {
        this.lock.writeLock().lock();
        try {
            this.initializingDevices.remove(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int setSuccessfullyFinishedInitializingDevice(Device device) {
        this.lock.writeLock().lock();
        try {
            this.initializingDevices.remove(device.getDeviceID());
            int n = this.setDeviceRunning(device);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isMaxInitializingDevicesNumberReached() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.initializingDevices.size() >= 100;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private int setDeviceRunning(Device device) {
        this.lock.writeLock().lock();
        try {
            if (this.getDevice(device.getDeviceID()) != null) {
                this.logger.error(device + " already exists!");
                int n = -21600;
                return n;
            }
            this.devices.add(device);
            int n = 0;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int setDeviceStopped(Device device) {
        this.lock.writeLock().lock();
        try {
            int n = this.devices.remove(device) ? 0 : -21600;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.lock.writeLock().lock();
        try {
            this.devices.clear();
            this.initializingDevices.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

