/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.DMSRPCHandler;
import de.seetec.v5.re.shared.RESRPCConnector;
import de.seetec.v5.shared.net.srpc.SRPCHandler;
import de.seetec.v5.shared.networking.srpc.DefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DMSRPCConnector
extends RESRPCConnector
implements SrpcRequestHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.DMSRPCConnector";
    private Logger logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    private DMSRPCHandler srpcHandler = null;
    private Socket socket = null;
    private SrpcClientIntf nSrpc = null;

    public int init(DMSRPCHandler srpcHandler, Socket socket) {
        this.srpcHandler = srpcHandler;
        if (this.srpcHandler == null) {
            return -21001;
        }
        this.socket = socket;
        if (this.socket == null) {
            return -21001;
        }
        try {
            this.nSrpc = SrpcFactory.getSrpc((Socket)this.socket, (SrpcRequestHandlerFactoryIntf)new DefaultRequestHandlerFactoryImpl((SrpcRequestHandlerIntf)this.srpcHandler), null, (ShutdownCallback)new SrpcShutdownListener(), (boolean)false);
        }
        catch (NullPointerException ex) {
            this.logger.error(String.format("GETSRPC ( %s, %s )", new Object[]{this.socket, this.srpcHandler}));
            this.logger.error(String.format("Cannot get SRPC for %s", this.socket), (Throwable)ex);
            return -20210;
        }
        catch (Throwable ex) {
            this.logger.error(String.format("Cannot get SRPC for %s", this.socket), ex);
            return -20210;
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.nSrpc != null) {
            this.nSrpc.shutdown();
            this.nSrpc = null;
        }
        if (this.srpcHandler != null) {
            this.srpcHandler.shutdown();
            this.srpcHandler = null;
        }
        return 0;
    }

    protected final SRPCHandler getSRPCHandler() {
        return this.srpcHandler;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.DMSRPCConnector@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.socket + "], SRPC=" + this.nSrpc + "]";
    }

    private class SrpcShutdownListener
    implements ShutdownCallback {
        private SrpcShutdownListener() {
        }

        public void onShutdown() {
            if (DMSRPCConnector.this.logger.isDebugEnabled() && DMSRPCConnector.this.nSrpc != null) {
                DMSRPCConnector.this.logger.info("ShutdownCallback of " + DMSRPCConnector.this.nSrpc);
            }
            DMSRPCConnector.this.nSrpc = null;
            DMSRPCConnector.this.shutdown();
        }
    }
}

