/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.shared.REConstantsIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.CommandLineProcessor;
import de.seetec.v5.shared.ServiceMessageProviderImpl;
import de.seetec.v5.shared.networking.srpc.SrpcStatistics;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DM {
    private static Core core = null;
    private static boolean shutdown = false;

    public static void main(String[] argv) {
        ServiceMessageProviderImpl serviceMessageProvider = new ServiceMessageProviderImpl();
        System.err.println(serviceMessageProvider.getStartMessage("DeviceManager"));
        new DM(CommandLineProcessor.parse((String[])argv, (String[])REConstantsIntf.CM_OPTIONAL_CMD_LINE_ARGS));
    }

    private DM(Map<String, String> htParameter) {
        if (core != null) {
            System.out.println("Another [DeviceManager] is already active in this JVM. Terminating.");
            core = null;
            return;
        }
        Runtime.getRuntime().addShutdownHook(new ThreadImpl(this.getClass().getName()));
        SrpcStatistics.reset((boolean)false);
        core = new Core();
        int errorCode = core.init(htParameter);
        if (errorCode != 0) {
            System.out.println("Initializing [Core] failed with ErrorCode [" + errorCode + "]. Parameter=[" + htParameter + "]. Terminating");
            DM.shutdown(new String[0]);
            return;
        }
        System.out.println("\n[DeviceManager] is READY");
        System.out.println("*** DO NOT CLOSE THIS WINDOW UNTIL SHUTDOWN ***\n");
    }

    public static void shutdown(String[] argv) {
        int errorCode = 0;
        long tsStart = System.currentTimeMillis();
        Logger logger = LogManager.getLogger((String)"DeviceManager");
        if (shutdown) {
            return;
        }
        shutdown = true;
        System.out.println("Shutdown of [DeviceManager] started");
        logger.info("Shutdown of [DeviceManager] started");
        try {
            if (core != null && (errorCode = core.shutdown()) != 0) {
                System.out.println("Shutdown of [(Re)Core] failed with error [" + errorCode + "]");
            }
        }
        catch (Exception ex) {
            logger.warn("Shutting down " + (Object)((Object)core) + " failed.", (Throwable)ex);
        }
        try {
            long timeout = System.currentTimeMillis() + 60000L;
            while (!core.isShutdownFinished() && timeout > System.currentTimeMillis()) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception ex) {
            logger.warn("Exception " + ex.getMessage() + " occured.");
        }
        core = null;
        long duration = System.currentTimeMillis() - tsStart;
        long sleepTime = 20000L - duration;
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((duration = System.currentTimeMillis() - tsStart) > 20000L) {
            System.out.println("[DeviceManager] shutdown needed more than [" + Basic.longToFormattedString((long)duration) + " ms]");
            logger.info("[DeviceManager] shutdown needed more than [" + Basic.longToFormattedString((long)duration) + " ms]");
        }
        System.out.println("Bye!");
        logger.info("Bye!");
        System.exit(0);
    }

    private static class ThreadImpl
    extends Thread {
        ThreadImpl(String name) {
            super(name);
        }

        @Override
        public void run() {
            ServiceMessageProviderImpl serviceMessageProvider = new ServiceMessageProviderImpl();
            System.err.println(serviceMessageProvider.getStopMessage("DeviceManager"));
            if (shutdown) {
                return;
            }
            System.out.println("+----------------------------------------+");
            System.out.println("+                                        +");
            System.out.println("+ Sending Shutdown to [DeviceManager] +");
            System.out.println("+                                        +");
            System.out.println("+ PLEASE STAND BY ...                    +");
            System.out.println("+                                        +");
            System.out.println("+----------------------------------------+");
            DM.shutdown(new String[0]);
        }
    }
}

