/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.DMComponentVersionNumberProvider;
import de.seetec.v5.re.cm.DMConstantsIntf;
import de.seetec.v5.re.cm.DMSRPCHandler;
import de.seetec.v5.re.cm.DeviceLifeCycleInformation;
import de.seetec.v5.re.cm.DeviceLifeCycleInformationImpl;
import de.seetec.v5.re.cm.DeviceManagerStatistic;
import de.seetec.v5.re.cm.MultimediaDatabaseLifeCycle;
import de.seetec.v5.re.cm.StatisticDaemon;
import de.seetec.v5.re.cm.TimeLocation;
import de.seetec.v5.re.cm.device.other.sip.AudioDevice;
import de.seetec.v5.re.cm.device.other.sip.SIPMessageHandler;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.DeviceFactory;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandler;
import de.seetec.v5.re.cm.device.shared.ManualExportTriggerHandler;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifStatus;
import de.seetec.v5.re.cm.filesystemwatcher.FileSystemWatcherServer;
import de.seetec.v5.re.cm.firmware.FirmwareManager;
import de.seetec.v5.re.cm.firmware.FirmwareManagerImpl;
import de.seetec.v5.re.cm.shared.ActionHandlerIntf;
import de.seetec.v5.re.cm.shared.AlarmProcessor;
import de.seetec.v5.re.cm.shared.RecordingStatistic;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.cm.shared.communication.FailoverConfiguration;
import de.seetec.v5.re.cm.shared.communication.MDSProxy;
import de.seetec.v5.re.cm.shared.communication.NetworkClientHandler;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.re.cm.shared.communication.RecordingHandler;
import de.seetec.v5.re.cm.shared.sql.FrameStatistic;
import de.seetec.v5.re.cm.shared.sql.ManagerLoggingOfCameraUsage;
import de.seetec.v5.re.cm.shared.sql.SQLDatabaseHandler;
import de.seetec.v5.re.shared.RECnfMgr;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.ComponentVersionNumberProvider;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.LicenseErrors;
import de.seetec.v5.shared.LogHeaderProvider;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.OpenProblemWrapper;
import de.seetec.v5.shared.REStatus;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.configuration.events.opc.OPCEvent;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.networking.srpc.SrpcStatistics;
import de.seetec.v5.shared.networking.srpc.SrpcTcp;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.tree.TreeNode;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jdom.JDOMException;

public class Core
extends RECore {
    public static final Object PROBLEMS_SEMAPHORE = new Object();
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.Core";
    public Map<Long, ActionHandlerIntf> actionHandler = new HashMap<Long, ActionHandlerIntf>();
    public final DeviceManagerStatistic deviceManagerStatistic = new DeviceManagerStatistic();
    private Logger logger = null;
    private DeviceLifeCycleInformation deviceLifeCycleInformationImpl = null;
    private final long tsMilliStartup = System.currentTimeMillis();
    private ConfigurationProvider configurationProvider = null;
    private Thread myThread = null;
    private boolean shutdownFinished = false;
    private boolean coreEntityStored = false;
    private NetworkClientHandler networkClientHandler = null;
    private SIPMessageHandler sipMessageHandler = null;
    private FileSystemWatcherServer fileSystemWatcherServer = null;
    private Map<String, String> rtspInformation = new HashMap<String, String>();
    private Map<Long, TimeLocation> entityLocations = new HashMap<Long, TimeLocation>();
    private ManagerLoggingOfCameraUsage managerLoggingOfCameraUsage = null;
    private SQLDatabaseHandler sqlDatabaseHandler = null;
    private FrameStatistic frameStatistic = null;
    private AlarmProcessor alarmProcessor = null;
    private StatisticDaemon mdbStatisticsDaemon;
    private EdgeStorageHandler edgeStorageHandler;
    private RECore.RegistrationState registrationState = RECore.RegistrationState.NOT_REGISTERED;
    private boolean opcInSystem = false;
    private OnvifStatus firstOnvifDeviceStarting = OnvifStatus.NOT_STARTED;
    private final Lock onvifDeviceLock = new ReentrantLock();
    private final FirmwareManager firmwareManager = new FirmwareManagerImpl(System.getenv("TEMP"));
    private MultimediaDatabaseLifeCycle multimediaDatabaseLifeCycle;

    public int init(Map<String, String> parameter) {
        long dmID;
        String[] logHeader;
        String homeDirectory;
        String mdbCnfFile;
        String dmCnfFile = parameter.get("cnffile");
        if (dmCnfFile == null) {
            dmCnfFile = "../../../conf/dm.conf.xml";
        }
        if ((mdbCnfFile = parameter.get("cnffile")) == null) {
            mdbCnfFile = "../../../conf/mds.conf.xml";
        }
        if ((homeDirectory = parameter.get("home")) == null) {
            homeDirectory = "..";
        }
        File homeDirectoryFile = new File(homeDirectory);
        try {
            homeDirectory = homeDirectoryFile.getCanonicalPath().trim();
        }
        catch (Exception ex) {
            homeDirectory = homeDirectoryFile.getAbsolutePath().trim();
        }
        File dmCnfDirectory = new File(dmCnfFile);
        try {
            dmCnfFile = dmCnfDirectory.getCanonicalPath().trim();
        }
        catch (Exception ex) {
            dmCnfFile = dmCnfDirectory.getAbsolutePath().trim();
        }
        File mdbCnfDirectory = new File(mdbCnfFile);
        try {
            mdbCnfFile = mdbCnfDirectory.getCanonicalPath().trim();
        }
        catch (Exception ex) {
            mdbCnfFile = mdbCnfDirectory.getAbsolutePath().trim();
        }
        try {
            String logProperties = homeDirectory + "/../../" + "conf" + "/" + "dm" + ".log4j2.xml";
            Configurator.initialize(null, (String)logProperties);
            this.logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
        }
        catch (Exception ex) {
            this.logger.error("Initializing [Logger] failed [" + ex.getMessage() + "]");
            return -21606;
        }
        for (String string : logHeader = LogHeaderProvider.getLogHeader((String)"DeviceManager", (ComponentVersionNumberProvider)new DMComponentVersionNumberProvider(), (String)DMConstantsIntf.CM_APP_DATE)) {
            this.logger.info(string);
        }
        try {
            if (!new File(dmCnfFile).exists()) {
                this.logger.warn("Conf File for dm not found ");
                if (new File(dmCnfFile.replace("dm.conf.xml", "cm.conf.xml")).exists()) {
                    this.logger.warn("cm.conf.xml file found. Generating dm.conf.xml");
                    File dmFile = new File(dmCnfFile);
                    File cmFile = new File(dmCnfFile.replace("dm.conf.xml", "cm.conf.xml"));
                    if (!cmFile.renameTo(dmFile) && dmFile.canWrite()) {
                        dmFile.createNewFile();
                        Throwable throwable = null;
                        try (FileWriter dmWriter = new FileWriter(dmFile);
                             FileReader cmReader22 = new FileReader(cmFile);){
                            int i;
                            while ((i = cmReader22.read()) != -1) {
                                dmWriter.write(i);
                            }
                        }
                        catch (Throwable cmReader22) {
                            Throwable throwable2 = cmReader22;
                            throw cmReader22;
                        }
                    }
                }
            }
            this.configurationProvider = new ConfigurationProvider();
            this.configurationProvider.init(dmCnfFile, mdbCnfFile, this);
            this.multimediaDatabaseLifeCycle = new MultimediaDatabaseLifeCycle(this.configurationProvider, this.getRuntimeEnvironmentStatus(), this);
            this.multimediaDatabaseLifeCycle.init();
            String serverAddress = this.getDmCnfMgr().getServerAddress();
            if (serverAddress.length() <= 0) {
                try {
                    serverAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception ex) {
                    serverAddress = "<unknown>";
                }
            }
            dmID = this.getDmCnfMgr().getEntityID();
            this.logger.info("Configuration:");
            this.logger.info("   DM EntityID:         [" + dmID + "]");
            this.logger.info("   MDB EntityID:        [" + this.multimediaDatabaseLifeCycle.getMultimediaDatabaseRuntime() + "]");
            this.logger.info("   Reg. Address:        [" + serverAddress + "]");
            this.logger.info("   DM Daemon.Port:      [" + this.getDmCnfMgr().getDaemonPort() + "]");
            this.logger.info("   CoreService          [" + this.getDmCnfMgr().getEntMgrHost() + ":" + this.getDmCnfMgr().getEntMgrPort() + "]");
            if (!this.getDmCnfMgr().getCoreServiceMainHost().equals("-1") && this.getDmCnfMgr().getCoreServiceMainPort() != -1) {
                this.logger.info("   CoreServiceMain    [" + this.getDmCnfMgr().getCoreServiceMainHost() + ":" + this.getDmCnfMgr().getCoreServiceMainPort() + "]");
            }
            this.logger.info("   MaxVideoQueueLength: [" + this.getDmCnfMgr().getMaxVideoQueueLength() / 1000L + " s]");
            this.logger.info("");
        }
        catch (Exception ex) {
            this.logger.error("Initializing of [RECnfMgr] failed with error [" + ex.getMessage() + "]");
            return -21018;
        }
        byte[] key = new byte[]{61, 103, -63, 98, -50, 22, 100, 35, 94, -45, 19, -45, 36, 24, -41, -67};
        int errorCode = super.init(this.getDmCnfMgr(), "../../../conf/keystore.xml", "VMS_" + "dm".toUpperCase(), key, 105L);
        if (errorCode != 0) {
            String localHostAddress;
            this.sendErrorEvent(EventType.CM_EVENTTYPE_CANNOT_START_CM);
            try {
                localHostAddress = this.getDmCnfMgr().getServerAddress();
            }
            catch (ConfigurationException configurationException) {
                this.logger.warn("Could not read localHostAddress from cnfFile", (Throwable)configurationException);
                localHostAddress = Basic.getLocalHostAddress();
            }
            this.sendLoggingEvent(EventType.CM_EVENTTYPE_CANNOT_START_CM, dmID, errorCode, "Initializing [DeviceManager] failed", "Initializing [DeviceManager] at [" + Basic.getLocalHostName() + "/" + localHostAddress + "] failed with error [" + errorCode + "].");
            this.logger.error("Initializing super core failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        long timeout = System.nanoTime() + 60000000000L;
        while (true) {
            try {
                int tempErrorCode;
                this.registerCoreToEntityManager();
                Entity entity = this.getEntMgrProxy().getEntityByID(Long.valueOf(this.multimediaDatabaseLifeCycle.getMultimediaDatabaseRuntime()), Boolean.valueOf(true), 60000L);
                if (entity.getLogicalParent().longValue() != this.getDmCnfMgr().getEntityID() && (tempErrorCode = this.getEntMgrProxy().setEntity(entity.getEntityID(), entity.getEntityName(), entity.getEntityType(), entity.getMID(), entity.isEnabled(), entity.getConfiguration(), null, entity.getPhysicalParent(), entity.getPhysicalOrder(), Long.valueOf(this.getDmCnfMgr().getEntityID()), entity.getLogicalOrder(), this.getCayugaToken(), 60000L)) != 0) {
                    throw new SeeTecException(tempErrorCode, "DM could not be set as parent from MDB");
                }
            }
            catch (Exception exception) {
                this.logger.error("DM could not be set as parent from MDB." + (exception instanceof SeeTecException ? "ErrorCode: " + ((SeeTecException)exception).getErrorCode() : ""));
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("Thread sleep interrupted.");
                }
                if (System.nanoTime() - timeout <= 0L) continue;
                this.logger.error("Parent of MDB is not the current DM, or we could not verify it.");
                return -21000;
            }
            break;
        }
        this.fileSystemWatcherServer = new FileSystemWatcherServer();
        this.fileSystemWatcherServer.init();
        try {
            this.networkClientHandler = new NetworkClientHandler(this.deviceManagerStatistic, this.configurationProvider);
            errorCode = this.networkClientHandler.init(this.getDmCnfMgr().getDaemonPort());
            if (errorCode != 0) {
                this.logger.error("Creating [NetworkClientHandler] failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Creating [NetworkClientHandler] failed [" + throwable.getMessage() + "]");
            return -21600;
        }
        try {
            this.sipMessageHandler = new SIPMessageHandler();
            errorCode = this.sipMessageHandler.init(this, this.getDmCnfMgr().getSIPMessagePort());
            if (errorCode != 0) {
                this.logger.error("Creating [SIPMessageHandler] failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Creating [SIPMessageHandler] failed [" + throwable.getMessage() + "]");
            return -21600;
        }
        this.deviceLifeCycleInformationImpl = new DeviceLifeCycleInformationImpl((SystemTimeProvider)new DefaultSystemTimeProvider());
        this.rtspInformation = new HashMap<String, String>();
        this.actionHandler = new HashMap<Long, ActionHandlerIntf>();
        this.entityLocations = new HashMap<Long, TimeLocation>();
        this.myThread = new Thread((Runnable)((Object)this), this.toString());
        this.myThread.start();
        this.getRuntimeEnvironmentStatus().setStatus(REStatus.INITIALIZED.getStatus());
        this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"[DeviceManager] is READY"}));
        this.sqlDatabaseHandler = new SQLDatabaseHandler();
        this.sqlDatabaseHandler.init(this.getDmCnfMgr().getCommonDBPath(), this.getCoreExtension());
        this.frameStatistic = new FrameStatistic();
        this.frameStatistic.init(this.sqlDatabaseHandler);
        this.managerLoggingOfCameraUsage = new ManagerLoggingOfCameraUsage();
        this.managerLoggingOfCameraUsage.init(this.sqlDatabaseHandler);
        this.alarmProcessor = new AlarmProcessor();
        this.alarmProcessor.init(this);
        this.edgeStorageHandler = new EdgeStorageHandler();
        try {
            errorCode = this.edgeStorageHandler.init(this);
            if (errorCode != 0) {
                this.logger.error("EdgeStorageHandler could not be initalized. ErrorCode: " + errorCode);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("EdgeStorageHandler could not be initalized", throwable);
        }
        super.createDeadlockDetector();
        this.mdbStatisticsDaemon = new StatisticDaemon();
        RecordingStatistic recordingStatistic = new RecordingStatistic(this);
        errorCode = this.mdbStatisticsDaemon.init(this, recordingStatistic);
        if (errorCode != 0) {
            this.logger.error("StatisticsDaemon could not be initialized. ErrorCode: " + errorCode);
        }
        this.actionHandler.put(dmID, new ManualExportTriggerHandler(this, this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()));
        return 0;
    }

    public void run() {
        int errorCode;
        super.setRunFinished(CLASS_NAME, false);
        long nextEntMgrRegistration = System.currentTimeMillis() + 1000L;
        long nextStatusEveryMinute = -1L;
        long nextStatusEveryHour = -1L;
        long hourlyDeviceCheck = -1L;
        long systemTimeCheck = System.currentTimeMillis();
        long nextTreePositionCheck = Long.MAX_VALUE;
        long nextCheckForOldExportJobs = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
        long statistics = System.currentTimeMillis();
        long lastGrabbedVideoFrames = 0L;
        long lastGrabbedAudioFrames = 0L;
        long lastGrabbedData = 0L;
        long lastClientFrames = 0L;
        long lastDiscardedClientFrames = 0L;
        int dayOfWeek = Calendar.getInstance().get(7);
        try {
            while (true) {
                long gap;
                super.doDelayBreakedByShutdown(CLASS_NAME, 1000L);
                if (this.isShutdown()) break;
                if (dayOfWeek != Calendar.getInstance().get(7)) {
                    System.gc();
                    dayOfWeek = Calendar.getInstance().get(7);
                }
                if ((gap = Math.abs(System.currentTimeMillis() - systemTimeCheck)) > 3600000L) {
                    try {
                        this.sendErrorEvent(EventType.GENERAL_EVENTTYPE_SERVERTIME_CHANGED, this.getDmCnfMgr().getEntityID());
                        this.sendLoggingEvent(EventType.GENERAL_EVENTTYPE_SERVERTIME_CHANGED, this.getDmCnfMgr().getEntityID(), Integer.MIN_VALUE, "System time changed", "System time at [" + Basic.getLocalHostName() + "/" + this.getDmCnfMgr().getServerAddress() + "] changed for more than [" + gap / 60000L + " min].");
                    }
                    catch (Exception ex) {
                        this.logger.warn("Cannot send mail for " + EventType.GENERAL_EVENTTYPE_SERVERTIME_CHANGED.getDescription(), (Throwable)ex);
                    }
                }
                systemTimeCheck = System.currentTimeMillis();
                if (nextEntMgrRegistration < System.currentTimeMillis()) {
                    errorCode = this.registerCoreToEntityManager();
                    if (errorCode != 0) {
                        this.registrationState = RECore.RegistrationState.NOT_REGISTERED;
                        if (errorCode == LicenseErrors.ERR_LICENSE_EXCEED_TOO_MANY_REMOTE_CONNECTIONS.getErrorCode()) {
                            this.logger.fatal("Shutting down " + (Object)((Object)this) + " because of license purposes!");
                            break;
                        }
                        this.logger.warn("Registering " + (Object)((Object)this) + " to the [EntityManager] failed with error [" + errorCode + "]");
                        nextEntMgrRegistration = System.currentTimeMillis() + 10000L;
                    } else {
                        if (this.registrationState.equals((Object)RECore.RegistrationState.NOT_REGISTERED)) {
                            this.registrationState = RECore.RegistrationState.REGISTERED;
                        }
                        if ((errorCode = super.subscribeForEvents()) != 0) {
                            this.logger.warn("Subscribing for changed entities failed with error [" + errorCode + "] :-(");
                        }
                        try {
                            List locateOPC = this.getEntMgrProxy().locateEntitiesByType(Long.valueOf(115L), TimeUnit.SECONDS.toMillis(20L));
                            this.opcInSystem = locateOPC != null && !locateOPC.isEmpty();
                        }
                        catch (SeeTecException seeTecException) {
                            this.logger.warn("Error while locating OPC REs in system [ErrorCode:" + seeTecException.getErrorCode() + "] | " + seeTecException.getMessage());
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while locating OPC REs in system | " + throwable.getMessage());
                        }
                        nextEntMgrRegistration = System.currentTimeMillis() + 60000L;
                    }
                }
                if (nextStatusEveryMinute < System.currentTimeMillis()) {
                    Thread[] threads;
                    nextStatusEveryMinute = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
                    DMComponentVersionNumberProvider componentVersionNumberProvider = new DMComponentVersionNumberProvider();
                    StringBuilder sb = new StringBuilder(1024);
                    sb.append("System Info:\r\n\r\n");
                    sb.append("   Version:             [").append("DeviceManager ").append(componentVersionNumberProvider.getReleaseVersion()).append(" / ").append(DMConstantsIntf.CM_APP_DATE).append("]\r\n");
                    sb.append("   Date:                [").append(new Date(System.currentTimeMillis())).append("]\r\n");
                    String serverAddress = null;
                    if (this.getDmCnfMgr() != null && this.getDmCnfMgr().getServerAddress().length() > 0) {
                        serverAddress = this.getDmCnfMgr().getServerAddress();
                    }
                    for (String line : LogHeaderProvider.getLogBody(serverAddress)) {
                        sb.append(line);
                        sb.append("\r\n");
                    }
                    sb.append("   Uptime:              [").append(TimeHelper.getReadableTimerange((long)this.getUptime())).append("]");
                    sb.append("\r\n");
                    sb.append("   Connected to Core:   [");
                    if (this.coreServiceWrapper.getCurrentCoreServiceHost() != null) {
                        sb.append(this.coreServiceWrapper.getCurrentCoreServiceHost()).append(":").append(this.coreServiceWrapper.getCurrentCoreServicePort()).append(" (ID: ").append(this.coreServiceWrapper.getCurrentCoreServiceId()).append(")]");
                        sb.append("\r\n");
                    } else {
                        sb.append("No connection to core]");
                        sb.append("\r\n");
                    }
                    try {
                        long dmID = this.getDmCnfMgr().getEntityID();
                        sb.append("   DM EntityID:         [").append(dmID).append("]").append("\r\n");
                        sb.append("   MDS (RE)EntityID:    [").append(this.multimediaDatabaseLifeCycle.getMultimediaDatabaseRuntime()).append("]").append("\r\n");
                        sb.append("   MDS (Device)EntityID:[").append(this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()).append("]").append("\r\n");
                    }
                    catch (Exception e) {
                        this.logger.warn("Error while reading IDs.");
                    }
                    sb.append("\r\n");
                    sb.append("   SRPC Connections:    [");
                    sb.append(Basic.longToFormattedString((long)SrpcTcp.ActiveConnections()));
                    sb.append("]");
                    sb.append("\r\n");
                    sb.append("   Current Threads:     [");
                    sb.append(Basic.longToFormattedString((long)Thread.activeCount()));
                    sb.append("]");
                    sb.append("\r\n");
                    try {
                        threads = new Thread[Thread.activeCount()];
                        Thread.enumerate(threads);
                        sb.append("   VideoSrvCRH-Threads: [").append(Basic.longToFormattedString((long)this.determineNumberOfActiveClientThreads(threads))).append("]");
                        sb.append("\r\n");
                        sb.append("   Connected clients:   ").append("[").append(this.networkClientHandler != null ? this.networkClientHandler.getNumberOfNetworkClientProxies() : 0).append("] ").append(this.networkClientHandler).append("]");
                        sb.append("\r\n");
                    }
                    catch (Throwable ex) {
                        this.logger.warn("Error while checking current client/DM connections");
                    }
                    if (nextStatusEveryHour < System.currentTimeMillis()) {
                        nextStatusEveryHour = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
                        if (Core.getCpuLoadStats() != null) {
                            sb.append("\r\n");
                            sb.append("   Number of CPUs in system: ");
                            sb.append(Core.getCpuLoadStats().getCurrentLoad().getCpuNumber());
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append("Current system CPU load: ");
                            sb.append(Core.getCpuLoadStats().getCurrentLoad().getSystemCpuLoadAsString());
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append("Average system CPU load (24h or since startup): ");
                            sb.append(Core.getCpuLoadStats().getAverageSystemLoadAsString());
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append("Equipartition system CPU load (24h or since startup):");
                            sb.append("\r\n");
                            sb.append(Core.getCpuLoadStats().getEquipartitionSystemLoadAsString("       "));
                            sb.append("       ");
                            sb.append("Current process CPU load: ");
                            sb.append(Core.getCpuLoadStats().getCurrentLoad().getProcessCpuLoadAsString());
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append("Average process CPU load (24h or since startup): ");
                            sb.append(Core.getCpuLoadStats().getAverageProcessLoadAsString());
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append("Equipartition process CPU load (24h or since startup):");
                            sb.append("\r\n");
                            sb.append(Core.getCpuLoadStats().getEquipartitionProcessLoadAsString("       "));
                        }
                        if ((threads = new Thread[Thread.activeCount()]).length > 0) {
                            sb.append("\r\n   Current thread list (").append(threads.length).append("):\r\n");
                            Thread.enumerate(threads);
                            for (int i = 0; i < threads.length; ++i) {
                                sb.append("      [").append(i).append("]=").append(threads[i]).append("\r\n");
                            }
                        }
                        try {
                            Device[] devices = this.deviceLifeCycleInformationImpl.getDeviceList();
                            sb.append("\r\n   Active Hardware devices (").append(devices.length).append("): \r\n");
                            for (Device device : devices) {
                                sb.append("\t\tName=[").append(device != null && device.getDeviceEntity() != null && device.getDeviceEntity().getEntityName() != null ? device.getDeviceEntity().getEntityName() : "unknown device name");
                                sb.append("], Host=[").append(device != null && device.getDeviceCnf() != null && device.getDeviceCnf().getHardwareHost() != null ? device.getDeviceCnf().getHardwareHost() : "unknown device host");
                                sb.append("], ID=[").append(device != null && device.getDeviceID() != null ? device.getDeviceID() : "unknown device id");
                                sb.append("], Type=[").append(device != null && device.getDeviceType() != null ? device.getDeviceType() : "unknown device type");
                                sb.append("]\r\n");
                            }
                        }
                        catch (Throwable t) {
                            this.logger.warn("Error while checking current device list");
                        }
                    }
                    long coreGrabbedVideoFrames = this.deviceManagerStatistic.getGrabbedVideoFrames();
                    long coreGrabbedAudioFrames = this.deviceManagerStatistic.getGrabbedAudioFrames();
                    long coreGrabbedData = this.deviceManagerStatistic.getGrabbedData();
                    long coreClientFrames = this.deviceManagerStatistic.getClientFrames();
                    long coreDiscardedClientFrames = this.deviceManagerStatistic.getDiscardedClientFrames();
                    long coreWrittenDatabaseFrames = this.deviceManagerStatistic.getWrittenDatabaseFrames();
                    long coreDiscardedDatabaseFrames = this.deviceManagerStatistic.getDiscardedDatabaseFrames();
                    long duration = System.currentTimeMillis() - statistics;
                    long grabbedVideoFramesLocal = coreGrabbedVideoFrames - lastGrabbedVideoFrames;
                    long grabbedAudioFramesLocal = coreGrabbedAudioFrames - lastGrabbedAudioFrames;
                    long grabbedDataLocal = coreGrabbedData - lastGrabbedData;
                    long clientFramesLocal = coreClientFrames - lastClientFrames;
                    long discardedClientFramesLocal = coreDiscardedClientFrames - lastDiscardedClientFrames;
                    statistics = System.currentTimeMillis();
                    lastGrabbedVideoFrames = coreGrabbedVideoFrames;
                    lastGrabbedAudioFrames = coreGrabbedAudioFrames;
                    lastGrabbedData = coreGrabbedData;
                    lastClientFrames = coreClientFrames;
                    lastDiscardedClientFrames = coreDiscardedClientFrames;
                    if (grabbedVideoFramesLocal + grabbedAudioFramesLocal > 0L || clientFramesLocal > 0L) {
                        sb.append("\r\n   Grabbed Frames:\r\n");
                        sb.append("      Video:            [").append(Basic.longToFormattedString((long)coreGrabbedVideoFrames)).append("] / [").append(Core.getReadableRate((long)grabbedVideoFramesLocal, (long)duration)).append(" fps]\r\n");
                        sb.append("      Audio:            [").append(Basic.longToFormattedString((long)coreGrabbedAudioFrames)).append("] / [").append(Core.getReadableRate((long)grabbedAudioFramesLocal, (long)duration)).append(" fps]\r\n");
                        sb.append("   Grabbed Data:        [").append(Basic.longToFormattedString((long)(coreGrabbedData >> 20))).append(" MB] / [").append(Core.getReadableRate((long)(grabbedDataLocal >> 10), (long)duration)).append(" KB/s]\r\n");
                        sb.append("   Client Frames:       [").append(Basic.longToFormattedString((long)coreClientFrames)).append("] / [").append(Core.getReadableRate((long)clientFramesLocal, (long)duration)).append(" fps]\r\n");
                        sb.append("   Disc. Client Frames: [").append(Basic.longToFormattedString((long)coreDiscardedClientFrames)).append("] / [").append(Core.getReadableRate((long)discardedClientFramesLocal, (long)duration)).append(" fps]\r\n");
                        sb.append("   Written DB Frames:   [").append(Basic.longToFormattedString((long)coreWrittenDatabaseFrames)).append("]\r\n");
                        sb.append("   Discarded DB Frames: [").append(Basic.longToFormattedString((long)coreDiscardedDatabaseFrames)).append("]\r\n");
                    }
                    if (SrpcStatistics.isActivated()) {
                        sb.append(SrpcStatistics.createReport());
                    }
                    this.logger.info(sb.toString());
                }
                if (hourlyDeviceCheck < System.currentTimeMillis()) {
                    hourlyDeviceCheck = System.currentTimeMillis() + 60000L;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Checking devices ...");
                    }
                    try {
                        Device[] deviceList;
                        for (Device device : deviceList = this.deviceLifeCycleInformationImpl.getDeviceList()) {
                            long start = System.currentTimeMillis();
                            try {
                                errorCode = device.checkDevice();
                                if (errorCode != 0) {
                                    this.logger.warn("Device " + device + " has an error [" + errorCode + "] and will be discarded.");
                                    this.stopDevice(device);
                                }
                            }
                            catch (Throwable throwable) {
                                this.logger.warn("Error while checking device " + device);
                            }
                            long duration = System.currentTimeMillis() - start;
                            if (duration <= 60000L) continue;
                            this.logger.info("Checking " + device + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Checking devices failed", throwable);
                    }
                }
                if (nextCheckForOldExportJobs < System.currentTimeMillis()) {
                    nextCheckForOldExportJobs = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
                    try {
                        long tooOld = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L);
                        File exportDirectory = new File("../../../tools/AVExport/jobs");
                        File[] exportJobs = exportDirectory.listFiles();
                        long start = System.currentTimeMillis();
                        int numberRemovedJobs = 0;
                        for (File exportJob : exportJobs) {
                            if (exportJob == null || !exportJob.getName().startsWith("ExportJob.") || exportJob.lastModified() >= tooOld) continue;
                            ++numberRemovedJobs;
                            if (exportJob.delete()) continue;
                            this.logger.warn("... There was a problem removing " + exportJob);
                        }
                        if (numberRemovedJobs > 0) {
                            long duration = System.currentTimeMillis() - start;
                            this.logger.warn("[" + numberRemovedJobs + "] outdated export jobs removed within [" + duration + " ms]");
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn("Trouble removing outdated export jobs");
                    }
                }
                if (!this.registrationState.equals((Object)RECore.RegistrationState.REGISTERED) && nextTreePositionCheck >= System.currentTimeMillis()) continue;
                if (this.registrationState.equals((Object)RECore.RegistrationState.REGISTERED)) {
                    this.registrationState = RECore.RegistrationState.RIGHT_TREE_POSITION_ENSURED;
                }
                nextTreePositionCheck = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
                this.logger.debug("Check correct Core of this DM...");
                errorCode = this.ensureConnectToCorrectCore();
                if (errorCode == 0) continue;
                this.logger.warn("Something works not correct on ensuring right tree position of core or correcting to core in cnf file again. ErrorCode: " + errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.logger.info("Thread of [(Re)Core] terminated");
        errorCode = this.shutdown();
        if (errorCode != 0) {
            this.logger.error("[shutdown] of " + (Object)((Object)this) + " failed with error [" + errorCode + "]");
        }
    }

    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        try {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.warn(ex.getMessage());
        }
        this.getRuntimeEnvironmentStatus().setStatus(REStatus.INVALID.getStatus());
        if (this.multimediaDatabaseLifeCycle != null) {
            this.multimediaDatabaseLifeCycle.shutdown();
        }
        if (this.edgeStorageHandler != null) {
            this.edgeStorageHandler.shutdown();
            this.edgeStorageHandler = null;
        }
        if (this.fileSystemWatcherServer != null) {
            this.fileSystemWatcherServer.shutdown();
        }
        if (this.networkClientHandler != null) {
            int errorCode = this.networkClientHandler.shutdown();
            if (errorCode != 0) {
                this.logger.error("Shutting down [" + this.networkClientHandler + "] failed with error [" + errorCode + "] :-(");
                this.networkClientHandler = null;
            }
            this.networkClientHandler = null;
        }
        if (this.lifeCycleEventEngine != null) {
            this.lifeCycleEventEngine.sendStopEvent();
        }
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread didn't finished in time :-(");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    this.logger.warn("Exception while thread sleep: " + ex.getMessage());
                }
            }
            this.myThread = null;
        }
        this.logger.info("Shutting down devices ...");
        for (Device device : this.deviceLifeCycleInformationImpl.getDeviceList()) {
            int errorCode = this.stopDevice(device);
            if (errorCode == 0) continue;
            this.logger.debug("Stopping " + device + " failed with error [" + errorCode + "] :-(");
        }
        this.deviceLifeCycleInformationImpl.shutdown();
        try {
            Long entityID = this.getDmCnfMgr().getEntityID();
            int errorCode = this.deregisterEntity(entityID);
            if (errorCode != 0) {
                this.logger.warn("Deregistering " + (Object)((Object)this) + " from [EntityManager] failed with error [" + errorCode + "] :-(");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Deregistering " + (Object)((Object)this) + " failed. Maybe [EntityManager] already shutdown!");
        }
        if (this.managerLoggingOfCameraUsage != null) {
            this.managerLoggingOfCameraUsage.shutdown();
            this.managerLoggingOfCameraUsage = null;
        }
        if (this.frameStatistic != null) {
            this.frameStatistic.shutdown();
            this.frameStatistic = null;
        }
        if (this.sqlDatabaseHandler != null) {
            this.sqlDatabaseHandler.shutdown();
            this.sqlDatabaseHandler = null;
        }
        if (this.mdbStatisticsDaemon != null) {
            this.mdbStatisticsDaemon.shutdown();
            this.mdbStatisticsDaemon = null;
        }
        super.shutdown();
        this.shutdownFinished = true;
        return super.shutdown();
    }

    public boolean isShutdownFinished() {
        return this.shutdownFinished;
    }

    public AlarmProcessor getAlarmProcessor() {
        return this.alarmProcessor;
    }

    public RECnfMgr getDmCnfMgr() {
        return this.configurationProvider.getDMConfigurationFromFile();
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public ManagerLoggingOfCameraUsage getManagerLoggingOfCameraUsage() {
        return this.managerLoggingOfCameraUsage;
    }

    public FrameStatistic getFrameStatistic() {
        return this.frameStatistic;
    }

    public int registerEntity() {
        try {
            return this.registerEntity(this.getDmCnfMgr().getEntityID(), 105L);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Could not read entityID from cnf for " + (Object)((Object)this));
            return -21622;
        }
    }

    public int registerEntity(Long entityID, Long entityType) {
        if (this.isShutdown()) {
            this.logger.error("Cannot register entity [" + entityID + "]/[" + entityType + "] because of shutdown");
            return -21609;
        }
        try {
            String serverAddress = this.getDmCnfMgr().getServerAddress();
            if (serverAddress.length() <= 0) {
                serverAddress = InetAddress.getLocalHost().getHostAddress();
            }
            return super.registerEntity(entityID, entityType, serverAddress, Integer.valueOf(this.getDmCnfMgr().getDaemonPort()), Long.valueOf(this.tsMilliStartup));
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return -21622;
        }
    }

    public int startDevice(long entityID, String entityName, long entityType) {
        Device device;
        block25: {
            this.logger.info("Start device " + entityName + "(ID: " + entityID + ") of type " + entityType);
            if (this.getRuntimeEnvironmentStatus().getStatus() == -21040) {
                return this.getRuntimeEnvironmentStatus().getStatus();
            }
            if (this.isShutdown()) {
                this.logger.error("Cannot start device [" + entityName + "]/[" + entityID + "] because of shutdown");
                return -21609;
            }
            int activeThreads = Thread.activeCount();
            if (activeThreads >= RECore.getThreadLimit()) {
                this.logger.error("There are already [" + activeThreads + "] threads active. Device [" + entityName + "]/[" + entityID + "] will not be started!");
                return -21680;
            }
            this.getRuntimeEnvironmentStatus().setStatus(REStatus.OPERATING.getStatus());
            Long startUpOfDevice = this.deviceLifeCycleInformationImpl.getStartUpTimeOfInitializingDevice(entityID);
            if (startUpOfDevice != null) {
                long duration = System.currentTimeMillis() - startUpOfDevice;
                this.logger.warn("Device [" + entityID + "] is initializing now for [" + Basic.longToFormattedString((long)(duration / 1000L)) + " s]");
                if (duration > 600000L) {
                    this.logger.warn("Device [" + entityID + "] is starting up for more than 10 minutes, so discarding it ...");
                    this.stopDevice(entityID);
                }
                return 0;
            }
            if (this.deviceLifeCycleInformationImpl.isMaxInitializingDevicesNumberReached()) {
                this.logger.warn("Already [100] devices starting up, so ignoring startup request for device [" + entityID + "] for the moment!");
                return 0;
            }
            if (entityType == 209601L || entityType == 209600L || entityType == 205501L || entityType == 204203L || entityType == 206500L || entityType == 206600L) {
                if (this.firstOnvifDeviceStarting == OnvifStatus.STARTING) {
                    return 0;
                }
                if (this.firstOnvifDeviceStarting == OnvifStatus.NOT_STARTED) {
                    try {
                        this.setFlag(OnvifStatus.STARTING);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while setting status for start of ONVIF-Library: " + ex.getMessage());
                        return 0;
                    }
                }
            }
            this.deviceLifeCycleInformationImpl.setStartInitializingDevice(entityID);
            device = this.deviceLifeCycleInformationImpl.getDevice(entityID);
            if (device != null) {
                if (System.currentTimeMillis() - device.getStartup() > 120000L) {
                    this.logger.warn(device + " already started. Shutting down the device because of invalid status ...");
                    return this.stopDevice(device);
                }
                this.logger.info("Don't restart 'young' device " + device);
            }
            try {
                device = DeviceFactory.getInstance().getDevice(this, this.logger, entityID, entityName, entityType);
                if ((entityType == 209601L || entityType == 209600L || entityType == 205501L || entityType == 204203L || entityType == 206500L || entityType == 206600L) && this.firstOnvifDeviceStarting == OnvifStatus.STARTING) {
                    this.setFlag(OnvifStatus.FINISHED_STARTING);
                }
            }
            catch (Exception ex) {
                if (ex instanceof SeeTecException) {
                    this.setEntityStatus(entityID, ((SeeTecException)((Object)ex)).getErrorCode());
                }
                if (entityType != 209601L && entityType != 209600L && entityType != 205501L && entityType != 204203L && entityType != 206500L && entityType != 206600L || this.firstOnvifDeviceStarting != OnvifStatus.STARTING) break block25;
                try {
                    this.setFlag(OnvifStatus.NOT_STARTED);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception while setting status for start of ONVIF-Library: " + exception.getMessage());
                }
            }
        }
        if (device != null) {
            if (device.isShutdown()) {
                this.logger.warn(device + " has done a shutdown and will be discarded!");
                return this.stopDevice(device);
            }
            if (this.isShutdown()) {
                this.logger.error("Discard " + device + " because of shutdown :-(");
                return this.stopDevice(device);
            }
        } else {
            this.logger.warn("Couldn't create valid device for entity [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "]/[" + Basic.longToFormattedString((long)entityType) + "] ;-(");
            this.deviceLifeCycleInformationImpl.setStopInitializingDevice(entityID);
            return -21600;
        }
        try {
            this.setEntityStatus(entityID, 0);
        }
        catch (Throwable ex) {
            this.logger.warn("Can not set new entity status for device [" + entityID + "] to " + -21014 + " [" + ex.getMessage() + "]");
        }
        return this.deviceLifeCycleInformationImpl.setSuccessfullyFinishedInitializingDevice(device);
    }

    public int stopDevice(long entityId) {
        this.deviceLifeCycleInformationImpl.setStopInitializingDevice(entityId);
        Device device = this.deviceLifeCycleInformationImpl.getDevice(entityId);
        if (device == null) {
            this.logger.warn("Device with id [" + Basic.longToFormattedString((long)entityId) + "] is unknown");
            return -21676;
        }
        return this.stopDevice(device);
    }

    public int sendErrorEvent(EventType eventType) {
        try {
            return super.sendEvent(eventType, this.getDmCnfMgr().getEntityID(), -1L, null);
        }
        catch (Throwable ex) {
            this.logger.warn("Cannot send error event with type [" + eventType.getDescription() + "], cause no [CnfMgr] is available because of [" + ex.getMessage() + "]");
            return -21600;
        }
    }

    public int sendOPCEvent(String value, OPCLowerNodeIDType lowerNodeIDType, long entityID) {
        if (this.opcInSystem) {
            try {
                OPCEvent payload = new OPCEvent();
                payload.setValue(value);
                payload.setLowerNodeID(lowerNodeIDType.getType());
                this.getSendEventDaemon().put(new EventDataObject(EventType.GENERAL_EVENTTYPE_OPC_TO, entityID, Long.MIN_VALUE, Basic.cutOffRoot((String)Basic.marshalXML((Object)payload)).getBytes()));
            }
            catch (Exception ex) {
                return -21600;
            }
        } else {
            return -21601;
        }
        return 0;
    }

    public void sendTamperingEvent(VideoSrv videoSrv) {
        try {
            String message = "Manipulation alarm: Tampering detected for [" + videoSrv.getEntityID() + "]/[" + videoSrv.getEntityName() + "] at [" + Basic.getLocalHostName() + "/" + videoSrv.getCore().getDmCnfMgr().getServerAddress() + "].";
            this.sendErrorEvent(EventType.CM_EVENTTYPE_TAMPERING, videoSrv.getEntityID());
            this.sendLoggingEvent(EventType.CM_EVENTTYPE_TAMPERING, videoSrv.getEntityID(), -21667, "Manipulation alarm: Tampering detected for [" + videoSrv.getEntityID() + "]/[" + videoSrv.getEntityName() + "]", message);
            this.sendOPCEvent("-1", OPCLowerNodeIDType.CAMERA_TAMPERING_STATUS, videoSrv.getEntityID());
        }
        catch (ConfigurationException e) {
            this.logger.error("Exception while sending tampering data: " + e.getMessage());
        }
    }

    public void sendVideoLossEvent(VideoSrv videoSrv) {
        try {
            String message = "Manipulation alarm: Video loss detected for [" + videoSrv.getEntityID() + "]/[" + videoSrv.getEntityName() + "] at [" + Basic.getLocalHostName() + "/" + videoSrv.getCore().getDmCnfMgr().getServerAddress() + "].";
            this.sendErrorEvent(EventType.CM_EVENTTYPE_VIDEO_LOSS, videoSrv.getEntityID());
            this.sendLoggingEvent(EventType.CM_EVENTTYPE_VIDEO_LOSS, videoSrv.getEntityID(), -21663, "Manipulation alarm: Video loss detected for [" + Basic.longToFormattedString((Long)videoSrv.getEntityID()) + "]/[" + videoSrv.getEntityName() + "]", message);
            this.sendOPCEvent("true", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, videoSrv.getEntityID());
        }
        catch (ConfigurationException e) {
            this.logger.error("Exception while sending tampering data: " + e.getMessage());
        }
    }

    public void sendLoggingEvent(EventType eventType, long sourceID, int error, String subject, String body) {
        super.sendLoggingEvent(eventType, sourceID, error, subject, body);
        if (eventType == EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM) {
            try {
                this.sqlDatabaseHandler.saveOpenProblem(new OpenProblemWrapper(sourceID, eventType, error, System.currentTimeMillis()));
            }
            catch (SeeTecException ex) {
                this.logger.warn(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConnectivityProblemResolvedEvent(long sourceId, long time, String subject, String body) {
        Object object = PROBLEMS_SEMAPHORE;
        synchronized (object) {
            try {
                try {
                    if (this.windowsLoggingMgr != null) {
                        this.windowsLoggingMgr.sendLog(0, sourceId, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED.getType(), Level.INFO, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED.getDescription() + ": " + body, false);
                    }
                }
                catch (Throwable t) {
                    this.logger.warn("Error while writing windows system log. errorCode: " + t.getMessage());
                }
                try {
                    this.coreServiceWrapper.sendEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED, sourceId, -1L, null);
                    this.coreServiceWrapper.sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED, sourceId, 0, subject, body);
                }
                catch (Exception ex) {
                    this.logger.warn("Error while sending problem resolved event because of [" + ex.getMessage() + "]");
                }
                this.sqlDatabaseHandler.deleteOpenProblem(sourceId);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Error while getting open problems: " + seeTecException.getMessage());
            }
        }
    }

    public int notify(ReqNotify request) {
        block43: {
            if (this.isShutdown()) {
                this.logger.warn((Object)((Object)this) + " is already shutting down!");
                return 0;
            }
            Long eventType = request.getEventType();
            Long sourceId = request.getSourceID();
            super.notify(eventType, sourceId, request.getData());
            if (eventType != null && (eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType() || eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_DELETED.getType())) {
                Device[] deviceList;
                for (Device device : deviceList = this.deviceLifeCycleInformationImpl.getDeviceList()) {
                    if (!device.isSubEntity(sourceId) || eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType() && !device.hasNewVersionRelevantChanges(sourceId) && !device.hasMutableEntityTree()) continue;
                    this.frameStatistic.deleteStatisticForVideoSource(sourceId);
                    String deviceName = "Unknown Device Name";
                    String deviceHost = "Unknown Device Host";
                    int devicePort = -1;
                    String reHost = "Unknown DeviceManager";
                    try {
                        deviceName = device.getDeviceEntity().getEntityName();
                        deviceHost = device.getDeviceCnf().getHardwareHost();
                        devicePort = device.getDeviceCnf().getHardwarePort();
                        reHost = this.getDmCnfMgr().getServerAddress();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String body = "Device is stopped [" + deviceHost + ":" + devicePort + "]/[" + device.getDeviceEntity().getEntityName() + "] from [" + reHost + "].";
                    String subject = "Device is stopped [" + deviceHost + ":" + devicePort + "]/[" + deviceName + "]";
                    for (Entity srvEntity : device.getSrvEntities()) {
                        try {
                            List<OpenProblemWrapper> result = this.sqlDatabaseHandler.getOpenProblem(srvEntity.getEntityID());
                            if (result.size() < 1) continue;
                            this.sendConnectivityProblemResolvedEvent(srvEntity.getEntityID(), result.get(0).getTimestamp(), subject, body);
                        }
                        catch (SeeTecException seeTecException) {
                            this.logger.error("Error retrieving open problem for: " + srvEntity.getEntityID());
                        }
                    }
                    try {
                        List<OpenProblemWrapper> result = this.sqlDatabaseHandler.getOpenProblem(sourceId);
                        if (result.size() >= 1) {
                            this.sendConnectivityProblemResolvedEvent(sourceId, result.get(0).getTimestamp(), subject, body);
                        }
                    }
                    catch (SeeTecException seeTecException) {
                        this.logger.error("Error retrieving open problem for: " + sourceId);
                    }
                    int errorCode = this.stopDevice(device);
                    if (errorCode == 0) continue;
                    this.logger.warn("Stopping " + device + " failed with error [" + errorCode + "]");
                }
                try {
                    if (this.getDmCnfMgr().getEntityID() == sourceId.longValue()) {
                        this.notificationSettingsChanged();
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.warn("Unable to notify Statistics Daemon for settings changed [" + ex.getMessage() + "]");
                }
                try {
                    if (this.configurationProvider.getDMConfigurationFromFile().getEntityID() == sourceId.longValue() || this.configurationProvider.getMDSConfigurationFromFile().getEntityID() == sourceId.longValue()) {
                        this.configurationProvider.notify(request);
                    }
                }
                catch (ConfigurationException | SeeTecException ex) {
                    this.logger.warn("Unable to notify ConfigurationProvider for settings changed [" + ex.getMessage() + "]");
                }
            } else if (eventType != null && eventType.longValue() == EventType.GENERAL_EVENTTYPE_OPC_FROM.getType()) {
                try {
                    OPCEvent opcEvent = (OPCEvent)Basic.unmarshalXML(OPCEvent.class, (Object)("<root>" + new String(request.getData()) + "</root>"));
                    if (OPCLowerNodeIDType.isExisting((long)opcEvent.getLowerNodeID())) {
                        this.logger.info(OPCLowerNodeIDType.valueOf((Long)opcEvent.getLowerNodeID()) + " reached from OPC service.");
                        if (opcEvent.getLowerNodeID() == OPCLowerNodeIDType.CAMERA_ALARM_RECORDING_CONTROL.getType()) {
                            try {
                                VideoSrv videoSrv = (VideoSrv)this.deviceLifeCycleInformationImpl.getService(sourceId);
                                if (videoSrv == null) {
                                    this.logger.error("No VideoSrv [" + sourceId + "] registered, so ignoring command [start alarm recording");
                                    return -21600;
                                }
                                RecordingHandler recordingHandler = videoSrv.getRecordingHandler();
                                if (recordingHandler == null) {
                                    this.logger.error("Cannot fetch RecordingHandler from " + videoSrv);
                                    return -21600;
                                }
                                if (Boolean.parseBoolean(opcEvent.getValue())) {
                                    int errorCode = recordingHandler.startAlarmRecording();
                                    if (errorCode != 0) {
                                        this.logger.warn("Command [start alarm recording] failed with error code [" + errorCode + "] for " + videoSrv);
                                    } else {
                                        this.logger.warn("Command [start alarm recording] successful for " + videoSrv);
                                    }
                                } else {
                                    int errorCode = recordingHandler.stopAlarmRecording();
                                    if (errorCode != 0) {
                                        this.logger.warn("Command [stop alarm recording] failed with error code [" + errorCode + "] for " + videoSrv);
                                    } else {
                                        this.logger.warn("Command [stop alarm recording] successful for " + videoSrv);
                                    }
                                }
                                break block43;
                            }
                            catch (Throwable ex) {
                                this.logger.error("Trouble executing " + opcEvent + " for service [" + sourceId + "] because of [" + ex.getMessage() + "]", ex);
                                return -21600;
                            }
                        }
                        if (opcEvent.getLowerNodeID() == OPCLowerNodeIDType.CAMERA_PRESET_CONTROL.getType()) {
                            try {
                                Entity entityByID = this.getEntMgrProxy().getEntityByID(sourceId, Boolean.valueOf(false), 30000L);
                                VideoSrv videoSrv = (VideoSrv)this.deviceLifeCycleInformationImpl.getService(entityByID.getLogicalParent());
                                if (videoSrv == null) {
                                    this.logger.error("No VideoSrv [" + entityByID.getLogicalParent() + "] registered, so ignoring command [" + opcEvent + "]");
                                    return -21600;
                                }
                                videoSrv.setPresetPosition(entityByID.getEntityName());
                                break block43;
                            }
                            catch (SeeTecException ex) {
                                this.logger.error("Trouble executing " + opcEvent + " for service [" + sourceId + "] because of [" + ex.getMessage() + "]", (Throwable)ex);
                                return -21600;
                            }
                        }
                        if (opcEvent.getLowerNodeID() != OPCLowerNodeIDType.CAMERA_OUTPUT_CONTROL.getType()) break block43;
                        try {
                            Entity entityByID = this.getEntMgrProxy().getEntityByID(sourceId, Boolean.valueOf(true), 30000L);
                            Device device = this.deviceLifeCycleInformationImpl.getDevice(entityByID.getLogicalParent());
                            if (device == null) {
                                this.logger.error("No Device [" + entityByID.getLogicalParent() + "] registered, so ignoring command [" + opcEvent + "]");
                                return -21600;
                            }
                            DigitalOutputSrv[] digitalOutputSrv = device.getIOHandler().getDigitalOutputSrv();
                            int outputNumber = -1;
                            long holdTime = -1L;
                            int value = -1;
                            for (DigitalOutputSrv digitalOutput : digitalOutputSrv) {
                                if (digitalOutput.getServiceID() != entityByID.getEntityID().longValue()) continue;
                                outputNumber = digitalOutput.getOutputNumber();
                                if (entityByID.getEntityType() == 9911L) {
                                    holdTime = digitalOutput.getHoldTime();
                                    value = 1;
                                    continue;
                                }
                                holdTime = 0L;
                                value = 0;
                            }
                            if (outputNumber < 0 || value < 0 || holdTime < 0L) {
                                this.logger.error("Could not get all the necessary info.");
                                return -21600;
                            }
                            device.getIOHandler().writeDigitalOutput(outputNumber, value, holdTime);
                            break block43;
                        }
                        catch (SeeTecException ex) {
                            this.logger.error("Trouble executing " + opcEvent + " for service [" + sourceId + "] because of [" + ex.getMessage() + "]", (Throwable)ex);
                            return -21600;
                        }
                    }
                    this.logger.warn("LowerNodeID " + opcEvent.getLowerNodeID() + " unknown. Ignoring it.");
                }
                catch (Exception e) {
                    this.logger.error("Error while parsing opc event: " + e.getMessage());
                }
            }
        }
        return 0;
    }

    public int delegateSIPEvent(long eventType, String caller, String callee, long start, long end, byte[] recording) {
        int errorCode;
        if (this.isShutdown()) {
            return 0;
        }
        AudioDevice callerDevice = null;
        AudioDevice calleeDevice = null;
        int recordingLength = recording != null ? recording.length : 0;
        this.logger.info("SIP-Processing(A): EventType=[" + Basic.longToFormattedString((long)eventType) + "], Caller=[" + caller + "], Callee=[" + callee + "], Start=[" + start + "], End=[" + end + "], Recording=[" + Basic.longToFormattedString((long)(recordingLength >> 10)) + " KB]");
        try {
            Device[] deviceList;
            for (Device device : deviceList = this.deviceLifeCycleInformationImpl.getDeviceList()) {
                if (!(device instanceof AudioDevice)) continue;
                AudioDevice audioDevice = (AudioDevice)device;
                if (audioDevice.getSIPAddress().equals(caller)) {
                    callerDevice = audioDevice;
                }
                if (!audioDevice.getSIPAddress().equals(callee)) continue;
                calleeDevice = audioDevice;
            }
        }
        catch (Throwable ex) {
            this.logger.error("Error finding audio devices [" + ex.getMessage() + "]");
            return -21600;
        }
        if (callerDevice == null && calleeDevice == null) {
            this.logger.warn("No matching audio devices for recording of Caller=[" + caller + "]");
            return -21600;
        }
        boolean isAlarmRecording = callerDevice != null;
        this.logger.info("EventType=[" + Basic.longToFormattedString((long)eventType) + "], Caller=[" + caller + "], Callee=[" + callee + "], AlarmRecording=[" + isAlarmRecording + "]");
        if (callerDevice != null) {
            this.logger.info("Delegating audio event to " + callerDevice + " ...");
            errorCode = callerDevice.processEvent(isAlarmRecording, eventType, caller, callee, start, end, recording);
            if (errorCode != 0) {
                this.logger.error("Problems delegating audio event to " + callerDevice);
                return errorCode;
            }
        }
        if (calleeDevice != null) {
            this.logger.info("Delegating audio event to " + calleeDevice + " ...");
            errorCode = calleeDevice.processEvent(isAlarmRecording, eventType, caller, callee, start, end, recording);
            if (errorCode != 0) {
                this.logger.error("Problems delegating audio event to " + calleeDevice + " :-(");
                return errorCode;
            }
        }
        return 0;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.tsMilliStartup;
    }

    public FirmwareManager getFirmwareManager() {
        return this.firmwareManager;
    }

    public FileSystemWatcherServer getFileSystemWatcherServer() {
        return this.fileSystemWatcherServer;
    }

    public DatabaseProxy[] createDatabaseProxies(DatabaseProxyListener listener) {
        DatabaseProxy[] databaseProxies = new DatabaseProxy[2];
        try {
            databaseProxies[0] = this.createMainDatabaseProxy(listener);
        }
        catch (ConfigurationException | SeeTecException | JDOMException exception) {
            this.logger.warn("Could not create mds proxy: ", exception);
        }
        try {
            databaseProxies[1] = this.createAdditionalDatabaseProxy(listener);
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not create failover mds proxy: ", (Throwable)exception);
        }
        return databaseProxies;
    }

    public DatabaseProxy createDatabaseProxy(DatabaseProxyListener listener, int proxyIndex) throws ConfigurationException, SeeTecException, JDOMException {
        return proxyIndex == 0 ? this.createMainDatabaseProxy(listener) : this.createAdditionalDatabaseProxy(listener);
    }

    private DatabaseProxy createMainDatabaseProxy(DatabaseProxyListener listener) throws SeeTecException, ConfigurationException, JDOMException {
        return this.createDatabaseProxy(listener, this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice());
    }

    private DatabaseProxy createAdditionalDatabaseProxy(DatabaseProxyListener listener) throws SeeTecException {
        DatabaseProxy databaseProxy = null;
        long failoverMdbID = this.getFailoverMdbID();
        if (failoverMdbID >= 0L) {
            long id = failoverMdbID + 1L;
            databaseProxy = this.createDatabaseProxy(listener, id);
        }
        return databaseProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseProxy createDatabaseProxy(DatabaseProxyListener listener, long mdsId) throws SeeTecException {
        MDSProxy databaseProxy;
        int errorCode;
        if (this.isShutdown()) {
            throw new RuntimeException("Cannot create [MDSProxy] because of shutdown :-(");
        }
        Location locationMdb = this.readCachedEntityLocation(mdsId);
        if (locationMdb == null) {
            try {
                locationMdb = this.getEntMgrProxy().locateEntityByID(Long.valueOf(mdsId), TimeUnit.SECONDS.toMillis(20L));
            }
            catch (SeeTecException exception) {
                if (mdsId == this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()) {
                    this.multimediaDatabaseLifeCycle.checkMdsFailoverState();
                }
                throw exception;
            }
            if (this.entityLocations != null) {
                Map<Long, TimeLocation> exception = this.entityLocations;
                synchronized (exception) {
                    TimeLocation timeLocation = new TimeLocation(System.currentTimeMillis(), locationMdb);
                    this.entityLocations.put(mdsId, timeLocation);
                }
            }
        }
        Long entityId = locationMdb.getID();
        Long entityType = locationMdb.getType();
        String entityHost = locationMdb.getHost();
        Integer entityPort = locationMdb.getPort();
        if (entityId != mdsId) {
            if (this.entityLocations != null) {
                this.entityLocations.remove(mdsId);
            }
            if (mdsId == this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()) {
                this.multimediaDatabaseLifeCycle.checkMdsFailoverState();
            }
            throw new RuntimeException("Requested MDS [" + mdsId + "] doesn't match with response [" + Basic.longToFormattedString((Long)entityId) + "]/[" + Basic.longToFormattedString((Long)entityType) + "]");
        }
        if (entityType != 204L) {
            if (this.entityLocations != null) {
                this.entityLocations.remove(mdsId);
            }
            if (mdsId == this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()) {
                this.multimediaDatabaseLifeCycle.checkMdsFailoverState();
            }
            throw new RuntimeException("Requested MDS [" + mdsId + "] has wrong type [" + entityType + "]");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("MDS [" + entityId + "]/[" + Basic.longToFormattedString((Long)entityType) + "] localized at [" + entityHost + ":" + entityPort + "]");
        }
        if ((errorCode = ((DatabaseProxy)(databaseProxy = new MDSProxy())).init(listener, entityHost, entityPort, entityId)) != 0) {
            databaseProxy.shutdown();
            databaseProxy = null;
            if (mdsId == this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()) {
                this.multimediaDatabaseLifeCycle.checkMdsFailoverState();
                throw new RuntimeException("Creating [MDSProxy] at [" + entityHost + "]/[" + entityPort + "] failed with error [" + errorCode + "]");
            }
            throw new SeeTecException(-21040, "Creating [MDSProxy for failover ] at [" + entityHost + "]/[" + entityPort + "] failed with error [" + errorCode + "]");
        }
        if (mdsId == this.multimediaDatabaseLifeCycle.getMultimediaDatabaseDevice()) {
            this.multimediaDatabaseLifeCycle.setNextDefaultMultimediaDatabaseCheck(-1L);
        }
        return databaseProxy;
    }

    public long getFailoverMdbID() {
        try {
            long failoverMdsId = -1L;
            FailoverConfiguration failoverConfiguration = new FailoverConfiguration(this.getConfigurationProvider().getDMConfigurationFromDatabase());
            long failoverDmId = failoverConfiguration.getFailoverMdbWriterId();
            if (!failoverConfiguration.isFailoverConfigured()) {
                return failoverDmId;
            }
            ArrayList<Long> types = new ArrayList<Long>();
            types.add(105L);
            types.add(104L);
            Tree tree = this.getEntMgrProxy().getEntitiesAsTree(Long.valueOf(failoverDmId), types, Boolean.valueOf(false), Integer.valueOf(TreeTypes.LOGICALTREE.getType()), 30000L);
            for (TreeNode treeNode : tree.getRoot().getChildren()) {
                Entity child = (Entity)treeNode.getData();
                if (child.getEntityType() != 104L) continue;
                failoverMdsId = child.getEntityID();
                break;
            }
            if (failoverDmId != -1L && failoverDmId != this.getDmCnfMgr().getFailoverMdbID()) {
                this.getDmCnfMgr().setFailoverMdbID(failoverDmId);
                int errorCode = this.getDmCnfMgr().writeCnfFile();
                if (errorCode != 0) {
                    this.logger.error("Writing configuration file failed with error [" + errorCode + "]");
                }
            }
            return failoverMdsId;
        }
        catch (Throwable ex) {
            this.logger.warn("There is no failover MDB, or failover MDB could not be found [" + ex.getMessage() + "]", ex);
            return -1L;
        }
    }

    public int registerNetworkClientProxy(NetworkClientProxy networkClientProxy) {
        return this.networkClientHandler.registerNetworkClientProxy(networkClientProxy);
    }

    public ContentTransportQueue determineClientRecipient(long targetClientID, long targetSessionID) {
        return this.networkClientHandler.determineClientRecipient(targetClientID, targetSessionID);
    }

    public void delegateTriggerAction(Long serviceId, Long actionId, Long alarmScriptId, Long alarmInstanceID, Long alarmDuration, byte[] genericData, long ptzPriority, long ptzTimeout) {
        try {
            ActionHandlerIntf localActionHandler = this.actionHandler.get(serviceId);
            if (localActionHandler == null) {
                this.logger.warn("Cannot trigger action on service [" + serviceId + "], because it isn't registered!");
            } else {
                long startExecTriggerAction = System.nanoTime();
                localActionHandler.triggerAction(actionId, alarmScriptId, alarmInstanceID, alarmDuration, genericData, ptzPriority, ptzTimeout);
                this.logger.info(String.format("TriggerAction execution done in [%s ms] on [%s] / [%s]", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startExecTriggerAction), localActionHandler.getClass().getSimpleName(), localActionHandler));
            }
        }
        catch (ClassCastException ex) {
            this.logger.warn(this.actionHandler.get(serviceId) + " doesn't implement the [ActionHandlerIntf] [" + ex.getMessage() + "]");
        }
        catch (Throwable ex) {
            this.logger.warn(ex.getMessage(), ex);
        }
    }

    public void storeRTSPInformation(String key, String information) {
        if (key != null && information != null) {
            this.rtspInformation.put(key, information);
        } else {
            this.logger.warn("Storing RTSP information not possible. At least one value is null.");
        }
    }

    public String readRTSPInformation(String key) {
        this.logger.info("Reading RTSP information for key [" + key + "] ...");
        String value = this.rtspInformation.get(key);
        if (value != null) {
            this.logger.info("... delivering value [" + value + "]");
        } else {
            String fallbackKey = key.substring(0, key.indexOf(58) + 1) + "-1";
            value = this.rtspInformation.get(fallbackKey);
            this.logger.info("Reading RTSP information for key [" + fallbackKey + "] ...");
            if (value != null) {
                this.logger.info("... no value available :-(");
                this.logger.info(this.rtspInformation);
            }
        }
        return value;
    }

    public int removeRTSPInformation(String key) {
        if (key != null) {
            this.logger.info("Removing RTSP information for key [" + key + "] ...");
            this.rtspInformation.remove(key);
        } else {
            this.logger.warn("Key to remove was null.");
        }
        return 0;
    }

    public final int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn("Client refused request. Core is already shutting down");
            return -21017;
        }
        DMSRPCHandler dmSRPCHandler = new DMSRPCHandler();
        try {
            int errorCode = dmSRPCHandler.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing [CMSRPCHandler] failed with error [" + errorCode + "]");
                errorCode = dmSRPCHandler.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down [CMSRPCHandler] failed with error [" + errorCode + "]");
                }
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            dmSRPCHandler.shutdown();
            throw new RuntimeException("Creating " + (Object)((Object)dmSRPCHandler) + " failed because of [" + ex + "]");
        }
    }

    public int handleNonSRPCRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() != 0 && networkDispatcherHeader.getProtocol() != 1 && networkDispatcherHeader.getProtocol() != 2) {
            this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported");
            try {
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn("Exception while closing socket: " + ex.getMessage());
            }
            return -21005;
        }
        this.logger.info("Handling " + socket + " / " + networkDispatcherHeader);
        return 0;
    }

    public String toString() {
        return "[de.seetec.v5.re.cm.Core, " + super.toString() + "]";
    }

    public final EdgeStorageHandler getEdgeStorageHandler() {
        return this.edgeStorageHandler;
    }

    public SQLDatabaseHandler getSqlDatabaseHandler() {
        return this.sqlDatabaseHandler;
    }

    public final NetworkClientHandler getNetworkClientHandler() {
        return this.networkClientHandler;
    }

    protected int determineNumberOfActiveClientThreads(Thread[] threads) {
        String SEARCHSTRING = "Thread[[VideoSrvCRH@";
        int clientConnections = 0;
        if (threads != null) {
            for (Thread thread : threads) {
                if (!thread.toString().startsWith("Thread[[VideoSrvCRH@")) continue;
                ++clientConnections;
            }
        }
        return clientConnections;
    }

    private void setFlag(OnvifStatus newStatus) throws InterruptedException, SeeTecException {
        if (!this.onvifDeviceLock.tryLock(30L, TimeUnit.SECONDS)) {
            throw new SeeTecException(-20000, "Lock for getting ticket timed out.");
        }
        try {
            this.firstOnvifDeviceStarting = newStatus;
        }
        finally {
            this.onvifDeviceLock.unlock();
        }
    }

    private void notificationSettingsChanged() {
        this.mdbStatisticsDaemon.notificationSettingsChanged();
    }

    private int registerCoreToEntityManager() {
        EntMgrProxy entMgrProxy = null;
        try {
            int errorCode;
            entMgrProxy = this.getEntMgrProxy();
            if (entMgrProxy == null) {
                this.logger.error("No [EntMgr] avalable for " + (Object)((Object)this));
                return -21607;
            }
            if (this.getDmCnfMgr().getEntityID() < 0L) {
                this.logger.info("Creating new ID for this DeviceManager");
                this.getDmCnfMgr().setEntityID(this.getCnfTicket());
                this.getDmCnfMgr().writeCnfFile();
                errorCode = this.getDmCnfMgr().writeCnfFile();
                if (errorCode != 0) {
                    this.logger.error("Writing configuration file failed with error [" + errorCode + "] :-(");
                    return errorCode;
                }
            }
            super.registerToSRPCDispatcher((SRPCDispatcherListener)this, Long.valueOf(this.getDmCnfMgr().getEntityID()));
            try {
                Entity dmEntity = this.getEntMgrProxy().getEntityByID(Long.valueOf(this.getDmCnfMgr().getEntityID()), Boolean.TRUE, 60000L);
                this.coreEntityStored = true;
                if (this.managerLoggingOfCameraUsage != null && dmEntity != null) {
                    this.managerLoggingOfCameraUsage.updateConfiguration(dmEntity.getConfiguration());
                }
            }
            catch (SeeTecException srpcex) {
                if (srpcex.getErrorCode() == -20110) {
                    this.coreEntityStored = false;
                }
                this.logger.error("Lookup for this failed with error [" + srpcex.getErrorCode() + "]", (Throwable)srpcex);
                return srpcex.getErrorCode();
            }
            if (!this.coreEntityStored) {
                Long entityID = this.getDmCnfMgr().getEntityID();
                String entityName = "DeviceManager";
                Long entityType = 105L;
                Long mid = 108L;
                Boolean active = Boolean.TRUE;
                long timeout = 30000L;
                byte[] dummyCnf = "<CameraManagement xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r</CameraManagement>".getBytes();
                errorCode = entMgrProxy.setEntity(entityID, entityName + "_" + Basic.getLocalHostName(), entityType, mid, active, dummyCnf, null, null, null, Long.valueOf(108L), Long.valueOf(-1L), this.getCayugaToken(), timeout);
                if (errorCode != 0) {
                    this.logger.error("Setting this RE as new Entity failed with error [" + errorCode + "]");
                    return errorCode;
                }
                errorCode = entMgrProxy.setEntity(Long.valueOf(this.getCnfTicket()), "Video Backup", Long.valueOf(9992L), Long.valueOf(13001L), active, dummyCnf, null, null, null, entityID, Long.valueOf(-1L), this.getCayugaToken(), timeout);
                if (errorCode != 0) {
                    this.logger.error("Setting manual action export as new Entity failed with error [" + errorCode + "]");
                    return errorCode;
                }
                this.logger.debug("Entity of " + (Object)((Object)this) + " with [" + "DeviceManager" + "]/[" + Basic.longToFormattedString((Long)entityID) + "]/[" + Basic.longToFormattedString((Long)entityType) + "] was written to " + entMgrProxy);
            }
            if ((errorCode = this.registerEntity(this.getDmCnfMgr().getEntityID(), 105L)) != 0) {
                if (errorCode == LicenseErrors.ERR_LICENSE_EXCEED_TOO_MANY_REMOTE_CONNECTIONS.getErrorCode()) {
                    this.logger.error("Problems with the license: Too much remote servers are connected!");
                    this.logger.error("Recovery not possible, so shutting down the instance!");
                } else {
                    this.logger.error("Registering instance to [EntityManager] failed with error [" + errorCode + "] :-(");
                    if (errorCode == -20921) {
                        this.logger.info(Basic.generateIndentedMultiLineLog((String)"License trial period exceed."));
                    }
                }
                return errorCode;
            }
            try {
                this.clearEntityStatus(this.getDmCnfMgr().getEntityID());
                this.setEntityStatus(this.getDmCnfMgr().getEntityID(), errorCode);
            }
            catch (Throwable ex) {
                this.logger.warn(ex.getMessage(), ex);
            }
            this.lifeCycleEventEngine.sendStartupEvent(true);
            return 0;
        }
        catch (Throwable ex) {
            if (entMgrProxy != null) {
                entMgrProxy.shutdown();
            }
            this.logger.error("Initializing of [EntMgrProxy] failed [" + ex.getMessage() + "]", ex);
            return -21622;
        }
    }

    public int stopAllDevices() {
        this.logger.info("Stop all devices...");
        try {
            for (Long value : this.deviceLifeCycleInformationImpl.getDevicesInLifeCycle()) {
                this.stopDevice(value);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Could not execute stopAllDevices() or stop all devices", throwable);
            return -21600;
        }
        this.logger.info("All devices stopped successfully!");
        return 0;
    }

    private int stopDevice(Device device) {
        this.logger.info("Stopping device " + device);
        this.deviceLifeCycleInformationImpl.setStopInitializingDevice(device.getDeviceID());
        int errorCode = device.shutdown();
        if (errorCode != 0) {
            this.logger.warn("Shutting down device [" + device + "] failed with error [" + errorCode + "]");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location readCachedEntityLocation(Long entityId) {
        if (this.entityLocations != null) {
            Map<Long, TimeLocation> map = this.entityLocations;
            synchronized (map) {
                TimeLocation timeLocation = this.entityLocations.get(entityId);
                if (timeLocation != null) {
                    return timeLocation.getLocation();
                }
            }
        }
        return null;
    }

    public DeviceLifeCycleInformation getDeviceLifeCycleInformation() {
        return this.deviceLifeCycleInformationImpl;
    }

    public MultimediaDatabaseLifeCycle getMultimediaDatabaseLifeCycle() {
        return this.multimediaDatabaseLifeCycle;
    }
}

