/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.Date;
import java.util.List;

public class RspReadFrame {
    Integer resultCode = null;
    Long firstTimestamp = null;
    Long lastTimestamp = null;
    ContentFrame contentFrame = null;

    protected RspReadFrame(Integer resultCode, Long firstTimestamp, Long lastTimestamp, ContentFrame contentFrame) {
        this.resultCode = resultCode;
        this.firstTimestamp = firstTimestamp;
        this.lastTimestamp = lastTimestamp;
        this.contentFrame = contentFrame;
    }

    protected static RspReadFrame parseGObject(GObject goResponse) {
        Long firstTimestamp = null;
        Long lastTimestamp = null;
        ContentFrame contentFrame = null;
        List lParameter = goResponse.getChildren();
        Integer resultCode = ((GObject)lParameter.get(0)).getAsInt();
        if (lParameter.size() > 1) {
            firstTimestamp = ((GObject)lParameter.get(1)).getAsLong();
        }
        if (lParameter.size() > 2) {
            lastTimestamp = ((GObject)lParameter.get(2)).getAsLong();
        }
        if (lParameter.size() > 3) {
            List lContentFrame = ((GObject)lParameter.get(3)).getChildren();
            Integer mediatype = ((GObject)lContentFrame.get(0)).getAsInt();
            Integer attributes = ((GObject)lContentFrame.get(1)).getAsInt();
            Long startTimestamp = ((GObject)lContentFrame.get(2)).getAsLong();
            Long endTimestamp = ((GObject)lContentFrame.get(3)).getAsLong();
            byte[] data = ((GObject)lContentFrame.get(4)).getAsArrayOfByte();
            contentFrame = new ContentFrame(mediatype, attributes, startTimestamp, endTimestamp, data);
        }
        return new RspReadFrame(resultCode, firstTimestamp, lastTimestamp, contentFrame);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.resultCode);
        if (this.getFirstTimestamp() != null) {
            goResponse.addChild(this.getFirstTimestamp());
            goResponse.addChild(this.getLastTimestamp());
            if (this.contentFrame != null) {
                GObject goContentFrame = GObject.createList();
                goContentFrame.addChild(Integer.valueOf(this.contentFrame.getMediatype()));
                goContentFrame.addChild(Integer.valueOf(this.contentFrame.getAttributes()));
                goContentFrame.addChild(Long.valueOf(this.contentFrame.getStartTimestamp()));
                goContentFrame.addChild(Long.valueOf(this.contentFrame.getEndTimestamp()));
                goContentFrame.addChild(this.contentFrame.getData());
                goResponse.addChild(goContentFrame);
            }
        }
        return goResponse;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public Long getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public Long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public ContentFrame getContentFrame() {
        return this.contentFrame;
    }

    public String toString() {
        if (this.firstTimestamp != null && this.lastTimestamp != null) {
            return "[, ResultCode=[" + this.resultCode + "], FirstTimestamp=[" + new Date(this.firstTimestamp) + "], LastTimestamp=[" + new Date(this.lastTimestamp) + "], " + this.contentFrame + "]";
        }
        return "[, ResultCode=[" + this.resultCode + "]]";
    }
}

