/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.AudioConfiguration;
import de.seetec.v5.re.shared.CameraOrientation;
import de.seetec.v5.re.shared.CnfVideoSourceCropping;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.SynchronizationTime;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.re.shared.VideoStreamingAction;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.Day;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class VideoSourceParameter {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.VideoSourceParameter";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Entity entity = null;
    private String videoProfileName = null;
    private String videoModus = null;
    private Document xmlCnf = null;
    private ConfigurationElement cnfRoot = null;
    private AudioConfiguration audioConfiguration = null;
    private int temporaryAlarmFramerate = -1;
    private boolean basicProfile = false;
    private ConfigurationElement cnfVideoProfile = null;
    private List<ConfigurationElement> classifications = null;
    private ConfigurationElement cnfIsStandardProfile = null;
    private ConfigurationElement cnfAudioEnabled = null;
    private ConfigurationElement cnfFetchPermanently = null;
    private ConfigurationElement cnfTransmission = null;
    private int deviceRtspPort = -1;

    public int init(Entity entity, String videoProfileName, String videoModus, AudioConfiguration audioConfiguration) {
        this.entity = entity;
        if (this.entity == null) {
            return -21001;
        }
        if (videoProfileName == null && videoModus == null || videoProfileName != null && videoModus != null) {
            return -21001;
        }
        if (videoProfileName != null) {
            this.videoProfileName = videoProfileName.trim();
            this.basicProfile = false;
        } else {
            this.videoModus = videoModus.trim();
            this.basicProfile = true;
        }
        this.audioConfiguration = audioConfiguration;
        try {
            this.xmlCnf = new SAXBuilder().build((InputStream)new ByteArrayInputStream(this.entity.getConfiguration()));
            this.cnfRoot = new ConfigurationElement(this.xmlCnf.getRootElement());
        }
        catch (Exception ex) {
            this.logger.error("Parsing configuration failed :-(", (Throwable)ex);
            return -21002;
        }
        try {
            if (this.basicProfile) {
                this.cnfVideoProfile = this.getRoot().getChild(this.videoModus + "Recording");
                this.classifications = this.getRoot().getChildren("BaseProfileClassifications", "int");
                this.cnfAudioEnabled = this.getRoot().getChild("BaseProfileAudioEnabled");
                this.cnfFetchPermanently = this.getRoot().getChild("BaseProfileFetchPermanently");
                this.cnfTransmission = this.getRoot().getChild("BaseProfileTransmission");
                this.cnfIsStandardProfile = this.getRoot().getChild("BaseProfileIsStandardProfile");
            } else {
                List<ConfigurationElement> videoProfiles = this.getRoot().getChildren("VideoProfiles", "VideoProfile");
                if (videoProfiles != null) {
                    for (int i = 0; i < videoProfiles.size(); ++i) {
                        ConfigurationElement localCnfVideoProfile = videoProfiles.get(i);
                        if (!this.videoProfileName.equalsIgnoreCase(localCnfVideoProfile.getChild("Name").getAsString().trim())) continue;
                        this.cnfVideoProfile = localCnfVideoProfile;
                        break;
                    }
                }
                if (videoProfiles == null || this.cnfVideoProfile == null) {
                    throw new ConfigurationException("Invalid configuration for " + this);
                }
                this.classifications = this.cnfVideoProfile.getChildren("Classifications", "int");
                this.cnfAudioEnabled = this.cnfVideoProfile.getChild("AudioEnabled");
                this.cnfFetchPermanently = this.cnfVideoProfile.getChild("FetchPermanently");
                this.cnfTransmission = this.cnfVideoProfile.getChild("Transmission");
                this.cnfIsStandardProfile = this.cnfVideoProfile.getChild("IsStandardProfile");
            }
        }
        catch (Exception ex) {
            this.logger.error("Parsing configuration failed.", (Throwable)ex);
            return -21002;
        }
        return 0;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getVideoModus() {
        return this.videoModus;
    }

    public AudioConfiguration getAudioConfiguration() {
        return this.audioConfiguration;
    }

    public String getVideoProfileName() {
        return this.videoProfileName;
    }

    private ConfigurationElement getRoot() {
        return this.cnfRoot;
    }

    public int getServerEntryNo() throws ConfigurationException {
        ConfigurationElement cnfServerEntryNo = this.getRoot().getChild("ServerEntryNr");
        int serverEntryNo = cnfServerEntryNo.getAsInt4();
        if (serverEntryNo < 1) {
            throw new ConfigurationException("Parameter [ServerEntryNr]=[" + serverEntryNo + "] invalid :-(");
        }
        return serverEntryNo;
    }

    public int getPtzAddress() throws ConfigurationException {
        return this.getRoot().getChild("VideoSourceID").getAsInt4();
    }

    public long getExportTimeRangeID() throws ConfigurationException {
        ConfigurationElement cnfExportTimeRangeID = this.getRoot().getChild("ExportTimeRangeID");
        if (cnfExportTimeRangeID != null) {
            return cnfExportTimeRangeID.getAsInt8();
        }
        return -1L;
    }

    public long getPreconditionID() throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild("StandardRecording");
        ConfigurationElement cnfPreconditionID = cnfRecording.getChild("PreconditionIDs");
        if (cnfPreconditionID != null) {
            return cnfPreconditionID.getAsInt8();
        }
        return -1L;
    }

    public long getPreAlarmTime() throws ConfigurationException {
        long recordOnMotionPreAlarm = -1L;
        long alarmRecordingPreAlarm = -1L;
        long maxTime = 3600000L;
        try {
            if (this.isRecordOnMotion()) {
                recordOnMotionPreAlarm = this.getRecordOnMotionPreAlarm();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ConfigurationElement cnfRecording = this.getRoot().getChild("AlarmRecording");
            ConfigurationElement cnfPreAlarmTime = cnfRecording.getChild("PreAlarmTime");
            if (cnfPreAlarmTime != null) {
                alarmRecordingPreAlarm = cnfPreAlarmTime.getAsInt8();
            }
        }
        catch (Exception e) {
            this.logger.debug("Could not read alarm recording settings.");
        }
        if (recordOnMotionPreAlarm > 0L || alarmRecordingPreAlarm > 0L) {
            long maxPreAlarm = Math.max(recordOnMotionPreAlarm, alarmRecordingPreAlarm);
            return Math.min(maxPreAlarm, maxTime);
        }
        return -1L;
    }

    @Deprecated
    private boolean isRotateImage() throws ConfigurationException {
        return this.getRoot().getChild("RotateImage").getAsBoolean();
    }

    public int getImageRotation() throws ConfigurationException {
        if (this.getRoot().getChild("ImageRotation") != null) {
            int value = this.getRoot().getChild("ImageRotation").getAsInt4();
            if (value >= 0 && value <= 360000) {
                return this.getRoot().getChild("ImageRotation").getAsInt4();
            }
            return 0;
        }
        if (this.isRotateImage()) {
            return 180000;
        }
        return 0;
    }

    public long getExternalPtzId() throws ConfigurationException {
        if (this.getRoot().getChild("ExternalPTZID") != null) {
            return this.getRoot().getChild("ExternalPTZID").getAsInt8();
        }
        return -1L;
    }

    public boolean isEnableVideoloss() throws ConfigurationException {
        if (this.getRoot().getChild("EnableVideoloss") != null) {
            return this.getRoot().getChild("EnableVideoloss").getAsBoolean();
        }
        return true;
    }

    public boolean isEnableTampering() throws ConfigurationException {
        if (this.getRoot().getChild("EnableTampering") != null) {
            return this.getRoot().getChild("EnableTampering").getAsBoolean();
        }
        return true;
    }

    public long getVCamOriginalEntityID() throws ConfigurationException {
        if (this.getRoot().getChild("VCamOriginalEntityID") != null) {
            return this.getRoot().getChild("VCamOriginalEntityID").getAsInt8();
        }
        return -1L;
    }

    public boolean useTitle() throws ConfigurationException {
        return this.getRoot().getChild("UseTitle").getAsBoolean();
    }

    public final String getGenericRTSPUrl() throws ConfigurationException {
        ConfigurationElement genericRTSPUrl = this.getRoot().getChild("GenericRTSPUrl");
        if (genericRTSPUrl != null) {
            return genericRTSPUrl.getAsString();
        }
        return "";
    }

    public final boolean isRecordOnMotion() throws ConfigurationException {
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null) {
            ConfigurationElement recordOnMotionEnabled = recordOnMotionConfigurationElement.getChild("RecordOnMotionEnabled");
            if (recordOnMotionEnabled != null) {
                return recordOnMotionEnabled.getAsBoolean();
            }
        } else {
            recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotion");
            if (recordOnMotionConfigurationElement != null) {
                return recordOnMotionConfigurationElement.getAsBoolean();
            }
        }
        return false;
    }

    public final long getRecordOnMotionPreAlarm() throws ConfigurationException {
        ConfigurationElement recordOnMotionPreAlarm;
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null && (recordOnMotionPreAlarm = recordOnMotionConfigurationElement.getChild("RecordOnMotionPreAlarm")) != null) {
            return recordOnMotionPreAlarm.getAsInt8();
        }
        return -1L;
    }

    public final long getRecordOnMotionPostAlarm() throws ConfigurationException {
        ConfigurationElement recordOnMotionPreAlarm;
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null && (recordOnMotionPreAlarm = recordOnMotionConfigurationElement.getChild("RecordOnMotionPostAlarm")) != null) {
            return recordOnMotionPreAlarm.getAsInt8();
        }
        return 0L;
    }

    public String getTitle() throws ConfigurationException {
        try {
            return this.getRoot().getChild("Titel").getAsString();
        }
        catch (NullPointerException nullPointerException) {
            return this.getRoot().getChild("Title").getAsString();
        }
    }

    public boolean isTimeDateEnabled() throws ConfigurationException {
        return this.getRoot().getChild("TimeDateEnabled").getAsBoolean();
    }

    public long getFramerate() throws ConfigurationException {
        if (this.videoModus != null && this.videoModus.trim().equalsIgnoreCase("alarmrecording") && this.temporaryAlarmFramerate > 0) {
            return this.temporaryAlarmFramerate;
        }
        int framerate = this.cnfVideoProfile.getChild("Framerate").getAsInt4();
        if (framerate < 0) {
            throw new ConfigurationException("Parameter [Framerate]=[" + framerate / 1000 + "." + framerate % 1000 + "] invalid.");
        }
        return framerate;
    }

    public int getQuality() throws ConfigurationException {
        int compression;
        ConfigurationElement cnfQuality = this.cnfVideoProfile.getChild("Quality");
        if (cnfQuality != null) {
            int quality = cnfQuality.getAsInt4();
            if (quality >= 0 && quality <= 100000) {
                return quality;
            }
            throw new ConfigurationException("Parameter [Quality]=[" + quality / 1000 + "." + quality % 1000 + "] invalid");
        }
        ConfigurationElement cnfCompression = this.cnfVideoProfile.getChild("Compression");
        if (cnfCompression != null && (compression = cnfCompression.getAsInt4()) >= 0 && compression <= 100000) {
            return 100000 - compression;
        }
        throw new ConfigurationException("Parameter [Quality]=[null] invalid");
    }

    public int[] getImageSize() throws ConfigurationException {
        ConfigurationElement cnfImageSize = this.cnfVideoProfile.getChild("ImageSize");
        int width = cnfImageSize.getChild("Width").getAsInt4();
        int height = cnfImageSize.getChild("Height").getAsInt4();
        return new int[]{width, height};
    }

    public String getResolution() throws ConfigurationException {
        return this.cnfVideoProfile.getChild("ImageSize").getChild("Resolution").getAsString();
    }

    public String getDisplayResolution() throws ConfigurationException {
        return this.cnfVideoProfile.getChild("ImageSize").getChild("DisplayResolution").getAsString();
    }

    public void setRtspPort(int port) {
        this.deviceRtspPort = port;
    }

    public int getRtspPort() throws ConfigurationException {
        ConfigurationElement cnfStreamingMode = this.basicProfile ? this.getRoot().getChild("BaseProfileRTSPPort") : this.cnfVideoProfile.getChild("RTSPPort");
        if (cnfStreamingMode != null) {
            return cnfStreamingMode.getAsInt4();
        }
        if (this.deviceRtspPort != -1) {
            return this.deviceRtspPort;
        }
        return -1;
    }

    public String getStreamName() throws ConfigurationException {
        ConfigurationElement cnfStreamingMode = this.basicProfile ? this.getRoot().getChild("BaseProfileStreamName") : this.cnfVideoProfile.getChild("StreamName");
        if (cnfStreamingMode != null) {
            return cnfStreamingMode.getAsString();
        }
        return null;
    }

    public String getStreamAlias() throws ConfigurationException {
        ConfigurationElement cnfStreamAlias = this.basicProfile ? this.getRoot().getChild("BaseProfileStreamAlias") : this.cnfVideoProfile.getChild("StreamAlias");
        if (cnfStreamAlias != null) {
            return cnfStreamAlias.getAsString();
        }
        return null;
    }

    public MpegProfile getMpegProfile() throws ConfigurationException {
        ConfigurationElement cnfMpegProfile = this.basicProfile ? this.getRoot().getChild(this.videoModus + "Recording").getChild("MPEGProfile") : this.cnfVideoProfile.getChild("MPEGProfile");
        if (cnfMpegProfile == null) {
            return MpegProfile.DEFAULT;
        }
        return MpegProfile.valueOf(cnfMpegProfile.getAsInt4());
    }

    public int getEncodingInterval() throws ConfigurationException {
        ConfigurationElement cnfEncodingInterval = this.basicProfile ? this.getRoot().getChild(this.videoModus + "Recording").getChild("EncodingInterval") : this.cnfVideoProfile.getChild("EncodingInterval");
        if (cnfEncodingInterval == null) {
            return -1;
        }
        return cnfEncodingInterval.getAsInt4();
    }

    public Codec getMediaCodec() throws ConfigurationException {
        ConfigurationElement cnfStreamingMode = this.basicProfile ? this.getRoot().getChild("MediaCodec") : this.cnfVideoProfile.getChild("MediaCodec");
        if (cnfStreamingMode != null && cnfStreamingMode.getChild("Value") != null) {
            return Codec.valueOf(cnfStreamingMode.getChild("Value").getAsInt4());
        }
        cnfStreamingMode = this.basicProfile ? this.getRoot().getChild("StreamingMode") : this.cnfVideoProfile.getChild("StreamingMode");
        if (cnfStreamingMode == null || cnfStreamingMode.getAsString().equals("")) {
            return Codec.UNKNOWN;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("image/jpeg")) {
            return Codec.MJPEG;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/H.264")) {
            return Codec.H264;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/mxpeg")) {
            return Codec.MXPEG;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/mpeg-4")) {
            return Codec.MPEG4;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/RTSP")) {
            return Codec.RTSP;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("G711")) {
            return Codec.G711U;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("G711A")) {
            return Codec.G711A;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("AAC")) {
            return Codec.AAC;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("PCM")) {
            return Codec.PCM;
        }
        return Codec.UNKNOWN;
    }

    public int getIFrameDistance() throws ConfigurationException {
        ConfigurationElement cnfIFrameDistance = this.cnfVideoProfile.getChild("IFrameDistance");
        if (cnfIFrameDistance == null) {
            throw new ConfigurationException("Configuration parameter [IFrameDistance] not existent :-(");
        }
        return cnfIFrameDistance.getAsInt4();
    }

    public int getBandWidth() throws ConfigurationException {
        ConfigurationElement cnfBandWidth = this.cnfVideoProfile.getChild("BandWidth");
        if (cnfBandWidth == null) {
            throw new ConfigurationException("Configuration parameter [BandWidth] not existent :-(");
        }
        return cnfBandWidth.getAsInt4();
    }

    public int getBandwidthControl() throws ConfigurationException {
        ConfigurationElement cnfBandwidthControl = this.cnfVideoProfile.getChild("BandwidthControl");
        if (cnfBandwidthControl == null) {
            return 1;
        }
        return cnfBandwidthControl.getAsInt4();
    }

    public boolean hasExport(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfExport = cnfRecording.getChild("Export");
        if (cnfExport != null) {
            return cnfExport.getAsBoolean();
        }
        return false;
    }

    public long getMaxRecordingSize(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfMaxRecordingSize = cnfRecording.getChild("MaxRecordingSize");
        if (cnfMaxRecordingSize == null) {
            return 0L;
        }
        long maxRecordingSize = cnfMaxRecordingSize.getAsInt8();
        if (maxRecordingSize < 0L) {
            throw new ConfigurationException("Parameter [MaxRecordingSize]=[" + maxRecordingSize / 1000L + "." + maxRecordingSize % 1000L + "] invalid :-(");
        }
        return maxRecordingSize;
    }

    public long getMaxRecordingTime(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfMaxRecordingTime = cnfRecording.getChild("MaxRecordingTime");
        long maxRecordingTime = cnfMaxRecordingTime.getAsInt8();
        if (maxRecordingTime < 0L) {
            throw new ConfigurationException("Parameter [MaxRecordingTime]=[" + maxRecordingTime / 1000L + "." + maxRecordingTime % 1000L + "] invalid :-(");
        }
        return maxRecordingTime;
    }

    public long getTimeRangeID(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfTimeRangeID = cnfRecording.getChild("TimeRangeID");
        return cnfTimeRangeID.getAsInt8();
    }

    public boolean isRecordingEnabled() throws ConfigurationException {
        return this.isRecordingEnabled("Standard") || this.isRecordingEnabled("Alarm");
    }

    public boolean isRecordingEnabled(String recording) throws ConfigurationException {
        if (this.isArchive()) {
            return false;
        }
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfEnableRecording = cnfRecording.getChild("RecordingEnabled");
        return cnfEnableRecording.getAsBoolean();
    }

    public long getPostEventTime() throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild("AlarmRecording");
        ConfigurationElement cnfPostEventTime = cnfRecording.getChild("PostEventTime");
        if (cnfPostEventTime == null) {
            return 30000L;
        }
        long postEventTime = cnfPostEventTime.getAsInt8();
        if (postEventTime < 0L) {
            throw new ConfigurationException("Parameter [PostEventTime]=[" + postEventTime + " is invalid :-(");
        }
        return postEventTime;
    }

    public List<Long> getInactivityActionParameter() throws ConfigurationException {
        ConfigurationElement cnfInactivityAction = this.getRoot().getChild("InactivityAction");
        if (cnfInactivityAction == null) {
            return new ArrayList<Long>();
        }
        boolean enabled = cnfInactivityAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfInactivityAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfInactivityAction.getChild("ServiceID").getAsInt8();
        long timeout = cnfInactivityAction.getChild("Timeout").getAsInt8();
        if (enabled) {
            ArrayList<Long> inactivityActionParameter = new ArrayList<Long>();
            inactivityActionParameter.add(actionID);
            inactivityActionParameter.add(serviceID);
            inactivityActionParameter.add(timeout);
            return inactivityActionParameter;
        }
        return new ArrayList<Long>();
    }

    public Vector<Long> getNetworkFailureActionParameter() throws ConfigurationException {
        ConfigurationElement cnfNetworkFailureAction = this.getRoot().getChild("NetworkFailureAction");
        if (cnfNetworkFailureAction == null) {
            return new Vector<Long>();
        }
        boolean enabled = cnfNetworkFailureAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfNetworkFailureAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfNetworkFailureAction.getChild("ServiceID").getAsInt8();
        long timeout = cnfNetworkFailureAction.getChild("Timeout").getAsInt8();
        if (enabled) {
            Vector<Long> networkFailureActionParameter = new Vector<Long>();
            networkFailureActionParameter.addElement(actionID);
            networkFailureActionParameter.addElement(serviceID);
            networkFailureActionParameter.addElement(timeout);
            return networkFailureActionParameter;
        }
        return new Vector<Long>();
    }

    public VideoStreamingAction getVideoStreamingStartActionParameter() throws ConfigurationException {
        ConfigurationElement cnfVideoStreamingStartAction = this.getRoot().getChild("VideoStreamingStartAction");
        if (cnfVideoStreamingStartAction == null) {
            return new VideoStreamingAction();
        }
        boolean enabled = cnfVideoStreamingStartAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfVideoStreamingStartAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfVideoStreamingStartAction.getChild("ServiceID").getAsInt8();
        if (enabled) {
            return new VideoStreamingAction(actionID, serviceID);
        }
        return new VideoStreamingAction();
    }

    public VideoStreamingAction getVideoStreamingStopActionParameter() throws ConfigurationException {
        ConfigurationElement cnfVideoStreamingStopAction = this.getRoot().getChild("VideoStreamingStopAction");
        if (cnfVideoStreamingStopAction == null) {
            return new VideoStreamingAction();
        }
        boolean enabled = cnfVideoStreamingStopAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfVideoStreamingStopAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfVideoStreamingStopAction.getChild("ServiceID").getAsInt8();
        return enabled ? new VideoStreamingAction(actionID, serviceID) : new VideoStreamingAction();
    }

    public long getContentID() {
        return this.entity.getEntityID();
    }

    public long getOriginalID() throws ConfigurationException {
        ConfigurationElement cnfArchive = this.getRoot().getChild("Archive");
        if (cnfArchive == null) {
            return this.getContentID();
        }
        ConfigurationElement cnfOriginalID = cnfArchive.getChild("OriginalID");
        if (cnfOriginalID == null) {
            return this.getContentID();
        }
        return cnfOriginalID.getAsInt8();
    }

    public boolean hasVideoGateway() throws ConfigurationException {
        ConfigurationElement cnfVideoGateway = this.getRoot().getChild("Gateway");
        if (cnfVideoGateway == null) {
            return false;
        }
        ConfigurationElement cnfEnabled = cnfVideoGateway.getChild("Enabled");
        if (cnfEnabled == null) {
            return false;
        }
        return cnfEnabled.getAsBoolean();
    }

    public int getVideoGatewayPort() throws ConfigurationException {
        ConfigurationElement cnfVideoGateway = this.getRoot().getChild("Gateway");
        if (cnfVideoGateway == null) {
            return -1;
        }
        ConfigurationElement cnfPort = cnfVideoGateway.getChild("Port");
        if (cnfPort == null) {
            return -1;
        }
        return cnfPort.getAsInt4();
    }

    public boolean isArchive() throws ConfigurationException {
        ConfigurationElement cnfIsArchive;
        ConfigurationElement cnfArchive = this.getRoot().getChild("Archive");
        if (cnfArchive != null && (cnfIsArchive = cnfArchive.getChild("IsArchive")) != null) {
            return cnfIsArchive.getAsBoolean();
        }
        return false;
    }

    public boolean isAudioEnabled() throws ConfigurationException {
        return this.cnfAudioEnabled != null ? this.cnfAudioEnabled.getAsBoolean() : false;
    }

    public boolean isStandardProfile() throws ConfigurationException {
        return this.cnfIsStandardProfile != null ? this.cnfIsStandardProfile.getAsBoolean() : false;
    }

    public Integer[] getClassifications() throws ConfigurationException {
        if (this.classifications == null || this.classifications.size() <= 0) {
            return new Integer[0];
        }
        Integer[] classifications = new Integer[this.classifications.size()];
        for (int i = 0; i < this.classifications.size(); ++i) {
            classifications[i] = this.classifications.get(i).getAsInt4();
        }
        return classifications;
    }

    public boolean isFetchPermanently() throws ConfigurationException {
        return this.cnfFetchPermanently != null ? this.cnfFetchPermanently.getAsBoolean() : false;
    }

    public TransmissionType getTransmissionID() throws ConfigurationException {
        if (this.cnfTransmission != null) {
            return TransmissionType.valueOf(this.cnfTransmission.getChild("ID").getAsInt4());
        }
        return TransmissionType.UNKNOWN;
    }

    public String getTransmissionName() throws ConfigurationException {
        if (this.cnfTransmission != null) {
            return this.cnfTransmission.getChild("Name").getAsString();
        }
        return null;
    }

    public static String[] getAdditionalVideoProfiles(byte[] configuration) throws ConfigurationException {
        try {
            Document xmlCnf = new SAXBuilder().build((InputStream)new ByteArrayInputStream(configuration));
            ConfigurationElement cnfRoot = new ConfigurationElement(xmlCnf.getRootElement());
            if (cnfRoot.getChild("VideoProfiles") == null) {
                return new String[0];
            }
            List<ConfigurationElement> videoProfiles = cnfRoot.getChildren("VideoProfiles", "VideoProfile");
            if (videoProfiles == null) {
                return new String[0];
            }
            String[] videoProfileNames = new String[videoProfiles.size()];
            for (int i = 0; i < videoProfiles.size(); ++i) {
                ConfigurationElement cnfVideoProfile = videoProfiles.get(i);
                videoProfileNames[i] = cnfVideoProfile.getChild("Name").getAsString().trim();
            }
            return videoProfileNames;
        }
        catch (Throwable ex) {
            throw new ConfigurationException("Parsing configuration failed :-(");
        }
    }

    public boolean isAudioOutEnabled() throws ConfigurationException {
        if (this.getRoot().getChild("AudioOutEnabled") != null) {
            return this.getRoot().getChild("AudioOutEnabled").getAsBoolean();
        }
        return false;
    }

    public Codec getAudioCodec() throws ConfigurationException {
        if (this.audioConfiguration == null || this.audioConfiguration.getCodec() == null) {
            throw new ConfigurationException("Audio parameter not valid!");
        }
        return this.audioConfiguration.getCodec();
    }

    public int getAudioDefaultBitrate() throws ConfigurationException {
        if (this.audioConfiguration == null || this.audioConfiguration.getBitrate() < 0) {
            throw new ConfigurationException("Audio parameter not valid!");
        }
        return this.audioConfiguration.getBitrate();
    }

    public CnfVideoSourceCropping getCropping() throws ConfigurationException {
        ConfigurationElement cnfCropping = this.getRoot().getChild("Cropping");
        if (cnfCropping != null) {
            ConfigurationElement cnfEnabled = cnfCropping.getChild("Enabled");
            ConfigurationElement cnfRectangleX = cnfCropping.getChild("CroppingRectangleX");
            ConfigurationElement cnfRectangleY = cnfCropping.getChild("CroppingRectangleY");
            ConfigurationElement cnfRectangleWidth = cnfCropping.getChild("CroppingRectangleWidth");
            ConfigurationElement cnfRectangleHeight = cnfCropping.getChild("CroppingRectangleHeight");
            ConfigurationElement cnfUse4to3 = cnfCropping.getChild("Use4to3");
            ConfigurationElement cnfUser4to3 = cnfCropping.getChild("User4to3");
            ConfigurationElement cnfUse16to9 = cnfCropping.getChild("Use16to9");
            int[] value = new int[]{cnfRectangleX.getAsInt4(), cnfRectangleY.getAsInt4(), cnfRectangleWidth.getAsInt4(), cnfRectangleHeight.getAsInt4()};
            CnfVideoSourceCropping cnfVideoSourceCropping = new CnfVideoSourceCropping(cnfEnabled.getAsBoolean(), value, cnfUser4to3 != null ? cnfUser4to3.getAsBoolean() : cnfUse4to3.getAsBoolean(), cnfUse16to9.getAsBoolean());
            return cnfVideoSourceCropping;
        }
        return new CnfVideoSourceCropping();
    }

    public String[] getDeviceMulticastConfiguration() throws ConfigurationException {
        ConfigurationElement cnfEnabled;
        ConfigurationElement cnfDeviceMulticast = this.basicProfile ? this.getRoot().getChild("DeviceMulticast") : this.cnfVideoProfile.getChild("DeviceMulticast");
        if (cnfDeviceMulticast != null && (cnfEnabled = cnfDeviceMulticast.getChild("Enabled")) != null && cnfEnabled.getAsBoolean()) {
            ConfigurationElement cnfTTL = cnfDeviceMulticast.getChild("TTL");
            String ttl = cnfTTL != null ? cnfTTL.getAsString() : "";
            String[] value = new String[]{cnfDeviceMulticast.getChild("Address").getAsString(), cnfDeviceMulticast.getChild("Port").getAsString(), ttl};
            return value;
        }
        return null;
    }

    public String[] getMulticastConfiguration() throws ConfigurationException {
        ConfigurationElement cnfEnabled;
        ConfigurationElement cnfMulticast = this.basicProfile ? this.getRoot().getChild("Multicast") : this.cnfVideoProfile.getChild("Multicast");
        if (cnfMulticast != null && (cnfEnabled = cnfMulticast.getChild("Enabled")) != null && cnfEnabled.getAsBoolean()) {
            ConfigurationElement cnfTTL = cnfMulticast.getChild("TTL");
            String ttl = cnfTTL != null ? cnfTTL.getAsString() : "";
            String[] value = new String[]{cnfMulticast.getChild("Address").getAsString(), cnfMulticast.getChild("Port").getAsString(), ttl};
            return value;
        }
        return null;
    }

    public CameraOrientation getDewarpingOrientation() throws ConfigurationException {
        ConfigurationElement dewarpingMode;
        ConfigurationElement cnfDewarping = this.getRoot().getChild("Dewarping");
        if (cnfDewarping != null && (dewarpingMode = cnfDewarping.getChild("DewarpingOrientation")) != null) {
            String orientation = dewarpingMode.getAsString();
            if (orientation.toLowerCase().contains("table")) {
                return CameraOrientation.TABLE;
            }
            if (orientation.toLowerCase().contains("wall")) {
                return CameraOrientation.WALL;
            }
            return CameraOrientation.CEILING;
        }
        return CameraOrientation.UNKNOWN;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.shared.VideoSourceParameter@" + Integer.toHexString(this.hashCode());
        String standardProfile = "<undefined>";
        try {
            standardProfile = "" + this.isStandardProfile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.entity + ", VideoProfileName=[" + this.videoProfileName + "] , StandardProfile=[" + standardProfile + "] , BasicProfile=[" + this.basicProfile + "] , VideoModus=[" + this.videoModus + "] ]";
    }

    public final EdgeStorageParameter getEdgeStorageParameter() throws ConfigurationException {
        EdgeStorageParameter edgeStorageParameter = new EdgeStorageParameter();
        ConfigurationElement cnfEdgeStorage = this.getRoot().getChild("EdgeStorage");
        if (cnfEdgeStorage != null) {
            ConfigurationElement cnfEdgeStoragePlaybackSpeed;
            ConfigurationElement cnfEdgeStorageOptionalTimeRange;
            ConfigurationElement cnfEdgeStorageUseOptionalTimeRange;
            ConfigurationElement cnfEdgeStorageActivateTrigger;
            ConfigurationElement cnfEdgeStorageCheckOnDeviceStart;
            List<ConfigurationElement> cnfSyncTimes;
            ConfigurationElement cnfEdgeStorageTrack;
            ConfigurationElement cnfEdgeStorageType;
            ConfigurationElement cnfEdgeStorageEnabled = cnfEdgeStorage.getChild("EdgeStorageEnabled");
            if (cnfEdgeStorageEnabled != null) {
                boolean isEnabled = cnfEdgeStorageEnabled.getAsBoolean();
                edgeStorageParameter.setIsEnabled(isEnabled);
            }
            if ((cnfEdgeStorageType = cnfEdgeStorage.getChild("EdgeStorageType")) != null) {
                EdgeStorageMode edgeStorageMode;
                String mode = cnfEdgeStorageType.getAsString();
                switch (mode.toLowerCase()) {
                    case "syncselectedrange": {
                        edgeStorageMode = EdgeStorageMode.IMPORT;
                        break;
                    }
                    case "fillgaps": {
                        edgeStorageMode = EdgeStorageMode.GAP_FILLING;
                        break;
                    }
                    default: {
                        edgeStorageMode = EdgeStorageMode.DISABLED;
                    }
                }
                edgeStorageParameter.setEdgeStorageMode(edgeStorageMode);
            }
            if ((cnfEdgeStorageTrack = cnfEdgeStorage.getChild("EdgeStorageSyncTrack")) != null) {
                int track = cnfEdgeStorageTrack.getAsInt4();
                edgeStorageParameter.setTrack(track);
            }
            if ((cnfSyncTimes = cnfEdgeStorage.getChildren("SyncTimes", "TourTime")) != null) {
                for (ConfigurationElement cnfSyncTime : cnfSyncTimes) {
                    int timeStamp = cnfSyncTime.getChild("TourDaysAndTime").getChild("Times").getChild("TimeStart").getAsInt4();
                    List<ConfigurationElement> cnfDays = cnfSyncTime.getChildren(new String[]{"TourDaysAndTime", "Days"}, "boolean");
                    for (int i = 0; i < cnfDays.size(); ++i) {
                        if (!cnfDays.get(i).getAsBoolean()) continue;
                        SynchronizationTime syncTime = new SynchronizationTime(Day.valueOf((int)i), timeStamp);
                        if (i == 7) {
                            ArrayList<Long> calendarIds = new ArrayList<Long>();
                            for (ConfigurationElement calendar : cnfSyncTime.getChildren(new String[]{"TourDaysAndTime", "CalendarIds"}, "long")) {
                                calendarIds.add(calendar.getAsInt8());
                            }
                            syncTime.setCalendarIds(calendarIds);
                        }
                        edgeStorageParameter.addSynchronizationTime(syncTime);
                    }
                }
            }
            if ((cnfEdgeStorageCheckOnDeviceStart = cnfEdgeStorage.getChild("EdgeStorageCheckOnDeviceStart")) != null) {
                boolean checkOnDeviceStart = cnfEdgeStorageCheckOnDeviceStart.getAsBoolean();
                edgeStorageParameter.setCheckOnDeviceStart(checkOnDeviceStart);
            }
            if ((cnfEdgeStorageActivateTrigger = cnfEdgeStorage.getChild("EdgeStorageActivateTrigger")) != null) {
                boolean activateTrigger = cnfEdgeStorageActivateTrigger.getAsBoolean();
                edgeStorageParameter.setActivateTrigger(activateTrigger);
            }
            if ((cnfEdgeStorageUseOptionalTimeRange = cnfEdgeStorage.getChild("EdgeStorageUseOptionalTimeRange")) != null) {
                boolean useOptionalTimeRange = cnfEdgeStorageUseOptionalTimeRange.getAsBoolean();
                edgeStorageParameter.setUseOptionalTimeRange(useOptionalTimeRange);
            }
            if ((cnfEdgeStorageOptionalTimeRange = cnfEdgeStorage.getChild("EdgeStorageOptionalTimeRange")) != null) {
                long optionalTimeRange = cnfEdgeStorageOptionalTimeRange.getAsInt8();
                edgeStorageParameter.setOptionalTimeRange(optionalTimeRange);
            }
            if ((cnfEdgeStoragePlaybackSpeed = cnfEdgeStorage.getChild("EdgeStoragePlaybackSpeed")) != null) {
                int playbackSpeed = cnfEdgeStoragePlaybackSpeed.getAsInt4();
                edgeStorageParameter.setPlaybackSpeed(playbackSpeed);
            }
        }
        return edgeStorageParameter;
    }
}

