/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.CoreServiceWrapperWatchdog;
import de.seetec.v5.re.shared.SetStatusAgentListener;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.util.AccumulatingLogger;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetStatusAgent
implements Runnable {
    private final ScheduledExecutorService scheduler;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final Map<Long, Integer> htEntityStatusToSubmit;
    private final CoreServiceWrapperWatchdog watchdog;
    private final SetStatusAgentListener listener;
    private final AccumulatingLogger accumulatingLogger;

    public SetStatusAgent(CoreServiceWrapperWatchdog watchdog, SetStatusAgentListener listener) throws SeeTecException {
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("SetStatusAgent"));
        this.htEntityStatusToSubmit = new ConcurrentHashMap<Long, Integer>();
        this.watchdog = watchdog;
        if (this.watchdog == null) {
            throw new SeeTecException(-20002, "Watchdog null");
        }
        this.listener = listener;
        if (this.listener == null) {
            throw new SeeTecException(-20002, "Listener null");
        }
        this.accumulatingLogger = new AccumulatingLogger(this.logger, 250);
    }

    public void init() {
        this.scheduler.scheduleWithFixedDelay(this, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public void setEntityStatusToSubmit(Long entityID, Integer statusToSet, Integer statusCurrentlySet) throws SeeTecException {
        if (entityID == null) {
            throw new SeeTecException(-20002, "Entity ID null");
        }
        if (statusToSet == null) {
            throw new SeeTecException(-20002, "Status null");
        }
        if (this.htEntityStatusToSubmit.get(entityID) == null && statusCurrentlySet != null && statusCurrentlySet.intValue() == statusToSet.intValue()) {
            return;
        }
        this.logger.info(String.format("Set status %s (Locally stored status: %s) on id %s    : ", statusToSet, statusCurrentlySet, entityID));
        this.htEntityStatusToSubmit.put(entityID, statusToSet);
    }

    @Override
    public void run() {
        Long nextEntity = null;
        Integer nextStatus = null;
        try {
            EntMgrProxy entMgrProxy = this.watchdog.getEntMgrProxy();
            if (entMgrProxy != null) {
                for (Map.Entry<Long, Integer> entry : this.htEntityStatusToSubmit.entrySet()) {
                    nextEntity = entry.getKey();
                    nextStatus = entry.getValue();
                    entMgrProxy.setStatus(nextEntity, nextStatus, TimeUnit.SECONDS.toMillis(30L));
                    this.listener.setStatusSuccessfull(nextEntity, nextStatus);
                    this.htEntityStatusToSubmit.remove(nextEntity);
                }
            } else {
                this.accumulatingLogger.log(Level.ERROR, TimeUnit.MINUTES.toMillis(1L), "No connection to EntMgr available. Changing status of entity failed.");
            }
        }
        catch (SeeTecException ex) {
            if (ex.getErrorCode() == -20110) {
                this.listener.setStatusIdUnknown(nextEntity);
                this.htEntityStatusToSubmit.remove(nextEntity);
            }
            this.logger.error("Cannot set status of entity [" + nextEntity + "] to [" + Basic.longToFormattedString(nextStatus) + "], because of exception [" + ex.getMessage() + "]");
        }
        catch (Throwable ex) {
            if (nextEntity != null && nextStatus != null) {
                this.logger.error("Cannot set status of entity [" + nextEntity + "] to [" + Basic.longToFormattedString(nextStatus) + "], because of exception [" + ex.getMessage() + "]");
            }
            this.logger.error("Cannot set status, because of exception [" + ex.getMessage() + "]");
        }
    }
}

