/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.net.srpc.SRPCHandler;
import de.seetec.v5.shared.net.srpc.general.ReqTriggerAction;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Objects;

public abstract class RESRPCHandler
extends SRPCHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.RESRPCHandler";

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    protected abstract RECore getCore();

    protected final void execGetStatus(SrpcMessage req, RequestHandlerCallback callback) {
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(this.getCore().getRuntimeEnvironmentStatus().getStatus());
        callback.onRequestHandled(req, rsp);
    }

    protected final void execStartDevice(SrpcMessage req, RequestHandlerCallback callback) {
        int errorCode;
        GObject params = req.getPayload();
        long entityID = params.getChildAt(0).getAsLong();
        String entityName = params.getChildAt(1).getAsString();
        long entityType = params.getChildAt(2).getAsLong();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Starting device [" + entityID + "] ...");
        }
        if ((errorCode = this.getCore().startDevice(entityID, entityName, entityType)) != 0) {
            this.logger.warn("Starting device with id [" + entityID + "] failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execStopDevice(SrpcMessage req, RequestHandlerCallback callback) {
        long entityID = req.getPayload().getAsLong();
        this.logger.info("Stopping device [" + entityID + "] ...");
        int errorCode = this.getCore().stopDevice(entityID);
        if (errorCode != 0) {
            this.logger.warn(String.format("Stopping device with id [%,d] failed with error [%s]", entityID, errorCode));
        } else {
            this.logger.info("... stopping device [" + entityID + "] done");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execNotify(SrpcMessage req, RequestHandlerCallback callback) {
        ReqNotify request = (ReqNotify)ReqNotify.parseGObject((GObject)req.getPayload());
        int errorCode = this.getCore().notify(request);
        if (errorCode != 0) {
            this.logger.warn("Notifying failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execTriggerAction(SrpcMessage req, RequestHandlerCallback callback) {
        int errorCode = 0;
        ReqTriggerAction request = ReqTriggerAction.parseGObject((GObject)req.getPayload());
        TriggerActionHandler triggerActionHandler = new TriggerActionHandler();
        try {
            errorCode = triggerActionHandler.init(request);
            if (errorCode != 0) {
                this.logger.warn("Initializing " + triggerActionHandler + " for " + (Object)((Object)this) + " failed with error [" + errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems initializing " + triggerActionHandler + " for " + (Object)((Object)this), ex);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down proxy ...");
        this.shutdown();
    }

    private class TriggerActionHandler
    implements Runnable {
        private static final String CLASS_NAME = "TriggerActionHandler";
        private Thread thread = null;
        private ReqTriggerAction reqTriggerAction = null;

        TriggerActionHandler() {
        }

        public int init(ReqTriggerAction reqTriggerAction) {
            this.reqTriggerAction = reqTriggerAction;
            if (this.reqTriggerAction == null) {
                return -21001;
            }
            if (Thread.activeCount() < 800) {
                this.thread = new Thread((Runnable)this, this.toString());
                this.thread.start();
            } else {
                if (RESRPCHandler.this.logger.isDebugEnabled()) {
                    RESRPCHandler.this.logger.info("Executing " + this + " within CRH thread, because already [" + Basic.longToFormattedString((long)Thread.activeCount()) + "] are active!");
                }
                this.run();
            }
            return 0;
        }

        @Override
        public void run() {
            RESRPCHandler.this.logger.info("Forwarding " + this.reqTriggerAction + " to " + RESRPCHandler.this.getCore() + "...");
            long serviceID = this.reqTriggerAction.getServiceID();
            long actionID = this.reqTriggerAction.getActionID();
            try {
                Entity service = RESRPCHandler.this.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(serviceID), Boolean.valueOf(false), 30000L);
                Entity action = RESRPCHandler.this.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(actionID), Boolean.valueOf(false), 30000L);
                if (!Objects.equals(action.getLogicalParent(), service.getEntityID()) && Objects.equals(action.getLogicalParent(), service.getPhysicalParent())) {
                    serviceID = service.getPhysicalParent();
                }
            }
            catch (Exception e) {
                if (e instanceof SeeTecException) {
                    RESRPCHandler.this.logger.warn("Error when checking for the correct service, let's try to trigger the action with the configuration we have. ErrorCode: " + ((SeeTecException)((Object)e)).getErrorCode(), (Throwable)e);
                }
                RESRPCHandler.this.logger.info("Exception because core is not available. DM is swtiching Core. Functionality not affected");
            }
            RESRPCHandler.this.getCore().delegateTriggerAction(serviceID, actionID, this.reqTriggerAction.getAlarmScriptID(), this.reqTriggerAction.getAlarmInstanceID(), this.reqTriggerAction.getAlarmTimerange(), this.reqTriggerAction.getGenericData(), this.reqTriggerAction.getPTZPriority(), this.reqTriggerAction.getPTZPriorityTimeout());
        }

        public String toString() {
            String sThis = "TriggerActionHandler@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.reqTriggerAction + "]";
        }
    }
}

