/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.jdom.Element;

public class ConfigurationElement
implements SSLConstantsIntf {
    private Element eNode = null;

    private ConfigurationElement() {
    }

    public ConfigurationElement(Element eNode) {
        this.eNode = eNode;
    }

    public String getName() {
        return this.eNode.getName();
    }

    private void detach() {
        this.eNode.detach();
    }

    public String getAsString() {
        return this.eNode.getText().trim();
    }

    public void setAsString(String sValue) {
        this.eNode.setText(sValue.trim());
    }

    public boolean getAsBoolean() throws ConfigurationException {
        if (this.getAsString().toLowerCase().equals("false") || this.getAsString().toLowerCase().equals("true")) {
            return Boolean.parseBoolean(this.getAsString());
        }
        throw new ConfigurationException("[" + this.getAsString() + "] is not a valid boolean value");
    }

    public boolean getAsBooleanSafely() {
        try {
            return this.getAsBoolean();
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    public void setAsBoolean(boolean nValue) {
        this.eNode.setText(Boolean.toString(nValue));
    }

    public int getAsInt4() throws ConfigurationException {
        try {
            return Integer.parseInt(this.getAsString());
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("[" + this.getAsString() + " cannot converted to [int4]");
        }
    }

    public void setAsInt4(int nValue) {
        this.eNode.setText(Integer.toString(nValue));
    }

    public long getAsInt8() throws ConfigurationException {
        try {
            return Long.parseLong(this.getAsString());
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("[" + this.getAsString() + " cannot converted to [int8]");
        }
    }

    public void setAsInt8(long nValue) {
        this.eNode.setText(Long.toString(nValue));
    }

    public double getAsFloat8() throws ConfigurationException {
        try {
            return Double.valueOf(this.getAsString()).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("[" + this.getAsString() + " cannot converted to [float8]");
        }
    }

    public void setAsFloat8(double nValue) {
        this.eNode.setText(Double.toString(nValue));
    }

    public ConfigurationElement createChild(String sName) {
        if (sName == null) {
            return null;
        }
        Element eElement = new Element(sName);
        this.eNode.addContent(eElement);
        return new ConfigurationElement(eElement);
    }

    public boolean removeChild(String sName) {
        ConfigurationElement eChild = this.getChild(sName);
        if (eChild != null) {
            eChild.detach();
            return true;
        }
        return false;
    }

    public ConfigurationElement getChild(String sName) {
        return this.getChild(new String[]{sName});
    }

    public Optional<ConfigurationElement> getChildNullSafe(String name) {
        return Optional.ofNullable(this.getChild(name));
    }

    public ConfigurationElement getChild(String[] path) {
        Element eNextNode = this.eNode;
        for (String path1 : path) {
            Element eChild = null;
            List lChildren = eNextNode.getChildren();
            for (int j = 0; j < lChildren.size() && !(eChild = (Element)lChildren.get(j)).getName().equals(path1); ++j) {
                eChild = null;
            }
            if (eChild == null) {
                return null;
            }
            eNextNode = eChild;
        }
        return new ConfigurationElement(eNextNode);
    }

    public List<ConfigurationElement> getChildren(String sPath, String sName) {
        if (sPath != null) {
            return this.getChildren(new String[]{sPath}, sName);
        }
        return this.getChildren((String[])null, sName);
    }

    public List<ConfigurationElement> getChildren(String[] path, String sName) {
        Element eNextNode = this.eNode;
        if (path != null) {
            for (String path1 : path) {
                Element eChild = null;
                List lChildren = eNextNode.getChildren();
                for (int j = 0; j < lChildren.size() && !(eChild = (Element)lChildren.get(j)).getName().equals(path1); ++j) {
                    eChild = null;
                }
                if (eChild == null) {
                    return null;
                }
                eNextNode = eChild;
            }
        }
        Vector<ConfigurationElement> vChildren = new Vector<ConfigurationElement>();
        List lChildren = eNextNode.getChildren();
        for (int j = 0; j < lChildren.size(); ++j) {
            Element eChild = (Element)lChildren.get(j);
            if (sName != null && !eChild.getName().equals(sName)) continue;
            vChildren.add(new ConfigurationElement(eChild));
        }
        return vChildren;
    }

    public Element getElement() {
        return this.eNode;
    }

    public String getAttributeValue(String sKey) {
        return this.eNode.getAttributeValue(sKey);
    }
}

