/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class RspGetAlarmInstances {
    static final String MethodName = "GetAlarmInstances";
    Integer resultCode = null;
    List<Long[]> alarmInstances = null;

    public RspGetAlarmInstances(Integer resultCode, List<Long[]> alarmInstances) {
        this.resultCode = resultCode;
        this.alarmInstances = alarmInstances != null ? alarmInstances : new LinkedList();
    }

    public static RspGetAlarmInstances parseGObject(GObject goResponse) {
        LinkedList<Long[]> alarmInstances = new LinkedList<Long[]>();
        Integer resultCode = goResponse.getChildAt(0).getAsInt();
        byte[] byteArray = goResponse.getChildAt(1).getAsArrayOfByte();
        int pos = 0;
        long tsAbsolute = Basic.byteArrayToInt8((byte[])byteArray, (int)pos, (int)8);
        pos += 8;
        while (pos < byteArray.length) {
            long instanceID = Basic.byteArrayToInt8((byte[])byteArray, (int)pos, (int)8);
            long alarmStart = tsAbsolute + Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 8), (int)5);
            long alarmEnd = alarmStart + Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 5), (int)4);
            pos += 4;
            alarmInstances.add(new Long[]{instanceID, alarmStart, alarmEnd});
        }
        return new RspGetAlarmInstances(resultCode, alarmInstances);
    }

    public GObject createGObject() throws IOException {
        Long[] alarmInstance;
        int i;
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.resultCode);
        ByteArrayOutputStream result = new ByteArrayOutputStream(this.alarmInstances.size() * 9);
        long tsAbsolute = 0x1000000000000000L;
        for (i = 0; i < this.alarmInstances.size(); ++i) {
            alarmInstance = this.alarmInstances.get(i);
            long alarmStart = alarmInstance[1];
            if (alarmStart >= tsAbsolute) continue;
            tsAbsolute = alarmStart;
        }
        result.write(Basic.int8ToByteArray((long)tsAbsolute, (int)8));
        for (i = 0; i < this.alarmInstances.size(); ++i) {
            alarmInstance = this.alarmInstances.get(i);
            Long alarmInstanceID = alarmInstance[0];
            Long alarmStartRelative = alarmInstance[1] - tsAbsolute;
            Long alarmDuration = alarmInstance[2] - alarmInstance[1];
            result.write(Basic.int8ToByteArray((long)alarmInstanceID, (int)8));
            result.write(Basic.int8ToByteArray((long)alarmStartRelative, (int)5));
            result.write(Basic.int8ToByteArray((long)alarmDuration, (int)4));
        }
        goResponse.addChild(result.toByteArray());
        return goResponse;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public List<Long[]> getAlarmInstances() {
        return this.alarmInstances;
    }

    public String toString() {
        return "[GetAlarmInstances, ResultCode=[" + this.resultCode + "], #AlarmInstances=[" + Basic.longToFormattedString((long)this.alarmInstances.size()) + "]]";
    }
}

