/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.Date;

public class ReqWriteFrame
extends RequestWrapper {
    static final String METHOD_NAME = Methods.MD_REQ_WRITEFRAME.methodName();
    private final Integer mediatype;
    private final Integer attributes;
    private final Long startTimestamp;
    private final Long endTimestamp;
    private final byte[] data;

    public ReqWriteFrame(Integer mediatype, Integer attributes, Long startTimestamp, Long endTimestamp, byte[] data) {
        this.mediatype = mediatype;
        this.attributes = attributes;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.data = data;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        Integer mediatype = goRequest.getChildAt(0).getAsInt();
        Integer attributes = goRequest.getChildAt(1).getAsInt();
        Long startTimestamp = goRequest.getChildAt(2).getAsLong();
        Long endTimestamp = goRequest.getChildAt(3).getAsLong();
        byte[] data = goRequest.getChildAt(4).getAsArrayOfByte();
        return new ReqWriteFrame(mediatype, attributes, startTimestamp, endTimestamp, data);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.mediatype);
        goResponse.addChild(this.attributes);
        goResponse.addChild(this.startTimestamp);
        goResponse.addChild(this.endTimestamp);
        goResponse.addChild(this.data);
        return goResponse;
    }

    public Integer getMediatype() {
        return this.mediatype;
    }

    public Integer getAttributes() {
        return this.attributes;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "[" + METHOD_NAME + ", Mediatype=[" + this.mediatype + "], Attributes=[" + this.attributes + "], STS=[" + new Date(this.startTimestamp) + "], ETS=[" + new Date(this.endTimestamp) + "], DataSize=[" + Basic.longToFormattedString((long)this.data.length) + "]]";
    }
}

