/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class ReqWriteAlarmInstances
extends RequestWrapper {
    static final String MethodName = "WriteAlarmInstances";
    private LinkedList<Long[]> alarmInstances = null;

    public ReqWriteAlarmInstances(LinkedList<Long[]> alarmInstances) {
        this.alarmInstances = alarmInstances;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        LinkedList<Long[]> alarmInstances = new LinkedList<Long[]>();
        byte[] byteArray = goRequest.getChildAt(0).getAsArrayOfByte();
        int pos = 0;
        long tsAbsolute = Basic.byteArrayToInt8((byte[])byteArray, (int)pos, (int)8);
        pos += 8;
        while (pos < byteArray.length) {
            long contentID = Basic.byteArrayToInt8((byte[])byteArray, (int)pos, (int)8);
            long alarmScriptID = Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 8), (int)8);
            long alarmInstanceID = Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 8), (int)8);
            long alarmStart = tsAbsolute + Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 8), (int)5);
            long alarmEnd = alarmStart + Basic.byteArrayToInt8((byte[])byteArray, (int)(pos += 5), (int)4);
            pos += 4;
            alarmInstances.add(new Long[]{contentID, alarmScriptID, alarmInstanceID, alarmStart, alarmEnd});
        }
        return new ReqWriteAlarmInstances(alarmInstances);
    }

    public GObject createGObject() {
        GObject goRequest = GObject.createList();
        long tsAbsolute = 0x1000000000000000L;
        for (int i = 0; i < this.alarmInstances.size(); ++i) {
            Long[] alarmInstance = this.alarmInstances.get(i);
            long alarmStart = alarmInstance[3];
            if (alarmStart >= tsAbsolute) continue;
            tsAbsolute = alarmStart;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.alarmInstances.size() * 40);
            baos.write(Basic.int8ToByteArray((long)tsAbsolute, (int)8));
            for (int i = 0; i < this.alarmInstances.size(); ++i) {
                Long[] alarmInstance = this.alarmInstances.get(i);
                long contentID = alarmInstance[0];
                long alarmScriptID = alarmInstance[1];
                long alarmInstanceID = alarmInstance[2];
                long alarmStartRelative = alarmInstance[3] - tsAbsolute;
                long alarmDuration = alarmInstance[4] - alarmInstance[3];
                baos.write(Basic.int8ToByteArray((long)contentID, (int)8));
                baos.write(Basic.int8ToByteArray((long)alarmScriptID, (int)8));
                baos.write(Basic.int8ToByteArray((long)alarmInstanceID, (int)8));
                baos.write(Basic.int8ToByteArray((long)alarmStartRelative, (int)5));
                baos.write(Basic.int8ToByteArray((long)alarmDuration, (int)4));
            }
            goRequest.addChild(baos.toByteArray());
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
        return goRequest;
    }

    public LinkedList<Long[]> getAlarmInstances() {
        return this.alarmInstances;
    }

    public String toString() {
        return "[WriteAlarmInstances, AlarmInstances.size=[" + (this.alarmInstances != null ? this.alarmInstances.size() : 0) + "]]";
    }
}

