/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.CnfVideoSourceFtpExport;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.EntityCnf;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.StreamOnDemandMode;
import de.seetec.v5.re.shared.TrackParameters;
import de.seetec.v5.re.shared.VideoStreamingAction;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;

public class VideoSourceCnf
extends EntityCnf
implements MDBCnfIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.VideoSourceCnf";
    private int temporaryAlarmFramerate = -1;
    private long preAlarmTime = -1L;

    @Override
    public int init(Entity entity) {
        int errorCode = super.init(entity);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            this.preAlarmTime = this.parseForPreAlarmTime();
        }
        catch (ConfigurationException ce) {
            this.logger.error("Error while parsing configuration for PreAlarmTime " + this);
        }
        return 0;
    }

    public int getServerEntryNo() throws ConfigurationException {
        ConfigurationElement cnfServerEntryNo = this.getRoot().getChild("ServerEntryNr");
        int serverEntryNo = cnfServerEntryNo.getAsInt4();
        if (serverEntryNo < 1) {
            throw new ConfigurationException("Parameter [ServerEntryNr]=[" + serverEntryNo + "] invalid.");
        }
        return serverEntryNo;
    }

    public int getPtzAddress() throws ConfigurationException {
        return this.getRoot().getChild("VideoSourceID").getAsInt4();
    }

    public long getExportTimeRangeID() throws ConfigurationException {
        ConfigurationElement cnfExportTimeRangeID = this.getRoot().getChild("ExportTimeRangeID");
        if (cnfExportTimeRangeID != null) {
            return cnfExportTimeRangeID.getAsInt8();
        }
        return -1L;
    }

    public long getPreconditionID() throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild("StandardRecording");
        ConfigurationElement cnfPreconditionID = cnfRecording.getChild("PreconditionIDs");
        if (cnfPreconditionID != null) {
            return cnfPreconditionID.getAsInt8();
        }
        return -1L;
    }

    public Boolean getIncludePrivacyMasks() throws ConfigurationException {
        ConfigurationElement includePrivacyMasksConfigurationElement = this.getRoot().getChild("IncludePrivacyMasks");
        Boolean includePrivacyMask = null;
        if (includePrivacyMasksConfigurationElement != null) {
            includePrivacyMask = includePrivacyMasksConfigurationElement.getAsBoolean();
        }
        return includePrivacyMask;
    }

    public Document getVideoSourceConfigurationDocument() {
        return (Document)this.xmlCnf.clone();
    }

    private long parseForPreAlarmTime() throws ConfigurationException {
        long recordOnMotionPreAlarm = -1L;
        long alarmRecordingPreAlarm = -1L;
        long maxTime = 3600000L;
        try {
            if (this.isRecordOnMotion()) {
                recordOnMotionPreAlarm = this.getRecordOnMotionPreAlarm();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ConfigurationElement cnfRecording = this.getRoot().getChild("AlarmRecording");
            ConfigurationElement cnfPreAlarmTime = cnfRecording.getChild("PreAlarmTime");
            if (cnfPreAlarmTime != null) {
                alarmRecordingPreAlarm = cnfPreAlarmTime.getAsInt8();
            }
        }
        catch (Exception e) {
            this.logger.debug("Could not read alarm recording settings.");
        }
        if (recordOnMotionPreAlarm > 0L || alarmRecordingPreAlarm > 0L) {
            long maxPreAlarm = Math.max(recordOnMotionPreAlarm, alarmRecordingPreAlarm);
            return Math.min(maxPreAlarm, maxTime);
        }
        return -1L;
    }

    public long getPreAlarmTime() {
        return this.preAlarmTime;
    }

    public long getTimeoutLastFullFrameIsTooOld() throws ConfigurationException {
        ConfigurationElement cnf = this.getRoot().getChild("SystemMessageWhenLastFullFrameIsTooOldTime");
        if (cnf != null) {
            return cnf.getAsInt8();
        }
        return -1L;
    }

    public long getTimeoutLastAlarmFullFrameIsTooOld() throws ConfigurationException {
        ConfigurationElement cnf = this.getRoot().getChild("SystemMessageWhenLastAlarmFullFrameIsTooOldTime");
        if (cnf != null) {
            return cnf.getAsInt8();
        }
        return -1L;
    }

    @Deprecated
    private boolean isRotateImage() throws ConfigurationException {
        return this.getRoot().getChild("RotateImage").getAsBoolean();
    }

    public int getImageRotation() throws ConfigurationException {
        if (this.getRoot().getChild("ImageRotation") != null) {
            int value = this.getRoot().getChild("ImageRotation").getAsInt4();
            if (value >= 0 && value <= 360000) {
                return this.getRoot().getChild("ImageRotation").getAsInt4();
            }
            return 0;
        }
        if (this.isRotateImage()) {
            return 180000;
        }
        return 0;
    }

    public long getExternalPtzId() throws ConfigurationException {
        if (this.getRoot().getChild("ExternalPTZID") != null) {
            return this.getRoot().getChild("ExternalPTZID").getAsInt8();
        }
        return -1L;
    }

    public long getExternalPTZBackReference() throws ConfigurationException {
        if (this.getRoot().getChild("ExternalPTZBackReference") != null) {
            return this.getRoot().getChild("ExternalPTZBackReference").getAsInt8();
        }
        return -1L;
    }

    public boolean canPreset() throws ConfigurationException {
        if (this.getRoot().getChild("Features") != null && this.getRoot().getChild("Features").getChild("CanPreset") != null) {
            return this.getRoot().getChild("Features").getChild("CanPreset").getAsBoolean();
        }
        throw new ConfigurationException("Features and/or CanPreset tag not found.");
    }

    public boolean isEnableVideoloss() throws ConfigurationException {
        if (this.getRoot().getChild("EnableVideoloss") != null) {
            return this.getRoot().getChild("EnableVideoloss").getAsBoolean();
        }
        return true;
    }

    public boolean isEnableTampering() throws ConfigurationException {
        if (this.getRoot().getChild("EnableTampering") != null) {
            return this.getRoot().getChild("EnableTampering").getAsBoolean();
        }
        return true;
    }

    public boolean useTitle() throws ConfigurationException {
        return this.getRoot().getChild("UseTitle").getAsBoolean();
    }

    public final String getGenericRTSPUrl() throws ConfigurationException {
        ConfigurationElement genericRTSPUrl = this.getRoot().getChild("GenericRTSPUrl");
        if (genericRTSPUrl != null) {
            return genericRTSPUrl.getAsString();
        }
        return "";
    }

    public final boolean isRecordOnMotion() throws ConfigurationException {
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null) {
            ConfigurationElement recordOnMotionEnabled = recordOnMotionConfigurationElement.getChild("RecordOnMotionEnabled");
            if (recordOnMotionEnabled != null) {
                return recordOnMotionEnabled.getAsBoolean();
            }
        } else {
            recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotion");
            if (recordOnMotionConfigurationElement != null) {
                return recordOnMotionConfigurationElement.getAsBoolean();
            }
        }
        return false;
    }

    public final long getRecordOnMotionPreAlarm() throws ConfigurationException {
        ConfigurationElement recordOnMotionPreAlarm;
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null && (recordOnMotionPreAlarm = recordOnMotionConfigurationElement.getChild("RecordOnMotionPreAlarm")) != null) {
            return recordOnMotionPreAlarm.getAsInt8();
        }
        return -1L;
    }

    public final long getRecordOnMotionPostAlarm() throws ConfigurationException {
        ConfigurationElement recordOnMotionPreAlarm;
        ConfigurationElement recordOnMotionConfigurationElement = this.getRoot().getChild("RecordOnMotionProperty");
        if (recordOnMotionConfigurationElement != null && (recordOnMotionPreAlarm = recordOnMotionConfigurationElement.getChild("RecordOnMotionPostAlarm")) != null) {
            return recordOnMotionPreAlarm.getAsInt8();
        }
        return 0L;
    }

    public final StreamOnDemandMode getStreamOnDemandMode() throws ConfigurationException {
        if (this.getRoot() == null) {
            return StreamOnDemandMode.UNKNOWN;
        }
        if (this.getRoot().getChild("StreamOnDemandMode") != null) {
            int value = this.getRoot().getChild("StreamOnDemandMode").getAsInt4();
            return StreamOnDemandMode.valueOf(value);
        }
        return StreamOnDemandMode.ALWAYS;
    }

    public String getTitle() throws ConfigurationException {
        try {
            return this.getRoot().getChild("Titel").getAsString();
        }
        catch (NullPointerException nullPointerException) {
            return this.getRoot().getChild("Title").getAsString();
        }
    }

    public boolean isTimeDateEnabled() throws ConfigurationException {
        return this.getRoot().getChild("TimeDateEnabled").getAsBoolean();
    }

    private String getVersion() throws ConfigurationException {
        ConfigurationElement cnfVersion = this.getRoot().getChild("Version");
        if (cnfVersion != null) {
            return cnfVersion.getAsString();
        }
        return "5.0.0";
    }

    public Codec getMediaCodec() throws ConfigurationException {
        ConfigurationElement cnfStreamingMode = this.getRoot().getChild("MediaCodec");
        if (cnfStreamingMode != null && cnfStreamingMode.getChild("Value") != null) {
            return Codec.valueOf(cnfStreamingMode.getChild("Value").getAsInt4());
        }
        cnfStreamingMode = this.getRoot().getChild("StreamingMode");
        if (cnfStreamingMode == null || cnfStreamingMode.getAsString().equals("")) {
            return Codec.UNKNOWN;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("image/jpeg")) {
            return Codec.MJPEG;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/H.264")) {
            return Codec.H264;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/mxpeg")) {
            return Codec.MXPEG;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/mpeg-4")) {
            return Codec.MPEG4;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("video/RTSP")) {
            return Codec.RTSP;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("G711")) {
            return Codec.G711U;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("G711A")) {
            return Codec.G711A;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("AAC")) {
            return Codec.AAC;
        }
        if (cnfStreamingMode.getAsString().equalsIgnoreCase("PCM")) {
            return Codec.PCM;
        }
        return Codec.UNKNOWN;
    }

    @Override
    public void setTemporaryAlarmFramerate(int temporaryAlarmFramerate) {
        this.temporaryAlarmFramerate = temporaryAlarmFramerate;
    }

    @Override
    public int getFramerate(String recording) throws ConfigurationException {
        if (recording.toLowerCase().trim().equals("alarm") && this.temporaryAlarmFramerate > 0) {
            return this.temporaryAlarmFramerate;
        }
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfFramerate = cnfRecording.getChild("Framerate");
        int framerate = cnfFramerate.getAsInt4();
        if (framerate < 0) {
            throw new ConfigurationException("Parameter [Framerate]=[" + framerate / 1000 + "." + framerate % 1000 + "] invalid :-(");
        }
        return framerate;
    }

    public int getQuality(String recording) throws ConfigurationException {
        int nCompression;
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfQuality = cnfRecording.getChild("Quality");
        if (cnfQuality != null) {
            int quality = cnfQuality.getAsInt4();
            if (quality >= 0 && quality <= 100000) {
                return quality;
            }
            throw new ConfigurationException("Parameter [Quality]=[" + quality / 1000 + "." + quality % 1000 + "] invalid");
        }
        ConfigurationElement cnfCompression = cnfRecording.getChild("Compression");
        if (cnfCompression != null && (nCompression = cnfCompression.getAsInt4()) >= 0 && nCompression <= 100000) {
            return 100000 - nCompression;
        }
        throw new ConfigurationException("Parameter [Quality]=[null] invalid");
    }

    public boolean hasExport(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfExport = cnfRecording.getChild("Export");
        if (cnfExport != null) {
            return cnfExport.getAsBoolean();
        }
        return false;
    }

    public long getMaxRecordingSize(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfMaxRecordingSize = cnfRecording.getChild("MaxRecordingSize");
        if (cnfMaxRecordingSize == null) {
            return 0L;
        }
        long maxRecordingSize = cnfMaxRecordingSize.getAsInt8();
        if (maxRecordingSize < 0L) {
            throw new ConfigurationException("Parameter [MaxRecordingSize]=[" + maxRecordingSize / 1000L + "." + maxRecordingSize % 1000L + "] invalid :-(");
        }
        return maxRecordingSize;
    }

    public long getMaxRecordingTime(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfMaxRecordingTime = cnfRecording.getChild("MaxRecordingTime");
        long maxRecordingTime = cnfMaxRecordingTime.getAsInt8();
        if (maxRecordingTime < 0L) {
            throw new ConfigurationException("Parameter [MaxRecordingTime]=[" + maxRecordingTime / 1000L + "." + maxRecordingTime % 1000L + "] invalid :-(");
        }
        return maxRecordingTime;
    }

    public long getTimeRangeID(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfTimeRangeID = cnfRecording.getChild("TimeRangeID");
        return cnfTimeRangeID.getAsInt8();
    }

    @Override
    public boolean isRecordingEnabled() throws ConfigurationException {
        return this.isRecordingEnabled("Standard") || this.isRecordingEnabled("Alarm");
    }

    @Override
    public boolean isRecordingEnabled(String recording) throws ConfigurationException {
        if (this.isArchive()) {
            return false;
        }
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfEnableRecording = cnfRecording.getChild("RecordingEnabled");
        return cnfEnableRecording.getAsBoolean();
    }

    public int[] getImageSize(String recording) throws ConfigurationException {
        ConfigurationElement cnfStandardRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfImageSize = cnfStandardRecording.getChild("ImageSize");
        int width = cnfImageSize.getChild("Width").getAsInt4();
        int height = cnfImageSize.getChild("Height").getAsInt4();
        if (width < -1 || width > 2048000) {
            throw new ConfigurationException("[StandardGrabbing\\ImageSize\\Width]=[" + width / 1000 + "." + width % 1000 + "] invalid :-(");
        }
        if (height < -1 || height > 0x177000) {
            throw new ConfigurationException("[StandardGrabbing\\ImageSize\\Height]=[" + height / 1000 + "." + height % 1000 + "] invalid :-(");
        }
        return new int[]{width, height};
    }

    public String getResolution(String recording) throws ConfigurationException {
        if (this.getRoot().getChild(recording + "Recording").getChild("ImageSize").getChild("DisplayResolution") != null) {
            return this.getRoot().getChild(recording + "Recording").getChild("ImageSize").getChild("DisplayResolution").getAsString();
        }
        this.logger.warn("Ignoring deprecated resolution. Please configure the camera with a newer client!");
        return "";
    }

    public int getIFrameDistance(String recording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(recording + "Recording");
        ConfigurationElement cnfIFrameDistance = cnfRecording.getChild("IFrameDistance");
        if (cnfIFrameDistance == null) {
            throw new ConfigurationException("Configuration parameter [" + recording + "/Recording/IFrameDistance] not existent :-(");
        }
        return cnfIFrameDistance.getAsInt4();
    }

    public int getBandWidth(String sRecording) throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild(sRecording + "Recording");
        ConfigurationElement cnfBandWidth = cnfRecording.getChild("BandWidth");
        if (cnfBandWidth == null) {
            throw new ConfigurationException("Configuration parameter [" + sRecording + "/Recording/BandWidth] not existent :-(");
        }
        return cnfBandWidth.getAsInt4();
    }

    public long getPostEventTime() throws ConfigurationException {
        ConfigurationElement cnfRecording = this.getRoot().getChild("AlarmRecording");
        ConfigurationElement cnfPostEventTime = cnfRecording.getChild("PostEventTime");
        if (cnfPostEventTime == null) {
            return 30000L;
        }
        long postEventTime = cnfPostEventTime.getAsInt8();
        if (postEventTime < 0L) {
            throw new ConfigurationException("Parameter [PostEventTime]=[" + postEventTime + " is invalid :-(");
        }
        return postEventTime;
    }

    public final int getAlarmRecordingStreamIndex() throws ConfigurationException {
        ConfigurationElement recordingConfigurationElement = this.getRoot().getChild("AlarmRecording");
        ConfigurationElement alarmRecordingStreamIndexConfigurationElement = recordingConfigurationElement.getChild("AlarmRecordingStreamIndex");
        if (alarmRecordingStreamIndexConfigurationElement == null) {
            return 0;
        }
        int alarmRecordingStreamIndex = alarmRecordingStreamIndexConfigurationElement.getAsInt4();
        if (alarmRecordingStreamIndex < 0) {
            throw new ConfigurationException("Parameter [AlarmRecording/AlarmRecordingStreamIndex]=[" + alarmRecordingStreamIndex + " is invalid");
        }
        return alarmRecordingStreamIndex;
    }

    public List<TrackParameters> getTrackParameters() throws ConfigurationException {
        ArrayList<TrackParameters> trackParameter = new ArrayList<TrackParameters>();
        TrackParameters alarmTrack = new TrackParameters();
        TrackParameters standardTrack = new TrackParameters();
        String version = this.getVersion();
        if (version.startsWith("5.0")) {
            this.logger.warn("Version of " + this + " is not up to date.");
        }
        alarmTrack.setRecordingEnabled(this.isRecordingEnabled("Alarm"));
        if (version.compareTo("5.1") < 0) {
            alarmTrack.setMaxSize(0L);
            alarmTrack.setMaxTimerange(this.getMaxRecordingTime("Alarm"));
        } else {
            alarmTrack.setMaxSize(this.getMaxRecordingSize("Alarm"));
            alarmTrack.setMaxTimerange(this.getMaxRecordingTime("Alarm"));
        }
        trackParameter.add(alarmTrack);
        standardTrack.setRecordingEnabled(this.isRecordingEnabled("Standard"));
        if (version.compareTo("5.1") < 0) {
            standardTrack.setMaxSize(0L);
            standardTrack.setMaxTimerange(this.getMaxRecordingTime("Standard"));
        } else {
            standardTrack.setMaxSize(this.getMaxRecordingSize("Standard"));
            standardTrack.setMaxTimerange(this.getMaxRecordingTime("Standard"));
        }
        trackParameter.add(standardTrack);
        return trackParameter;
    }

    public List<Long> getInactivityActionParameter() throws ConfigurationException {
        ConfigurationElement cnfInactivityAction = this.getRoot().getChild("InactivityAction");
        if (cnfInactivityAction == null) {
            return new ArrayList<Long>();
        }
        boolean enabled = cnfInactivityAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfInactivityAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfInactivityAction.getChild("ServiceID").getAsInt8();
        long timeout = cnfInactivityAction.getChild("Timeout").getAsInt8();
        if (enabled) {
            ArrayList<Long> inactivityActionParameter = new ArrayList<Long>();
            inactivityActionParameter.add(actionID);
            inactivityActionParameter.add(serviceID);
            inactivityActionParameter.add(timeout);
            return inactivityActionParameter;
        }
        return new ArrayList<Long>();
    }

    public Vector<Long> getNetworkFailureActionParameter() throws ConfigurationException {
        ConfigurationElement cnfNetworkFailureAction = this.getRoot().getChild("NetworkFailureAction");
        if (cnfNetworkFailureAction == null) {
            return new Vector<Long>();
        }
        boolean enabled = cnfNetworkFailureAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfNetworkFailureAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfNetworkFailureAction.getChild("ServiceID").getAsInt8();
        long timeout = cnfNetworkFailureAction.getChild("Timeout").getAsInt8();
        if (enabled) {
            Vector<Long> networkFailureActionParameter = new Vector<Long>();
            networkFailureActionParameter.addElement(actionID);
            networkFailureActionParameter.addElement(serviceID);
            networkFailureActionParameter.addElement(timeout);
            return networkFailureActionParameter;
        }
        return new Vector<Long>();
    }

    public final long getNetworkFailureActionDeadtime() throws ConfigurationException {
        ConfigurationElement cnfNetworkFailureActionDeadtime = this.getRoot().getChild("NetworkFailureActionDeadtime");
        if (cnfNetworkFailureActionDeadtime != null) {
            return cnfNetworkFailureActionDeadtime.getAsInt8();
        }
        throw new ConfigurationException("No NetworkFailureActionDeadtime configured");
    }

    public VideoStreamingAction getVideoStreamingStartActionParameter() throws ConfigurationException {
        ConfigurationElement cnfVideoStreamingStartAction = this.getRoot().getChild("VideoStreamingStartAction");
        if (cnfVideoStreamingStartAction == null) {
            return new VideoStreamingAction();
        }
        boolean enabled = cnfVideoStreamingStartAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfVideoStreamingStartAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfVideoStreamingStartAction.getChild("ServiceID").getAsInt8();
        return enabled ? new VideoStreamingAction(actionID, serviceID) : new VideoStreamingAction();
    }

    public VideoStreamingAction getVideoStreamingStopActionParameter() throws ConfigurationException {
        ConfigurationElement cnfVideoStreamingStopAction = this.getRoot().getChild("VideoStreamingStopAction");
        if (cnfVideoStreamingStopAction == null) {
            return new VideoStreamingAction();
        }
        boolean enabled = cnfVideoStreamingStopAction.getChild("Enabled").getAsBoolean();
        long actionID = cnfVideoStreamingStopAction.getChild("ActionID").getAsInt8();
        long serviceID = cnfVideoStreamingStopAction.getChild("ServiceID").getAsInt8();
        if (enabled) {
            return new VideoStreamingAction(actionID, serviceID);
        }
        return new VideoStreamingAction();
    }

    public long getContentID() {
        return super.getEntity().getEntityID();
    }

    public long getOriginalID() throws ConfigurationException {
        ConfigurationElement cnfArchive = this.getRoot().getChild("Archive");
        if (cnfArchive == null) {
            return this.getContentID();
        }
        ConfigurationElement cnfOriginalID = cnfArchive.getChild("OriginalID");
        if (cnfOriginalID == null) {
            return this.getContentID();
        }
        return cnfOriginalID.getAsInt8();
    }

    public int getDatabasePriority() throws ConfigurationException {
        ConfigurationElement cnfDatabasePriority = this.getRoot().getChild("DatabasePriority");
        if (cnfDatabasePriority == null) {
            return 0;
        }
        return cnfDatabasePriority.getAsInt4();
    }

    public boolean isArchive() throws ConfigurationException {
        ConfigurationElement cnfIsArchive;
        ConfigurationElement cnfArchive = this.getRoot().getChild("Archive");
        if (cnfArchive != null && (cnfIsArchive = cnfArchive.getChild("IsArchive")) != null) {
            return cnfIsArchive.getAsBoolean();
        }
        return false;
    }

    public CnfVideoSourceFtpExport getFtpExport() throws ConfigurationException {
        ConfigurationElement cnfFtpExport = this.getRoot().getChild("FtpExport");
        if (cnfFtpExport != null) {
            ConfigurationElement cnfMaximumDuration = cnfFtpExport.getChild("MaximumDuration");
            CnfVideoSourceFtpExport cnfVideoSourceFtpExport = new CnfVideoSourceFtpExport(cnfMaximumDuration.getAsInt8());
            return cnfVideoSourceFtpExport;
        }
        return new CnfVideoSourceFtpExport();
    }

    public EdgeStorageParameter getEdgeStorageParameter() throws ConfigurationException {
        EdgeStorageParameter edgeStorageParameter = null;
        ConfigurationElement edgeStorage = this.getRoot().getChild("EdgeStorage");
        if (edgeStorage != null) {
            ConfigurationElement edgeStoragePlaybackSpeed;
            ConfigurationElement edgeStorageOptionalTimeRange;
            ConfigurationElement edgeStorageUseOptionalTimeRange;
            ConfigurationElement edgeStorageActivateTrigger;
            ConfigurationElement edgeStorageCheckOnDeviceStart;
            ConfigurationElement edgeStorageSyncTrack;
            ConfigurationElement type;
            edgeStorageParameter = new EdgeStorageParameter();
            ConfigurationElement enabled = edgeStorage.getChild("EdgeStorageEnabled");
            if (enabled != null) {
                edgeStorageParameter.setIsEnabled(enabled.getAsBoolean());
            }
            if ((type = edgeStorage.getChild("EdgeStorageType")) != null) {
                edgeStorageParameter.setEdgeStorageMode(EdgeStorageMode.valueOfMode(type.getElement().getText()));
            }
            if ((edgeStorageSyncTrack = edgeStorage.getChild("EdgeStorageSyncTrack")) != null) {
                edgeStorageParameter.setTrack(edgeStorageSyncTrack.getAsInt4());
            }
            if ((edgeStorageCheckOnDeviceStart = edgeStorage.getChild("EdgeStorageCheckOnDeviceStart")) != null) {
                edgeStorageParameter.setCheckOnDeviceStart(edgeStorageCheckOnDeviceStart.getAsBoolean());
            }
            if ((edgeStorageActivateTrigger = edgeStorage.getChild("EdgeStorageActivateTrigger")) != null) {
                edgeStorageParameter.setActivateTrigger(edgeStorageActivateTrigger.getAsBoolean());
            }
            if ((edgeStorageUseOptionalTimeRange = edgeStorage.getChild("EdgeStorageUseOptionalTimeRange")) != null) {
                edgeStorageParameter.setUseOptionalTimeRange(edgeStorageUseOptionalTimeRange.getAsBoolean());
            }
            if ((edgeStorageOptionalTimeRange = edgeStorage.getChild("EdgeStorageOptionalTimeRange")) != null) {
                edgeStorageParameter.setOptionalTimeRange(edgeStorageOptionalTimeRange.getAsInt8());
            }
            if ((edgeStoragePlaybackSpeed = edgeStorage.getChild("EdgeStoragePlaybackSpeed")) != null) {
                edgeStorageParameter.setPlaybackSpeed(edgeStoragePlaybackSpeed.getAsInt4());
            }
        }
        return edgeStorageParameter;
    }

    @Override
    public String toString() {
        String parameter = "de.seetec.v5.re.shared.VideoSourceCnf@" + Integer.toHexString(this.hashCode());
        return "[" + parameter.substring(parameter.lastIndexOf(46) + 1) + " ," + super.toString() + "]";
    }
}

