/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.ContentFrameTools;
import de.seetec.v5.re.shared.SmoothingBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmoothingBufferImpl
implements SmoothingBuffer {
    private final LinkedList<ContentFrame> elements = new LinkedList();
    private final Logger logger;

    public SmoothingBufferImpl() {
        this((Logger)null);
    }

    public SmoothingBufferImpl(Logger logger) {
        this.logger = logger != null ? logger : LogManager.getLogger(SmoothingBufferImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothingBufferImpl(List<ContentFrame> frames) {
        this();
        if (frames != null) {
            LinkedList<ContentFrame> linkedList = this.elements;
            synchronized (linkedList) {
                this.elements.addAll(frames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContentFrame(ContentFrame frame) {
        if (frame == null) {
            return;
        }
        LinkedList<ContentFrame> linkedList = this.elements;
        synchronized (linkedList) {
            this.elements.addLast(frame);
        }
    }

    @Override
    public List<ContentFrame> getUnsmoothedBuffer() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentFrame> flushBuffer() {
        ArrayList<ContentFrame> returnList = new ArrayList<ContentFrame>();
        LinkedList<ContentFrame> linkedList = this.elements;
        synchronized (linkedList) {
            returnList.addAll(this.elements);
            this.elements.clear();
        }
        return returnList;
    }

    @Override
    public List<ContentFrame> getSmoothAndCollisionPreventedFrames() {
        return this.getSmoothFramesAndRemoveFromBuffer(SmoothingMode.SMOOTHING_AND_TIMESTAMP_COLLISION_PREVENTION);
    }

    @Override
    public List<ContentFrame> getCollisionPreventedFrames() {
        return this.getSmoothFramesAndRemoveFromBuffer(SmoothingMode.TIMESTAMP_COLLISION_PREVENTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ContentFrame> getSmoothFramesAndRemoveFromBuffer(SmoothingMode smoothingMode) {
        ArrayList<ContentFrame> resultList = new ArrayList<ContentFrame>();
        if (smoothingMode == SmoothingMode.SMOOTHING_AND_TIMESTAMP_COLLISION_PREVENTION && !this.containsAtLeast2FullFrames()) {
            return resultList;
        }
        LinkedList<ContentFrame> linkedList = this.elements;
        synchronized (linkedList) {
            double distanceBetweenFrames = this.getFrameDistance();
            ContentFrame firstFullFrame = this.getFirstFullFrame();
            int firstFullFrameIndex = this.elements.indexOf(firstFullFrame);
            ContentFrame lastFullFrame = this.getLastFullFrame();
            int lastFullFrameIndex = this.elements.indexOf(lastFullFrame);
            Iterator iteratorOverElements = this.elements.iterator();
            int totalIndex = 0;
            int pFrameIndex = 1;
            HashMap<Long, ContentFrame> timestampMap = new HashMap<Long, ContentFrame>();
            for (ContentFrame cf : this.elements) {
                if (cf.isVideoFrame() || timestampMap.containsKey(cf.getStartTimestamp())) continue;
                timestampMap.put(cf.getStartTimestamp(), cf);
            }
            while (iteratorOverElements.hasNext()) {
                ContentFrame frame = (ContentFrame)iteratorOverElements.next();
                if (smoothingMode == SmoothingMode.SMOOTHING_AND_TIMESTAMP_COLLISION_PREVENTION) {
                    if (totalIndex > firstFullFrameIndex && totalIndex < lastFullFrameIndex && frame.isVideoFrame()) {
                        long newTimestamp = firstFullFrame.getStartTimestamp() + Math.round(distanceBetweenFrames * (double)pFrameIndex);
                        this.updateTimestamp(frame, newTimestamp, timestampMap);
                        ++pFrameIndex;
                    }
                    if (totalIndex < lastFullFrameIndex) {
                        resultList.add(frame);
                        iteratorOverElements.remove();
                    }
                    ++totalIndex;
                    continue;
                }
                if (frame.isVideoFrame()) {
                    this.updateTimestamp(frame, frame.getStartTimestamp(), timestampMap);
                }
                resultList.add(frame);
                iteratorOverElements.remove();
            }
        }
        return resultList;
    }

    @Override
    public double getFrameDistance() {
        long fullFrameDistance = this.getFullFrameDistance();
        int numberOfVideoFrames = this.getNumberOfVideoFramesWithoutLastFullFrame();
        if (fullFrameDistance == 0L || numberOfVideoFrames == 0) {
            return 0.0;
        }
        double distanceBetweenFrames = (double)fullFrameDistance / (double)numberOfVideoFrames;
        return distanceBetweenFrames;
    }

    @Override
    public long getFullFrameDistance() {
        if (!this.containsAtLeast2FullFrames()) {
            return 0L;
        }
        ContentFrame firstFullFrame = this.getFirstFullFrame();
        ContentFrame lastFullFrame = this.getLastFullFrame();
        if (firstFullFrame == null || lastFullFrame == null) {
            return 0L;
        }
        return lastFullFrame.getStartTimestamp() - firstFullFrame.getStartTimestamp();
    }

    private int getNumberOfVideoFramesWithoutLastFullFrame() {
        int count = 0;
        ContentFrame firstFullFrame = this.getFirstFullFrame();
        ContentFrame lastFullFrame = this.getLastFullFrame();
        if (firstFullFrame != null && lastFullFrame != null) {
            for (ContentFrame frame : this.elements) {
                if (frame.getStartTimestamp() < firstFullFrame.getStartTimestamp() || frame.getStartTimestamp() >= lastFullFrame.getStartTimestamp() || !frame.isVideoFrame()) continue;
                ++count;
            }
        }
        return count;
    }

    private ContentFrame getFirstFullFrame() {
        for (ContentFrame frame : this.elements) {
            if (!frame.isFullVideoFrame()) continue;
            return frame;
        }
        return null;
    }

    private ContentFrame getLastFullFrame() {
        ListIterator<ContentFrame> iteratorOverElements = this.elements.listIterator(this.elements.size());
        while (iteratorOverElements.hasPrevious()) {
            ContentFrame frame = iteratorOverElements.previous();
            if (!frame.isFullVideoFrame()) continue;
            return frame;
        }
        return null;
    }

    private void updateTimestamp(ContentFrame frame, long timestamp, Map<Long, ContentFrame> timestampMap) {
        if (!timestampMap.containsKey(timestamp = this.getNearestTimestampForSmoothing(timestamp, timestampMap))) {
            timestampMap.put(timestamp, frame);
        }
        frame.setStartTimestamp(timestamp);
        frame.setEndTimestamp(timestamp);
    }

    @Override
    public boolean containsAtLeast2FullFrames() {
        return ContentFrameTools.containsAtLeastNumberOfFullFrames(this.elements, 2);
    }

    private long getNearestTimestampForSmoothing(long calculatedTimestamp, Map<Long, ContentFrame> timestampMap) {
        if (timestampMap == null || timestampMap.isEmpty() || !timestampMap.containsKey(calculatedTimestamp)) {
            return calculatedTimestamp;
        }
        for (int tryCount = 1; tryCount < 10; ++tryCount) {
            long testTimestamp = calculatedTimestamp + (long)tryCount;
            if (!timestampMap.containsKey(testTimestamp)) {
                return testTimestamp;
            }
            testTimestamp = calculatedTimestamp - (long)tryCount;
            if (timestampMap.containsKey(testTimestamp)) continue;
            return testTimestamp;
        }
        return calculatedTimestamp;
    }

    private static enum SmoothingMode {
        SMOOTHING_AND_TIMESTAMP_COLLISION_PREVENTION,
        TIMESTAMP_COLLISION_PREVENTION;

    }
}

