/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.WorkCenterCalendar;
import de.seetec.v5.shared.util.WorkCenterCalendarRepository;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReWorkCenterCalendarRepositoryImpl
implements WorkCenterCalendarRepository {
    private final EntMgrProxy proxy;
    private final Map<Long, WorkCenterCalendar> map = new HashMap<Long, WorkCenterCalendar>();

    public ReWorkCenterCalendarRepositoryImpl(EntMgrProxy proxy) throws SeeTecException {
        Entity[] calendars;
        this.proxy = proxy;
        if (this.proxy == null) {
            throw new SeeTecException(-20002, "Parameter null while starting up ReWorkCenterCalendarRepositoryImpl");
        }
        for (Entity calendar : calendars = this.proxy.getEntitiesAsList(Arrays.asList(55L), Boolean.TRUE, TimeUnit.SECONDS.toMillis(30L))) {
            this.storeCalendarEntity(calendar);
        }
    }

    public void store(long id) throws SeeTecException {
        Entity calendar = this.proxy.getEntityByID(Long.valueOf(id), Boolean.TRUE, TimeUnit.SECONDS.toMillis(30L));
        if (calendar.getEntityType() == 55L) {
            this.storeCalendarEntity(calendar);
        }
    }

    public void remove(long id) {
        this.map.remove(id);
    }

    public WorkCenterCalendar get(long id) {
        return this.map.get(id);
    }

    private void storeCalendarEntity(Entity calendar) throws SeeTecException {
        WorkCenterCalendar workCenterCalendar = new WorkCenterCalendar(calendar.getEntityID().longValue());
        workCenterCalendar.init(calendar.getConfiguration());
        this.map.put(calendar.getEntityID(), workCenterCalendar);
    }
}

