/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.CoreServiceWrapper;
import de.seetec.v5.re.shared.DeadlockDetector;
import de.seetec.v5.re.shared.LifeCycleEventEngine;
import de.seetec.v5.re.shared.RECnfMgr;
import de.seetec.v5.re.shared.ReWorkCenterCalendarRepositoryImpl;
import de.seetec.v5.re.shared.RuntimeEnvironmentStatus;
import de.seetec.v5.re.shared.SendEventDaemon;
import de.seetec.v5.re.shared.configuration.ltesupport.LTESupportConfiguration;
import de.seetec.v5.re.shared.token.RETokenRefresher;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.ExportVMMemoryParameters;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.configuration.events.entity.EntityEvent;
import de.seetec.v5.shared.configuration.key.LicenseKey;
import de.seetec.v5.shared.crypto.Crypto;
import de.seetec.v5.shared.interaction.LicenseDataObject;
import de.seetec.v5.shared.logging.WindowsLoggingMgr;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.SRPCDispatcher;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.proxy.ssl.SSLProxy;
import de.seetec.v5.shared.proxy.ssl.SSLProxyImpl;
import de.seetec.v5.shared.token.TokenManager;
import de.seetec.v5.shared.token.TokenManagerImpl;
import de.seetec.v5.shared.token.TokenRefresher;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.tree.TreeNode;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.CpuLoadStats;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.WorkCenterCalendarRepository;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class RECore
extends Basic
implements Runnable,
SRPCDispatcherListener {
    public static final String FileSeparator = System.getProperty("file.separator");
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.RECore";
    private static int threadLimit = 16384;
    private static CpuLoadStats cpuLoadStats = null;
    protected CoreServiceWrapper coreServiceWrapper = null;
    protected LifeCycleEventEngine lifeCycleEventEngine = null;
    protected WindowsLoggingMgr windowsLoggingMgr = null;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private SRPCDispatcher srpcDispatcher = null;
    private RECnfMgr reCnfMgr = null;
    private RuntimeEnvironmentStatus runtimeEnvironmentStatus = new RuntimeEnvironmentStatus();
    private ReWorkCenterCalendarRepositoryImpl workCenterCalendarRepositoryReImpl = null;
    private SendEventDaemon sendEventDaemon = null;
    private String modulNameForLogging = null;
    private LicenseKey licenseKey = null;
    private String extension = "";
    private TokenManager tokenManager = null;
    @Deprecated
    private static final ThreadLocal<DateFormat> UNIFORM_SIMPLE_DATEFORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE, dd MMM yyyy - HH:mm:ss,SSS", Locale.US);
        }
    };

    public int init(RECnfMgr reCnfMgr, String pathKeystore, String modulNameForLogging, byte[] keyFromCore, long entityTpe) {
        String cayugaToken = null;
        ExportVMMemoryParameters.export();
        this.reCnfMgr = reCnfMgr;
        if (this.reCnfMgr == null) {
            return -21001;
        }
        long entMgrId = 2L;
        try {
            if (reCnfMgr.getEntMgrId() != -1L) {
                entMgrId = reCnfMgr.getEntMgrId();
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("EntMgrId not valid or not found?");
        }
        this.processStartupDelay();
        cpuLoadStats = new CpuLoadStats();
        cpuLoadStats.init();
        try {
            int countTries = 0;
            while (!this.isShutdown()) {
                if (++countTries >= 100) {
                    this.logger.error("Cannot create Crypto within [" + countTries + "] tries.");
                    return -21016;
                }
                cayugaToken = this.getTokenAndEncryptionKeyFromCore(pathKeystore, keyFromCore, entMgrId);
                if (cayugaToken == null) {
                    long delaySeconds = Math.round(Math.random() * (double)Math.min(countTries, 300));
                    if (delaySeconds <= 0L) continue;
                    this.logger.info("Waiting [" + delaySeconds + " s] before trying again to create the Crypto instance ...");
                    try {
                        Thread.sleep(delaySeconds * 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        catch (Throwable ex) {
            this.logger.error("Cannot create [Crypto]", ex);
            return -21000;
        }
        this.processExtension(reCnfMgr);
        this.srpcDispatcher = new SRPCDispatcher();
        try {
            this.srpcDispatcher.init(this.getRECnfMgr().getDaemonPort());
        }
        catch (Exception ex) {
            this.logger.error("Creating [SRPCDispatcher] failed", (Throwable)ex);
            return -21011;
        }
        try {
            this.coreServiceWrapper = new CoreServiceWrapper(this.getRECnfMgr(), this);
        }
        catch (Throwable ex) {
            this.logger.error("Cannot create [coreServiceWrapper].", ex);
            return -21000;
        }
        this.tokenManager = new TokenManagerImpl();
        this.tokenManager.init(cayugaToken, (TokenRefresher)new RETokenRefresher(this, pathKeystore, keyFromCore, entMgrId));
        int errorCode = this.initializeLifeCycleEventEngine(reCnfMgr, entityTpe);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            Entity coreProxyEntity = this.getEntMgrProxy().ping(30000L);
            long coreId = coreProxyEntity.getEntityID();
            if (coreId != 2L) {
                if (reCnfMgr.getEntMgrId() != coreId) {
                    reCnfMgr.setEntMgrId(coreId);
                    errorCode = reCnfMgr.writeCnfFile();
                    if (errorCode != 0) {
                        this.logger.error("Writing configuration file failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                }
                this.logger.info("Set CoreServiceMain host and port for " + this);
                Location location = this.getEntMgrProxy().locateEntityByID(Long.valueOf(2L), 30000L);
                if (!reCnfMgr.getCoreServiceMainHost().equalsIgnoreCase(location.getHost()) || reCnfMgr.getCoreServiceMainPort() != location.getPort()) {
                    reCnfMgr.setCoreServiceMainHost(location.getHost());
                    reCnfMgr.setCoreServiceMainPort(location.getPort());
                    errorCode = reCnfMgr.writeCnfFile();
                    if (errorCode != 0) {
                        this.logger.error("Writing configuration file failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                }
            }
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not receive location of CSM or write location to config file. ErrorCode: " + exception.getErrorCode(), (Throwable)exception);
        }
        catch (Throwable throwable) {
            this.logger.warn("Could not receive location of CSM or write location to config file.", throwable);
        }
        long initWindowsLoggingMgrExpire = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
        while (!this.isShutdown()) {
            this.modulNameForLogging = modulNameForLogging;
            errorCode = this.initWindowsLoggingMgr(modulNameForLogging);
            if (errorCode == 0) break;
            if (System.currentTimeMillis() < initWindowsLoggingMgrExpire) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return errorCode;
        }
        long initWorkCenterCalendarExpire = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
        while (!this.isShutdown() && (errorCode = this.initWorkCenterCalendar()) != 0) {
            if (System.currentTimeMillis() < initWorkCenterCalendarExpire) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return errorCode;
        }
        if (System.currentTimeMillis() < 1343197544448L) {
            this.logger.fatal("System time [" + new Date(System.currentTimeMillis()) + "] is before [" + new Date(1343197544448L) + "]. Please use a valid time or time server!");
            return -21003;
        }
        this.sendEventDaemon = new SendEventDaemon();
        errorCode = this.sendEventDaemon.init(this);
        if (errorCode != 0) {
            this.logger.error("Creating [SendEventDaemon] failed with error [" + errorCode + "]");
            return errorCode;
        }
        return 0;
    }

    private void processExtension(RECnfMgr reCnfMgr1) {
        try {
            if (!reCnfMgr1.getExtension().isEmpty()) {
                this.logger.info("Extension specified in conf file: " + reCnfMgr1.getExtension());
                this.extension = reCnfMgr1.getExtension();
            } else {
                this.logger.info("No extension specified in conf file.");
            }
        }
        catch (Exception e) {
            this.logger.warn("Problem [" + e.getMessage() + "] reading RE core extension tag");
        }
    }

    private void processStartupDelay() {
        try {
            long startupDelay = this.getRECnfMgr().getStartupDelay();
            if (startupDelay > 0L) {
                this.logger.info("Delay the startup for [" + Basic.longToFormattedString((long)startupDelay) + " ms] ...");
                try {
                    Thread.sleep(startupDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (ConfigurationException cex) {
            this.logger.warn((Object)cex, (Throwable)cex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int initializeLifeCycleEventEngine(RECnfMgr reConfigurationManager, long entityTpe) {
        int errorCode = 0;
        long retryUntil = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
        this.lifeCycleEventEngine = new LifeCycleEventEngine();
        try {
            while (!this.isShutdown()) {
                if (System.currentTimeMillis() >= retryUntil) return errorCode;
                if (this.coreServiceWrapper.getEntMgrProxy() != null && this.coreServiceWrapper.getEntMgrProxy().isReady()) {
                    Entity entity = this.coreServiceWrapper.getEntityByID(4L);
                    if (entity != null) {
                        errorCode = this.lifeCycleEventEngine.init(this, entity.getConfiguration(), reConfigurationManager.getEntityID(), entityTpe);
                        if (errorCode == 0) return errorCode;
                        this.logger.error("Unable to initialize event engine. [" + errorCode + "]");
                        return errorCode;
                    }
                    this.logger.warn("Unable to request event entity.");
                    errorCode = -21011;
                } else {
                    this.logger.warn("Unable to initialize event engine. [Core service not reachable]");
                    errorCode = -21011;
                }
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
                catch (InterruptedException ex) {
                    this.logger.info("Thread sleep interrupted. [" + ex.getMessage() + "]");
                }
            }
            return errorCode;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Unable to initialize event engine. [" + errorCode + "]");
            return -20000;
        }
    }

    public String getTokenAndEncryptionKeyFromCore(String pathKeystore, byte[] keyFromCore, long entMgrId) throws ConfigurationException {
        Crypto crypto = new Crypto((SSLProxy)new SSLProxyImpl());
        int errorCode = crypto.init(pathKeystore, this.getRECnfMgr().getEntMgrHost(), this.getRECnfMgr().getEntMgrPort(), this.reCnfMgr.getCoreServiceMainHost(), this.reCnfMgr.getCoreServiceMainPort(), entMgrId, keyFromCore);
        if (errorCode == 0) {
            return crypto.getCayugaToken();
        }
        crypto.shutdown();
        this.logger.warn("Creating [Crypto] failed with error [" + errorCode + "]");
        return null;
    }

    protected final int initWindowsLoggingMgr(String modulNameForLogging) {
        try {
            this.windowsLoggingMgr = new WindowsLoggingMgr();
            this.windowsLoggingMgr.init(modulNameForLogging, this.coreServiceWrapper.getEntityByID(4L).getConfiguration());
        }
        catch (Throwable ex) {
            this.logger.error("Creating [WindowsLoggingMgr] failed with exception", ex);
            return -21000;
        }
        return 0;
    }

    protected final int initWorkCenterCalendar() {
        try {
            this.workCenterCalendarRepositoryReImpl = new ReWorkCenterCalendarRepositoryImpl(this.coreServiceWrapper.getEntMgrProxy());
        }
        catch (Throwable ex) {
            this.logger.error("Creating [WorkCenterCalendar] failed with exception", ex);
            return -21000;
        }
        return 0;
    }

    public abstract boolean isShutdown();

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.srpcDispatcher != null) {
            int errorCode = this.srpcDispatcher.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + this.srpcDispatcher + " failed with error [" + errorCode + "]");
            }
            this.srpcDispatcher = null;
        }
        if (this.windowsLoggingMgr != null) {
            this.windowsLoggingMgr.shutdown();
            this.windowsLoggingMgr = null;
        }
        if (this.sendEventDaemon != null) {
            this.sendEventDaemon.shutdown();
            this.sendEventDaemon = null;
        }
        if (this.coreServiceWrapper != null) {
            this.coreServiceWrapper.shutdown();
            this.coreServiceWrapper = null;
        }
        if (cpuLoadStats != null) {
            cpuLoadStats.shutdown();
        }
        return 0;
    }

    public RECnfMgr getRECnfMgr() {
        return this.reCnfMgr;
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() == 0) {
            return this.handleRequest(socket);
        }
        return this.handleNonSRPCRequest(socket, networkDispatcherHeader);
    }

    public abstract int handleNonSRPCRequest(Socket var1, NetworkDispatcherHeader var2);

    public abstract int handleRequest(Socket var1);

    public String getCayugaToken() {
        return this.tokenManager.getToken();
    }

    public abstract int startDevice(long var1, String var3, long var4);

    public abstract int stopDevice(long var1);

    public abstract int notify(ReqNotify var1);

    protected int notify(Long eventType, Long sourceID, byte[] additionalData) {
        this.coreServiceWrapper.notify(eventType, sourceID, additionalData);
        if (eventType != null) {
            if (eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType() || eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_DELETED.getType()) {
                try {
                    EntityEvent entityEvent = (EntityEvent)Basic.unmarshalXML(EntityEvent.class, (Object)("<root>" + new String(additionalData).trim() + "</root>"));
                    long entityType = entityEvent.getEntityType();
                    if (entityType == 206L || entityType == 201L || entityType == 105L) {
                        this.ensureConnectToCorrectCore();
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("Trouble evaluating right position of " + this + " after Entity changes/deleted event. Maybe the entity itself was deleted.");
                    this.logger.warn((Object)exception, (Throwable)exception);
                }
                if (sourceID == 4L) {
                    if (this.windowsLoggingMgr != null) {
                        try {
                            this.windowsLoggingMgr.init(this.modulNameForLogging, this.coreServiceWrapper.getEntityByID(4L).getConfiguration());
                        }
                        catch (SeeTecException seeTecException) {
                            this.logger.debug("Error while updating WindowsLoggingMgr. Error: " + seeTecException.getErrorCode());
                        }
                    }
                    if (this.lifeCycleEventEngine != null) {
                        this.lifeCycleEventEngine.update(this.coreServiceWrapper.getEntityByID(4L).getConfiguration());
                    }
                }
            } else if (eventType.longValue() == EventType.ENT_EVENTTYPE_LICENCE_CHANGE_SUCCESSFUL.getType()) {
                try {
                    this.getLicenseKey(true, TimeUnit.SECONDS.toMillis(30L));
                }
                catch (Exception exception) {
                    this.logger.error("Problems while updating license", (Throwable)exception);
                }
            } else if (eventType.longValue() == EventType.ENT_EVENTTYPE_CORE_STARTED.getType()) {
                try {
                    this.logger.info("Core started Event: " + sourceID);
                    if (sourceID.longValue() == this.getRECnfMgr().getEntMgrId()) {
                        this.getEntMgrProxy().shutdown();
                    } else {
                        this.logger.info("Check correct Core of this RE...");
                        int errorCode = this.ensureConnectToCorrectCore();
                        if (errorCode != 0) {
                            this.logger.warn("Something works not correct on ensuring right tree position of core. ErrorCode: " + errorCode);
                        }
                    }
                }
                catch (Throwable exception) {
                    this.logger.warn((Object)exception, exception);
                }
            }
            this.notifyWorkCenterCalendar(eventType, sourceID, additionalData);
        }
        return 0;
    }

    private void notifyWorkCenterCalendar(Long eventType, Long sourceID, byte[] additionalData) {
        if (eventType != null) {
            if (eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType() || eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_SET.getType()) {
                try {
                    EntityEvent entityEvent = (EntityEvent)Basic.unmarshalXML(EntityEvent.class, (Object)("<root>" + new String(additionalData).trim() + "</root>"));
                    if (entityEvent.getEntityType() == 55L) {
                        this.workCenterCalendarRepositoryReImpl.store(sourceID);
                    }
                }
                catch (Exception seeTecException) {
                    this.logger.error("Problems while updating calendar: " + sourceID, (Throwable)seeTecException);
                }
            } else if (eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_DELETED.getType()) {
                this.workCenterCalendarRepositoryReImpl.remove(sourceID);
            }
        }
    }

    public final Entity getEntityByID(Long entityID) {
        return this.coreServiceWrapper.getEntityByID(entityID);
    }

    public final LicenseKey getLicenseKey(boolean force, long timeout) throws SeeTecException, SAXException, JAXBException, UnsupportedEncodingException {
        if (this.licenseKey == null || force) {
            LicenseDataObject license = this.getEntMgrProxy().getLicense(timeout);
            String licenseAsString = new String((byte[])license.getValue(), "UTF-8");
            this.licenseKey = (LicenseKey)Basic.unmarshalXML(LicenseKey.class, (Object)licenseAsString, (boolean)false);
        }
        return this.licenseKey;
    }

    public EntMgrProxy getEntMgrProxy() {
        return this.coreServiceWrapper.getEntMgrProxy();
    }

    protected int subscribeForEvents() {
        block5: {
            EntMgrProxy entMgrProxy = null;
            try {
                int errorCode;
                entMgrProxy = this.getEntMgrProxy();
                long entityID = this.getRECnfMgr().getEntityID();
                ArrayList<Long> eventTypes = new ArrayList<Long>();
                eventTypes.add(EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType());
                eventTypes.add(EventType.ENT_EVENTTYPE_ENTITY_DELETED.getType());
                eventTypes.add(EventType.ENT_EVENTTYPE_STATUS_CHANGED.getType());
                eventTypes.add(EventType.ENT_EVENTTYPE_DEFINITIONS_CHANGED.getType());
                eventTypes.add(EventType.ENT_EVENTTYPE_CORE_STARTED.getType());
                eventTypes.add(EventType.GENERAL_EVENTTYPE_OPC_FROM.getType());
                eventTypes.add(EventType.ENT_EVENTTYPE_LICENCE_CHANGE_SUCCESSFUL.getType());
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("==================================");
                    this.logger.info("Subscribing " + this + " for changed entities:");
                    this.logger.info("   EntityID   =[" + entityID + "]");
                    this.logger.info("   EventTypes =[" + eventTypes + "]");
                    this.logger.info("==================================");
                }
                ArrayList<Long> branchIds = new ArrayList<Long>();
                branchIds.add(this.getBranch(this.getEntityByID(entityID)).getEntityID());
                if (!branchIds.contains(TreeTypes.LOGICALTREE.getRoot())) {
                    branchIds.add(TreeTypes.LOGICALTREE.getRoot());
                }
                if ((errorCode = entMgrProxy.subscribe(Long.valueOf(entityID), eventTypes, branchIds, 20000L)) != 0) {
                    this.logger.warn("Subscribing of " + this + " to " + entMgrProxy + " failed with error [" + errorCode + "]");
                }
            }
            catch (Exception ex) {
                this.logger.warn("Subscribe for events failed because of [" + ex.getMessage() + "]");
                if (entMgrProxy == null) break block5;
                entMgrProxy.shutdown();
            }
        }
        return 0;
    }

    public void sendLoggingEvent(EventType eventType, long sourceID, int error, String subject, String body, Level level) {
        try {
            if (this.windowsLoggingMgr != null) {
                this.windowsLoggingMgr.sendLog(error, sourceID, eventType.getType(), level, body);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Error while writing windows system log. errorCode: " + t.getMessage());
        }
        try {
            this.coreServiceWrapper.sendLoggingEvent(eventType, sourceID, error, subject, body);
        }
        catch (Exception ex) {
            this.logger.warn("Error while sending logging event because of [" + ex.getMessage() + "]");
        }
    }

    public void sendLoggingEvent(EventType eventType, long sourceID, int error, String subject, String body) {
        this.sendLoggingEvent(eventType, sourceID, error, subject, body, Level.ERROR);
    }

    public int sendErrorEvent(EventType eventType, long sourceID) {
        return this.coreServiceWrapper.sendErrorEvent(eventType, sourceID);
    }

    public int sendApplicationEvent(long sourceID) {
        return this.coreServiceWrapper.sendApplicationEvent(sourceID);
    }

    public int sendApplicationEvent(long sourceID, byte[] genericData) {
        return this.coreServiceWrapper.sendApplicationEvent(sourceID, genericData);
    }

    public int sendEvent(EventType eventType, long sourceID, long causeID, byte[] data) {
        return this.coreServiceWrapper.sendEvent(eventType, sourceID, causeID, data);
    }

    public long getCnfTicket() {
        return this.coreServiceWrapper.getCnfTicket();
    }

    public long getTicket() {
        return this.coreServiceWrapper.getTicket();
    }

    public SendEventDaemon getSendEventDaemon() {
        return this.sendEventDaemon;
    }

    protected int registerEntity(Long entityID, Long entityType, String tcpHost, Integer tcpPort, Long sessionID) {
        try {
            this.getEntMgrProxy().registerEntity(entityID, entityType, tcpHost, tcpPort, sessionID, TimeUnit.SECONDS.toMillis(30L));
            return 0;
        }
        catch (SeeTecException stex) {
            return stex.getErrorCode();
        }
    }

    public int deregisterEntity(Long entityID) {
        try {
            this.getEntMgrProxy().deregisterEntity(entityID, TimeUnit.SECONDS.toMillis(30L));
            return 0;
        }
        catch (SeeTecException stex) {
            return stex.getErrorCode();
        }
    }

    public void registerToSRPCDispatcher(SRPCDispatcherListener listener, Long entityID) {
        this.srpcDispatcher.registerListener(listener, entityID);
    }

    public SRPCDispatcherListener deregisterFromSRPCDispatcher(Long entityID) throws Exception {
        return this.srpcDispatcher.deregisterListener(entityID);
    }

    public Integer getEntityStatus(Long entityID) {
        return this.coreServiceWrapper.getEntityStatus(entityID);
    }

    public int setEntityStatus(Long entityID, Integer status) {
        return this.coreServiceWrapper.setEntityStatus(entityID, status);
    }

    public void clearEntityStatus(Long entityID) {
        if (this.coreServiceWrapper == null) {
            return;
        }
        this.coreServiceWrapper.clearEntityStatus(entityID);
    }

    public static String getReadableRate(long data, long timerange) {
        String result = "0.0";
        if (timerange > 0L) {
            long n = data * 10000L / timerange;
            result = n < 100L ? Basic.longToFormattedString((long)(n / 10L)) + "," + n % 10L : Basic.longToFormattedString((long)(n / 10L));
        }
        return result;
    }

    public static int getThreadLimit() {
        return threadLimit;
    }

    public abstract void delegateTriggerAction(Long var1, Long var2, Long var3, Long var4, Long var5, byte[] var6, long var7, long var9);

    public static void ensureFilePath(String entryPath, String subPath) {
        RECore.ensureFilePath(entryPath + FileSeparator + subPath);
    }

    public static void ensureFilePath(String path) {
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.shared.RECore@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.srpcDispatcher + "]";
    }

    public final int ensureConnectToCorrectCore() {
        try {
            ArrayList<Long> types = new ArrayList<Long>();
            types.add(201L);
            types.add(206L);
            types.add(105L);
            types.add(104L);
            types.add(115L);
            EntMgrProxy entMgrProxy = this.getEntMgrProxy();
            if (entMgrProxy == null) {
                return -20062;
            }
            Tree tree = this.getEntMgrProxy().getEntitiesAsTree(Long.valueOf(0L), types, Boolean.valueOf(false), Integer.valueOf(TreeTypes.LOGICALTREE.getType()), 30000L);
            LinkedList<TreeNode<Entity>> path = this.findLocation((TreeNode<Entity>)tree.getRoot());
            long coreId = this.findCorrectCoreId(path, this.getRECnfMgr().getEntityID());
            this.checkCorrectCoreId(coreId);
            return 0;
        }
        catch (Throwable throwable) {
            this.logger.warn("Trouble evaluating correct position of this RE: " + throwable.getMessage());
            return -20062;
        }
    }

    private void findLocationRecursively(TreeNode<Entity> node, LinkedList<TreeNode<Entity>> path) throws ConfigurationException {
        List rootChildren = node.getChildren();
        for (TreeNode treeNode : rootChildren) {
            Entity entity = (Entity)treeNode.getData();
            if (entity.getEntityID().longValue() == this.getRECnfMgr().getEntityID()) {
                path.add((TreeNode<Entity>)treeNode);
                return;
            }
            if (treeNode.getChildrenSize() <= 0) continue;
            path.add((TreeNode<Entity>)treeNode);
            int originalPathSize = path.size();
            this.findLocationRecursively((TreeNode<Entity>)treeNode, path);
            if (originalPathSize != path.size()) continue;
            path.removeLast();
        }
    }

    protected LinkedList<TreeNode<Entity>> findLocation(TreeNode<Entity> node) throws ConfigurationException {
        LinkedList<TreeNode<Entity>> path = new LinkedList<TreeNode<Entity>>();
        this.findLocationRecursively(node, path);
        if (path.isEmpty()) {
            throw new NoSuchElementException("Entity with Id " + this.getRECnfMgr().getEntityID() + " not found in logical tree.");
        }
        path.add(0, node);
        return path;
    }

    private int connectToCoreAndSave(long coreId) {
        try {
            int errorCode;
            Location location = this.getEntMgrProxy().locateEntityByID(Long.valueOf(coreId), 30000L);
            this.getRECnfMgr().setEntMgrHost(location.getHost());
            this.getRECnfMgr().setEntMgrPort(location.getPort());
            this.getRECnfMgr().setEntMgrId(coreId);
            if (coreId == 2L) {
                if (!this.getRECnfMgr().getCoreServiceMainHost().equalsIgnoreCase("-1") || this.getRECnfMgr().getCoreServiceMainPort() != -1) {
                    this.getRECnfMgr().setCoreServiceMainHost("-1");
                    this.getRECnfMgr().setCoreServiceMainPort(-1);
                }
            } else {
                Location mainLocation = this.getEntMgrProxy().locateEntityByID(Long.valueOf(2L), 30000L);
                this.getRECnfMgr().setCoreServiceMainHost(mainLocation.getHost());
                this.getRECnfMgr().setCoreServiceMainPort(mainLocation.getPort());
            }
            if ((errorCode = this.getRECnfMgr().writeCnfFile()) != 0) {
                this.logger.error("Writing configuration file failed with error [" + errorCode + "]");
            }
            try {
                this.logger.info("Connect to right core if not already connected...");
                this.checkCoreConnection(coreId);
            }
            catch (Throwable throwable) {
                this.logger.warn("Could not connect to Core - ID: " + coreId);
                return -20062;
            }
            return errorCode;
        }
        catch (ConfigurationException exception) {
            this.logger.warn("Could not read configuration");
            return -20036;
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not connect to Core (ID:" + coreId + "). ErrorCode: " + exception.getErrorCode());
            return exception.getErrorCode();
        }
    }

    private void checkCoreConnection(long coreId) throws SeeTecException {
        Entity currentCoreEntity = this.getEntMgrProxy().ping(30000L);
        if (currentCoreEntity.getEntityID() != coreId) {
            try {
                Location locationOfNewCore = this.getEntMgrProxy().locateEntityByID(Long.valueOf(coreId), 30000L);
                this.getRECnfMgr().setEntMgrHost(locationOfNewCore.getHost());
                this.getRECnfMgr().setEntMgrPort(locationOfNewCore.getPort());
                int errorCode = this.getRECnfMgr().writeCnfFile();
                if (errorCode != 0) {
                    this.logger.error("Writing configuration file failed with error [" + errorCode + "]");
                }
                this.logger.info("Core in cnf file (" + coreId + ")  is available, but IP was wrong");
                this.getEntMgrProxy().shutdown();
            }
            catch (SeeTecException exception) {
                this.logger.warn("Core in cnf file (" + coreId + ") is not available");
            }
        }
    }

    public WorkCenterCalendarRepository getWorkCenterCalendarRepository() {
        return this.workCenterCalendarRepositoryReImpl;
    }

    public abstract int registerEntity();

    protected static CpuLoadStats getCpuLoadStats() {
        return cpuLoadStats;
    }

    public String getCoreExtension() {
        return this.extension;
    }

    public LTESupportConfiguration getLTESupportConfiguration() {
        return this.getRECnfMgr().getLTEConfiguration();
    }

    public static String getUniformFormattedDateTime(long ms) {
        return UNIFORM_SIMPLE_DATEFORMAT.get().format(new Date(ms));
    }

    protected void createDeadlockDetector() {
        new Thread("DeadlockDetector"){

            @Override
            public void run() {
                RECore.this.logger.info("Checking for deadlocks until shutdown of service. Pay attention to the error log!");
                int maxOutputBeforeBreak = 0x100000;
                int outputDone = 0;
                long cycle = TimeUnit.MINUTES.toNanos(5L);
                long nextCheck = System.nanoTime() + cycle;
                while (!RECore.this.isShutdown()) {
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (nextCheck > System.nanoTime()) continue;
                    String info = DeadlockDetector.getDescriptionOfDeadlockedThreads();
                    if (info.length() > 0) {
                        System.err.println("Found deadlocks on " + new Date());
                        System.err.println(info);
                        if ((outputDone += info.length()) > maxOutputBeforeBreak) {
                            System.err.println("Upper limit for deadlock output reached!");
                            break;
                        }
                    }
                    nextCheck = System.nanoTime() + cycle;
                }
                RECore.this.logger.info("Stopping DeadlockDetector!");
            }
        }.start();
    }

    public TreeNode<Entity> getFirstChildOfType(TreeNode<Entity> node, long entityType) {
        for (TreeNode child : node.getChildren()) {
            if (!((Entity)child.getData()).getEntityType().equals(entityType)) continue;
            return child;
        }
        return null;
    }

    public int checkCorrectCoreId(long coreEntityId) throws SeeTecException, ConfigurationException {
        if (coreEntityId != this.getRECnfMgr().getEntMgrId()) {
            this.logger.info("Connect RE to Core (ID: " + coreEntityId + ")");
            return this.connectToCoreAndSave(coreEntityId);
        }
        this.checkCoreConnection(this.getRECnfMgr().getEntMgrId());
        return 0;
    }

    public long findCorrectCoreId(LinkedList<TreeNode<Entity>> path, long reEntityId) {
        LinkedList<TreeNode<Entity>> pathToBranch = this.removeTrailingNodeUntilBranch(path, reEntityId);
        TreeNode<Entity> cssNode = this.getFirstChildOfType(pathToBranch.getLast(), 206L);
        long coreEntityId = cssNode != null ? ((Entity)cssNode.getData()).getEntityID() : ((cssNode = this.getFirstChildOfType(pathToBranch.getFirst(), 206L)) != null ? ((Entity)cssNode.getData()).getEntityID() : 2L);
        return coreEntityId;
    }

    public LinkedList<TreeNode<Entity>> removeTrailingNodeUntilBranch(LinkedList<TreeNode<Entity>> path, long entityId) {
        LinkedList<TreeNode<Entity>> result = new LinkedList<TreeNode<Entity>>(path);
        while (((Entity)result.getLast().getData()).getEntityType() != 3012L) {
            result.removeLast();
        }
        return result;
    }

    public Entity getBranch(Entity entityToFindBranchFor) throws SeeTecException {
        if (entityToFindBranchFor == null) {
            throw new SeeTecException(-20002, "Parameter for getBranch was null.");
        }
        Entity parent = this.getEntityByID(entityToFindBranchFor.getLogicalParent());
        if (parent == null) {
            throw new SeeTecException(-20110, "Requesting ID '" + entityToFindBranchFor.getLogicalParent() + "' failed.");
        }
        while (parent.getEntityType() != 3012L) {
            if ((parent = this.getEntityByID(parent.getLogicalParent())) != null) continue;
            throw new SeeTecException(-20110, "Requesting ID '" + entityToFindBranchFor.getLogicalParent() + "' failed.");
        }
        return parent;
    }

    public RuntimeEnvironmentStatus getRuntimeEnvironmentStatus() {
        return this.runtimeEnvironmentStatus;
    }

    protected static enum RegistrationState {
        NOT_REGISTERED,
        REGISTERED,
        RIGHT_TREE_POSITION_ENSURED;

    }
}

