/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentFrame
implements Cloneable {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.ContentFrame";
    private static final int TRANSMISSION_FRAME_HEADER = 1592257585;
    private static final int TRANSMISSION_FRAME_HEADER_LENGTH = 20;
    private static final int PACKED = 1;
    private static final long MAX_TIMERANGE = 600000L;
    private static final byte[] START_SEQUENCE_001 = new byte[]{0, 0, 1};
    private static final byte[] START_SEQUENCE_0001 = new byte[]{0, 0, 0, 1};
    private final Object DataSemaphore = new Object();
    private final Logger logger = LogManager.getLogger(ContentFrame.class);
    public int mediatype = -1;
    public int attributes = 0;
    private long startTimestamp = -1L;
    private long endTimestamp = -1L;
    private byte[] data = null;
    private ByteArrayOutputStream baos = null;

    private ContentFrame(byte[] contentFrameData) {
        ByteBuffer contenFrameBuffer;
        if (contentFrameData != null && contentFrameData.length >= 20) {
            contenFrameBuffer = ByteBuffer.wrap(contentFrameData);
            int readHeader = contenFrameBuffer.getInt();
            if (readHeader != 1592257585) {
                throw new IllegalArgumentException("No valid content frame header found during deserialization.");
            }
        } else {
            throw new IllegalArgumentException("ContentFrameData is uncomplete or null");
        }
        this.startTimestamp = this.endTimestamp = contenFrameBuffer.getLong();
        this.mediatype = contenFrameBuffer.getInt();
        int dataSize = contenFrameBuffer.getInt();
        this.data = new byte[dataSize];
        contenFrameBuffer.get(this.data);
    }

    public ContentFrame(int mediatype, byte[] data) {
        this.mediatype = mediatype;
        this.attributes = 0;
        this.startTimestamp = this.endTimestamp = System.currentTimeMillis();
        this.data = data;
    }

    public ContentFrame(int mediatype, int attributes, long startTimestamp, long endTimestamp, byte[] data) {
        this.mediatype = mediatype;
        this.attributes = attributes;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.data = data;
        if (endTimestamp < startTimestamp) {
            throw new RuntimeException("Cannot create [ContentFrame], because timerange is invalid!");
        }
    }

    public int getMediatype() {
        return this.mediatype;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long ts) {
        this.startTimestamp = ts;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(long ts) {
        this.endTimestamp = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        Object object = this.DataSemaphore;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            return this.baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameSize() {
        Object object = this.DataSemaphore;
        synchronized (object) {
            if (this.data != null) {
                return this.data.length;
            }
            return this.baos.size();
        }
    }

    public int getPayloadSize() {
        int offset = 0;
        if (this.getMediatype() == 0 || this.getMediatype() == 33 || this.getMediatype() == 35) {
            offset = 16;
        }
        int size = 0;
        FramePartIterator framePartIterator = this.getFramePartIterator();
        while (framePartIterator.hasNext()) {
            FramePart next = framePartIterator.next();
            size += (next.getData().length - offset) * 8;
        }
        return size;
    }

    public byte[] createTransmissionFrame() {
        byte[] transmissionFrame;
        byte[] cfData = this.getData();
        byte[] codec = new byte[]{0, 0, 0, cfData.length > 8 ? cfData[8] : (byte)-1};
        if (Codec.valueOf(Basic.byteArrayToInt4((byte[])codec)) == Codec.H264 && !this.isPacked()) {
            try {
                transmissionFrame = this.extendH264Data();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error while converting H264 frame", throwable);
            }
        } else {
            transmissionFrame = new byte[20 + cfData.length];
            this.writeHeader(transmissionFrame, cfData.length);
            System.arraycopy(cfData, 0, transmissionFrame, 20, cfData.length);
        }
        return transmissionFrame;
    }

    private byte[] extendH264Data() throws IOException {
        byte[] cfData = this.getData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(cfData.length + 20);
        byte[] transmissionFrameHeader = new byte[20];
        this.writeHeader(transmissionFrameHeader, 0);
        byteArrayOutputStream.write(transmissionFrameHeader);
        int pointer = 12;
        byteArrayOutputStream.write(cfData, 0, pointer);
        while (pointer < cfData.length - 1) {
            pointer = this.convertH264Data(byteArrayOutputStream, cfData, pointer);
        }
        byte[] transmissionFrame = byteArrayOutputStream.toByteArray();
        Basic.int4ToByteArray((int)(transmissionFrame.length - 20), (byte[])transmissionFrame, (int)16, (int)4);
        return transmissionFrame;
    }

    private int convertH264Data(ByteArrayOutputStream byteArrayOutputStream, byte[] data, int start) throws IOException {
        int payloadLength = Basic.byteArrayToInt4((byte[])data, (int)start, (int)4);
        int pointer = start + 4;
        int end = start + 4 + payloadLength;
        ArrayList<Integer> listOfStartSequences = new ArrayList<Integer>();
        while ((pointer = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE_001, (int)pointer, (boolean)true)) != -1 && pointer < end - START_SEQUENCE_001.length) {
            if (pointer > 0 && (data[pointer - 1] != 0 || pointer == 16)) {
                listOfStartSequences.add(pointer);
            }
            pointer += START_SEQUENCE_001.length;
        }
        if (listOfStartSequences.size() > 0) {
            byteArrayOutputStream.write(Basic.int4ToByteArray((int)(payloadLength + listOfStartSequences.size())));
            if ((Integer)listOfStartSequences.get(0) > start + 4) {
                byteArrayOutputStream.write(data, start + 4, (Integer)listOfStartSequences.get(0) - start - 4);
            }
            for (int i = 0; i < listOfStartSequences.size(); ++i) {
                Integer index = (Integer)listOfStartSequences.get(i);
                int begin = index + START_SEQUENCE_001.length;
                int length = i >= listOfStartSequences.size() - 1 ? end - index - START_SEQUENCE_001.length : (Integer)listOfStartSequences.get(i + 1) - index - START_SEQUENCE_001.length;
                byteArrayOutputStream.write(START_SEQUENCE_0001);
                byteArrayOutputStream.write(data, begin, length);
            }
        } else {
            byteArrayOutputStream.write(data, start, end - start);
        }
        return end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFramePart(byte[] part, long timestamp) {
        try {
            Object object = this.DataSemaphore;
            synchronized (object) {
                if (this.data != null) {
                    this.baos = new ByteArrayOutputStream(this.data.length << 2);
                    this.baos.write(Basic.int4ToByteArray((int)0, (int)3));
                    this.baos.write(Basic.int4ToByteArray((int)this.data.length, (int)3));
                    this.baos.write(this.data);
                    this.data = null;
                    this.attributes |= 1;
                }
                this.endTimestamp = timestamp;
                this.baos.write(Basic.int8ToByteArray((long)(this.endTimestamp - this.startTimestamp), (int)3));
                this.baos.write(Basic.int4ToByteArray((int)part.length, (int)3));
                this.baos.write(part);
            }
            if (Math.abs(this.endTimestamp - this.startTimestamp) > 600000L) {
                throw new SeeTecException(-21050, "Covered timerange of " + this + " is too large!");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private FramePartIterator getFramePartIterator() {
        return new FramePartIterator();
    }

    public int getNumberOfFrameParts() {
        int result = 0;
        FramePartIterator framePartIterator = this.getFramePartIterator();
        while (framePartIterator.hasNext()) {
            framePartIterator.next();
            ++result;
        }
        return result;
    }

    public boolean isPacked() {
        return (this.attributes & 1) != 0;
    }

    public boolean isMpegVideoFrame() {
        return this.getMediatype() == 33 || this.getMediatype() == 35;
    }

    public boolean isVideoFrame() {
        return this.isFullVideoFrame() || this.getMediatype() == 35;
    }

    public boolean isFullVideoFrame() {
        return this.getMediatype() == 33 || this.getMediatype() == 0;
    }

    public boolean isIFrameInfo() {
        return this.getMediatype() == 259;
    }

    public boolean isJpegFrame() {
        return this.getMediatype() == 0 || this.getMediatype() == 1;
    }

    public ContentFrame getNextUnpackedContentFrame(long timestamp) {
        ContentFrame nextContentFrame = null;
        FramePartIterator iterator = this.getFramePartIterator();
        while (iterator.hasNext()) {
            FramePart framePart = iterator.next();
            if (framePart.getAbsoluteTimestamp() < timestamp) continue;
            nextContentFrame = new ContentFrame(this.getMediatype(), 0, framePart.getAbsoluteTimestamp(), framePart.getAbsoluteTimestamp(), framePart.getData());
            break;
        }
        return nextContentFrame;
    }

    public List<ContentFrame> getUnpackedContentFrames() {
        ArrayList<ContentFrame> contentFrames = new ArrayList<ContentFrame>();
        try {
            FramePartIterator iterator = this.getFramePartIterator();
            while (iterator.hasNext()) {
                FramePart framePart = iterator.next();
                contentFrames.add(new ContentFrame(this.getMediatype(), 0, framePart.getAbsoluteTimestamp(), framePart.getAbsoluteTimestamp(), framePart.getData()));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass().getName() + " occurred during unpackaing Frames: " + ex.getMessage() + " for " + this);
        }
        return contentFrames;
    }

    public void addContentFramesToGObject(GObject goResponse) {
        if (this.isPacked()) {
            FramePart part;
            FramePartIterator iterator = this.getFramePartIterator();
            while ((part = iterator.next()) != null) {
                GObject goContentFrame = GObject.createList();
                goContentFrame.addChild(Integer.valueOf(this.getMediatype()));
                goContentFrame.addChild(Integer.valueOf(0));
                goContentFrame.addChild(Long.valueOf(part.getAbsoluteTimestamp()));
                goContentFrame.addChild(Long.valueOf(part.getAbsoluteTimestamp()));
                goContentFrame.addChild(part.getData());
                goResponse.addChild(goContentFrame);
            }
        } else {
            GObject goContentFrame = GObject.createList();
            goContentFrame.addChild(Integer.valueOf(this.getMediatype()));
            goContentFrame.addChild(Integer.valueOf(this.getAttributes()));
            goContentFrame.addChild(Long.valueOf(this.getStartTimestamp()));
            goContentFrame.addChild(Long.valueOf(this.getEndTimestamp()));
            goContentFrame.addChild(this.getData());
            goResponse.addChild(goContentFrame);
        }
    }

    public final byte[] serialize() throws Exception {
        byte[] contentFrame = new byte[20 + this.data.length];
        this.writeHeader(contentFrame, this.data.length);
        System.arraycopy(this.data, 0, contentFrame, 20, this.data.length);
        return contentFrame;
    }

    private void writeHeader(byte[] contentFrame, int dataLength) {
        ByteBuffer contentFrameHeader = ByteBuffer.allocate(20);
        contentFrameHeader.putInt(1592257585);
        contentFrameHeader.putLong(this.startTimestamp);
        contentFrameHeader.putInt(this.mediatype);
        contentFrameHeader.putInt(dataLength);
        contentFrameHeader.flip();
        contentFrameHeader.get(contentFrame, 0, 20);
    }

    public static ContentFrame deserialize(byte[] contentFrame) {
        return new ContentFrame(contentFrame);
    }

    public static ContentFrame createPseudoFrame(long timestamp) {
        ContentFrame pseudoFrame = new ContentFrame(260, new byte[0]);
        pseudoFrame.setStartTimestamp(timestamp);
        pseudoFrame.setEndTimestamp(timestamp);
        return pseudoFrame;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.mediatype;
        hash = 97 * hash + this.attributes;
        hash = 97 * hash + (int)(this.startTimestamp ^ this.startTimestamp >>> 32);
        hash = 97 * hash + (int)(this.endTimestamp ^ this.endTimestamp >>> 32);
        hash = 97 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentFrame other = (ContentFrame)obj;
        if (this.mediatype != other.mediatype) {
            return false;
        }
        if (this.attributes != other.attributes) {
            return false;
        }
        if (this.startTimestamp != other.startTimestamp) {
            return false;
        }
        if (this.endTimestamp != other.endTimestamp) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public Object clone() {
        if (this.data == null) {
            return new ContentFrame(this.mediatype, this.attributes, this.startTimestamp, this.endTimestamp, null);
        }
        byte[] cloned = new byte[this.data.length];
        System.arraycopy(this.data, 0, cloned, 0, this.data.length);
        return new ContentFrame(this.mediatype, this.attributes, this.startTimestamp, this.endTimestamp, cloned);
    }

    public String toString() {
        String sHashCode = "00000000" + Integer.toHexString(this.hashCode());
        String sThis = "de.seetec.v5.re.shared.ContentFrame@" + sHashCode.substring(sHashCode.length() - 8);
        if (this.data != null) {
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Mediatype=[" + this.mediatype + "], Attributes=[" + this.attributes + "], [" + Basic.longToFormattedString((long)this.startTimestamp) + "]/[" + RECore.getUniformFormattedDateTime(this.startTimestamp) + "]-[" + Basic.longToFormattedString((long)this.endTimestamp) + "]/[" + RECore.getUniformFormattedDateTime(this.endTimestamp) + "], FrameSize=[" + Basic.longToFormattedString((long)this.data.length) + " b]]";
        }
        if (this.baos != null) {
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Mediatype=[" + this.mediatype + "], Attributes=[" + this.attributes + "], [" + Basic.longToFormattedString((long)this.startTimestamp) + "]/[" + RECore.getUniformFormattedDateTime(this.startTimestamp) + "]-[" + Basic.longToFormattedString((long)this.endTimestamp) + "]/[" + RECore.getUniformFormattedDateTime(this.endTimestamp) + "], FrameSize=[" + Basic.longToFormattedString((long)this.baos.size()) + " b]]";
        }
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + "]";
    }

    private class FramePartIterator
    implements Iterator<FramePart> {
        private int positionInPart = -1;
        private byte[] fixedData = null;
        private long lastTimestamp = -1L;

        private FramePartIterator() {
            this.fixedData = ContentFrame.this.getData();
            this.positionInPart = 0;
        }

        @Override
        public boolean hasNext() {
            return this.positionInPart < this.fixedData.length || this.positionInPart == 0 && this.fixedData.length == 0;
        }

        @Override
        public FramePart next() {
            try {
                if (!this.hasNext()) {
                    return null;
                }
                if (!ContentFrame.this.isPacked()) {
                    this.validateMediaFrameHeader();
                    this.positionInPart = this.fixedData.length + 1;
                    return new FramePart(0L, this.fixedData);
                }
                long ts = Basic.byteArrayToInt8((byte[])this.fixedData, (int)this.positionInPart, (int)3);
                this.positionInPart += 3;
                int partSize = Basic.byteArrayToInt4((byte[])this.fixedData, (int)this.positionInPart, (int)3);
                this.positionInPart += 3;
                byte[] part = new byte[partSize];
                if (this.lastTimestamp < ts) {
                    this.lastTimestamp = ts;
                } else {
                    ++this.lastTimestamp;
                    ts = this.lastTimestamp;
                }
                this.validateMediaFrameHeader();
                System.arraycopy(this.fixedData, this.positionInPart, part, 0, partSize);
                this.positionInPart += partSize;
                return new FramePart(ts, part);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        private void validateMediaFrameHeader() throws SeeTecException {
            int mediaFrameHeader;
            if (ContentFrame.this.isVideoFrame() && (mediaFrameHeader = Basic.byteArrayToInt4((byte[])this.fixedData, (int)this.positionInPart, (int)4)) != Basic.byteArrayToInt4((byte[])MediaFrame.MEDIA_FRAME_HEADER_MAGIC)) {
                throw new SeeTecException(-21050, "Expected frame to start with MediaFrame.MEDIA_FRAME_HEADER_MAGIC: " + Basic.byteArrayToInt4((byte[])MediaFrame.MEDIA_FRAME_HEADER_MAGIC) + " but found " + mediaFrameHeader + " instead. Frame corrupt!" + ContentFrame.this.toString());
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Operation not supported for " + this + " !");
        }
    }

    private class FramePart {
        private final long timestamp;
        private final byte[] data;

        private FramePart(long timestamp, byte[] data) {
            this.timestamp = timestamp;
            this.data = data;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getAbsoluteTimestamp() {
            return ContentFrame.this.startTimestamp + this.timestamp;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return ContentFrame.this.toString() + "[FramePart, Timestamp=[" + new Date(this.getAbsoluteTimestamp()) + "], FramePartSize=[" + Basic.longToFormattedString((long)this.data.length) + " b]]";
        }
    }
}

