/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.tree;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class TreeNode<T>
implements Serializable {
    private static final long serialVersionUID = 5816045127031023903L;
    private final T data;
    private final List<TreeNode<T>> children = new Vector<TreeNode<T>>();
    private final long key;
    private long parent = Long.MIN_VALUE;

    public TreeNode(T o, long key) {
        this.data = o;
        this.key = key;
    }

    public T getData() {
        return this.data;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public void setChild(TreeNode<T> child) {
        child.setParent(this.getKey());
        this.children.add(child);
    }

    public void removeChild(int index) {
        TreeNode<T> child = this.children.remove(index);
        child.setParent(Long.MIN_VALUE);
    }

    public long getKey() {
        return this.key;
    }

    public String toString() {
        return String.format("ID=[%s], Parent=[%s], Data=[%s]", this.key, this.parent, this.getData());
    }

    public long getParent() {
        return this.parent;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }
}

