/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.token;

import de.seetec.v5.shared.token.TokenManager;
import de.seetec.v5.shared.token.TokenRefresher;
import de.seetec.v5.shared.util.SeeTecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class TokenManagerImpl
implements TokenManager {
    private String token;
    private Timer timer;
    private JwtConsumer jwtConsumer;
    private TokenRefresher refreshToken;
    private long delayTimeBeforeExpired = TimeUnit.MINUTES.toMillis(30L);
    private long delayTimeAfterRefreshFailed = TimeUnit.MINUTES.toMillis(1L);
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    @Override
    public void init(String initialToken, TokenRefresher refreshToken) {
        this.refreshToken = refreshToken;
        this.jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().build();
        this.token = initialToken;
        this.timer = new Timer();
        this.startTimerFirst();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    private long getExpirationDate() throws MalformedClaimException, InvalidJwtException {
        JwtClaims jwtClaims = this.jwtConsumer.processToClaims(this.token);
        return jwtClaims.getExpirationTime().getValue();
    }

    public void setDelayTimer(long delayTimeBeforeExpired, long delayTimeAfterRefreshFailed) {
        this.delayTimeBeforeExpired = delayTimeBeforeExpired;
        this.delayTimeAfterRefreshFailed = delayTimeAfterRefreshFailed;
    }

    private long getDelayTime() throws InvalidJwtException, MalformedClaimException {
        long now = new Date().getTime();
        long expirationDate = TimeUnit.SECONDS.toMillis(this.getExpirationDate());
        long refreshStart = expirationDate - this.delayTimeBeforeExpired;
        return refreshStart - now;
    }

    private void startTimerFirst() {
        try {
            this.startTimer(new RefreshTimerTask(), this.getDelayTime());
        }
        catch (MalformedClaimException | InvalidJwtException ex) {
            this.logger.error("Current token is invalid.");
            this.startTimer(new GetNewTokenTimerTask(), this.delayTimeAfterRefreshFailed);
        }
    }

    private void startTimer(TimerTask task, long delay) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        long now = new Date().getTime();
        this.logger.info("Token will be refreshed at: " + sdf.format(new Date(now + delay)));
        this.timer.schedule(task, delay);
    }

    private class GetNewTokenTimerTask
    extends TimerTask {
        private GetNewTokenTimerTask() {
        }

        @Override
        public void run() {
            try {
                String newToken = TokenManagerImpl.this.refreshToken.getNewToken();
                TokenManagerImpl.this.token = newToken;
                TokenManagerImpl.this.startTimerFirst();
            }
            catch (SeeTecException ex) {
                TokenManagerImpl.this.logger.error("Can't get a new token: " + ex.getMessage());
                TokenManagerImpl.this.timer.schedule((TimerTask)new RefreshTimerTask(), TokenManagerImpl.this.delayTimeAfterRefreshFailed);
            }
        }
    }

    private class RefreshTimerTask
    extends TimerTask {
        private RefreshTimerTask() {
        }

        @Override
        public void run() {
            try {
                String newToken = TokenManagerImpl.this.refreshToken.refreshToken(TokenManagerImpl.this.token);
                TokenManagerImpl.this.token = newToken;
                TokenManagerImpl.this.startTimerFirst();
            }
            catch (SeeTecException ex) {
                if (this.isTokenIssue(ex)) {
                    TokenManagerImpl.this.startTimer(new GetNewTokenTimerTask(), TokenManagerImpl.this.delayTimeAfterRefreshFailed);
                }
                TokenManagerImpl.this.startTimer(new RefreshTimerTask(), TokenManagerImpl.this.delayTimeAfterRefreshFailed);
            }
        }

        private boolean isTokenIssue(SeeTecException exeption) {
            if (exeption == null) {
                throw new IllegalArgumentException("Exception must not be null");
            }
            return exeption.getErrorCode() == -50501 || exeption.getErrorCode() == -50502;
        }
    }
}

