/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.ssl;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.interaction.KeyDataObject;
import de.seetec.v5.shared.networking.srpc.ProxyDefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ssl.SSLProxy;
import de.seetec.v5.shared.proxy.ssl.SSLSRPCProxy;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLProxyImpl
extends Basic
implements SSLProxy {
    private SSLSRPCProxy srpcProxy = null;
    private static final String CLASSNAME = "de.seetec.v5.shared.proxy.ssl.SSLProxy";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    @Override
    public int init(String sHost, int nPort, long nTimeout) {
        return this.init(sHost, nPort, 2L, nTimeout);
    }

    @Override
    public int init(String host, int nPort, long coreID, long nTimeout) {
        int nErrorCode = 0;
        nTimeout = nTimeout <= 0L ? 120000L : nTimeout;
        ++nPort;
        long nDeadline = System.currentTimeMillis() + nTimeout;
        while (true) {
            if (System.currentTimeMillis() > nDeadline) {
                this.logger.error("Creating new connector failed :-(");
                return -20005;
            }
            try {
                this.srpcProxy = new SSLSRPCProxy();
                nErrorCode = this.srpcProxy.init(new ProxyDefaultRequestHandlerFactoryImpl(), host, nPort, coreID);
                if (nErrorCode == 0) {
                    this.ping(2000L);
                    break;
                }
            }
            catch (Exception ex) {
                this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + ex.getMessage());
            }
            this.srpcProxy.shutdown();
            this.srpcProxy = null;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.logger.debug("Error while sleeping.");
            }
        }
        return nErrorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASSNAME)) {
            return 0;
        }
        if (this.srpcProxy != null) {
            if (this.srpcProxy.shutdown() != 0) {
                this.logger.warn("Shutting down connector [" + this.srpcProxy + "] failed :-(");
            }
            this.srpcProxy = null;
        }
        return 0;
    }

    @Override
    public Entity ping(long nTimeout) throws SeeTecException {
        return this.srpcProxy.Ping(nTimeout);
    }

    @Override
    public KeyDataObject getEncryptionKey(String pass, String pass2, long nTimeout) throws SeeTecException {
        return this.srpcProxy.GetEncryptionKey(null, pass, pass2, nTimeout);
    }

    @Override
    public KeyDataObject getEncryptionKey(String username, String pass, String pass2, long nTimeout) throws SeeTecException {
        return this.srpcProxy.GetEncryptionKey(username, pass, pass2, nTimeout);
    }

    @Override
    public String getSalt(long nTimeout) throws SeeTecException {
        return this.srpcProxy.GetSalt(nTimeout);
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", srpcProxy=" + this.srpcProxy + "]";
    }
}

