/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.LoadAndNotifySrpcMessageFilter;
import de.seetec.v5.shared.net.srpc.OutdatedTransactionIdPolicy;
import de.seetec.v5.shared.net.srpc.OverflowSrpcMessageFilter;
import de.seetec.v5.shared.net.srpc.SrpcMessageFilter;
import de.seetec.v5.shared.net.srpc.SrpcQueueCleanPolicy;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SRPCHandler
extends Basic
implements Runnable,
SrpcRequestHandlerIntf {
    public static final int SRPC_MAXSIZE_SRPC_QUEUE = 250;
    private static final String CLASS_NAME = "de.seetec.v5.shared.net.srpc.SRPCHandler";
    protected Logger logger = null;
    protected Thread thread = null;
    private boolean bStopped = false;
    private final BlockingDeque<SrpcMessage> reqQueue = new LinkedBlockingDeque<SrpcMessage>();
    private final Map<UUID, RequestHandlerCallback> callbacks = new HashMap<UUID, RequestHandlerCallback>();
    private final List<SrpcMessageFilter> messageFilter = new ArrayList<SrpcMessageFilter>();
    private final List<SrpcQueueCleanPolicy> cleanPolicies = new ArrayList<SrpcQueueCleanPolicy>();

    public SRPCHandler() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.messageFilter.add(new LoadAndNotifySrpcMessageFilter());
        this.messageFilter.add(new OverflowSrpcMessageFilter());
        this.cleanPolicies.add(new OutdatedTransactionIdPolicy());
    }

    @Override
    public void handleRequest(SrpcMessage sm, RequestHandlerCallback rhc) {
        if (this.bStopped) {
            throw new RuntimeException(new SeeTecException(-20007, ""));
        }
        Methods method = Methods.valueOf(sm.getHash());
        for (SrpcMessageFilter srpcMessageFilter : this.messageFilter) {
            if (!srpcMessageFilter.filter(method, sm, rhc, this.reqQueue)) continue;
            return;
        }
        this.cleanPolicies.forEach(srpcQueueCleanPolicy -> this.reqQueue.removeIf(x -> srpcQueueCleanPolicy.clean(sm, (SrpcMessage)x, this.callbacks)));
        this.callbacks.put(sm.getId(), rhc);
        if (method == Methods.ENT_FUNCTION_GET_STATUS) {
            this.reqQueue.offerFirst(sm);
        } else {
            this.reqQueue.offer(sm);
        }
    }

    protected SrpcMessage getNextReq() throws InterruptedException {
        return this.getNextReq(30, TimeUnit.SECONDS);
    }

    protected SrpcMessage getNextReq(int timeout, TimeUnit unit) throws InterruptedException {
        return this.reqQueue.poll(timeout, unit);
    }

    protected SrpcMessage getNextReqOrNull() {
        return this.reqQueue.poll();
    }

    protected RequestHandlerCallback getCallback(UUID id) {
        return this.callbacks.remove(id);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.reqQueue != null && this.reqQueue.size() > 0) {
            this.logger.warn("Attention: Shutdown in progress, but requests still in queue for " + this);
            Iterator<SrpcMessage> itr = this.reqQueue.iterator();
            while (itr.hasNext()) {
                this.logger.warn("   " + itr.next());
            }
        }
        return 0;
    }

    public abstract void onError(int var1);

    protected void stopHandler() {
        this.bStopped = true;
    }

    protected boolean hasRequest() {
        return !this.reqQueue.isEmpty();
    }

    protected int getQueueSize() {
        return this.reqQueue.size();
    }
}

