/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class ReqCoreAnnounce
extends ReqNotify {
    private Long forwardedBy = null;

    public ReqCoreAnnounce(Long eventID, Long eventType, Long sourceID, Long causeID, Long time, Long forwardedBy, byte[] data) {
        super(eventID, eventType, sourceID, causeID, time, data);
        this.forwardedBy = forwardedBy;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        Long eventID = null;
        Long eventType = null;
        Long sourceID = null;
        Long causeID = null;
        Long time = null;
        Long forwardedBy = null;
        byte[] data = null;
        if (!goRequest.isNull()) {
            byte[] bArray = goRequest.getAsArrayOfByte();
            ByteBuffer bb = ByteBuffer.wrap(bArray).asReadOnlyBuffer();
            eventID = bb.getLong();
            eventType = bb.getLong();
            sourceID = bb.getLong();
            causeID = bb.getLong();
            time = bb.getLong();
            forwardedBy = bb.getLong();
            if (bb.remaining() > 0) {
                data = new byte[bb.remaining()];
                bb.get(data, 0, bb.remaining());
            }
        } else {
            LOGGER.warn(String.format("Could not parse Request Notify: [%s]!", goRequest.toString()));
        }
        return new ReqCoreAnnounce(eventID, eventType, sourceID, causeID, time, forwardedBy, data);
    }

    @Override
    public GObject createGObject() {
        int len = 48 + (null == this.data ? 0 : this.data.length);
        ByteBuffer buffer = ByteBuffer.allocate(len);
        this.eventID = this.eventID == null ? Long.MIN_VALUE : this.eventID;
        buffer.putLong(this.eventID);
        this.eventType = this.eventType == null ? Long.MIN_VALUE : this.eventType;
        buffer.putLong(this.eventType);
        this.sourceID = this.sourceID == null ? Long.MIN_VALUE : this.sourceID;
        buffer.putLong(this.sourceID);
        this.causeID = this.causeID == null ? Long.MIN_VALUE : this.causeID;
        buffer.putLong(this.causeID);
        this.time = this.time == null ? Long.MIN_VALUE : this.time;
        buffer.putLong(this.time);
        this.forwardedBy = this.forwardedBy == null ? Long.MIN_VALUE : this.forwardedBy;
        buffer.putLong(this.forwardedBy);
        if (this.data != null) {
            buffer.put(this.data);
        }
        GObject params = GObject.create(buffer.array());
        return params;
    }

    public Long getForwardedBy() {
        return this.forwardedBy;
    }

    @Override
    public String toString() {
        return String.format("[%s , EventID=[%,d], EventType=[%,d], SourceID=[%,d], CauseID=[%,d], Time=[%,d], ForwardedBy=[%,d], ]", Methods.NOTIFY.methodName(), this.eventID, this.eventType, this.sourceID, this.causeID, this.time, this.forwardedBy);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + super.hashCode();
        hash = 43 * hash + Objects.hashCode(this.forwardedBy);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReqCoreAnnounce other = (ReqCoreAnnounce)obj;
        return Objects.equals(this.eventID, other.eventID) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.sourceID, other.sourceID) && Objects.equals(this.time, other.time) && Objects.equals(this.forwardedBy, other.forwardedBy) && Arrays.equals(this.data, other.data);
    }
}

