/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.net.srpc.SrpcMessageFilter;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverflowSrpcMessageFilter
implements SrpcMessageFilter {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());

    @Override
    public boolean filter(Methods method, SrpcMessage sm, RequestHandlerCallback callback, Collection<SrpcMessage> currentQueue) {
        if (currentQueue.size() >= 250) {
            this.logger.error("Max queue size [250] reached for " + this);
            this.logger.error("   Queue: " + currentQueue);
            this.sendQueueOverflowResponce(sm, callback);
            return true;
        }
        return false;
    }

    private void sendQueueOverflowResponce(SrpcMessage sm, RequestHandlerCallback callback) {
        SrpcMessage rsp = SrpcMessage.createResponse(sm, null);
        rsp.setError(-20038);
        callback.onRequestHandled(sm, rsp);
    }
}

