/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.HttpVersion;
import java.util.concurrent.TimeUnit;

public class NetworkParameter {
    public static final String CLASS_NAME = "de.seetec.v5.shared.net.NetworkParameter";
    private String sHost = null;
    private int nHTTPport = -1;
    private boolean bUseHTTPS = false;
    private int nSSLport = -1;
    private int nSoTimeout = (int)TimeUnit.SECONDS.toMillis(60L);
    private boolean timeoutFromConfiguration = false;
    private String[] sUserPWD = null;
    private byte[] httpSingleLineDelimitter = new byte[]{13, 10};
    private byte[] httpDoubleLineDelimitter = new byte[]{13, 10, 13, 10};
    private String additionalData = null;
    private boolean bIgnoreSoTimeout = false;
    private String realm = null;
    private String nonce = null;
    private String qop = null;
    private static String localServerAddress = null;
    private boolean startWithoutAuthentication = false;
    private HttpVersion httpVersion = HttpVersion.HTTP_1_1;

    NetworkParameter(String sHost, int nHTTPport, String[] sUserPWD) {
        this(sHost, nHTTPport, false, -1, (int)TimeUnit.SECONDS.toMillis(60L), sUserPWD);
    }

    NetworkParameter(String sHost, int nHTTPport, boolean bUseHTTPS, int nSSLport, int nSoTimeout, String[] sUserPWD) {
        this.sHost = sHost;
        this.nHTTPport = nHTTPport;
        this.bUseHTTPS = bUseHTTPS;
        this.nSSLport = nSSLport;
        this.nSoTimeout = nSoTimeout;
        this.sUserPWD = sUserPWD;
    }

    NetworkParameter(String sHost, int nHTTPport, boolean bUseHTTPS, int nSSLport, int nSoTimeout, boolean timeoutReadFromconfiguration, String[] sUserPWD) {
        this.sHost = sHost;
        this.nHTTPport = nHTTPport;
        this.bUseHTTPS = bUseHTTPS;
        this.nSSLport = nSSLport;
        this.nSoTimeout = nSoTimeout;
        this.timeoutFromConfiguration = timeoutReadFromconfiguration;
        this.sUserPWD = sUserPWD;
    }

    NetworkParameter(NetworkParameter networkParameter) {
        this.sHost = networkParameter.getHost();
        this.nHTTPport = networkParameter.getHTTPport();
        this.bUseHTTPS = networkParameter.useHTTPS();
        this.nSSLport = networkParameter.getSSLport();
        this.nSoTimeout = networkParameter.getSoTimeout();
        this.sUserPWD = networkParameter.getUserPWD();
        this.additionalData = networkParameter.getAdditionalData();
        this.bIgnoreSoTimeout = networkParameter.getIgnoreSoTimeout();
        this.realm = networkParameter.getRealm();
        this.qop = networkParameter.getQop();
        this.nonce = networkParameter.getNonce();
    }

    public String getHost() {
        return this.sHost;
    }

    public int getHTTPport() {
        return this.nHTTPport;
    }

    public boolean useHTTPS() {
        return this.bUseHTTPS;
    }

    public int getSSLport() {
        return this.nSSLport;
    }

    public int getSoTimeout() {
        return this.nSoTimeout;
    }

    public void setSoTimeout(int nSoTimeout) {
        this.nSoTimeout = nSoTimeout;
    }

    public void checkAndSetTimeout(int socketTimeout) {
        if (!this.isTimeoutReadFromConfiguation()) {
            this.nSoTimeout = socketTimeout;
        }
    }

    public String[] getUserPWD() {
        return this.sUserPWD;
    }

    public void setUserPWD(String[] auth) {
        this.sUserPWD = auth;
    }

    public byte[] getHttpSingleLineDelimitter() {
        return this.httpSingleLineDelimitter;
    }

    public void setHttpSingleLineDelimitter(byte[] delimitter) {
        this.httpSingleLineDelimitter = delimitter;
    }

    public byte[] getHttpDoubleLineDelimitter() {
        return this.httpDoubleLineDelimitter;
    }

    public void setHttpDoubleLineDelimitter(byte[] delimitter) {
        this.httpDoubleLineDelimitter = delimitter;
    }

    public void setAdditionalData(String data) {
        this.additionalData = data;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public boolean getIgnoreSoTimeout() {
        return this.bIgnoreSoTimeout;
    }

    public void setIgnoreSoTimeout(boolean bIgnoreSoTimeout) {
        this.bIgnoreSoTimeout = bIgnoreSoTimeout;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getQop() {
        return this.qop;
    }

    public void setQop(String qop) {
        this.qop = qop;
    }

    public final void setHost(String host) {
        this.sHost = host;
    }

    public String getLocalServerAddress() {
        return localServerAddress;
    }

    public boolean isTimeoutReadFromConfiguation() {
        return this.timeoutFromConfiguration;
    }

    public static void setLocalServerAddress(String localServerAddress) {
        NetworkParameter.localServerAddress = localServerAddress;
    }

    public String toString() {
        String sThis = "de.seetec.v5.shared.net.NetworkParameter@" + Integer.toHexString(this.hashCode());
        StringBuilder authInfo = new StringBuilder();
        if (this.sHost != null) {
            if (this.sUserPWD != null) {
                if (this.sUserPWD[0] != null) {
                    authInfo.append(this.sUserPWD[0]);
                }
                authInfo.append(":");
                if (this.sUserPWD[1] != null) {
                    for (int i = 0; i < this.sUserPWD[1].length(); ++i) {
                        authInfo.append('*');
                    }
                }
            } else {
                authInfo.append("<anonymous>");
            }
        } else {
            authInfo.append("<undefined>");
        }
        authInfo.append(", Nonce=").append(this.nonce != null ? this.nonce : "null");
        authInfo.append(", Realm=").append(this.realm != null ? this.realm : "null");
        authInfo.append(", QOP=").append(this.qop != null ? this.qop : "null");
        StringBuilder sbHTTPS = new StringBuilder("use HTTPS=[" + this.bUseHTTPS + "]");
        if (this.bUseHTTPS) {
            sbHTTPS.append(", SSL port=[").append(this.nSSLport > 0 ? "" + this.nSSLport : "undefined").append("]");
        }
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Host=[" + (this.sHost != null ? this.sHost : "undefined") + "], HTTP port=[" + (this.nHTTPport > 0 ? "" + this.nHTTPport : "undefined") + "], " + sbHTTPS.toString() + ", SoTimeout=[" + Basic.longToFormattedString((long)this.nSoTimeout) + "], SoTimeout from configuration [" + this.timeoutFromConfiguration + "], Host=[" + (this.additionalData != null ? this.additionalData : "undefined") + "], Authorization=[" + authInfo.toString() + "]]";
    }

    public void setHttpPort(int port) {
        this.nHTTPport = port;
    }

    public boolean isStartWithoutAuthentication() {
        return this.startWithoutAuthentication;
    }

    public void setStartWithoutAuthentication(boolean startWithoutAuthentication) {
        this.startWithoutAuthentication = startWithoutAuthentication;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }
}

