/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.net.CipherSuitesFilterEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CipherSuitesFilterEngineModern
implements CipherSuitesFilterEngine {
    private final List<String> strongCipherSuites = new ArrayList<String>();

    public CipherSuitesFilterEngineModern() {
        this.strongCipherSuites.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        this.strongCipherSuites.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        this.strongCipherSuites.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        this.strongCipherSuites.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        this.strongCipherSuites.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
        this.strongCipherSuites.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
    }

    @Override
    public String[] filter(String[] enabledCipherSuitesToFilter) {
        List<String> suitesAsList = Arrays.asList(enabledCipherSuitesToFilter);
        return (String[])suitesAsList.stream().filter(cipher -> this.strongCipherSuites.contains(cipher)).toArray(String[]::new);
    }
}

