/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncLprHeaderDataObject
extends DataObject {
    private static final Logger LOGGER = LogManager.getLogger(SyncLprHeaderDataObject.class);
    public static final SyncLprHeaderDataObject MAGIC = SyncLprHeaderDataObject.createInstance("MAGIC", "MAGIC", -1L);
    public static final String UPDATE_STMT = "UPDATE LPR_HEADER_DATA_00 (MY_VALUE, SYNCID) VALUES(?,?) WHERE MY_KEY=?";
    public static final String INSERT_STMT = "INSERT INTO LPR_HEADER_DATA_00 (MY_KEY, MY_VALUE, SYNCID) VALUES(?,?,?)";
    private static final long serialVersionUID = -2124900732716835316L;
    private String MY_KEY;
    private String MY_VALUE;
    private Long SYNCID;

    public static SyncLprHeaderDataObject createInstance(String key, String value, Long syncid) {
        SyncLprHeaderDataObject instance = new SyncLprHeaderDataObject();
        instance.setMY_KEY(key);
        instance.setMY_VALUE(value);
        instance.setSYNCID(syncid);
        return instance;
    }

    public static SyncLprHeaderDataObject fromGObject(GObject go) {
        SyncLprHeaderDataObject result = null;
        try {
            result = SyncLprHeaderDataObject.createInstance(go.getChildAt(0).tryGetAsString(), go.getChildAt(1).tryGetAsString(), go.getChildAt(2).tryGetAsLong());
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, (Throwable)ex);
        }
        return result;
    }

    public static SyncLprHeaderDataObject fromResultSet(ResultSet rs) throws SQLException {
        String aKey = rs.getString("MY_KEY");
        if (rs.wasNull()) {
            aKey = null;
        }
        String aVal = rs.getString("MY_VALUE");
        if (rs.wasNull()) {
            aVal = null;
        }
        Long aSyn = rs.getLong("SYNCID");
        if (rs.wasNull()) {
            aSyn = null;
        }
        return SyncLprHeaderDataObject.createInstance(aKey, aVal, aSyn);
    }

    public void fillUpdateStatement(PreparedStatement stmt) throws SQLException {
        if (this.MY_VALUE == null) {
            stmt.setNull(1, 12);
        } else {
            stmt.setString(1, this.MY_VALUE);
        }
        if (this.SYNCID == null) {
            stmt.setNull(2, -5);
        } else {
            stmt.setLong(2, this.SYNCID);
        }
        if (this.MY_KEY == null) {
            stmt.setNull(3, 12);
        } else {
            stmt.setString(3, this.MY_KEY);
        }
    }

    public void fillInsertStatement(PreparedStatement stmt) throws SQLException {
        if (this.MY_KEY == null) {
            stmt.setNull(1, 12);
        } else {
            stmt.setString(1, this.MY_KEY);
        }
        if (this.MY_VALUE == null) {
            stmt.setNull(2, 12);
        } else {
            stmt.setString(2, this.MY_VALUE);
        }
        if (this.SYNCID == null) {
            stmt.setNull(3, -5);
        } else {
            stmt.setLong(3, this.SYNCID);
        }
    }

    public boolean isMagic() {
        return this.getSYNCID() != null && this.getMY_KEY() != null && this.getMY_VALUE() != null && this.getSYNCID() == -1L && this.getMY_KEY().equalsIgnoreCase("MAGIC") && this.getMY_VALUE().equalsIgnoreCase("MAGIC");
    }

    public GObject toGObject() {
        GObject result = GObject.createList();
        result.addChild(this.MY_KEY);
        result.addChild(this.MY_VALUE);
        result.addChild(this.SYNCID);
        return result;
    }

    public String getMY_KEY() {
        return this.MY_KEY;
    }

    private void setMY_KEY(String MY_KEY) {
        this.MY_KEY = MY_KEY;
    }

    public String getMY_VALUE() {
        return this.MY_VALUE;
    }

    private void setMY_VALUE(String MY_VALUE) {
        this.MY_VALUE = MY_VALUE;
    }

    public Long getSYNCID() {
        return this.SYNCID;
    }

    private void setSYNCID(Long SYNCID) {
        this.SYNCID = SYNCID;
    }
}

