/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.interaction.DataObject;
import java.net.Socket;
import java.util.Date;

public class EventDataObject
extends DataObject {
    private static final long serialVersionUID = -1383493437526894068L;
    private long eventId = Long.MIN_VALUE;
    private EventType ETID;
    private long SID = Long.MIN_VALUE;
    private long CID = Long.MIN_VALUE;
    private long time = Long.MIN_VALUE;
    private long forwardedBy = Long.MIN_VALUE;
    private byte[] data = null;
    private transient Socket source = null;
    private boolean createdBySync = false;
    private boolean createdByBulkCommand = false;

    public EventDataObject() {
    }

    public EventDataObject(long EID, EventType ETID, long SID, long CID, long time, byte[] data, Socket source) {
        this(EID, ETID, SID, CID, data);
        this.time = time;
        this.source = source;
    }

    public EventDataObject(long EID, long ETID, long SID, long CID, long time, byte[] data) {
        this.eventId = EID;
        this.ETID = EventType.valueOf(ETID);
        this.SID = SID;
        this.CID = CID;
        this.time = time;
        this.data = data;
    }

    public EventDataObject(long EID, EventType ETID, long SID, long CID, long time, long forwardedBy, byte[] data, Socket source) {
        this(EID, ETID, SID, CID, time, data, source);
        this.forwardedBy = forwardedBy;
    }

    public EventDataObject(long EID, EventType ETID, long SID, long CID, byte[] data) {
        this(ETID, SID, CID, data);
        this.eventId = EID;
        this.time = System.currentTimeMillis();
    }

    public EventDataObject(EventType ETID, long SID, long CID, byte[] data) {
        this(ETID, CID, data);
        this.SID = SID;
    }

    public EventDataObject(EventType ETID, long CID, byte[] data) {
        this.ETID = ETID;
        this.CID = CID;
        this.time = System.currentTimeMillis();
        this.data = data;
    }

    public long getEID() {
        return this.eventId;
    }

    public void setEID(long EID) {
        this.eventId = EID;
    }

    public long getETID() {
        return this.ETID == null ? Long.MIN_VALUE : this.ETID.getType();
    }

    public EventType getEventType() {
        return this.ETID;
    }

    public void setEventType(EventType ETID) {
        this.ETID = ETID;
    }

    public long getSID() {
        return this.SID;
    }

    public void setSID(long SID) {
        this.SID = SID;
    }

    public long getCID() {
        return this.CID;
    }

    public void setCID(long CID) {
        this.CID = CID;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Socket getSource() {
        return this.source;
    }

    public void setSource(Socket source) {
        this.source = source;
    }

    public long getForwardedBy() {
        return this.forwardedBy;
    }

    public void setForwardedBy(long forwardedBy) {
        this.forwardedBy = forwardedBy;
    }

    public boolean isForwarded() {
        return !this.isDirectlyArrived();
    }

    public boolean isDirectlyArrived() {
        return this.forwardedBy == Long.MIN_VALUE;
    }

    public boolean isCreatedBySync() {
        return this.createdBySync;
    }

    public void setCreatedBySync(boolean createdBySync) {
        this.createdBySync = createdBySync;
    }

    public boolean isCreatedByBulkCommand() {
        return this.createdByBulkCommand;
    }

    public void setCreatedByBulkCommand(boolean createdByBulkCommand) {
        this.createdByBulkCommand = createdByBulkCommand;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.ETID) + ", EventID: " + this.getEID() + ", SourceID: " + this.SID + ", CauseID: " + this.CID + ", generic data length: " + (this.data != null ? Integer.valueOf(this.data.length) : "null") + (this.isDirectlyArrived() ? ", Directly reached" : ", Forwarded by: " + this.forwardedBy) + ", Created by sync?: " + this.createdBySync + ", Created by bulk?: " + this.createdByBulkCommand + ", reached at " + new Date(this.time).toString();
    }
}

