/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

public enum SmtpEncryptionMethod {
    UNENCRYPTED(0),
    SSL(1),
    TLS(2);

    private final int value;

    private SmtpEncryptionMethod(int v) {
        this.value = v;
    }

    public int value() {
        return this.value;
    }

    public static SmtpEncryptionMethod fromValue(int v) throws IllegalArgumentException {
        for (SmtpEncryptionMethod c : SmtpEncryptionMethod.values()) {
            if (c.value != v) continue;
            return c;
        }
        throw new IllegalArgumentException(String.valueOf(v));
    }

    public static SmtpEncryptionMethod parseMethod(String method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("null");
        }
        try {
            return SmtpEncryptionMethod.fromValue(Integer.parseInt(method));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.valueOf(method));
        }
    }

    public static String printMethod(SmtpEncryptionMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("null");
        }
        return Integer.toString(method.value);
    }
}

