/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

public enum LicenseErrors {
    ERR_LICENSE_KEY_FILE_MISSING(-20900),
    ERR_LICENSE_KEY_INVALID(-20901),
    ERR_LICENSE_IP_DOESNT_MATCH(-20902),
    ERR_LICENSE_EXCEED_TOO_MANY_REMOTE_CONNECTIONS(-20903, "Distributions", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_CAMERAS(-20904, "Cameras", "License exceeded. Too many %s."),
    ERR_LICENSE_KEY_EXPIRED(-20907),
    ERR_LICENSE_EXCEED_TOO_MANY_IOS(-20912, "IOs", "License exceeded. Too many %s."),
    ERR_LICENSE_VOIP_NOT_ALLOWED(-20913, "VOIP", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_NOT_VALID_FOR_THIS_VERSION(-20914),
    ERR_LICENSE_AD_NOT_ALLOWED(-20915, "Active Directory", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_EVENT_INTERFACE_ITEM_ACCESSCONTROL(-20917, "Event Interface Item Access Control", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_EVENT_INTERFACE_ITEM_OTHER(-20918, "Event Interface Item Other", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_LPR(-20919, "Lanes", "License exceeded. Too many %s."),
    ERR_LICENSE_TRIAL_PERIOD_EXCEEDED(-20921),
    ERR_LICENSE_EXCEED_3RD_PARTY_DISPLAY_AGENT_NOT_ALLOWED(-20925, "ThirdPartyMonitorWalls", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_EXCEED_OPC_NOT_ALLOWED(-20926, "OPC", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_ACCESS_CONTROL_NOT_ALLOWED(-20928, "AccessContol", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_ACCESS_INTERCOM_NOT_ALLOWED(-20930, "Intercom", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_EXCEED_DISPLAY_AGENT_NOT_ALLOWED(-20931, "DisplayAgent", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_EXCEED_MOTION_DETECTION_NOT_ALLOWED(-20932, "Serverside Motion Detection", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_INTRUSION_DETECTION_NOT_ALLOWED(-20933, "Intrusion Detection", "License exceeded. License does NOT allow usage of %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_VCA_API_CHANNEL(-20934, "SeeTec VCA API", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_CONCURRENT_USERS(-20935, "Concurrent users", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_VA_SERVER_3D_CHANNEL(-20936, "SeeTec Analytics Server 3D", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_TOO_MANY_MIRRORED_SERVERS(-20937, "Mirrored Servers", "License exceeded. Too many %s."),
    ERR_LICENSE_EXCEED_CAMERA_SHARING_NOT_ALLOWED(-20939, "Camera sharing", "License exceeded. License does NOT allow usage of %s.");

    private final int error;
    private final String longDescription;
    private final String shortDescription;
    private static final String DOES_NOT_ALLOW = "License exceeded. License does NOT allow usage of %s.";
    private static final String TOO_MANY = "License exceeded. Too many %s.";

    private LicenseErrors(int error, String shortDescription, String longDescription) {
        this.error = error;
        this.shortDescription = shortDescription;
        this.longDescription = String.format(longDescription, shortDescription);
    }

    private LicenseErrors(int error) {
        this.error = error;
        this.shortDescription = String.valueOf(error);
        this.longDescription = String.valueOf(error);
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public int getErrorCode() {
        return this.error;
    }

    public static LicenseErrors valueOf(int givenError) {
        LicenseErrors error = null;
        for (LicenseErrors t : LicenseErrors.values()) {
            if (givenError != t.error) continue;
            error = t;
            break;
        }
        return error;
    }
}

