/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsTrustManager;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.WorkerTask;

public class TLSTM
extends TcpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(TLSTM.class);
    public static final int TLS_MAX_FRAGMENT_SIZE = 16384;
    private Map<Address, SocketEntry> sockets = new Hashtable<Address, SocketEntry>();
    private WorkerTask server;
    private ServerThread serverThread;
    private CommonTimer socketCleaner;
    private long connectionTimeout = 60000L;
    private boolean serverEnabled = false;
    private long nextSessionID = 1L;
    private SSLEngineConfigurator sslEngineConfigurator = new DefaultSSLEngineConfiguration();
    private TlsTmSecurityCallback<X509Certificate> securityCallback;
    private CounterSupport counterSupport;
    public static final String DEFAULT_TLSTM_PROTOCOLS = "TLSv1";
    public static final int MAX_TLS_PAYLOAD_SIZE = 32768;
    private String localCertificateAlias;
    private String keyStore;
    private String keyStorePassword;
    private String trustStore;
    private String trustStorePassword;
    private String[] tlsProtocols;
    private TLSTMTrustManagerFactory trustManagerFactory = new DefaultTLSTMTrustManagerFactory();
    private int tlsMaxFragmentSize = 16384;

    public TLSTM() throws UnknownHostException {
        super(new TlsAddress(InetAddress.getLocalHost(), 0));
        this.counterSupport = CounterSupport.getInstance();
        this.maxInboundMessageSize = 32768;
    }

    public TLSTM(TlsAddress address) throws IOException {
        super(address);
        this.maxInboundMessageSize = 32768;
        this.serverEnabled = true;
        this.counterSupport = CounterSupport.getInstance();
        try {
            if (Class.forName("javax.net.ssl.X509ExtendedTrustManager") != null) {
                Class<?> trustManagerFactoryClass = Class.forName("org.snmp4j.transport.tls.TLSTMExtendedTrustManagerFactory");
                Constructor<?> c = trustManagerFactoryClass.getConstructors()[0];
                TLSTMTrustManagerFactory trustManagerFactory = (TLSTMTrustManagerFactory)c.newInstance(CounterSupport.getInstance(), this.securityCallback);
                this.setTrustManagerFactory(trustManagerFactory);
            }
        }
        catch (ClassNotFoundException trustManagerFactoryClass) {
        }
        catch (InvocationTargetException ex) {
            throw new IOException("Failed to init TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Failed to setup TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("Failed to access TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new IOException("Failed to instantiate TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
    }

    public TLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress serverAddress) throws IOException {
        this(securityCallback, serverAddress, CounterSupport.getInstance());
    }

    public TLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress serverAddress, CounterSupport counterSupport) throws IOException {
        super(serverAddress);
        this.maxInboundMessageSize = 32768;
        this.serverEnabled = true;
        this.securityCallback = securityCallback;
        this.counterSupport = counterSupport;
    }

    public String getLocalCertificateAlias() {
        if (this.localCertificateAlias == null) {
            return System.getProperty("org.snmp4j.arg.tlsLocalID", null);
        }
        return this.localCertificateAlias;
    }

    public String[] getTlsProtocols() {
        if (this.tlsProtocols == null) {
            String s = System.getProperty("org.snmp4j.arg.tlsVersion", DEFAULT_TLSTM_PROTOCOLS);
            return s.split(",");
        }
        return this.tlsProtocols;
    }

    public void setTlsProtocols(String[] tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public String getKeyStore() {
        if (this.keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        if (this.keyStorePassword == null) {
            return System.getProperty("javax.net.ssl.keyStorePassword");
        }
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setLocalCertificateAlias(String localCertificateAlias) {
        this.localCertificateAlias = localCertificateAlias;
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return TlsAddress.class;
    }

    public TlsTmSecurityCallback<X509Certificate> getSecurityCallback() {
        return this.securityCallback;
    }

    public void setSecurityCallback(TlsTmSecurityCallback<X509Certificate> securityCallback) {
        this.securityCallback = securityCallback;
    }

    public TLSTMTrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TLSTMTrustManagerFactory trustManagerFactory) {
        if (trustManagerFactory == null) {
            throw new NullPointerException();
        }
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.server != null) {
            throw new SocketException("Port already listening");
        }
        try {
            this.serverThread = new ServerThread();
            if (logger.isInfoEnabled()) {
                logger.info("TCP address " + this.getListenAddress() + " bound successfully");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("SSL not available: " + e.getMessage(), e);
        }
        this.server = SNMP4JSettings.getThreadFactory().createWorkerThread("TLSTM_" + this.getAddress(), this.serverThread, true);
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.server.run();
    }

    public void setThreadName(String name) {
        WorkerTask st = this.server;
        if (st instanceof Thread) {
            ((Thread)((Object)st)).setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask st = this.server;
        if (st != null) {
            return ((Thread)((Object)st)).getName();
        }
        return null;
    }

    @Override
    public void close() {
        for (SocketEntry entry : this.sockets.values()) {
            entry.closeSession();
        }
        WorkerTask st = this.server;
        if (st != null) {
            st.terminate();
            st.interrupt();
            try {
                st.join();
            }
            catch (InterruptedException ex) {
                logger.warn(ex);
            }
            this.server = null;
            for (SocketEntry entry : this.sockets.values()) {
                Socket s = entry.getSocket();
                if (s == null) continue;
                try {
                    SocketChannel sc = s.getChannel();
                    s.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Socket to " + entry.getPeerAddress() + " closed")));
                    }
                    if (sc == null) continue;
                    sc.close();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Serializable)((Object)("Socket channel to " + entry.getPeerAddress() + " closed")));
                }
                catch (IOException iox) {
                    logger.debug(iox);
                }
            }
            if (this.socketCleaner != null) {
                this.socketCleaner.cancel();
            }
            this.socketCleaner = null;
        }
    }

    @Override
    public synchronized boolean close(TcpAddress remoteAddress) throws IOException {
        SocketEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Closing socket for peer address " + remoteAddress)));
        }
        if ((entry = (SocketEntry)this.removeSocketEntry(remoteAddress)) != null) {
            Socket s = entry.getSocket();
            if (s != null) {
                SocketChannel sc = entry.getSocket().getChannel();
                entry.getSocket().close();
                if (logger.isInfoEnabled()) {
                    logger.info("Socket to " + entry.getPeerAddress() + " closed");
                }
                if (sc != null) {
                    sc.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Closed socket channel for peer address " + remoteAddress)));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object removeSocketEntry(TcpAddress remoteAddress) {
        return this.sockets.remove(remoteAddress);
    }

    @Override
    public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference) throws IOException {
        if (this.server == null || this.serverThread == null) {
            if (this.isOpenSocketOnSending()) {
                this.listen();
            } else {
                this.handleDroppedMessageToSend(address, message, tmStateReference);
            }
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference);
            }
        }
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return null;
    }

    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
    }

    @Override
    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    private synchronized void timeoutSocket(SocketEntry entry) {
        if (this.connectionTimeout > 0L) {
            SocketTimeout socketTimeout = new SocketTimeout(entry);
            entry.setSocketTimeout(socketTimeout);
            this.socketCleaner.schedule(socketTimeout, this.connectionTimeout);
        }
    }

    @Override
    public boolean isListening() {
        return this.server != null;
    }

    public static OctetString getFingerprint(X509Certificate cert) {
        OctetString certFingerprint = null;
        try {
            String algo = cert.getSigAlgName();
            if (algo.contains("with") && (algo = algo.substring(0, algo.indexOf("with"))).startsWith("SHA") && !algo.contains("-")) {
                algo = "SHA-" + algo.substring(3);
            }
            MessageDigest md = MessageDigest.getInstance(algo);
            md.update(cert.getEncoded());
            certFingerprint = new OctetString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("No such digest algorithm exception while getting fingerprint from " + cert + ": " + e.getMessage(), e);
        }
        catch (CertificateEncodingException e) {
            logger.error("Certificate encoding exception while getting fingerprint from " + cert + ": " + e.getMessage(), e);
        }
        return certFingerprint;
    }

    public static Object getSubjAltName(Collection<List<?>> subjAltNames, int type) {
        if (subjAltNames != null) {
            for (List<?> entry : subjAltNames) {
                int t = (Integer)entry.get(0);
                if (t != type) continue;
                return entry.get(1);
            }
        }
        return null;
    }

    @Override
    public TcpAddress getListenAddress() {
        int port = this.tcpAddress.getPort();
        ServerThread serverThreadCopy = this.serverThread;
        try {
            port = serverThreadCopy.ssc.socket().getLocalPort();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new TcpAddress(this.tcpAddress.getInetAddress(), port);
    }

    protected void setSocketOptions(ServerSocket serverSocket) {
    }

    void writeNetBuffer(SocketEntry entry, SocketChannel sc) throws IOException {
        entry.outNetBuffer.flip();
        while (entry.outNetBuffer.hasRemaining()) {
            logger.debug((Serializable)((Object)("Writing TLS outNetBuffer(PAYLOAD): " + entry.outNetBuffer)));
            int num = sc.write(entry.outNetBuffer);
            logger.debug((Serializable)((Object)("Wrote TLS " + num + " bytes from outNetBuffer(PAYLOAD)")));
            if (num == -1) {
                throw new IOException("TLS connection closed");
            }
            if (num != 0) continue;
            entry.outNetBuffer.compact();
            return;
        }
        entry.outNetBuffer.clear();
    }

    private boolean matchingStateReferences(TransportStateReference tmStateReferenceNew, TransportStateReference tmStateReferenceExisting) {
        if (tmStateReferenceExisting == null || tmStateReferenceNew == null) {
            logger.error((Serializable)((Object)("Failed to compare TransportStateReferences refNew=" + tmStateReferenceNew + ",refOld=" + tmStateReferenceExisting)));
            return false;
        }
        if (tmStateReferenceNew.getSecurityName() == null || tmStateReferenceExisting.getSecurityName() == null) {
            logger.error((Serializable)((Object)("Could not match TransportStateReferences refNew=" + tmStateReferenceNew + ",refOld=" + tmStateReferenceExisting)));
            return false;
        }
        return tmStateReferenceNew.getSecurityName().equals(tmStateReferenceExisting.getSecurityName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult sendNetMessage(SocketEntry entry) throws IOException {
        SSLEngineResult result;
        Object object = entry.outboundLock;
        synchronized (object) {
            if (!entry.outNetBuffer.hasRemaining()) {
                return null;
            }
            result = entry.sslEngine.wrap(ByteBuffer.allocate(0), entry.outNetBuffer);
            entry.outNetBuffer.flip();
            logger.debug((Serializable)((Object)("TLS outNetBuffer = " + entry.outNetBuffer)));
            entry.socket.getChannel().write(entry.outNetBuffer);
            entry.outNetBuffer.clear();
        }
        return result;
    }

    public String getTrustStore() {
        if (this.trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        if (this.trustStorePassword == null) {
            return System.getProperty("javax.net.ssl.trustStorePassword");
        }
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    private void adjustInNetBuffer(SocketEntry entry, SSLEngineResult result) {
        if (result.getStatus() == SSLEngineResult.Status.OK) {
            if (result.bytesConsumed() == entry.inNetBuffer.limit()) {
                entry.inNetBuffer.clear();
            } else if (result.bytesConsumed() > 0) {
                entry.inNetBuffer.compact();
            }
        }
    }

    private class DefaultTLSTMTrustManagerFactory
    implements TLSTMTrustManagerFactory {
        private DefaultTLSTMTrustManagerFactory() {
        }

        @Override
        public X509TrustManager create(X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference) {
            return new TlsTrustManager(trustManager, useClientMode, tmStateReference, TLSTM.this.counterSupport, TLSTM.this.securityCallback);
        }
    }

    public static interface TLSTMTrustManagerFactory {
        public X509TrustManager create(X509TrustManager var1, boolean var2, TransportStateReference var3);
    }

    protected class DefaultSSLEngineConfiguration
    implements SSLEngineConfigurator {
        private TrustManager[] trustManagers;

        protected DefaultSSLEngineConfiguration() {
        }

        @Override
        public void configure(SSLEngine sslEngine) {
            logger.debug((Serializable)((Object)("Configuring SSL engine, supported protocols are " + Arrays.asList(sslEngine.getSupportedProtocols()) + ", supported ciphers are " + Arrays.asList(sslEngine.getSupportedCipherSuites()) + ", https defaults are " + System.getProperty("https.cipherSuites"))));
            String[] supportedCipherSuites = sslEngine.getEnabledCipherSuites();
            ArrayList<String> enabledCipherSuites = new ArrayList<String>(supportedCipherSuites.length);
            for (String cs : supportedCipherSuites) {
                if (cs.contains("_anon_") || cs.contains("_NULL_")) continue;
                enabledCipherSuites.add(cs);
            }
            sslEngine.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
            sslEngine.setEnabledProtocols(TLSTM.this.getTlsProtocols());
            if (!sslEngine.getUseClientMode()) {
                sslEngine.setNeedClientAuth(true);
                sslEngine.setWantClientAuth(true);
                logger.info("Need client authentication set to true");
            }
            logger.info("Configured SSL engine, enabled protocols are " + Arrays.asList(sslEngine.getEnabledProtocols()) + ", enabled ciphers are " + Arrays.asList(sslEngine.getEnabledCipherSuites()));
        }

        @Override
        public SSLContext getSSLContext(boolean useClientMode, TransportStateReference transportStateReference) {
            try {
                String protocol = TLSTM.DEFAULT_TLSTM_PROTOCOLS;
                if (TLSTM.this.getTlsProtocols() != null && TLSTM.this.getTlsProtocols().length > 0) {
                    protocol = TLSTM.this.getTlsProtocols()[0];
                }
                SSLContext sslContext = SSLContext.getInstance(protocol);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunPKIX");
                try {
                    FileInputStream fisKeyStore = new FileInputStream(TLSTM.this.getKeyStore());
                    FileInputStream fisTrustStore = new FileInputStream(TLSTM.this.getTrustStore());
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(fisKeyStore, TLSTM.this.getKeyStorePassword() != null ? TLSTM.this.getKeyStorePassword().toCharArray() : null);
                    if (logger.isInfoEnabled()) {
                        logger.info("KeyStore '" + TLSTM.this.getKeyStore() + "' contains: " + Collections.list(ks.aliases()));
                    }
                    this.filterCertificates(ks, transportStateReference);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ks, TLSTM.this.getKeyStorePassword() != null ? TLSTM.this.getKeyStorePassword().toCharArray() : null);
                    KeyStore ts = KeyStore.getInstance("JKS");
                    ts.load(fisTrustStore, TLSTM.this.getTrustStorePassword() != null ? TLSTM.this.getTrustStorePassword().toCharArray() : null);
                    if (logger.isInfoEnabled()) {
                        logger.info("TrustStore '" + TLSTM.this.trustStore + "' contains: " + Collections.list(ts.aliases()));
                    }
                    tmf.init(ts);
                    this.trustManagers = tmf.getTrustManagers();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("SSL context initializing with TrustManagers: " + Arrays.asList(this.trustManagers) + " and factory " + TLSTM.this.trustManagerFactory.getClass().getName())));
                    }
                    sslContext.init(kmf.getKeyManagers(), new TrustManager[]{TLSTM.this.trustManagerFactory.create((X509TrustManager)this.trustManagers[0], useClientMode, transportStateReference)}, null);
                    return sslContext;
                }
                catch (KeyStoreException e) {
                    logger.error("Failed to initialize SSLContext because of a KeyStoreException: " + e.getMessage(), e);
                }
                catch (KeyManagementException e) {
                    logger.error("Failed to initialize SSLContext because of a KeyManagementException: " + e.getMessage(), e);
                }
                catch (UnrecoverableKeyException e) {
                    logger.error("Failed to initialize SSLContext because of an UnrecoverableKeyException: " + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    logger.error("Failed to initialize SSLContext because of a CertificateException: " + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    logger.error("Failed to initialize SSLContext because of a FileNotFoundException: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    logger.error("Failed to initialize SSLContext because of an IOException: " + e.getMessage(), e);
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Failed to initialize SSLContext because of an NoSuchAlgorithmException: " + e.getMessage(), e);
            }
            return null;
        }

        private void filterCertificates(KeyStore ks, TransportStateReference transportStateReference) {
            String localCertAlias = TLSTM.this.localCertificateAlias;
            if (TLSTM.this.securityCallback != null && transportStateReference != null && (localCertAlias = TLSTM.this.securityCallback.getLocalCertificateAlias(transportStateReference.getAddress())) == null) {
                localCertAlias = TLSTM.this.localCertificateAlias;
            }
            if (localCertAlias != null) {
                try {
                    Certificate[] chain = ks.getCertificateChain(localCertAlias);
                    if (chain == null) {
                        logger.warn((Serializable)((Object)("Local certificate with alias '" + localCertAlias + "' not found. Known aliases are: " + Collections.list(ks.aliases()))));
                    } else {
                        ArrayList<String> chainAliases = new ArrayList<String>(chain.length);
                        for (Certificate certificate : chain) {
                            String alias = ks.getCertificateAlias(certificate);
                            if (alias == null) continue;
                            chainAliases.add(alias);
                        }
                        for (String alias : Collections.list(ks.aliases())) {
                            if (chainAliases.contains(alias)) continue;
                            ks.deleteEntry(alias);
                        }
                    }
                }
                catch (KeyStoreException e) {
                    logger.error("Failed to get certificate chain for alias " + localCertAlias + ": " + e.getMessage(), e);
                }
            }
        }
    }

    static interface SSLEngineConfigurator {
        public void configure(SSLEngine var1);

        public SSLContext getSSLContext(boolean var1, TransportStateReference var2);
    }

    class ServerThread
    implements WorkerTask {
        private volatile boolean stop = false;
        private Throwable lastError = null;
        private ServerSocketChannel ssc;
        private Selector selector;
        private LinkedList<SocketEntry> pending = new LinkedList();
        private BlockingQueue<SocketEntry> outQueue = new LinkedBlockingQueue<SocketEntry>();
        private BlockingQueue<SocketEntry> inQueue = new LinkedBlockingQueue<SocketEntry>();

        public ServerThread() throws IOException, NoSuchAlgorithmException {
            this.selector = Selector.open();
            if (TLSTM.this.serverEnabled) {
                this.ssc = ServerSocketChannel.open();
                this.ssc.configureBlocking(false);
                InetSocketAddress isa = new InetSocketAddress(TLSTM.this.tcpAddress.getInetAddress(), TLSTM.this.tcpAddress.getPort());
                TLSTM.this.setSocketOptions(this.ssc.socket());
                this.ssc.socket().bind(isa);
                this.ssc.register(this.selector, 16);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void processQueues() {
            while (!this.outQueue.isEmpty() || !this.inQueue.isEmpty()) {
                SocketEntry entry;
                while (!this.outQueue.isEmpty()) {
                    entry = null;
                    try {
                        entry = this.outQueue.take();
                        SSLEngineResult result = TLSTM.this.sendNetMessage(entry);
                        if (result == null || !this.runDelegatedTasks(result, entry) || !entry.isAppOutPending()) continue;
                        this.writeMessage(entry, entry.getSocket().getChannel());
                    }
                    catch (IOException iox) {
                        logger.error("IO exception caught while SSL processing: " + iox.getMessage(), iox);
                        while (this.inQueue.remove(entry)) {
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("SSL processing interrupted: " + e.getMessage(), e);
                        return;
                    }
                }
                while (!this.inQueue.isEmpty()) {
                    entry = null;
                    try {
                        entry = this.inQueue.take();
                        Object e = entry.inboundLock;
                        synchronized (e) {
                            if (entry.getInNetBuffer().position() > 0) {
                                entry.inNetBuffer.flip();
                                logger.debug((Serializable)((Object)("TLS inNetBuffer = " + entry.inNetBuffer)));
                                SSLEngineResult nextResult = entry.sslEngine.unwrap(entry.inNetBuffer, entry.inAppBuffer);
                                TLSTM.this.adjustInNetBuffer(entry, nextResult);
                                if (this.runDelegatedTasks(nextResult, entry)) {
                                    switch (nextResult.getStatus()) {
                                        case BUFFER_UNDERFLOW: {
                                            entry.inNetBuffer.position(entry.inNetBuffer.limit());
                                            entry.inNetBuffer.limit(entry.inNetBuffer.capacity());
                                            entry.addRegistration(this.selector, 1);
                                            break;
                                        }
                                        case BUFFER_OVERFLOW: {
                                            break;
                                        }
                                        case CLOSED: {
                                            break;
                                        }
                                        case OK: {
                                            if (entry.isAppOutPending()) {
                                                this.writeMessage(entry, entry.getSocket().getChannel());
                                            }
                                            entry.inAppBuffer.flip();
                                            logger.debug((Serializable)((Object)("Dispatching inAppBuffer=" + entry.inAppBuffer)));
                                            if (entry.inAppBuffer.limit() > 0) {
                                                this.dispatchMessage(entry.getPeerAddress(), entry.inAppBuffer, entry.inAppBuffer.limit(), entry.sessionID, entry.tmStateReference);
                                            }
                                            entry.inAppBuffer.clear();
                                        }
                                    }
                                }
                            } else {
                                entry.addRegistration(this.selector, 1);
                            }
                        }
                    }
                    catch (IOException iox) {
                        logger.error("IO exception caught while SSL processing: " + iox.getMessage(), iox);
                        while (this.inQueue.remove(entry)) {
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("SSL processing interrupted: " + e.getMessage(), e);
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPending() {
            LinkedList<SocketEntry> linkedList = this.pending;
            synchronized (linkedList) {
                for (int i = 0; i < this.pending.size(); ++i) {
                    TransportStateEvent e;
                    SocketEntry entry = this.pending.getFirst();
                    try {
                        if (entry.getSocket().isConnected()) {
                            if (!entry.isHandshakeFinished()) continue;
                            entry.addRegistration(this.selector, 4);
                            continue;
                        }
                        entry.addRegistration(this.selector, 8);
                        continue;
                    }
                    catch (CancelledKeyException ckex) {
                        logger.warn(ckex);
                        this.pending.remove(entry);
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(TLSTM.this, entry.getPeerAddress(), 4, null);
                            TLSTM.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        continue;
                    }
                    catch (IOException iox) {
                        logger.error(iox);
                        this.pending.remove(entry);
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(TLSTM.this, entry.getPeerAddress(), 4, iox);
                            TLSTM.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        this.lastError = iox;
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(iox);
                    }
                }
            }
        }

        public boolean runDelegatedTasks(SSLEngineResult result, SocketEntry entry) throws IOException {
            SSLEngineResult.HandshakeStatus status;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Running delegated task on " + entry + ": " + result)));
            }
            if ((status = result.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable runnable;
                while ((runnable = entry.sslEngine.getDelegatedTask()) != null) {
                    logger.debug((Serializable)((Object)"Running delegated task..."));
                    runnable.run();
                }
                status = entry.sslEngine.getHandshakeStatus();
                if (status == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    throw new IOException("Inconsistent Handshake status");
                }
                logger.info("Handshake status = " + (Object)((Object)status));
            }
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    entry.inNetBuffer.position(entry.inNetBuffer.limit());
                    entry.inNetBuffer.limit(entry.inNetBuffer.capacity());
                    entry.addRegistration(this.selector, 1);
                    return false;
                }
                case CLOSED: {
                    return false;
                }
            }
            switch (status) {
                case NEED_WRAP: {
                    this.outQueue.add(entry);
                    break;
                }
                case NEED_UNWRAP: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("NEED_UNRWAP processing with inNetBuffer=" + entry.inNetBuffer)));
                    }
                    this.inQueue.add(entry);
                    entry.addRegistration(this.selector, 1);
                    break;
                }
                case FINISHED: {
                    logger.debug((Serializable)((Object)"TLS handshake finished"));
                    entry.setHandshakeFinished(true);
                }
                case NOT_HANDSHAKING: {
                    if (result.bytesProduced() > 0) {
                        TLSTM.this.writeNetBuffer(entry, entry.getSocket().getChannel());
                    }
                    return true;
                }
            }
            return false;
        }

        protected void connectSocketToSendMessage(Address address, byte[] message, Socket s, SocketEntry entry, Map<Address, SocketEntry> sockets) {
            SocketEntry currentSocketEntry = sockets.putIfAbsent(address, entry);
            if (currentSocketEntry != null && currentSocketEntry.getSocket().isConnected()) {
                entry = currentSocketEntry;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Concurrent connection attempt detected, canceling this one to " + address)));
                }
                entry.addMessage(message);
                try {
                    s.close();
                }
                catch (IOException iox) {
                    logger.error("Failed to close recently opened socket for '" + address + "', with " + iox.getMessage(), iox);
                }
                if (currentSocketEntry.getSocket().isConnected()) {
                    this.queueNewMessage(entry);
                    return;
                }
            } else if (currentSocketEntry != null && !currentSocketEntry.getSocket().isConnected()) {
                entry.insertMessages(currentSocketEntry.message);
                sockets.put(address, entry);
                try {
                    currentSocketEntry.getSocket().close();
                }
                catch (IOException iox) {
                    logger.error("Failed to close socket for '" + address + "', with " + iox.getMessage(), iox);
                }
            }
            this.queueNewMessage(entry);
            logger.debug((Serializable)((Object)("Trying to connect to " + address)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueNewMessage(SocketEntry entry) {
            LinkedList<SocketEntry> linkedList = this.pending;
            synchronized (linkedList) {
                this.pending.add(entry);
            }
            this.selector.wakeup();
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Address address, byte[] message, TransportStateReference tmStateReference) throws IOException {
            Socket s = null;
            SocketEntry entry = (SocketEntry)TLSTM.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Looking up connection for destination '" + address + "' returned: " + entry)));
                logger.debug((Serializable)((Object)TLSTM.this.sockets.toString()));
            }
            if (entry != null) {
                if (tmStateReference != null && tmStateReference.getSessionID() != null && !tmStateReference.getSessionID().equals(entry.getSessionID())) {
                    TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionNoSessions));
                    throw new IOException("Session " + tmStateReference.getSessionID() + " not available");
                }
                s = entry.getSocket();
            }
            if (s == null || s.isClosed() || !s.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket for address '" + address + "' is closed, opening it...")));
                }
                LinkedList<SocketEntry> linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.remove(entry);
                }
                try {
                    SocketChannel sc;
                    InetSocketAddress targetAddress = new InetSocketAddress(((TcpAddress)address).getInetAddress(), ((TcpAddress)address).getPort());
                    if (s == null || s.isClosed()) {
                        sc = SocketChannel.open();
                        sc.configureBlocking(false);
                        sc.connect(targetAddress);
                        TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpens));
                    } else {
                        sc = s.getChannel();
                        sc.configureBlocking(false);
                        if (!sc.isConnectionPending()) {
                            sc.connect(targetAddress);
                            TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpens));
                        } else {
                            if (TLSTM.this.matchingStateReferences(tmStateReference, entry.tmStateReference)) {
                                entry.addMessage(message);
                                LinkedList<SocketEntry> linkedList2 = this.pending;
                                synchronized (linkedList2) {
                                    this.pending.add(entry);
                                }
                                this.selector.wakeup();
                                return;
                            }
                            logger.error((Serializable)((Object)("TransportStateReferences refNew=" + tmStateReference + ",refOld=" + entry.tmStateReference + " do not match, message dropped")));
                            throw new IOException("Transport state reference does not match existing reference for this session/target");
                        }
                    }
                    s = sc.socket();
                    entry = new SocketEntry((TcpAddress)address, s, true, tmStateReference);
                    entry.addMessage(message);
                    TLSTM.this.sockets.put(address, entry);
                    LinkedList<SocketEntry> linkedList3 = this.pending;
                    synchronized (linkedList3) {
                        this.pending.add(entry);
                    }
                    this.selector.wakeup();
                    logger.debug((Serializable)((Object)("Trying to connect to " + address)));
                }
                catch (IOException iox) {
                    logger.error(iox);
                    throw iox;
                }
                catch (NoSuchAlgorithmException e) {
                    logger.error("NoSuchAlgorithmException while sending message to " + address + ": " + e.getMessage(), e);
                }
            } else if (TLSTM.this.matchingStateReferences(tmStateReference, entry.tmStateReference)) {
                entry.addMessage(message);
                LinkedList<SocketEntry> linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.addFirst(entry);
                }
                logger.debug((Serializable)((Object)"Waking up selector for new message"));
                this.selector.wakeup();
            } else {
                logger.error((Serializable)((Object)("TransportStateReferences refNew=" + tmStateReference + ",refOld=" + entry.tmStateReference + " do not match, message dropped")));
                throw new IOException("Transport state reference does not match existing reference for this session/target");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    try {
                        this.processQueues();
                        if (this.selector.select() > 0) {
                            if (this.stop) break;
                            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                            Iterator<SelectionKey> it = readyKeys.iterator();
                            while (it.hasNext()) {
                                try {
                                    SocketEntry entry = null;
                                    SelectionKey sk = it.next();
                                    it.remove();
                                    SocketChannel readChannel = null;
                                    TcpAddress incomingAddress = null;
                                    if (sk.isAcceptable()) {
                                        logger.debug((Serializable)((Object)"Key is acceptable"));
                                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                        Socket s = nextReady.accept().socket();
                                        readChannel = s.getChannel();
                                        readChannel.configureBlocking(false);
                                        incomingAddress = new TcpAddress(s.getInetAddress(), s.getPort());
                                        entry = new SocketEntry(incomingAddress, s, false, null);
                                        entry.addRegistration(this.selector, 1);
                                        TLSTM.this.sockets.put(incomingAddress, entry);
                                        TLSTM.this.timeoutSocket(entry);
                                        TransportStateEvent e = new TransportStateEvent(TLSTM.this, incomingAddress, 1, null);
                                        TLSTM.this.fireConnectionStateChanged(e);
                                        if (e.isCancelled()) {
                                            logger.warn((Serializable)((Object)"Incoming connection cancelled"));
                                            s.close();
                                            TLSTM.this.removeSocketEntry(incomingAddress);
                                            readChannel = null;
                                        }
                                    } else if (sk.isWritable()) {
                                        logger.debug((Serializable)((Object)"Key is writable"));
                                        incomingAddress = this.writeData(sk, incomingAddress);
                                    } else if (sk.isReadable()) {
                                        logger.debug((Serializable)((Object)"Key is readable"));
                                        readChannel = (SocketChannel)sk.channel();
                                        incomingAddress = new TcpAddress(readChannel.socket().getInetAddress(), readChannel.socket().getPort());
                                    } else if (sk.isConnectable()) {
                                        logger.debug((Serializable)((Object)"Key is connectable"));
                                        this.connectChannel(sk, incomingAddress);
                                    }
                                    if (readChannel == null) continue;
                                    logger.debug((Serializable)((Object)"Key is reading"));
                                    try {
                                        this.readMessage(sk, readChannel, incomingAddress, entry);
                                    }
                                    catch (IOException iox) {
                                        logger.warn(iox);
                                        iox.printStackTrace();
                                        sk.cancel();
                                        readChannel.close();
                                        TransportStateEvent e = new TransportStateEvent(TLSTM.this, incomingAddress, 2, iox);
                                        TLSTM.this.fireConnectionStateChanged(e);
                                    }
                                }
                                catch (CancelledKeyException ckex) {
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug((Serializable)((Object)"Selection key cancelled, skipping it"));
                                }
                                catch (NoSuchAlgorithmException e) {
                                    logger.error("NoSuchAlgorithm while reading from server socket: " + e.getMessage(), e);
                                }
                            }
                        }
                    }
                    catch (NullPointerException npex) {
                        npex.printStackTrace();
                        logger.warn((Serializable)((Object)"NullPointerException within select()?"));
                        this.stop = true;
                    }
                    this.processPending();
                }
                if (this.ssc != null) {
                    this.ssc.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException iox) {
                logger.error(iox);
                this.lastError = iox;
            }
            if (!this.stop) {
                this.stop = true;
                TLSTM tLSTM = TLSTM.this;
                synchronized (tLSTM) {
                    TLSTM.this.server = null;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Worker task finished: " + this.getClass().getName())));
            }
        }

        private void connectChannel(SelectionKey sk, TcpAddress incomingAddress) {
            block6: {
                SocketEntry entry = (SocketEntry)sk.attachment();
                try {
                    SocketChannel sc = (SocketChannel)sk.channel();
                    if (!sc.isConnected()) {
                        if (sc.finishConnect()) {
                            sc.configureBlocking(false);
                            logger.debug((Serializable)((Object)("Connected to " + entry.getPeerAddress())));
                            TLSTM.this.timeoutSocket(entry);
                            entry.removeRegistration(this.selector, 8);
                            entry.addRegistration(this.selector, 4);
                        } else {
                            entry = null;
                        }
                    }
                    if (entry != null) {
                        TcpAddress addr = incomingAddress == null ? entry.getPeerAddress() : incomingAddress;
                        logger.debug((Serializable)((Object)("Fire connected event for " + addr)));
                        TransportStateEvent e = new TransportStateEvent(TLSTM.this, addr, 1, null);
                        TLSTM.this.fireConnectionStateChanged(e);
                    }
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    sk.cancel();
                    this.closeChannel(sk.channel());
                    if (entry == null) break block6;
                    this.pending.remove(entry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TcpAddress writeData(SelectionKey sk, TcpAddress incomingAddress) {
            SocketEntry entry = (SocketEntry)sk.attachment();
            try {
                SocketChannel sc = (SocketChannel)sk.channel();
                incomingAddress = new TcpAddress(sc.socket().getInetAddress(), sc.socket().getPort());
                if (entry != null && !entry.hasMessage()) {
                    LinkedList<SocketEntry> linkedList = this.pending;
                    synchronized (linkedList) {
                        this.pending.remove(entry);
                        entry.removeRegistration(this.selector, 4);
                    }
                }
                if (entry != null) {
                    this.writeMessage(entry, sc);
                }
            }
            catch (IOException iox) {
                logger.warn(iox);
                TransportStateEvent e = new TransportStateEvent(TLSTM.this, incomingAddress, 2, iox);
                TLSTM.this.fireConnectionStateChanged(e);
                this.closeChannel(sk.channel());
            }
            return incomingAddress;
        }

        private void closeChannel(SelectableChannel channel) {
            try {
                channel.close();
            }
            catch (IOException channelCloseException) {
                logger.warn(channelCloseException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry session) throws IOException {
            block20: {
                SocketEntry entry = (SocketEntry)sk.attachment();
                if (entry == null) {
                    entry = session;
                }
                if (entry == null) {
                    logger.error((Serializable)((Object)"SocketEntry null in readMessage"));
                }
                assert (entry != null);
                entry.used();
                ByteBuffer inNetBuffer = entry.getInNetBuffer();
                ByteBuffer inAppBuffer = entry.getInAppBuffer();
                try {
                    long bytesRead = readChannel.read(inNetBuffer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Read " + bytesRead + " bytes from " + incomingAddress)));
                        logger.debug((Serializable)((Object)("TLS inNetBuffer: " + inNetBuffer)));
                    }
                    if (bytesRead < 0L) {
                        logger.debug((Serializable)((Object)"Socket closed remotely"));
                        sk.cancel();
                        readChannel.close();
                        TransportStateEvent e = new TransportStateEvent(TLSTM.this, incomingAddress, 2, null);
                        TLSTM.this.fireConnectionStateChanged(e);
                        return;
                    }
                    if (bytesRead <= 0L) break block20;
                    Object object = entry.inboundLock;
                    synchronized (object) {
                        do {
                            inNetBuffer.flip();
                            SSLEngineResult result = entry.sslEngine.unwrap(inNetBuffer, inAppBuffer);
                            TLSTM.this.adjustInNetBuffer(entry, result);
                            switch (result.getStatus()) {
                                case BUFFER_OVERFLOW: {
                                    throw new IOException("BUFFER_OVERFLOW");
                                }
                            }
                            if (!this.runDelegatedTasks(result, entry)) break;
                            if (result.bytesProduced() > 0) {
                                entry.inAppBuffer.flip();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("Reading inappBuffer=" + entry.inAppBuffer)));
                                }
                                if (entry.inAppBuffer.remaining() % TLSTM.this.tlsMaxFragmentSize == 0) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Serializable)((Object)("Checking PDU header for fragmented message: " + entry)));
                                    }
                                    try {
                                        BER.decodeHeader(new BERInputStream(entry.inAppBuffer.asReadOnlyBuffer()), new BER.MutableByte(), true);
                                    }
                                    catch (IOException iox) {
                                        entry.inAppBuffer.position(entry.inAppBuffer.limit());
                                        entry.inAppBuffer.limit(entry.inAppBuffer.capacity());
                                        if (!logger.isDebugEnabled()) continue;
                                        logger.debug((Serializable)((Object)("Waiting for rest of packet because: " + iox.getMessage() + ", inAppBuffer=" + entry.inAppBuffer)));
                                        continue;
                                    }
                                }
                                entry.checkTransportStateReference();
                                this.dispatchMessage(incomingAddress, inAppBuffer, inAppBuffer.limit(), entry.sessionID, entry.tmStateReference);
                                entry.getInAppBuffer().clear();
                                break;
                            }
                            if (!entry.isAppOutPending()) continue;
                            this.writeMessage(entry, entry.getSocket().getChannel());
                        } while (inNetBuffer.position() > 0 && inNetBuffer.remaining() > 0);
                    }
                }
                catch (ClosedChannelException ccex) {
                    sk.cancel();
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
            }
        }

        private ByteBuffer createBufferCopy(ByteBuffer buffer) {
            byte[] conInNetData = new byte[buffer.limit()];
            int buflen = buffer.limit() - buffer.remaining();
            buffer.flip();
            buffer.get(conInNetData, 0, buflen);
            ByteBuffer bufferCopy = ByteBuffer.wrap(conInNetData);
            bufferCopy.position(buflen);
            return bufferCopy;
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead, Object sessionID, TransportStateReference tmStateReference) {
            ByteBuffer bis;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received message from " + incomingAddress + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString())));
            }
            if (TLSTM.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            TLSTM.this.fireProcessMessage(incomingAddress, bis, tmStateReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeMessage(SocketEntry entry, SocketChannel sc) throws IOException {
            Object object = entry.outboundLock;
            synchronized (object) {
                boolean sendNextFragment = false;
                do {
                    SSLEngineResult result;
                    int offset;
                    block13: {
                        block12: {
                            sendNextFragment = false;
                            offset = 0;
                            if (entry.outAppBuffer != null) break block12;
                            byte[] message = entry.nextMessage();
                            if (message != null) {
                                entry.outAppBuffer = ByteBuffer.wrap(message);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("Sending message with length " + message.length + " to " + entry.getPeerAddress() + ": " + new OctetString(message).toHexString())));
                                }
                                break block13;
                            } else {
                                entry.removeRegistration(this.selector, 4);
                                if (entry.hasMessage() && !entry.isRegistered(4)) {
                                    entry.addRegistration(this.selector, 4);
                                    logger.debug((Serializable)((Object)"Waking up selector"));
                                    this.selector.wakeup();
                                }
                                entry.addRegistration(this.selector, 1);
                                return;
                            }
                        }
                        offset = entry.outAppBuffer.position();
                    }
                    if ((result = entry.sslEngine.wrap(entry.outAppBuffer, entry.outNetBuffer)).getStatus() == SSLEngineResult.Status.OK) {
                        if (result.bytesProduced() > 0) {
                            TLSTM.this.writeNetBuffer(entry, sc);
                        }
                    } else if (this.runDelegatedTasks(result, entry)) {
                        logger.debug((Serializable)((Object)"SSL session OK"));
                    }
                    if (result.bytesConsumed() >= entry.outAppBuffer.limit() - offset) {
                        logger.debug((Serializable)((Object)"Payload sent completely"));
                        entry.outAppBuffer = null;
                        continue;
                    }
                    if (result.bytesConsumed() <= 0) continue;
                    logger.debug((Serializable)((Object)("Fragment of size " + result.bytesConsumed() + " sent: " + entry)));
                    sendNextFragment = true;
                } while (sendNextFragment);
            }
            entry.addRegistration(this.selector, 1);
        }

        public void close() {
            this.stop = true;
            WorkerTask st = TLSTM.this.server;
            if (st != null) {
                st.terminate();
            }
        }

        @Override
        public void terminate() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void join() {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void interrupt() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
            }
            this.selector.wakeup();
        }
    }

    class SocketTimeout
    extends TimerTask {
        private SocketEntry entry;

        public SocketTimeout(SocketEntry entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.nanoTime();
            if (TLSTM.this.socketCleaner == null || (now - this.entry.getLastUse()) / 1000000L >= TLSTM.this.connectionTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket has not been used for " + (now - this.entry.getLastUse()) + " milliseconds, closing it")));
                }
                TLSTM.this.removeSocketEntry(this.entry.getPeerAddress());
                SocketEntry entryCopy = this.entry;
                try {
                    SocketEntry socketEntry = entryCopy;
                    synchronized (socketEntry) {
                        entryCopy.getSocket().close();
                    }
                    logger.info("Socket to " + entryCopy.getPeerAddress() + " closed due to timeout");
                }
                catch (IOException ex) {
                    logger.error(ex);
                }
            } else {
                long nextRun = System.currentTimeMillis() + (now - this.entry.getLastUse()) / 1000000L + TLSTM.this.connectionTimeout;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Scheduling " + nextRun)));
                }
                SocketTimeout socketTimeout = new SocketTimeout(this.entry);
                this.entry.setSocketTimeout(socketTimeout);
                TLSTM.this.socketCleaner.schedule(socketTimeout, nextRun);
            }
        }

        @Override
        public boolean cancel() {
            boolean result = super.cancel();
            this.entry = null;
            return result;
        }
    }

    class SocketEntry {
        private Socket socket;
        private TcpAddress peerAddress;
        private long lastUse;
        private LinkedList<byte[]> message = new LinkedList();
        private ByteBuffer inNetBuffer;
        private ByteBuffer inAppBuffer;
        private ByteBuffer outAppBuffer;
        private ByteBuffer outNetBuffer;
        private volatile int registrations = 0;
        private SSLEngine sslEngine;
        private long sessionID;
        private TransportStateReference tmStateReference;
        private boolean handshakeFinished;
        private final Object outboundLock = new Object();
        private final Object inboundLock = new Object();
        private SocketTimeout socketTimeout;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketEntry(TcpAddress address, Socket socket, boolean useClientMode, TransportStateReference tmStateReference) throws NoSuchAlgorithmException {
            this.inAppBuffer = ByteBuffer.allocate(TLSTM.this.getMaxInboundMessageSize());
            this.inNetBuffer = ByteBuffer.allocate(TLSTM.this.getMaxInboundMessageSize());
            this.outNetBuffer = ByteBuffer.allocate(TLSTM.this.getMaxInboundMessageSize());
            this.peerAddress = address;
            this.tmStateReference = tmStateReference;
            this.socket = socket;
            this.lastUse = System.nanoTime();
            if (tmStateReference == null) {
                TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionAccepts));
            }
            SSLContext sslContext = TLSTM.this.sslEngineConfigurator.getSSLContext(useClientMode, tmStateReference);
            this.sslEngine = sslContext.createSSLEngine(address.getInetAddress().getHostName(), address.getPort());
            this.sslEngine.setUseClientMode(useClientMode);
            TLSTM.this.sslEngineConfigurator.configure(this.sslEngine);
            TLSTM tLSTM = TLSTM.this;
            synchronized (tLSTM) {
                this.sessionID = TLSTM.this.nextSessionID++;
            }
        }

        public synchronized void addRegistration(Selector selector, int opKey) throws ClosedChannelException {
            if ((this.registrations & opKey) == 0) {
                this.registrations |= opKey;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Adding operation " + opKey + " for: " + this.toString())));
                }
                this.socket.getChannel().register(selector, this.registrations, this);
            } else if (!this.socket.getChannel().isRegistered()) {
                this.registrations = opKey;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Registering new operation " + opKey + " for: " + this.toString())));
                }
                this.socket.getChannel().register(selector, opKey, this);
            }
        }

        public synchronized void removeRegistration(Selector selector, int opKey) throws ClosedChannelException {
            if ((this.registrations & opKey) == opKey) {
                this.registrations &= ~opKey;
                this.socket.getChannel().register(selector, this.registrations, this);
            }
        }

        public synchronized boolean isRegistered(int opKey) {
            return (this.registrations & opKey) == opKey;
        }

        public long getLastUse() {
            return this.lastUse;
        }

        public void used() {
            this.lastUse = System.nanoTime();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public TcpAddress getPeerAddress() {
            return this.peerAddress;
        }

        public synchronized void addMessage(byte[] message) {
            this.message.add(message);
        }

        public synchronized void insertMessages(List<byte[]> messages) {
            this.message.addAll(0, messages);
        }

        public synchronized byte[] nextMessage() {
            if (this.message.size() > 0) {
                return this.message.removeFirst();
            }
            return null;
        }

        public synchronized boolean hasMessage() {
            return !this.message.isEmpty();
        }

        public void setInNetBuffer(ByteBuffer byteBuffer) {
            this.inNetBuffer = byteBuffer;
        }

        public ByteBuffer getInNetBuffer() {
            return this.inNetBuffer;
        }

        public ByteBuffer getOutNetBuffer() {
            return this.outNetBuffer;
        }

        public void setOutNetBuffer(ByteBuffer outNetBuffer) {
            this.outNetBuffer = outNetBuffer;
        }

        public String toString() {
            return "SocketEntry[peerAddress=" + this.peerAddress + ",socket=" + this.socket + ",lastUse=" + new Date(this.lastUse / 1000000L) + ",inNetBuffer=" + this.inNetBuffer + ",inAppBuffer=" + this.inAppBuffer + ",outNetBuffer=" + this.outNetBuffer + ",socketTimeout=" + this.socketTimeout + "]";
        }

        public SocketTimeout getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(SocketTimeout socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public void checkTransportStateReference() {
            if (this.tmStateReference == null) {
                this.tmStateReference = new TransportStateReference(TLSTM.this, this.peerAddress, new OctetString(), SecurityLevel.authPriv, SecurityLevel.authPriv, true, this.sessionID);
                OctetString securityName = null;
                if (TLSTM.this.securityCallback != null) {
                    try {
                        securityName = TLSTM.this.securityCallback.getSecurityName((X509Certificate[])this.sslEngine.getSession().getPeerCertificates());
                    }
                    catch (SSLPeerUnverifiedException e) {
                        logger.error("SSL peer '" + this.peerAddress + "' is not verified: " + e.getMessage(), e);
                        this.sslEngine.setEnableSessionCreation(false);
                    }
                }
                this.tmStateReference.setSecurityName(securityName);
            } else if (this.tmStateReference.getTransportSecurityLevel().equals((Object)SecurityLevel.undefined)) {
                this.tmStateReference.setTransportSecurityLevel(SecurityLevel.authPriv);
            }
        }

        public void setInAppBuffer(ByteBuffer inAppBuffer) {
            this.inAppBuffer = inAppBuffer;
        }

        public ByteBuffer getInAppBuffer() {
            return this.inAppBuffer;
        }

        public boolean isHandshakeFinished() {
            return this.handshakeFinished;
        }

        public void setHandshakeFinished(boolean handshakeFinished) {
            this.handshakeFinished = handshakeFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAppOutPending() {
            Object object = this.outboundLock;
            synchronized (object) {
                return this.outAppBuffer != null && this.outAppBuffer.limit() > 0;
            }
        }

        public long getSessionID() {
            return this.sessionID;
        }

        public void closeSession() {
            this.sslEngine.closeOutbound();
            TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionServerCloses));
            try {
                SSLEngineResult result;
                while ((result = TLSTM.this.sendNetMessage(this)) != null && result.getStatus() != SSLEngineResult.Status.CLOSED && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                }
            }
            catch (IOException e) {
                logger.error("IOException while closing outbound channel of " + this + ": " + e.getMessage(), e);
            }
        }
    }
}

